/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.ContextThemeWrapper;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.android.internal.view.menu.IconMenuView;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class MenuBuilder
implements Menu {
    static final int[] ITEM_LAYOUT_RES_FOR_TYPE;
    static final int[] LAYOUT_RES_FOR_TYPE;
    private static final String LOGTAG = "MenuBuilder";
    public static final int NUM_TYPES = 3;
    static final int[] THEME_RES_FOR_TYPE;
    public static final int TYPE_DIALOG = 2;
    public static final int TYPE_EXPANDED = 1;
    public static final int TYPE_ICON = 0;
    private static final String VIEWS_TAG = "android:views";
    private static final int[] sCategoryToOrder;
    private Callback mCallback;
    private final Context mContext;
    private ContextMenu.ContextMenuInfo mCurrentMenuInfo;
    private SparseArray<Parcelable> mFrozenViewStates;
    Drawable mHeaderIcon;
    CharSequence mHeaderTitle;
    View mHeaderView;
    private boolean mIsVisibleItemsStale;
    private ArrayList<MenuItemImpl> mItems;
    private MenuType[] mMenuTypes = new MenuType[3];
    private boolean mOptionalIconsVisible = false;
    private boolean mPreventDispatchingItemsChanged = false;
    private boolean mQwertyMode;
    private final Resources mResources;
    private boolean mShortcutsVisible;
    private ArrayList<MenuItemImpl> mVisibleItems;

    static {
        THEME_RES_FOR_TYPE = new int[]{16973990, 16973991, 0};
        LAYOUT_RES_FOR_TYPE = new int[]{17367081, 17367076, 0};
        ITEM_LAYOUT_RES_FOR_TYPE = new int[]{17367080, 17367103, 17367103};
        sCategoryToOrder = new int[]{1, 4, 5, 3, 2, 0};
    }

    /*
     * Enabled aggressive block sorting
     */
    public MenuBuilder(Context context) {
        this.mContext = context;
        this.mResources = context.getResources();
        this.mItems = new ArrayList();
        this.mVisibleItems = new ArrayList();
        this.mIsVisibleItemsStale = true;
        boolean bl = this.mResources.getConfiguration().keyboard != 1;
        this.mShortcutsVisible = bl;
    }

    private MenuItem addInternal(int n, int n2, int n3, CharSequence charSequence) {
        int n4 = MenuBuilder.getOrdering(n3);
        MenuItemImpl menuItemImpl = new MenuItemImpl(this, n, n2, n3, n4, charSequence);
        if (this.mCurrentMenuInfo != null) {
            menuItemImpl.setMenuInfo(this.mCurrentMenuInfo);
        }
        this.mItems.add(MenuBuilder.findInsertIndex(this.mItems, n4), menuItemImpl);
        this.onItemsChanged(false);
        return menuItemImpl;
    }

    private static int findInsertIndex(ArrayList<MenuItemImpl> arrayList, int n) {
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            if (arrayList.get(i).getOrdering() > n) continue;
            return i + 1;
        }
        return 0;
    }

    private int getNumIconMenuItemsShown() {
        boolean bl = this.mMenuTypes[0].hasMenuView();
        ViewGroup viewGroup = null;
        if (!bl) {
            boolean bl2 = this.mMenuTypes[1].hasMenuView();
            viewGroup = null;
            if (bl2) {
                viewGroup = (ViewGroup)((View)((Object)this.mMenuTypes[1].getMenuView(null))).getParent();
            }
        }
        return ((IconMenuView)this.getMenuView(0, viewGroup)).getNumActualItemsShown();
    }

    private static int getOrdering(int n) {
        int n2 = (0xFFFF0000 & n) >> 16;
        if (n2 < 0 || n2 >= sCategoryToOrder.length) {
            throw new IllegalArgumentException("order does not contain a valid category.");
        }
        return sCategoryToOrder[n2] << 16 | 0xFFFF & n;
    }

    private void onItemsChanged(boolean bl) {
        if (!this.mPreventDispatchingItemsChanged) {
            if (!this.mIsVisibleItemsStale) {
                this.mIsVisibleItemsStale = true;
            }
            MenuType[] menuTypeArray = this.mMenuTypes;
            for (int i = 0; i < 3; ++i) {
                if (menuTypeArray[i] == null || !menuTypeArray[i].hasMenuView()) continue;
                ((MenuView)menuTypeArray[i].mMenuView.get()).updateChildren(bl);
            }
        }
    }

    private void refreshShortcuts(boolean bl, boolean bl2) {
        for (int i = this.mItems.size() - 1; i >= 0; --i) {
            MenuItemImpl menuItemImpl = this.mItems.get(i);
            if (menuItemImpl.hasSubMenu()) {
                ((MenuBuilder)((Object)menuItemImpl.getSubMenu())).refreshShortcuts(bl, bl2);
            }
            menuItemImpl.refreshShortcutOnItemViews(bl, bl2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void removeItemAtInt(int n, boolean bl) {
        block3: {
            block2: {
                if (n < 0 || n >= this.mItems.size()) break block2;
                this.mItems.remove(n);
                if (bl) break block3;
            }
            return;
        }
        this.onItemsChanged(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setHeaderInternal(int n, CharSequence charSequence, int n2, Drawable drawable2, View view) {
        Resources resources = this.getResources();
        if (view != null) {
            this.mHeaderView = view;
            this.mHeaderTitle = null;
            this.mHeaderIcon = null;
        } else {
            if (n > 0) {
                this.mHeaderTitle = resources.getText(n);
            } else if (charSequence != null) {
                this.mHeaderTitle = charSequence;
            }
            if (n2 > 0) {
                this.mHeaderIcon = resources.getDrawable(n2);
            } else if (drawable2 != null) {
                this.mHeaderIcon = drawable2;
            }
            this.mHeaderView = null;
        }
        this.onItemsChanged(false);
    }

    @Override
    public MenuItem add(int n) {
        return this.addInternal(0, 0, 0, this.mResources.getString(n));
    }

    @Override
    public MenuItem add(int n, int n2, int n3, int n4) {
        return this.addInternal(n, n2, n3, this.mResources.getString(n4));
    }

    @Override
    public MenuItem add(int n, int n2, int n3, CharSequence charSequence) {
        return this.addInternal(n, n2, n3, charSequence);
    }

    @Override
    public MenuItem add(CharSequence charSequence) {
        return this.addInternal(0, 0, 0, charSequence);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int addIntentOptions(int n, int n2, int n3, ComponentName componentName, Intent[] intentArray, Intent intent, int n4, MenuItem[] menuItemArray) {
        PackageManager packageManager = this.mContext.getPackageManager();
        List<ResolveInfo> list = packageManager.queryIntentActivityOptions(componentName, intentArray, intent, 0);
        int n5 = list != null ? list.size() : 0;
        if ((n4 & 1) == 0) {
            this.removeGroup(n);
        }
        int n6 = 0;
        while (n6 < n5) {
            ResolveInfo resolveInfo = list.get(n6);
            Intent intent2 = resolveInfo.specificIndex < 0 ? intent : intentArray[resolveInfo.specificIndex];
            Intent intent3 = new Intent(intent2);
            intent3.setComponent(new ComponentName(resolveInfo.activityInfo.applicationInfo.packageName, resolveInfo.activityInfo.name));
            MenuItem menuItem = this.add(n, n2, n3, resolveInfo.loadLabel(packageManager)).setIcon(resolveInfo.loadIcon(packageManager)).setIntent(intent3);
            if (menuItemArray != null && resolveInfo.specificIndex >= 0) {
                menuItemArray[resolveInfo.specificIndex] = menuItem;
            }
            ++n6;
        }
        return n5;
    }

    @Override
    public SubMenu addSubMenu(int n) {
        return this.addSubMenu(0, 0, 0, this.mResources.getString(n));
    }

    @Override
    public SubMenu addSubMenu(int n, int n2, int n3, int n4) {
        return this.addSubMenu(n, n2, n3, this.mResources.getString(n4));
    }

    @Override
    public SubMenu addSubMenu(int n, int n2, int n3, CharSequence charSequence) {
        MenuItemImpl menuItemImpl = (MenuItemImpl)this.addInternal(n, n2, n3, charSequence);
        SubMenuBuilder subMenuBuilder = new SubMenuBuilder(this.mContext, this, menuItemImpl);
        menuItemImpl.setSubMenu(subMenuBuilder);
        return subMenuBuilder;
    }

    @Override
    public SubMenu addSubMenu(CharSequence charSequence) {
        return this.addSubMenu(0, 0, 0, charSequence);
    }

    @Override
    public void clear() {
        this.mItems.clear();
        this.onItemsChanged(true);
    }

    public void clearAll() {
        this.mPreventDispatchingItemsChanged = true;
        this.clear();
        this.clearHeader();
        this.mPreventDispatchingItemsChanged = false;
        this.onItemsChanged(true);
    }

    public void clearHeader() {
        this.mHeaderIcon = null;
        this.mHeaderTitle = null;
        this.mHeaderView = null;
        this.onItemsChanged(false);
    }

    public void clearMenuViews() {
        for (int i = 2; i >= 0; --i) {
            if (this.mMenuTypes[i] == null) continue;
            MenuType.access$202(this.mMenuTypes[i], null);
        }
        for (int i = this.mItems.size() - 1; i >= 0; --i) {
            MenuItemImpl menuItemImpl = this.mItems.get(i);
            if (menuItemImpl.hasSubMenu()) {
                ((SubMenuBuilder)menuItemImpl.getSubMenu()).clearMenuViews();
            }
            menuItemImpl.clearItemViews();
        }
    }

    @Override
    public void close() {
        this.close(true);
    }

    final void close(boolean bl) {
        Callback callback = this.getCallback();
        if (callback != null) {
            callback.onCloseMenu(this, bl);
        }
    }

    public int findGroupIndex(int n) {
        return this.findGroupIndex(n, 0);
    }

    public int findGroupIndex(int n, int n2) {
        int n3 = this.size();
        if (n2 < 0) {
            n2 = 0;
        }
        for (int i = n2; i < n3; ++i) {
            if (this.mItems.get(i).getGroupId() != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public MenuItem findItem(int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            MenuItem menuItem;
            MenuItemImpl menuItemImpl = this.mItems.get(i);
            if (menuItemImpl.getItemId() == n) {
                return menuItemImpl;
            }
            if (!menuItemImpl.hasSubMenu() || (menuItem = menuItemImpl.getSubMenu().findItem(n)) == null) continue;
            return menuItem;
        }
        return null;
    }

    public int findItemIndex(int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (this.mItems.get(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    MenuItemImpl findItemWithShortcutForKey(int n, KeyEvent keyEvent) {
        MenuItemImpl menuItemImpl;
        char c;
        List<MenuItemImpl> list = this.findItemsWithShortcutForKey(n, keyEvent);
        if (list == null) {
            return null;
        }
        int n2 = keyEvent.getMetaState();
        KeyCharacterMap.KeyData keyData = new KeyCharacterMap.KeyData();
        keyEvent.getKeyData(keyData);
        if (list.size() == 1) {
            return list.get(0);
        }
        boolean bl = this.isQwertyMode();
        Iterator<MenuItemImpl> iterator = list.iterator();
        do {
            if (!iterator.hasNext()) {
                return null;
            }
            menuItemImpl = iterator.next();
        } while (!((c = bl ? menuItemImpl.getAlphabeticShortcut() : menuItemImpl.getNumericShortcut()) == keyData.meta[0] && (n2 & 2) == 0 || c == keyData.meta[2] && (n2 & 2) != 0) && (!bl || c != '\b' || n != 67));
        return menuItemImpl;
    }

    /*
     * Enabled aggressive block sorting
     */
    List<MenuItemImpl> findItemsWithShortcutForKey(int n, KeyEvent keyEvent) {
        boolean bl = this.isQwertyMode();
        int n2 = keyEvent.getMetaState();
        KeyCharacterMap.KeyData keyData = new KeyCharacterMap.KeyData();
        if (!keyEvent.getKeyData(keyData) && n != 67) {
            return null;
        }
        Vector<MenuItemImpl> vector = new Vector<MenuItemImpl>();
        int n3 = this.mItems.size();
        int n4 = 0;
        while (n4 < n3) {
            MenuItemImpl menuItemImpl = this.mItems.get(n4);
            if (menuItemImpl.hasSubMenu()) {
                vector.addAll(((MenuBuilder)((Object)menuItemImpl.getSubMenu())).findItemsWithShortcutForKey(n, keyEvent));
            }
            char c = bl ? menuItemImpl.getAlphabeticShortcut() : menuItemImpl.getNumericShortcut();
            if ((n2 & 5) == 0 && c != '\u0000' && (c == keyData.meta[0] || c == keyData.meta[2] || bl && c == '\b' && n == 67) && menuItemImpl.isEnabled()) {
                vector.add(menuItemImpl);
            }
            ++n4;
        }
        return vector;
    }

    public Callback getCallback() {
        return this.mCallback;
    }

    public Context getContext() {
        return this.mContext;
    }

    public Drawable getHeaderIcon() {
        return this.mHeaderIcon;
    }

    public CharSequence getHeaderTitle() {
        return this.mHeaderTitle;
    }

    public View getHeaderView() {
        return this.mHeaderView;
    }

    @Override
    public MenuItem getItem(int n) {
        return this.mItems.get(n);
    }

    public MenuAdapter getMenuAdapter(int n) {
        return new MenuAdapter(n);
    }

    MenuType getMenuType(int n) {
        if (this.mMenuTypes[n] == null) {
            this.mMenuTypes[n] = new MenuType(n);
        }
        return this.mMenuTypes[n];
    }

    public View getMenuView(int n, ViewGroup viewGroup) {
        if (!(n != 1 || this.mMenuTypes[0] != null && this.mMenuTypes[0].hasMenuView())) {
            this.getMenuType(0).getMenuView(viewGroup);
        }
        return (View)((Object)this.getMenuType(n).getMenuView(viewGroup));
    }

    boolean getOptionalIconsVisible() {
        return this.mOptionalIconsVisible;
    }

    Resources getResources() {
        return this.mResources;
    }

    public MenuBuilder getRootMenu() {
        return this;
    }

    ArrayList<MenuItemImpl> getVisibleItems() {
        if (!this.mIsVisibleItemsStale) {
            return this.mVisibleItems;
        }
        this.mVisibleItems.clear();
        int n = this.mItems.size();
        for (int i = 0; i < n; ++i) {
            MenuItemImpl menuItemImpl = this.mItems.get(i);
            if (!menuItemImpl.isVisible()) continue;
            this.mVisibleItems.add(menuItemImpl);
        }
        this.mIsVisibleItemsStale = false;
        return this.mVisibleItems;
    }

    @Override
    public boolean hasVisibleItems() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!this.mItems.get(i).isVisible()) continue;
            return true;
        }
        return false;
    }

    boolean isQwertyMode() {
        return this.mQwertyMode;
    }

    @Override
    public boolean isShortcutKey(int n, KeyEvent keyEvent) {
        return this.findItemWithShortcutForKey(n, keyEvent) != null;
    }

    public boolean isShortcutsVisible() {
        return this.mShortcutsVisible;
    }

    void onItemVisibleChanged(MenuItemImpl menuItemImpl) {
        this.onItemsChanged(false);
    }

    @Override
    public boolean performIdentifierAction(int n, int n2) {
        return this.performItemAction(this.findItem(n), n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performItemAction(MenuItem menuItem, int n) {
        MenuItemImpl menuItemImpl = (MenuItemImpl)menuItem;
        if (menuItemImpl == null) return false;
        if (!menuItemImpl.isEnabled()) {
            return false;
        }
        boolean bl = menuItemImpl.invoke();
        if (menuItem.hasSubMenu()) {
            this.close(false);
            if (this.mCallback == null) return bl;
            if (this.mCallback.onSubMenuSelected((SubMenuBuilder)menuItem.getSubMenu())) return true;
            if (!bl) return false;
            return true;
        }
        if ((n & 1) != 0) return bl;
        this.close(true);
        return bl;
    }

    @Override
    public boolean performShortcut(int n, KeyEvent keyEvent, int n2) {
        MenuItemImpl menuItemImpl = this.findItemWithShortcutForKey(n, keyEvent);
        boolean bl = false;
        if (menuItemImpl != null) {
            bl = this.performItemAction(menuItemImpl, n2);
        }
        if ((n2 & 2) != 0) {
            this.close(true);
        }
        return bl;
    }

    @Override
    public void removeGroup(int n) {
        int n2 = this.findGroupIndex(n);
        if (n2 >= 0) {
            int n3 = this.mItems.size() - n2;
            int n4 = 0;
            while (true) {
                int n5 = n4 + 1;
                if (n4 >= n3 || this.mItems.get(n2).getGroupId() != n) break;
                this.removeItemAtInt(n2, false);
                n4 = n5;
            }
            this.onItemsChanged(false);
        }
    }

    @Override
    public void removeItem(int n) {
        this.removeItemAtInt(this.findItemIndex(n), true);
    }

    public void removeItemAt(int n) {
        this.removeItemAtInt(n, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void restoreHierarchyState(Bundle bundle) {
        SparseArray<Parcelable> sparseArray = bundle.getSparseParcelableArray(VIEWS_TAG);
        this.mFrozenViewStates = sparseArray;
        MenuType[] menuTypeArray = this.mMenuTypes;
        int n = 2;
        while (n >= 0) {
            if (menuTypeArray[n] != null && menuTypeArray[n].hasMenuView()) {
                ((View)((Object)menuTypeArray[n].getMenuView(null))).restoreHierarchyState(sparseArray);
            }
            --n;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void saveHierarchyState(Bundle bundle) {
        SparseArray<Parcelable> sparseArray = new SparseArray<Parcelable>();
        MenuType[] menuTypeArray = this.mMenuTypes;
        int n = 2;
        while (true) {
            if (n < 0) {
                bundle.putSparseParcelableArray(VIEWS_TAG, sparseArray);
                return;
            }
            if (menuTypeArray[n] != null && menuTypeArray[n].hasMenuView()) {
                ((View)((Object)menuTypeArray[n].getMenuView(null))).saveHierarchyState(sparseArray);
            }
            --n;
        }
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void setCurrentMenuInfo(ContextMenu.ContextMenuInfo contextMenuInfo) {
        this.mCurrentMenuInfo = contextMenuInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setExclusiveItemChecked(MenuItem menuItem) {
        int n = menuItem.getGroupId();
        int n2 = this.mItems.size();
        int n3 = 0;
        while (n3 < n2) {
            MenuItemImpl menuItemImpl = this.mItems.get(n3);
            if (menuItemImpl.getGroupId() == n && menuItemImpl.isExclusiveCheckable() && menuItemImpl.isCheckable()) {
                boolean bl = menuItemImpl == menuItem;
                menuItemImpl.setCheckedInt(bl);
            }
            ++n3;
        }
        return;
    }

    @Override
    public void setGroupCheckable(int n, boolean bl, boolean bl2) {
        int n2 = this.mItems.size();
        for (int i = 0; i < n2; ++i) {
            MenuItemImpl menuItemImpl = this.mItems.get(i);
            if (menuItemImpl.getGroupId() != n) continue;
            menuItemImpl.setExclusiveCheckable(bl2);
            menuItemImpl.setCheckable(bl);
        }
    }

    @Override
    public void setGroupEnabled(int n, boolean bl) {
        int n2 = this.mItems.size();
        for (int i = 0; i < n2; ++i) {
            MenuItemImpl menuItemImpl = this.mItems.get(i);
            if (menuItemImpl.getGroupId() != n) continue;
            menuItemImpl.setEnabled(bl);
        }
    }

    @Override
    public void setGroupVisible(int n, boolean bl) {
        int n2 = this.mItems.size();
        boolean bl2 = false;
        for (int i = 0; i < n2; ++i) {
            MenuItemImpl menuItemImpl = this.mItems.get(i);
            if (menuItemImpl.getGroupId() != n || !menuItemImpl.setVisibleInt(bl)) continue;
            bl2 = true;
        }
        if (bl2) {
            this.onItemsChanged(false);
        }
    }

    protected MenuBuilder setHeaderIconInt(int n) {
        this.setHeaderInternal(0, null, n, null, null);
        return this;
    }

    protected MenuBuilder setHeaderIconInt(Drawable drawable2) {
        this.setHeaderInternal(0, null, 0, drawable2, null);
        return this;
    }

    protected MenuBuilder setHeaderTitleInt(int n) {
        this.setHeaderInternal(n, null, 0, null, null);
        return this;
    }

    protected MenuBuilder setHeaderTitleInt(CharSequence charSequence) {
        this.setHeaderInternal(0, charSequence, 0, null, null);
        return this;
    }

    protected MenuBuilder setHeaderViewInt(View view) {
        this.setHeaderInternal(0, null, 0, null, view);
        return this;
    }

    void setOptionalIconsVisible(boolean bl) {
        this.mOptionalIconsVisible = bl;
    }

    @Override
    public void setQwertyMode(boolean bl) {
        this.mQwertyMode = bl;
        this.refreshShortcuts(this.isShortcutsVisible(), bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setShortcutsVisible(boolean bl) {
        if (this.mShortcutsVisible == bl) {
            return;
        }
        boolean bl2 = this.mResources.getConfiguration().keyboard != 1 && bl;
        this.mShortcutsVisible = bl2;
        this.refreshShortcuts(this.mShortcutsVisible, this.isQwertyMode());
    }

    @Override
    public int size() {
        return this.mItems.size();
    }

    public static interface Callback {
        public void onCloseMenu(MenuBuilder var1, boolean var2);

        public void onCloseSubMenu(SubMenuBuilder var1);

        public boolean onMenuItemSelected(MenuBuilder var1, MenuItem var2);

        public void onMenuModeChange(MenuBuilder var1);

        public boolean onSubMenuSelected(SubMenuBuilder var1);
    }

    public static interface ItemInvoker {
        public boolean invokeItem(MenuItemImpl var1);
    }

    public class MenuAdapter
    extends BaseAdapter {
        private int mMenuType;

        public MenuAdapter(int n) {
            this.mMenuType = n;
        }

        @Override
        public int getCount() {
            return MenuBuilder.this.getVisibleItems().size() - this.getOffset();
        }

        @Override
        public MenuItemImpl getItem(int n) {
            return MenuBuilder.this.getVisibleItems().get(n + this.getOffset());
        }

        @Override
        public long getItemId(int n) {
            return n;
        }

        public int getOffset() {
            if (this.mMenuType == 1) {
                return MenuBuilder.this.getNumIconMenuItemsShown();
            }
            return 0;
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            return this.getItem(n).getItemView(this.mMenuType, viewGroup);
        }
    }

    class MenuType {
        private LayoutInflater mInflater;
        private int mMenuType;
        private WeakReference<MenuView> mMenuView;

        MenuType(int n) {
            this.mMenuType = n;
        }

        static /* synthetic */ WeakReference access$202(MenuType menuType, WeakReference weakReference) {
            menuType.mMenuView = weakReference;
            return weakReference;
        }

        LayoutInflater getInflater() {
            if (this.mInflater == null) {
                this.mInflater = (LayoutInflater)((Context)new ContextThemeWrapper(MenuBuilder.this.mContext, THEME_RES_FOR_TYPE[this.mMenuType])).getSystemService("layout_inflater");
            }
            return this.mInflater;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        MenuView getMenuView(ViewGroup viewGroup) {
            if (LAYOUT_RES_FOR_TYPE[this.mMenuType] == 0) {
                return null;
            }
            synchronized (this) {
                MenuView menuView = this.mMenuView != null ? (MenuView)this.mMenuView.get() : null;
                if (menuView == null) {
                    menuView = (MenuView)((Object)this.getInflater().inflate(LAYOUT_RES_FOR_TYPE[this.mMenuType], viewGroup, false));
                    menuView.initialize(MenuBuilder.this, this.mMenuType);
                    this.mMenuView = new WeakReference<MenuView>(menuView);
                    if (MenuBuilder.this.mFrozenViewStates != null) {
                        View view = (View)((Object)menuView);
                        view.restoreHierarchyState(MenuBuilder.this.mFrozenViewStates);
                        MenuBuilder.this.mFrozenViewStates.remove(view.getId());
                    }
                }
                return menuView;
            }
        }

        boolean hasMenuView() {
            return this.mMenuView != null && this.mMenuView.get() != null;
        }
    }
}

