/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.IBinder;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ListAdapter;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;

public class MenuDialogHelper
implements DialogInterface.OnKeyListener,
DialogInterface.OnClickListener {
    private ListAdapter mAdapter;
    private AlertDialog mDialog;
    private MenuBuilder mMenu;

    public MenuDialogHelper(MenuBuilder menuBuilder) {
        this.mMenu = menuBuilder;
    }

    public void dismiss() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
    }

    @Override
    public void onClick(DialogInterface dialogInterface, int n) {
        this.mMenu.performItemAction((MenuItemImpl)this.mAdapter.getItem(n), 0);
    }

    @Override
    public boolean onKey(DialogInterface dialogInterface, int n, KeyEvent keyEvent) {
        if (n == 82 || n == 4) {
            KeyEvent.DispatcherState dispatcherState;
            View view;
            Window window;
            if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
                KeyEvent.DispatcherState dispatcherState2;
                View view2;
                Window window2 = this.mDialog.getWindow();
                if (window2 != null && (view2 = window2.getDecorView()) != null && (dispatcherState2 = view2.getKeyDispatcherState()) != null) {
                    dispatcherState2.startTracking(keyEvent, this);
                    return true;
                }
            } else if (keyEvent.getAction() == 1 && !keyEvent.isCanceled() && (window = this.mDialog.getWindow()) != null && (view = window.getDecorView()) != null && (dispatcherState = view.getKeyDispatcherState()) != null && dispatcherState.isTracking(keyEvent)) {
                this.mMenu.close(true);
                dialogInterface.dismiss();
                return true;
            }
        }
        return this.mMenu.performShortcut(n, keyEvent, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void show(IBinder iBinder) {
        MenuBuilder menuBuilder = this.mMenu;
        this.mAdapter = menuBuilder.getMenuAdapter(2);
        AlertDialog.Builder builder = new AlertDialog.Builder(menuBuilder.getContext()).setAdapter(this.mAdapter, this);
        View view = menuBuilder.getHeaderView();
        if (view != null) {
            builder.setCustomTitle(view);
        } else {
            builder.setIcon(menuBuilder.getHeaderIcon()).setTitle(menuBuilder.getHeaderTitle());
        }
        builder.setOnKeyListener(this);
        builder.setRecycleOnMeasureEnabled(false);
        this.mDialog = builder.create();
        WindowManager.LayoutParams layoutParams = this.mDialog.getWindow().getAttributes();
        layoutParams.type = 1003;
        if (iBinder != null) {
            layoutParams.token = iBinder;
        }
        layoutParams.flags = 0x20000 | layoutParams.flags;
        this.mDialog.show();
    }
}

