/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import java.lang.ref.WeakReference;

public final class MenuItemImpl
implements MenuItem {
    private static final int CHECKABLE = 1;
    private static final int CHECKED = 2;
    private static final int ENABLED = 16;
    private static final int EXCLUSIVE = 4;
    private static final int HIDDEN = 8;
    static final int NO_ICON = 0;
    private static final String TAG = "MenuItemImpl";
    private static String sDeleteShortcutLabel;
    private static String sEnterShortcutLabel;
    private static String sPrependShortcutLabel;
    private static String sSpaceShortcutLabel;
    private final int mCategoryOrder;
    private MenuItem.OnMenuItemClickListener mClickListener;
    private int mFlags = 16;
    private final int mGroup;
    private Drawable mIconDrawable;
    private int mIconResId = 0;
    private final int mId;
    private Intent mIntent;
    private Runnable mItemCallback;
    private WeakReference<MenuView.ItemView>[] mItemViews;
    private MenuBuilder mMenu;
    private ContextMenu.ContextMenuInfo mMenuInfo;
    private final int mOrdering;
    private char mShortcutAlphabeticChar;
    private char mShortcutNumericChar;
    private SubMenuBuilder mSubMenu;
    private CharSequence mTitle;
    private CharSequence mTitleCondensed;

    MenuItemImpl(MenuBuilder menuBuilder, int n, int n2, int n3, int n4, CharSequence charSequence) {
        if (sPrependShortcutLabel == null) {
            sPrependShortcutLabel = menuBuilder.getContext().getResources().getString(17040067);
            sEnterShortcutLabel = menuBuilder.getContext().getResources().getString(17040069);
            sDeleteShortcutLabel = menuBuilder.getContext().getResources().getString(17040070);
            sSpaceShortcutLabel = menuBuilder.getContext().getResources().getString(17040068);
        }
        this.mItemViews = new WeakReference[3];
        this.mMenu = menuBuilder;
        this.mId = n2;
        this.mGroup = n;
        this.mCategoryOrder = n3;
        this.mOrdering = n4;
        this.mTitle = charSequence;
    }

    private MenuView.ItemView createItemView(int n, ViewGroup viewGroup) {
        MenuView.ItemView itemView = (MenuView.ItemView)((Object)this.getLayoutInflater(n).inflate(MenuBuilder.ITEM_LAYOUT_RES_FOR_TYPE[n], viewGroup, false));
        itemView.initialize(this, n);
        return itemView;
    }

    private boolean hasItemView(int n) {
        return this.mItemViews[n] != null && this.mItemViews[n].get() != null;
    }

    private boolean haveAnyOpenedIconCapableItemViews() {
        for (int i = 2; i >= 0; --i) {
            if (!this.hasItemView(i) || !((MenuView.ItemView)this.mItemViews[i].get()).showsIcon()) continue;
            return true;
        }
        return false;
    }

    private void refreshShortcutOnItemViews() {
        this.refreshShortcutOnItemViews(this.mMenu.isShortcutsVisible(), this.mMenu.isQwertyMode());
    }

    private void setIconOnViews(Drawable drawable2) {
        for (int i = 2; i >= 0; --i) {
            if (!this.hasItemView(i) || !((MenuView.ItemView)this.mItemViews[i].get()).showsIcon()) continue;
            ((MenuView.ItemView)this.mItemViews[i].get()).setIcon(drawable2);
        }
    }

    void clearItemViews() {
        for (int i = this.mItemViews.length - 1; i >= 0; --i) {
            this.mItemViews[i] = null;
        }
    }

    @Override
    public char getAlphabeticShortcut() {
        return this.mShortcutAlphabeticChar;
    }

    Runnable getCallback() {
        return this.mItemCallback;
    }

    @Override
    public int getGroupId() {
        return this.mGroup;
    }

    @Override
    public Drawable getIcon() {
        if (this.mIconDrawable != null) {
            return this.mIconDrawable;
        }
        if (this.mIconResId != 0) {
            return this.mMenu.getResources().getDrawable(this.mIconResId);
        }
        return null;
    }

    @Override
    public Intent getIntent() {
        return this.mIntent;
    }

    @Override
    @ViewDebug.CapturedViewProperty
    public int getItemId() {
        return this.mId;
    }

    View getItemView(int n, ViewGroup viewGroup) {
        if (!this.hasItemView(n)) {
            this.mItemViews[n] = new WeakReference<MenuView.ItemView>(this.createItemView(n, viewGroup));
        }
        return (View)this.mItemViews[n].get();
    }

    public LayoutInflater getLayoutInflater(int n) {
        return this.mMenu.getMenuType(n).getInflater();
    }

    @Override
    public ContextMenu.ContextMenuInfo getMenuInfo() {
        return this.mMenuInfo;
    }

    @Override
    public char getNumericShortcut() {
        return this.mShortcutNumericChar;
    }

    @Override
    public int getOrder() {
        return this.mCategoryOrder;
    }

    public int getOrdering() {
        return this.mOrdering;
    }

    char getShortcut() {
        if (this.mMenu.isQwertyMode()) {
            return this.mShortcutAlphabeticChar;
        }
        return this.mShortcutNumericChar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getShortcutLabel() {
        char c = this.getShortcut();
        if (c == '\u0000') {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(sPrependShortcutLabel);
        switch (c) {
            default: {
                stringBuilder.append(c);
                return stringBuilder.toString();
            }
            case '\n': {
                stringBuilder.append(sEnterShortcutLabel);
                return stringBuilder.toString();
            }
            case '\b': {
                stringBuilder.append(sDeleteShortcutLabel);
                return stringBuilder.toString();
            }
            case ' ': 
        }
        stringBuilder.append(sSpaceShortcutLabel);
        return stringBuilder.toString();
    }

    @Override
    public SubMenu getSubMenu() {
        return this.mSubMenu;
    }

    @Override
    @ViewDebug.CapturedViewProperty
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @Override
    public CharSequence getTitleCondensed() {
        if (this.mTitleCondensed != null) {
            return this.mTitleCondensed;
        }
        return this.mTitle;
    }

    CharSequence getTitleForItemView(MenuView.ItemView itemView) {
        if (itemView != null && itemView.prefersCondensedTitle()) {
            return this.getTitleCondensed();
        }
        return this.getTitle();
    }

    @Override
    public boolean hasSubMenu() {
        return this.mSubMenu != null;
    }

    public boolean invoke() {
        if (this.mClickListener != null && this.mClickListener.onMenuItemClick(this)) {
            return true;
        }
        MenuBuilder.Callback callback = this.mMenu.getCallback();
        if (callback != null && callback.onMenuItemSelected(this.mMenu.getRootMenu(), this)) {
            return true;
        }
        if (this.mItemCallback != null) {
            this.mItemCallback.run();
            return true;
        }
        if (this.mIntent != null) {
            try {
                this.mMenu.getContext().startActivity(this.mIntent);
                return true;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                Log.e(TAG, "Can't find activity to handle intent; ignoring", activityNotFoundException);
            }
        }
        return false;
    }

    @Override
    public boolean isCheckable() {
        return (1 & this.mFlags) == 1;
    }

    @Override
    public boolean isChecked() {
        return (2 & this.mFlags) == 2;
    }

    @Override
    public boolean isEnabled() {
        return (0x10 & this.mFlags) != 0;
    }

    public boolean isExclusiveCheckable() {
        return (4 & this.mFlags) != 0;
    }

    @Override
    public boolean isVisible() {
        return (8 & this.mFlags) == 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    void refreshShortcutOnItemViews(boolean bl, boolean bl2) {
        char c = bl2 ? this.mShortcutAlphabeticChar : this.mShortcutNumericChar;
        boolean bl3 = bl && c != '\u0000';
        int n = 2;
        while (n >= 0) {
            if (this.hasItemView(n)) {
                ((MenuView.ItemView)this.mItemViews[n].get()).setShortcut(bl3, c);
            }
            --n;
        }
        return;
    }

    @Override
    public MenuItem setAlphabeticShortcut(char c) {
        if (this.mShortcutAlphabeticChar == c) {
            return this;
        }
        this.mShortcutAlphabeticChar = Character.toLowerCase(c);
        this.refreshShortcutOnItemViews();
        return this;
    }

    public MenuItem setCallback(Runnable runnable) {
        this.mItemCallback = runnable;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public MenuItem setCheckable(boolean bl) {
        int n = this.mFlags;
        int n2 = 0xFFFFFFFE & this.mFlags;
        int n3 = bl ? 1 : 0;
        this.mFlags = n2 | n3;
        if (n != this.mFlags) {
            for (int i = 2; i >= 0; --i) {
                if (!this.hasItemView(i)) continue;
                ((MenuView.ItemView)this.mItemViews[i].get()).setCheckable(bl);
            }
        }
        return this;
    }

    @Override
    public MenuItem setChecked(boolean bl) {
        if ((4 & this.mFlags) != 0) {
            this.mMenu.setExclusiveItemChecked(this);
            return this;
        }
        this.setCheckedInt(bl);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setCheckedInt(boolean bl) {
        int n = this.mFlags;
        int n2 = 0xFFFFFFFD & this.mFlags;
        int n3 = bl ? 2 : 0;
        this.mFlags = n2 | n3;
        if (n != this.mFlags) {
            for (int i = 2; i >= 0; --i) {
                if (!this.hasItemView(i)) continue;
                ((MenuView.ItemView)this.mItemViews[i].get()).setChecked(bl);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public MenuItem setEnabled(boolean bl) {
        this.mFlags = bl ? 0x10 | this.mFlags : 0xFFFFFFEF & this.mFlags;
        int n = 2;
        while (n >= 0) {
            if (this.hasItemView(n)) {
                ((MenuView.ItemView)this.mItemViews[n].get()).setEnabled(bl);
            }
            --n;
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setExclusiveCheckable(boolean bl) {
        int n = 0xFFFFFFFB & this.mFlags;
        int n2 = bl ? 4 : 0;
        this.mFlags = n | n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public MenuItem setIcon(int n) {
        this.mIconDrawable = null;
        this.mIconResId = n;
        if (this.haveAnyOpenedIconCapableItemViews()) {
            Drawable drawable2 = n != 0 ? this.mMenu.getResources().getDrawable(n) : null;
            this.setIconOnViews(drawable2);
        }
        return this;
    }

    @Override
    public MenuItem setIcon(Drawable drawable2) {
        this.mIconResId = 0;
        this.mIconDrawable = drawable2;
        this.setIconOnViews(drawable2);
        return this;
    }

    @Override
    public MenuItem setIntent(Intent intent) {
        this.mIntent = intent;
        return this;
    }

    void setMenuInfo(ContextMenu.ContextMenuInfo contextMenuInfo) {
        this.mMenuInfo = contextMenuInfo;
    }

    @Override
    public MenuItem setNumericShortcut(char c) {
        if (this.mShortcutNumericChar == c) {
            return this;
        }
        this.mShortcutNumericChar = c;
        this.refreshShortcutOnItemViews();
        return this;
    }

    @Override
    public MenuItem setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener onMenuItemClickListener) {
        this.mClickListener = onMenuItemClickListener;
        return this;
    }

    @Override
    public MenuItem setShortcut(char c, char c2) {
        this.mShortcutNumericChar = c;
        this.mShortcutAlphabeticChar = Character.toLowerCase(c2);
        this.refreshShortcutOnItemViews();
        return this;
    }

    void setSubMenu(SubMenuBuilder subMenuBuilder) {
        if (this.mMenu != null && this.mMenu instanceof SubMenu) {
            throw new UnsupportedOperationException("Attempt to add a sub-menu to a sub-menu.");
        }
        this.mSubMenu = subMenuBuilder;
        subMenuBuilder.setHeaderTitle(this.getTitle());
    }

    @Override
    public MenuItem setTitle(int n) {
        return this.setTitle(this.mMenu.getContext().getString(n));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public MenuItem setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        for (int i = 2; i >= 0; --i) {
            MenuView.ItemView itemView;
            if (!this.hasItemView(i) || (itemView = (MenuView.ItemView)this.mItemViews[i].get()).prefersCondensedTitle() && this.mTitleCondensed != null) continue;
            itemView.setTitle(charSequence);
        }
        if (this.mSubMenu != null) {
            this.mSubMenu.setHeaderTitle(charSequence);
        }
        return this;
    }

    @Override
    public MenuItem setTitleCondensed(CharSequence charSequence) {
        this.mTitleCondensed = charSequence;
        if (charSequence == null) {
            charSequence = this.mTitle;
        }
        for (int i = 2; i >= 0; --i) {
            if (!this.hasItemView(i) || !((MenuView.ItemView)this.mItemViews[i].get()).prefersCondensedTitle()) continue;
            ((MenuView.ItemView)this.mItemViews[i].get()).setTitle(charSequence);
        }
        return this;
    }

    @Override
    public MenuItem setVisible(boolean bl) {
        if (this.setVisibleInt(bl)) {
            this.mMenu.onItemVisibleChanged(this);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean setVisibleInt(boolean bl) {
        int n = this.mFlags;
        int n2 = 0xFFFFFFF7 & this.mFlags;
        int n3 = bl ? 0 : 8;
        this.mFlags = n2 | n3;
        return n != this.mFlags;
    }

    public boolean shouldShowIcon(int n) {
        return n == 0 || this.mMenu.getOptionalIconsVisible();
    }

    boolean shouldShowShortcut() {
        return this.mMenu.isShortcutsVisible() && this.getShortcut() != '\u0000';
    }

    public String toString() {
        return ((Object)this.mTitle).toString();
    }
}

