/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.SystemClock;
import android.provider.ContactsContract;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.QuickContactBadge;
import android.widget.TextView;

public class ContactHeaderWidget
extends FrameLayout
implements View.OnClickListener {
    protected static final int CONTACT_LOOKUP_ID_COLUMN_INDEX = 0;
    protected static final String[] CONTACT_LOOKUP_PROJECTION;
    protected static final int EMAIL_LOOKUP_CONTACT_ID_COLUMN_INDEX = 0;
    protected static final int EMAIL_LOOKUP_CONTACT_LOOKUP_KEY_COLUMN_INDEX = 1;
    protected static final String[] EMAIL_LOOKUP_PROJECTION;
    protected static final int PHONE_LOOKUP_CONTACT_ID_COLUMN_INDEX = 0;
    protected static final int PHONE_LOOKUP_CONTACT_LOOKUP_KEY_COLUMN_INDEX = 1;
    protected static final String[] PHONE_LOOKUP_PROJECTION;
    private static final String TAG = "ContactHeaderWidget";
    private static final int TOKEN_CONTACT_INFO = 0;
    private static final int TOKEN_EMAIL_LOOKUP = 2;
    private static final int TOKEN_PHONE_LOOKUP = 1;
    private static final int TOKEN_PHOTO_QUERY = 3;
    private View mAggregateBadge;
    protected Uri mContactUri;
    protected ContentResolver mContentResolver = this.mContext.getContentResolver();
    private TextView mDisplayNameView;
    protected String[] mExcludeMimes = null;
    private ContactHeaderListener mListener;
    private int mNoPhotoResource;
    private TextView mPhoneticNameView;
    private QuickContactBadge mPhotoView;
    private ImageView mPresenceView;
    private QueryHandler mQueryHandler;
    private CheckBox mStarredView;
    private TextView mStatusAttributionView;
    private TextView mStatusView;

    static {
        PHONE_LOOKUP_PROJECTION = new String[]{"_id", "lookup"};
        EMAIL_LOOKUP_PROJECTION = new String[]{"contact_id", "lookup"};
        CONTACT_LOOKUP_PROJECTION = new String[]{"_id"};
    }

    public ContactHeaderWidget(Context context) {
        this(context, null);
    }

    public ContactHeaderWidget(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ContactHeaderWidget(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        ((LayoutInflater)this.mContext.getSystemService("layout_inflater")).inflate(17367070, (ViewGroup)this);
        this.mDisplayNameView = (TextView)this.findViewById(16908695);
        this.mAggregateBadge = this.findViewById(16908694);
        this.mPhoneticNameView = (TextView)this.findViewById(16908696);
        this.mStarredView = (CheckBox)this.findViewById(16908700);
        this.mStarredView.setOnClickListener(this);
        this.mPhotoView = (QuickContactBadge)this.findViewById(16908693);
        this.mPresenceView = (ImageView)this.findViewById(16908699);
        this.mStatusView = (TextView)this.findViewById(16908697);
        this.mStatusAttributionView = (TextView)this.findViewById(16908698);
        int n2 = 0xF & (int)SystemClock.elapsedRealtime();
        this.mNoPhotoResource = n2 < 9 ? 17301905 : (n2 < 14 ? 17301906 : 17301907);
        this.resetAsyncQueryHandler();
    }

    static /* synthetic */ QueryHandler access$000(ContactHeaderWidget contactHeaderWidget) {
        return contactHeaderWidget.mQueryHandler;
    }

    static /* synthetic */ Bitmap access$100(ContactHeaderWidget contactHeaderWidget, BitmapFactory.Options options) {
        return contactHeaderWidget.loadPlaceholderPhoto(options);
    }

    static /* synthetic */ QuickContactBadge access$200(ContactHeaderWidget contactHeaderWidget) {
        return contactHeaderWidget.mPhotoView;
    }

    static /* synthetic */ void access$300(ContactHeaderWidget contactHeaderWidget, Uri uri, boolean bl) {
        contactHeaderWidget.bindFromContactUriInternal(uri, bl);
    }

    private void bindFromContactUriInternal(Uri uri, boolean bl) {
        this.mContactUri = uri;
        this.startContactQuery(uri, bl);
    }

    private Bitmap loadPlaceholderPhoto(BitmapFactory.Options options) {
        if (this.mNoPhotoResource == 0) {
            return null;
        }
        return BitmapFactory.decodeResource(this.mContext.getResources(), this.mNoPhotoResource, options);
    }

    private void performDisplayNameClick() {
        if (this.mListener != null) {
            this.mListener.onDisplayNameClick(this.mDisplayNameView);
        }
    }

    private void performPhotoClick() {
        if (this.mListener != null) {
            this.mListener.onPhotoClick(this.mPhotoView);
        }
    }

    private void resetAsyncQueryHandler() {
        this.mQueryHandler = new QueryHandler(this.mContentResolver);
    }

    private void startContactQuery(Uri uri, boolean bl) {
        if (bl) {
            this.resetAsyncQueryHandler();
        }
        this.mQueryHandler.startQuery(0, uri, uri, ContactQuery.COLUMNS, null, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void bindContactInfo(Cursor cursor) {
        CharSequence charSequence;
        String string2;
        this.setDisplayName(cursor.getString(3), cursor.getString(4));
        boolean bl = cursor.getInt(5) != 0;
        this.mStarredView.setChecked(bl);
        if (!cursor.isNull(6)) {
            int n = cursor.getInt(6);
            this.mPresenceView.setImageResource(ContactsContract.StatusUpdates.getPresenceIconResourceId(n));
            this.mPresenceView.setVisibility(0);
        } else {
            this.mPresenceView.setVisibility(8);
        }
        if (TextUtils.isEmpty(string2 = cursor.getString(7))) {
            this.mStatusView.setVisibility(8);
            this.mStatusAttributionView.setVisibility(8);
            return;
        }
        this.mStatusView.setText(string2);
        this.mStatusView.setVisibility(0);
        boolean bl2 = cursor.isNull(8);
        CharSequence charSequence2 = null;
        if (!bl2) {
            charSequence2 = DateUtils.getRelativeTimeSpanString(cursor.getLong(8), System.currentTimeMillis(), 60000L, 262144);
        }
        boolean bl3 = cursor.isNull(10);
        String string3 = null;
        if (!bl3) {
            Resources resources;
            String string4 = cursor.getString(9);
            int n = cursor.getInt(10);
            if (TextUtils.isEmpty(string4)) {
                resources = this.getResources();
            } else {
                PackageManager packageManager = this.getContext().getPackageManager();
                try {
                    Resources resources2;
                    resources = resources2 = packageManager.getResourcesForApplication(string4);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    Log.w(TAG, "Contact status update resource package not found: " + string4);
                    resources = null;
                }
            }
            string3 = null;
            if (resources != null) {
                try {
                    String string5;
                    string3 = string5 = resources.getString(n);
                }
                catch (Resources.NotFoundException notFoundException) {
                    Log.w(TAG, "Contact status update resource not found: " + string4 + "@" + n);
                    string3 = null;
                }
            }
        }
        if ((charSequence = charSequence2 != null && string3 != null ? this.getContext().getString(17039994, charSequence2, string3) : (charSequence2 == null && string3 != null ? this.getContext().getString(17039993, string3) : (charSequence2 != null ? charSequence2 : null))) != null) {
            this.mStatusAttributionView.setText(charSequence);
            this.mStatusAttributionView.setVisibility(0);
            return;
        }
        this.mStatusAttributionView.setVisibility(8);
    }

    public void bindFromContactLookupUri(Uri uri) {
        this.bindFromContactUriInternal(uri, true);
    }

    public void bindFromEmail(String string2) {
        this.resetAsyncQueryHandler();
        this.mQueryHandler.startQuery(2, string2, Uri.withAppendedPath(ContactsContract.CommonDataKinds.Email.CONTENT_LOOKUP_URI, Uri.encode(string2)), EMAIL_LOOKUP_PROJECTION, null, null, null);
    }

    public void bindFromPhoneNumber(String string2) {
        this.resetAsyncQueryHandler();
        this.mQueryHandler.startQuery(1, string2, Uri.withAppendedPath(ContactsContract.PhoneLookup.CONTENT_FILTER_URI, Uri.encode(string2)), PHONE_LOOKUP_PROJECTION, null, null, null);
    }

    public void enableClickListeners() {
        this.mDisplayNameView.setOnClickListener(this);
        this.mPhotoView.setOnClickListener(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onClick(View view) {
        switch (view.getId()) {
            case 16908700: {
                if (this.mContactUri != null) {
                    ContentValues contentValues = new ContentValues(1);
                    contentValues.put("starred", this.mStarredView.isChecked());
                    this.mContentResolver.update(this.mContactUri, contentValues, null, null);
                    return;
                }
            }
            default: {
                return;
            }
            case 16908693: {
                this.performPhotoClick();
                return;
            }
            case 16908695: 
        }
        this.performDisplayNameClick();
    }

    public void setContactHeaderListener(ContactHeaderListener contactHeaderListener) {
        this.mListener = contactHeaderListener;
    }

    public void setContactUri(Uri uri) {
        this.setContactUri(uri, true);
    }

    public void setContactUri(Uri uri, boolean bl) {
        this.mContactUri = uri;
        if (bl) {
            this.mPhotoView.assignContactUri(uri);
        }
    }

    public void setDisplayName(CharSequence charSequence, CharSequence charSequence2) {
        this.mDisplayNameView.setText(charSequence);
        if (!TextUtils.isEmpty(charSequence2)) {
            this.mPhoneticNameView.setText(charSequence2);
            this.mPhoneticNameView.setVisibility(0);
            return;
        }
        this.mPhoneticNameView.setVisibility(8);
    }

    public void setExcludeMimes(String[] stringArray) {
        this.mExcludeMimes = stringArray;
        this.mPhotoView.setExcludeMimes(stringArray);
    }

    public void setPhoto(Bitmap bitmap) {
        this.mPhotoView.setImageBitmap(bitmap);
    }

    public void setPresence(int n) {
        this.mPresenceView.setImageResource(ContactsContract.StatusUpdates.getPresenceIconResourceId(n));
    }

    public void setSelectedContactsAppTabIndex(int n) {
        this.mPhotoView.setSelectedContactsAppTabIndex(n);
    }

    public void setSocialSnippet(CharSequence charSequence) {
        if (charSequence == null) {
            this.mStatusView.setVisibility(8);
            this.mStatusAttributionView.setVisibility(8);
            return;
        }
        this.mStatusView.setText(charSequence);
        this.mStatusView.setVisibility(0);
    }

    public void setStared(boolean bl) {
        this.mStarredView.setChecked(bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void showAggregateBadge(boolean bl) {
        View view = this.mAggregateBadge;
        int n = bl ? 0 : 8;
        view.setVisibility(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void showStar(boolean bl) {
        CheckBox checkBox = this.mStarredView;
        int n = bl ? 0 : 8;
        checkBox.setVisibility(n);
    }

    protected void startPhotoQuery(long l, Uri uri, boolean bl) {
        if (bl) {
            this.resetAsyncQueryHandler();
        }
        this.mQueryHandler.startQuery(3, uri, ContentUris.withAppendedId(ContactsContract.Data.CONTENT_URI, l), PhotoQuery.COLUMNS, null, null, null);
    }

    public void wipeClean() {
        this.resetAsyncQueryHandler();
        this.setDisplayName(null, null);
        this.setPhoto(this.loadPlaceholderPhoto(null));
        this.setSocialSnippet(null);
        this.setPresence(0);
        this.mContactUri = null;
        this.mExcludeMimes = null;
    }

    public static interface ContactHeaderListener {
        public void onDisplayNameClick(View var1);

        public void onPhotoClick(View var1);
    }

    private static interface ContactQuery {
        public static final String[] COLUMNS = new String[]{"_id", "lookup", "photo_id", "display_name", "phonetic_name", "starred", "contact_presence", "contact_status", "contact_status_ts", "contact_status_res_package", "contact_status_label"};
        public static final int CONTACT_PRESENCE_STATUS = 6;
        public static final int CONTACT_STATUS = 7;
        public static final int CONTACT_STATUS_LABEL = 10;
        public static final int CONTACT_STATUS_RES_PACKAGE = 9;
        public static final int CONTACT_STATUS_TIMESTAMP = 8;
        public static final int DISPLAY_NAME = 3;
        public static final int LOOKUP_KEY = 1;
        public static final int PHONETIC_NAME = 4;
        public static final int PHOTO_ID = 2;
        public static final int STARRED = 5;
        public static final int _ID;
    }

    private static interface PhotoQuery {
        public static final String[] COLUMNS = new String[]{"data15"};
        public static final int PHOTO;
    }

    private class QueryHandler
    extends AsyncQueryHandler {
        public QueryHandler(ContentResolver contentResolver) {
            super(contentResolver);
        }

        /*
         * Exception decompiling
         */
        @Override
        protected void onQueryComplete(int var1_1, Object var2_2, Cursor var3_3) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [8 : 209->254)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

