/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.graphics.Typeface;
import android.os.Handler;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.lang.ref.WeakReference;
import java.text.DateFormatSymbols;
import java.util.Calendar;

public class DigitalClock
extends LinearLayout {
    private static final String M12 = "h:mm";
    private static final String M24 = "kk:mm";
    private AmPm mAmPm;
    private int mAttached = 0;
    private Calendar mCalendar;
    private String mFormat;
    private ContentObserver mFormatChangeObserver;
    private final Handler mHandler = new Handler();
    private BroadcastReceiver mIntentReceiver;
    private TextView mTimeDisplay;

    public DigitalClock(Context context) {
        this(context, null);
    }

    public DigitalClock(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    static /* synthetic */ Calendar access$002(DigitalClock digitalClock, Calendar calendar) {
        digitalClock.mCalendar = calendar;
        return calendar;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setDateFormat() {
        String string2 = DateFormat.is24HourFormat(this.getContext()) ? M24 : M12;
        this.mFormat = string2;
        this.mAmPm.setShowAmPm(this.mFormat.equals(M12));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateTime() {
        this.mCalendar.setTimeInMillis(System.currentTimeMillis());
        CharSequence charSequence = DateFormat.format((CharSequence)this.mFormat, this.mCalendar);
        this.mTimeDisplay.setText(charSequence);
        AmPm amPm = this.mAmPm;
        boolean bl = this.mCalendar.get(9) == 0;
        amPm.setIsMorning(bl);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttached = 1 + this.mAttached;
        if (this.mIntentReceiver == null) {
            this.mIntentReceiver = new TimeChangedReceiver(this);
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.TIME_TICK");
            intentFilter.addAction("android.intent.action.TIME_SET");
            intentFilter.addAction("android.intent.action.TIMEZONE_CHANGED");
            this.mContext.registerReceiver(this.mIntentReceiver, intentFilter);
        }
        if (this.mFormatChangeObserver == null) {
            this.mFormatChangeObserver = new FormatChangeObserver(this);
            this.mContext.getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, this.mFormatChangeObserver);
        }
        this.updateTime();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        --this.mAttached;
        if (this.mIntentReceiver != null) {
            this.mContext.unregisterReceiver(this.mIntentReceiver);
        }
        if (this.mFormatChangeObserver != null) {
            this.mContext.getContentResolver().unregisterContentObserver(this.mFormatChangeObserver);
        }
        this.mFormatChangeObserver = null;
        this.mIntentReceiver = null;
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mTimeDisplay = (TextView)this.findViewById(16908765);
        this.mTimeDisplay.setTypeface(Typeface.createFromFile("/system/fonts/Clockopia.ttf"));
        this.mAmPm = new AmPm(this, Typeface.createFromFile("/system/fonts/DroidSans-Bold.ttf"));
        this.mCalendar = Calendar.getInstance();
        this.setDateFormat();
    }

    void updateTime(Calendar calendar) {
        this.mCalendar = calendar;
        this.updateTime();
    }

    static class AmPm {
        private TextView mAmPm;
        private String mAmString;
        private String mPmString;

        AmPm(View view, Typeface typeface) {
            this.mAmPm = (TextView)view.findViewById(16908766);
            if (typeface != null) {
                this.mAmPm.setTypeface(typeface);
            }
            String[] stringArray = new DateFormatSymbols().getAmPmStrings();
            this.mAmString = stringArray[0];
            this.mPmString = stringArray[1];
        }

        /*
         * Enabled aggressive block sorting
         */
        void setIsMorning(boolean bl) {
            TextView textView = this.mAmPm;
            String string2 = bl ? this.mAmString : this.mPmString;
            textView.setText(string2);
        }

        /*
         * Enabled aggressive block sorting
         */
        void setShowAmPm(boolean bl) {
            TextView textView = this.mAmPm;
            int n = bl ? 0 : 8;
            textView.setVisibility(n);
        }
    }

    private static class FormatChangeObserver
    extends ContentObserver {
        private WeakReference<DigitalClock> mClock;
        private Context mContext;

        public FormatChangeObserver(DigitalClock digitalClock) {
            super(new Handler());
            this.mClock = new WeakReference<DigitalClock>(digitalClock);
            this.mContext = digitalClock.getContext();
        }

        @Override
        public void onChange(boolean bl) {
            DigitalClock digitalClock = (DigitalClock)this.mClock.get();
            if (digitalClock != null) {
                digitalClock.setDateFormat();
                digitalClock.updateTime();
                return;
            }
            try {
                this.mContext.getContentResolver().unregisterContentObserver(this);
                return;
            }
            catch (RuntimeException runtimeException) {
                return;
            }
        }
    }

    private static class TimeChangedReceiver
    extends BroadcastReceiver {
        private WeakReference<DigitalClock> mClock;
        private Context mContext;

        public TimeChangedReceiver(DigitalClock digitalClock) {
            this.mClock = new WeakReference<DigitalClock>(digitalClock);
            this.mContext = digitalClock.getContext();
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            final boolean bl = intent.getAction().equals("android.intent.action.TIMEZONE_CHANGED");
            final DigitalClock digitalClock = (DigitalClock)this.mClock.get();
            if (digitalClock != null) {
                digitalClock.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (bl) {
                            DigitalClock.access$002(digitalClock, Calendar.getInstance());
                        }
                        digitalClock.updateTime();
                    }
                });
                return;
            }
            try {
                this.mContext.unregisterReceiver(this);
                return;
            }
            catch (RuntimeException runtimeException) {
                return;
            }
        }
    }
}

