/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.net.Uri;
import android.os.Bundle;
import android.text.Editable;
import android.text.Html;
import android.text.Layout;
import android.text.Spannable;
import android.text.Spanned;
import android.text.method.ArrowKeyMovementMethod;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.ParagraphStyle;
import android.text.style.QuoteSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import java.io.InputStream;
import java.util.ArrayList;

public class EditStyledText
extends EditText {
    private static final boolean DBG = false;
    public static final int DEFAULT_BACKGROUND_COLOR = 0xFFFFFF;
    public static final int HINT_MSG_COPY_BUF_BLANK = 1;
    public static final int HINT_MSG_NULL = 0;
    public static final int HINT_MSG_PUSH_COMPETE = 4;
    public static final int HINT_MSG_SELECT_END = 3;
    public static final int HINT_MSG_SELECT_START = 2;
    private static final String LOG_TAG = "EditStyledText";
    public static final int MODE_ALIGN = 6;
    public static final int MODE_COLOR = 4;
    public static final int MODE_COPY = 1;
    public static final int MODE_CUT = 7;
    public static final int MODE_NOTHING = 0;
    public static final int MODE_PASTE = 2;
    public static final int MODE_SELECT = 5;
    public static final int MODE_SIZE = 3;
    public static final int STATE_SELECTED = 2;
    public static final int STATE_SELECT_FIX = 3;
    public static final int STATE_SELECT_OFF = 0;
    public static final int STATE_SELECT_ON = 1;
    private int mBackgroundColor;
    private StyledTextConverter mConverter;
    private Drawable mDefaultBackground;
    private StyledTextDialog mDialog;
    private EditStyledTextNotifier mESTInterface;
    private EditorManager mManager;

    public EditStyledText(Context context) {
        super(context);
        this.init();
    }

    public EditStyledText(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    public EditStyledText(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init();
    }

    static /* synthetic */ int access$902(EditStyledText editStyledText, int n) {
        editStyledText.mBackgroundColor = n;
        return n;
    }

    private void init() {
        this.requestFocus();
        this.mDefaultBackground = this.getBackground();
        this.mBackgroundColor = 0xFFFFFF;
        this.mManager = new EditorManager(this);
        this.mConverter = new StyledTextConverter(this);
        this.mDialog = new StyledTextDialog(this);
        this.setMovementMethod(new StyledTextArrowKeyMethod(this.mManager));
        this.mManager.blockSoftKey();
        this.mManager.unblockSoftKey();
    }

    private void notifyStateChanged(int n, int n2) {
        if (this.mESTInterface != null) {
            this.mESTInterface.notifyStateChanged(n, n2);
        }
    }

    private void onShowAlignAlert() {
        this.mDialog.onShowAlignAlertDialog();
    }

    private void onShowBackgroundColorAlert() {
        this.mDialog.onShowBackgroundColorAlertDialog();
    }

    private void onShowForegroundColorAlert() {
        this.mDialog.onShowForegroundColorAlertDialog();
    }

    private void onShowSizeAlert() {
        this.mDialog.onShowSizeAlertDialog();
    }

    private void setHintMessage(int n) {
        if (this.mESTInterface != null) {
            this.mESTInterface.notifyHintMsg(n);
        }
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public int getEditMode() {
        return this.mManager.getEditMode();
    }

    public int getForeGroundColor(int n) {
        if (n < 0 || n > this.getText().length()) {
            Log.e(LOG_TAG, "---getForeGroundColor: Illigal position.");
            return 0xFFFFFF;
        }
        ForegroundColorSpan[] foregroundColorSpanArray = this.getText().getSpans(n, n, ForegroundColorSpan.class);
        if (foregroundColorSpanArray.length > 0) {
            return foregroundColorSpanArray[0].getForegroundColor();
        }
        return 0xFFFFFF;
    }

    public String getHtml() {
        return this.mConverter.getHtml();
    }

    public String getHtml(ArrayList<Uri> arrayList) {
        this.mConverter.getUriArray(arrayList, this.getText());
        return this.mConverter.getHtml();
    }

    @Override
    public Bundle getInputExtras(boolean bl) {
        Bundle bundle = super.getInputExtras(bl);
        if (bundle != null) {
            bundle = new Bundle();
        }
        bundle.putBoolean("allowEmoji", true);
        return bundle;
    }

    public int getSelectState() {
        return this.mManager.getSelectState();
    }

    public boolean isEditting() {
        return this.mManager.isEditting();
    }

    public boolean isSoftKeyBlocked() {
        return this.mManager.isSoftKeyBlocked();
    }

    public boolean isStyledText() {
        return this.mManager.isStyledText();
    }

    public void onClearStyles() {
        this.mManager.onClearStyles();
    }

    public void onEndEdit() {
        this.mManager.onEndEdit();
    }

    public void onFixSelectedItem() {
        this.mManager.onFixSelectedItem();
    }

    public void onInsertHorizontalLine() {
        this.mManager.onInsertHorizontalLine();
    }

    public void onInsertImage(int n) {
        this.mManager.onInsertImage(n);
    }

    public void onInsertImage(Uri uri) {
        this.mManager.onInsertImage(uri);
    }

    public void onStartAlign() {
        this.mManager.onStartAlign();
    }

    public void onStartBackgroundColor() {
        this.mManager.onStartBackgroundColor();
    }

    public void onStartColor() {
        this.mManager.onStartColor();
    }

    public void onStartCopy() {
        this.mManager.onStartCopy();
    }

    public void onStartCut() {
        this.mManager.onStartCut();
    }

    public void onStartEdit() {
        this.mManager.onStartEdit();
    }

    public void onStartPaste() {
        this.mManager.onStartPaste();
    }

    public void onStartSelect() {
        this.mManager.onStartSelect();
    }

    public void onStartSelectAll() {
        this.mManager.onStartSelectAll();
    }

    public void onStartSize() {
        this.mManager.onStartSize();
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mManager.isSoftKeyBlocked() && motionEvent.getAction() == 1) {
            this.cancelLongPress();
        }
        boolean bl = super.onTouchEvent(motionEvent);
        if (motionEvent.getAction() == 1) {
            this.mManager.onCursorMoved();
        }
        return bl;
    }

    public void setAlignAlertParams(CharSequence charSequence, CharSequence[] charSequenceArray) {
        this.mDialog.setAlignAlertParams(charSequence, charSequenceArray);
    }

    public void setAlignment(Layout.Alignment alignment) {
        this.mManager.setAlignment(alignment);
    }

    @Override
    public void setBackgroundColor(int n) {
        super.setBackgroundColor(n);
        this.mBackgroundColor = n;
    }

    public void setBuilder(AlertDialog.Builder builder) {
        this.mDialog.setBuilder(builder);
    }

    public void setColorAlertParams(CharSequence charSequence, CharSequence[] charSequenceArray, CharSequence[] charSequenceArray2) {
        this.mDialog.setColorAlertParams(charSequence, charSequenceArray, charSequenceArray2);
    }

    public void setHtml(String string2) {
        this.mConverter.SetHtml(string2);
    }

    public void setItemColor(int n) {
        this.mManager.setItemColor(n);
    }

    public void setItemSize(int n) {
        this.mManager.setItemSize(n);
    }

    public void setNotifier(EditStyledTextNotifier editStyledTextNotifier) {
        this.mESTInterface = editStyledTextNotifier;
    }

    public void setSizeAlertParams(CharSequence charSequence, CharSequence[] charSequenceArray, CharSequence[] charSequenceArray2, CharSequence[] charSequenceArray3) {
        this.mDialog.setSizeAlertParams(charSequence, charSequenceArray, charSequenceArray2, charSequenceArray3);
    }

    public static interface EditStyledTextNotifier {
        public void notifyHintMsg(int var1);

        public void notifyStateChanged(int var1, int var2);
    }

    private class EditorManager {
        private int mCurEnd = 0;
        private int mCurStart = 0;
        private EditStyledText mEST;
        private boolean mEditFlag = false;
        private int mMode = 0;
        private boolean mSoftKeyBlockFlag = false;
        private int mState = 0;

        EditorManager(EditStyledText editStyledText2) {
            this.mEST = editStyledText2;
        }

        private void blockSoftKey() {
            ((InputMethodManager)this.mEST.getContext().getSystemService("input_method")).hideSoftInputFromWindow(this.mEST.getWindowToken(), 0);
            this.mEST.setOnClickListener(new View.OnClickListener(){

                @Override
                public void onClick(View view) {
                    Log.d(EditStyledText.LOG_TAG, "--- ontrackballclick:");
                    EditorManager.this.onFixSelectedItem();
                }
            });
            this.mSoftKeyBlockFlag = true;
        }

        private void changeAlign(Layout.Alignment alignment) {
            this.setStyledTextSpan(new AlignmentSpan.Standard(alignment), this.findLineStart(this.mEST.getText(), this.mCurStart), this.findLineEnd(this.mEST.getText(), this.mCurEnd));
        }

        private void changeColorSelectedText(int n) {
            this.setStyledTextSpan(new ForegroundColorSpan(n), this.mCurStart, this.mCurEnd);
        }

        private void changeSizeSelectedText(int n) {
            this.setStyledTextSpan(new AbsoluteSizeSpan(n), this.mCurStart, this.mCurEnd);
        }

        private void doNextHandle() {
            switch (this.mMode) {
                default: {
                    return;
                }
                case 1: {
                    this.handleCopy();
                    return;
                }
                case 7: {
                    this.handleCut();
                    return;
                }
                case 2: {
                    this.handlePaste();
                    return;
                }
                case 3: {
                    this.handleSize();
                    return;
                }
                case 4: {
                    this.handleColor();
                    return;
                }
                case 6: 
            }
            this.handleAlign();
        }

        private int findLineEnd(Editable editable, int n) {
            int n2 = n;
            while (n2 < editable.length() && (n2 <= 0 || editable.charAt(n2 - 1) != '\n')) {
                ++n2;
            }
            return n2;
        }

        private int findLineStart(Editable editable, int n) {
            int n2 = n;
            while (n2 > 0 && editable.charAt(n2 - 1) != '\n') {
                --n2;
            }
            return n2;
        }

        private void handleAlign() {
            this.handleSetSpan(6);
        }

        private void handleCancel() {
            this.mMode = 0;
            this.mState = 0;
            this.mEditFlag = false;
            Log.d(EditStyledText.LOG_TAG, "--- handleCancel:" + this.mEST.getInputType());
            this.unblockSoftKey();
            this.unsetSelect();
        }

        private void handleColor() {
            this.handleSetSpan(4);
        }

        private void handleComplete() {
            if (!this.mEditFlag) {
                return;
            }
            if (this.mState == 2) {
                this.mState = 3;
            }
            this.doNextHandle();
        }

        private void handleCopy() {
            this.handleTextViewFunc(1, 0x1020021);
        }

        private void handleCut() {
            this.handleTextViewFunc(7, 0x1020020);
        }

        private void handlePaste() {
            if (!this.mEditFlag) {
                return;
            }
            this.mEST.onTextContextMenuItem(0x1020022);
        }

        private void handleResetEdit() {
            this.blockSoftKey();
            this.handleCancel();
            this.mEditFlag = true;
            this.mEST.setHintMessage(2);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void handleSelect() {
            block9: {
                block8: {
                    if (!this.mEditFlag) break block8;
                    if (this.mState == 0) {
                        if (this.isTextSelected()) {
                            Log.e(EditStyledText.LOG_TAG, "Selection is off, but selected");
                        }
                        this.setSelectStartPos();
                        this.blockSoftKey();
                        this.mEST.setHintMessage(3);
                        return;
                    }
                    if (this.mState == 1) {
                        if (this.isTextSelected()) {
                            Log.e(EditStyledText.LOG_TAG, "Selection now start, but selected");
                        }
                        this.setSelectedEndPos();
                        this.mEST.setHintMessage(4);
                        this.doNextHandle();
                        return;
                    }
                    if (this.mState == 2) break block9;
                }
                return;
            }
            if (!this.isTextSelected()) {
                Log.e(EditStyledText.LOG_TAG, "Selection is done, but not selected");
            }
            this.setSelectedEndPos();
            this.doNextHandle();
        }

        private void handleSelectAll() {
            if (!this.mEditFlag) {
                return;
            }
            this.mEST.selectAll();
            this.mState = 2;
        }

        private void handleSetSpan(int n) {
            if (!this.mEditFlag) {
                Log.e(EditStyledText.LOG_TAG, "--- handleSetSpan: Editing is not started.");
                return;
            }
            if (this.mMode == 0 || this.mMode == 5) {
                this.mMode = n;
                if (this.mState == 2) {
                    this.mState = 3;
                    this.handleSetSpan(n);
                    return;
                }
                this.handleSelect();
                return;
            }
            if (this.mMode != n) {
                this.handleCancel();
                this.mMode = n;
                this.handleSetSpan(n);
                return;
            }
            if (this.mState == 3) {
                this.mEST.setHintMessage(0);
                switch (n) {
                    default: {
                        Log.e(EditStyledText.LOG_TAG, "--- handleSetSpan: invalid mode.");
                        return;
                    }
                    case 4: {
                        this.mEST.onShowForegroundColorAlert();
                        return;
                    }
                    case 3: {
                        this.mEST.onShowSizeAlert();
                        return;
                    }
                    case 6: 
                }
                this.mEST.onShowAlignAlert();
                return;
            }
            Log.d(EditStyledText.LOG_TAG, "--- handleSetSpan: do nothing.");
        }

        private void handleSize() {
            this.handleSetSpan(3);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void handleTextViewFunc(int n, int n2) {
            block7: {
                block6: {
                    if (!this.mEditFlag) break block6;
                    if (this.mMode == 0 || this.mMode == 5) {
                        this.mMode = n;
                        if (this.mState == 2) {
                            this.mState = 3;
                            this.handleTextViewFunc(n, n2);
                            return;
                        }
                        this.handleSelect();
                        return;
                    }
                    if (this.mMode != n) {
                        this.handleCancel();
                        this.mMode = n;
                        this.handleTextViewFunc(n, n2);
                        return;
                    }
                    if (this.mState == 3) break block7;
                }
                return;
            }
            this.mEST.onTextContextMenuItem(n2);
            this.handleResetEdit();
        }

        private void insertImageSpan(ImageSpan imageSpan) {
            if (imageSpan != null) {
                Log.d(EditStyledText.LOG_TAG, "--- insertimagespan:" + imageSpan.getDrawable().getIntrinsicHeight() + "," + imageSpan.getDrawable().getIntrinsicWidth());
                Log.d(EditStyledText.LOG_TAG, "--- insertimagespan:" + imageSpan.getDrawable().getClass());
                int n = this.mEST.getSelectionStart();
                this.mEST.getText().insert(n, "\ufffc");
                this.mEST.getText().setSpan(imageSpan, n, n + 1, 33);
                this.mEST.notifyStateChanged(this.mMode, this.mState);
                return;
            }
            Log.e(EditStyledText.LOG_TAG, "--- insertImageSpan: null span was inserted");
        }

        private boolean isTextSelected() {
            return this.mCurStart != this.mCurEnd && (this.mState == 2 || this.mState == 3);
        }

        private void setSelectStartPos() {
            this.mCurStart = this.mEST.getSelectionStart();
            this.mState = 1;
        }

        private void setSelectedEndPos() {
            if (this.mEST.getSelectionStart() == this.mCurStart) {
                this.setSelectedEndPos(this.mEST.getSelectionEnd());
                return;
            }
            this.setSelectedEndPos(this.mEST.getSelectionStart());
        }

        /*
         * Enabled aggressive block sorting
         */
        private void setSelection() {
            if (this.mCurStart >= 0 && this.mCurStart <= this.mEST.getText().length() && this.mCurEnd >= 0 && this.mCurEnd <= this.mEST.getText().length()) {
                if (this.mCurStart < this.mCurEnd) {
                    this.mEST.setSelection(this.mCurStart, this.mCurEnd);
                } else {
                    this.mEST.setSelection(this.mCurEnd, this.mCurStart);
                }
                this.mState = 2;
                return;
            }
            Log.e(EditStyledText.LOG_TAG, "Select is on, but cursor positions are illigal.:" + this.mEST.getText().length() + "," + this.mCurStart + "," + this.mCurEnd);
        }

        private void setStyledTextSpan(Object object, int n, int n2) {
            if (n < n2) {
                this.mEST.getText().setSpan(object, n, n2, 33);
                return;
            }
            this.mEST.getText().setSpan(object, n2, n, 33);
        }

        private void unblockSoftKey() {
            this.mEST.setOnClickListener(null);
            this.mSoftKeyBlockFlag = false;
        }

        private void unsetSelect() {
            int n = this.mEST.getSelectionStart();
            this.mEST.setSelection(n, n);
            this.mState = 0;
        }

        public int getEditMode() {
            return this.mMode;
        }

        public int getSelectState() {
            return this.mState;
        }

        public int getSelectionEnd() {
            return this.mCurEnd;
        }

        public int getSelectionStart() {
            return this.mCurStart;
        }

        public boolean isEditting() {
            return this.mEditFlag;
        }

        public boolean isSoftKeyBlocked() {
            return this.mSoftKeyBlockFlag;
        }

        public boolean isStyledText() {
            int n;
            Editable editable = this.mEST.getText();
            return editable.getSpans(0, (n = editable.length()) - 1, ParagraphStyle.class).length > 0 || editable.getSpans(0, n - 1, QuoteSpan.class).length > 0 || editable.getSpans(0, n - 1, CharacterStyle.class).length > 0 || this.mEST.mBackgroundColor != 0xFFFFFF;
        }

        public void onClearStyles() {
            Editable editable = this.mEST.getText();
            for (Object object : editable.getSpans(0, editable.length(), Object.class)) {
                if (!(object instanceof ParagraphStyle) && !(object instanceof QuoteSpan) && !(object instanceof CharacterStyle)) continue;
                if (object instanceof ImageSpan) {
                    editable.replace(editable.getSpanStart(object), editable.getSpanEnd(object), "");
                }
                editable.removeSpan(object);
            }
            this.mEST.setBackgroundDrawable(this.mEST.mDefaultBackground);
            EditStyledText.access$902(this.mEST, 0xFFFFFF);
        }

        public void onCursorMoved() {
            if (this.mState == 1 || this.mState == 2) {
                this.handleSelect();
                this.mEST.notifyStateChanged(this.mMode, this.mState);
            }
        }

        public void onEndEdit() {
            this.handleCancel();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onFixSelectedItem() {
            this.handleComplete();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onInsertHorizontalLine() {
            this.insertImageSpan(new HorizontalLineSpan(-16777216, this.mEST));
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onInsertImage(int n) {
            this.insertImageSpan(new ImageSpan(this.mEST.getContext(), n));
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onInsertImage(Uri uri) {
            this.insertImageSpan(new ImageSpan(this.mEST.getContext(), uri));
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onStartAlign() {
            this.handleAlign();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onStartBackgroundColor() {
            this.mEST.onShowBackgroundColorAlert();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onStartColor() {
            this.handleColor();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onStartCopy() {
            this.handleCopy();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onStartCut() {
            this.handleCut();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onStartEdit() {
            Log.d(EditStyledText.LOG_TAG, "--- onstartedit:");
            this.handleResetEdit();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onStartPaste() {
            this.handlePaste();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onStartSelect() {
            this.mMode = 5;
            if (this.mState == 0) {
                this.handleSelect();
            } else {
                this.unsetSelect();
                this.handleSelect();
            }
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onStartSelectAll() {
            this.handleSelectAll();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void onStartSize() {
            this.handleSize();
            this.mEST.notifyStateChanged(this.mMode, this.mState);
        }

        public void setAlignment(Layout.Alignment alignment) {
            if (this.mState == 2 || this.mState == 3) {
                this.changeAlign(alignment);
                this.handleResetEdit();
            }
        }

        public void setItemColor(int n) {
            if (this.mState == 2 || this.mState == 3) {
                this.changeColorSelectedText(n);
                this.handleResetEdit();
            }
        }

        public void setItemSize(int n) {
            if (this.mState == 2 || this.mState == 3) {
                this.changeSizeSelectedText(n);
                this.handleResetEdit();
            }
        }

        public void setSelectedEndPos(int n) {
            this.mCurEnd = n;
            this.setSelection();
        }
    }

    public class HorizontalLineDrawable
    extends ShapeDrawable {
        private View mView;

        public HorizontalLineDrawable(int n, View view) {
            super(new RectShape());
            this.mView = view;
            this.renewColor(n);
            this.renewBounds(view);
        }

        private ImageSpan getParentSpan() {
            Editable editable;
            ImageSpan[] imageSpanArray;
            if (this.mView instanceof EditStyledText && (imageSpanArray = (editable = ((EditStyledText)this.mView).getText()).getSpans(0, editable.length(), ImageSpan.class)).length > 0) {
                for (ImageSpan imageSpan : imageSpanArray) {
                    if (imageSpan.getDrawable() != this) continue;
                    return imageSpan;
                }
            }
            Log.e(EditStyledText.LOG_TAG, "---renewBounds: Couldn't find");
            return null;
        }

        private void renewBounds(View view) {
            int n = this.mView.getWidth();
            if (n > 20) {
                n -= 20;
            }
            this.setBounds(0, 0, n, 2);
        }

        private void renewColor() {
            if (this.mView instanceof View) {
                int n;
                ImageSpan imageSpan = this.getParentSpan();
                Editable editable = ((EditStyledText)this.mView).getText();
                ForegroundColorSpan[] foregroundColorSpanArray = editable.getSpans(n = editable.getSpanStart(imageSpan), n, ForegroundColorSpan.class);
                if (foregroundColorSpanArray.length > 0) {
                    this.renewColor(foregroundColorSpanArray[foregroundColorSpanArray.length - 1].getForegroundColor());
                }
            }
        }

        private void renewColor(int n) {
            this.getPaint().setColor(n);
        }

        @Override
        public void draw(Canvas canvas) {
            this.renewColor();
            this.renewBounds(this.mView);
            super.draw(canvas);
        }
    }

    public class HorizontalLineSpan
    extends ImageSpan {
        public HorizontalLineSpan(int n, View view) {
            super(new HorizontalLineDrawable(n, view));
        }
    }

    private class StyledTextArrowKeyMethod
    extends ArrowKeyMovementMethod {
        EditorManager mManager;

        StyledTextArrowKeyMethod(EditorManager editorManager) {
            this.mManager = editorManager;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean down(TextView textView, Spannable spannable) {
            int n;
            int n2;
            Layout layout2 = textView.getLayout();
            int n3 = layout2.getLineForOffset(n2 = this.getEndPos(textView));
            if (n3 >= layout2.getLineCount() - 1) {
                return false;
            }
            if (layout2.getParagraphDirection(n3) == layout2.getParagraphDirection(n3 + 1)) {
                float f = layout2.getPrimaryHorizontal(n2);
                n = layout2.getOffsetForHorizontal(n3 + 1, f);
            } else {
                n = layout2.getLineStart(n3 + 1);
            }
            this.mManager.setSelectedEndPos(n);
            this.mManager.onCursorMoved();
            return true;
        }

        private boolean executeDown(TextView textView, Spannable spannable, int n) {
            switch (n) {
                default: {
                    return false;
                }
                case 19: {
                    return false | this.up(textView, spannable);
                }
                case 20: {
                    return false | this.down(textView, spannable);
                }
                case 21: {
                    return false | this.left(textView, spannable);
                }
                case 22: {
                    return false | this.right(textView, spannable);
                }
                case 23: 
            }
            this.mManager.onFixSelectedItem();
            return true;
        }

        private int getEndPos(TextView textView) {
            if (textView.getSelectionStart() == this.mManager.getSelectionStart()) {
                return textView.getSelectionEnd();
            }
            return textView.getSelectionStart();
        }

        private boolean left(TextView textView, Spannable spannable) {
            int n = textView.getLayout().getOffsetToLeftOf(this.getEndPos(textView));
            this.mManager.setSelectedEndPos(n);
            this.mManager.onCursorMoved();
            return true;
        }

        private boolean right(TextView textView, Spannable spannable) {
            int n = textView.getLayout().getOffsetToRightOf(this.getEndPos(textView));
            this.mManager.setSelectedEndPos(n);
            this.mManager.onCursorMoved();
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean up(TextView textView, Spannable spannable) {
            int n;
            int n2;
            Layout layout2 = textView.getLayout();
            int n3 = layout2.getLineForOffset(n2 = this.getEndPos(textView));
            if (n3 <= 0) {
                return false;
            }
            if (layout2.getParagraphDirection(n3) == layout2.getParagraphDirection(n3 - 1)) {
                float f = layout2.getPrimaryHorizontal(n2);
                n = layout2.getOffsetForHorizontal(n3 - 1, f);
            } else {
                n = layout2.getLineStart(n3 - 1);
            }
            this.mManager.setSelectedEndPos(n);
            this.mManager.onCursorMoved();
            return true;
        }

        @Override
        public boolean onKeyDown(TextView textView, Spannable spannable, int n, KeyEvent keyEvent) {
            if (!this.mManager.isSoftKeyBlocked()) {
                return super.onKeyDown(textView, spannable, n, keyEvent);
            }
            return this.executeDown(textView, spannable, n);
        }
    }

    private class StyledTextConverter {
        private EditStyledText mEST;

        public StyledTextConverter(EditStyledText editStyledText2) {
            this.mEST = editStyledText2;
        }

        public void SetHtml(String string2) {
            Spanned spanned = Html.fromHtml(string2, new Html.ImageGetter(){

                @Override
                public Drawable getDrawable(String string2) {
                    Log.d(EditStyledText.LOG_TAG, "--- sethtml: src=" + string2);
                    if (string2.startsWith("content://")) {
                        Uri uri = Uri.parse(string2);
                        try {
                            InputStream inputStream = StyledTextConverter.this.mEST.getContext().getContentResolver().openInputStream(uri);
                            Bitmap bitmap = BitmapFactory.decodeStream(inputStream);
                            BitmapDrawable bitmapDrawable = new BitmapDrawable(EditStyledText.this.getContext().getResources(), bitmap);
                            bitmapDrawable.setBounds(0, 0, ((Drawable)bitmapDrawable).getIntrinsicWidth(), ((Drawable)bitmapDrawable).getIntrinsicHeight());
                            inputStream.close();
                            return bitmapDrawable;
                        }
                        catch (Exception exception) {
                            Log.e(EditStyledText.LOG_TAG, "--- set html: Failed to loaded content " + uri, exception);
                            return null;
                        }
                    }
                    Log.d(EditStyledText.LOG_TAG, "  unknown src=" + string2);
                    return null;
                }
            }, null);
            this.mEST.setText(spanned);
        }

        public String getHtml() {
            return Html.toHtml(this.mEST.getText());
        }

        public void getUriArray(ArrayList<Uri> arrayList, Editable editable) {
            arrayList.clear();
            int n = editable.length();
            int n2 = 0;
            while (n2 < editable.length()) {
                int n3 = editable.nextSpanTransition(n2, n, ImageSpan.class);
                ImageSpan[] imageSpanArray = editable.getSpans(n2, n3, ImageSpan.class);
                for (int i = 0; i < imageSpanArray.length; ++i) {
                    arrayList.add(Uri.parse(imageSpanArray[i].getSource()));
                }
                n2 = n3;
            }
        }
    }

    private class StyledTextDialog {
        CharSequence[] mAlignNames;
        CharSequence mAlignTitle;
        AlertDialog.Builder mBuilder;
        CharSequence[] mColorInts;
        CharSequence[] mColorNames;
        CharSequence mColorTitle;
        EditStyledText mEST;
        CharSequence[] mSizeDisplayInts;
        CharSequence[] mSizeNames;
        CharSequence[] mSizeSendInts;
        CharSequence mSizeTitle;

        public StyledTextDialog(EditStyledText editStyledText2) {
            this.mEST = editStyledText2;
        }

        private boolean checkAlignAlertParams() {
            if (this.mBuilder == null) {
                Log.e(EditStyledText.LOG_TAG, "--- builder is null.");
                return false;
            }
            if (this.mAlignTitle == null) {
                Log.e(EditStyledText.LOG_TAG, "--- align alert params are null.");
                return false;
            }
            return true;
        }

        private boolean checkColorAlertParams() {
            if (this.mBuilder == null) {
                Log.e(EditStyledText.LOG_TAG, "--- builder is null.");
                return false;
            }
            if (this.mColorTitle == null || this.mColorNames == null || this.mColorInts == null) {
                Log.e(EditStyledText.LOG_TAG, "--- color alert params are null.");
                return false;
            }
            if (this.mColorNames.length != this.mColorInts.length) {
                Log.e(EditStyledText.LOG_TAG, "--- the length of color alert params are different.");
                return false;
            }
            return true;
        }

        private boolean checkSizeAlertParams() {
            if (this.mBuilder == null) {
                Log.e(EditStyledText.LOG_TAG, "--- builder is null.");
                return false;
            }
            if (this.mSizeTitle == null || this.mSizeNames == null || this.mSizeDisplayInts == null || this.mSizeSendInts == null) {
                Log.e(EditStyledText.LOG_TAG, "--- size alert params are null.");
                return false;
            }
            if (this.mSizeNames.length != this.mSizeDisplayInts.length && this.mSizeSendInts.length != this.mSizeDisplayInts.length) {
                Log.e(EditStyledText.LOG_TAG, "--- the length of size alert params are different.");
                return false;
            }
            return true;
        }

        private void onShowAlignAlertDialog() {
            if (!this.checkAlignAlertParams()) {
                return;
            }
            this.mBuilder.setTitle(this.mAlignTitle);
            this.mBuilder.setIcon(0);
            this.mBuilder.setItems(this.mAlignNames, new DialogInterface.OnClickListener(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void onClick(DialogInterface dialogInterface, int n) {
                    Log.d(EditStyledText.LOG_TAG, "mBuilder.onclick:" + n);
                    Layout.Alignment alignment = Layout.Alignment.ALIGN_NORMAL;
                    switch (n) {
                        case 0: {
                            alignment = Layout.Alignment.ALIGN_NORMAL;
                            break;
                        }
                        case 1: {
                            alignment = Layout.Alignment.ALIGN_CENTER;
                            break;
                        }
                        case 2: {
                            alignment = Layout.Alignment.ALIGN_OPPOSITE;
                            break;
                        }
                    }
                    StyledTextDialog.this.mEST.setAlignment(alignment);
                }
            });
            this.mBuilder.show();
        }

        private void onShowBackgroundColorAlertDialog() {
            if (!this.checkColorAlertParams()) {
                return;
            }
            this.mBuilder.setTitle(this.mColorTitle);
            this.mBuilder.setIcon(0);
            this.mBuilder.setItems(this.mColorNames, new DialogInterface.OnClickListener(){

                @Override
                public void onClick(DialogInterface dialogInterface, int n) {
                    Log.d("EETVM", "mBuilder.onclick:" + n);
                    int n2 = Integer.parseInt((String)StyledTextDialog.this.mColorInts[n], 16) - 0x1000000;
                    StyledTextDialog.this.mEST.setBackgroundColor(n2);
                }
            });
            this.mBuilder.show();
        }

        private void onShowForegroundColorAlertDialog() {
            if (!this.checkColorAlertParams()) {
                return;
            }
            this.mBuilder.setTitle(this.mColorTitle);
            this.mBuilder.setIcon(0);
            this.mBuilder.setItems(this.mColorNames, new DialogInterface.OnClickListener(){

                @Override
                public void onClick(DialogInterface dialogInterface, int n) {
                    Log.d("EETVM", "mBuilder.onclick:" + n);
                    int n2 = Integer.parseInt((String)StyledTextDialog.this.mColorInts[n], 16) - 0x1000000;
                    StyledTextDialog.this.mEST.setItemColor(n2);
                }
            });
            this.mBuilder.show();
        }

        private void onShowSizeAlertDialog() {
            if (!this.checkSizeAlertParams()) {
                return;
            }
            this.mBuilder.setTitle(this.mSizeTitle);
            this.mBuilder.setIcon(0);
            this.mBuilder.setItems(this.mSizeNames, new DialogInterface.OnClickListener(){

                @Override
                public void onClick(DialogInterface dialogInterface, int n) {
                    Log.d(EditStyledText.LOG_TAG, "mBuilder.onclick:" + n);
                    int n2 = Integer.parseInt((String)StyledTextDialog.this.mSizeDisplayInts[n]);
                    StyledTextDialog.this.mEST.setItemSize(n2);
                }
            });
            this.mBuilder.show();
        }

        public void setAlignAlertParams(CharSequence charSequence, CharSequence[] charSequenceArray) {
            this.mAlignTitle = charSequence;
            this.mAlignNames = charSequenceArray;
        }

        public void setBuilder(AlertDialog.Builder builder) {
            this.mBuilder = builder;
        }

        public void setColorAlertParams(CharSequence charSequence, CharSequence[] charSequenceArray, CharSequence[] charSequenceArray2) {
            this.mColorTitle = charSequence;
            this.mColorNames = charSequenceArray;
            this.mColorInts = charSequenceArray2;
        }

        public void setSizeAlertParams(CharSequence charSequence, CharSequence[] charSequenceArray, CharSequence[] charSequenceArray2, CharSequence[] charSequenceArray3) {
            this.mSizeTitle = charSequence;
            this.mSizeNames = charSequenceArray;
            this.mSizeDisplayInts = charSequenceArray2;
            this.mSizeSendInts = charSequenceArray3;
        }
    }
}

