/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.admin.DevicePolicyManager;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Environment;
import android.os.FileObserver;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.security.MessageDigest;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Button;
import com.android.internal.telephony.ITelephony;
import com.android.internal.widget.LockPatternView;
import com.google.android.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class LockPatternUtils {
    public static final int FAILED_ATTEMPTS_BEFORE_RESET = 20;
    public static final int FAILED_ATTEMPTS_BEFORE_TIMEOUT = 5;
    public static final long FAILED_ATTEMPT_COUNTDOWN_INTERVAL_MS = 1000L;
    public static final long FAILED_ATTEMPT_TIMEOUT_MS = 30000L;
    private static final String LOCKOUT_ATTEMPT_DEADLINE = "lockscreen.lockoutattemptdeadline";
    private static final String LOCKOUT_PERMANENT_KEY = "lockscreen.lockedoutpermanently";
    private static final String LOCK_PASSWORD_FILE = "password.key";
    private static final String LOCK_PASSWORD_SALT_KEY = "lockscreen.password_salt";
    private static final String LOCK_PATTERN_FILE = "gesture.key";
    public static final int MIN_LOCK_PATTERN_SIZE = 4;
    public static final int MIN_PATTERN_REGISTER_FAIL = 3;
    public static final String PASSWORD_TYPE_KEY = "lockscreen.password_type";
    private static final String PATTERN_EVER_CHOSEN_KEY = "lockscreen.patterneverchosen";
    private static final String SYSTEM_DIRECTORY = "/system/";
    private static final String TAG = "LockPatternUtils";
    private static final AtomicBoolean sHaveNonZeroPasswordFile;
    private static final AtomicBoolean sHaveNonZeroPatternFile;
    private static String sLockPasswordFilename;
    private static String sLockPatternFilename;
    private static FileObserver sPasswordObserver;
    private final ContentResolver mContentResolver;
    private final Context mContext;
    private DevicePolicyManager mDevicePolicyManager;

    static {
        sHaveNonZeroPatternFile = new AtomicBoolean(false);
        sHaveNonZeroPasswordFile = new AtomicBoolean(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public LockPatternUtils(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        if (sLockPatternFilename == null) {
            String string2 = Environment.getDataDirectory().getAbsolutePath() + SYSTEM_DIRECTORY;
            sLockPatternFilename = string2 + LOCK_PATTERN_FILE;
            sLockPasswordFilename = string2 + LOCK_PASSWORD_FILE;
            AtomicBoolean atomicBoolean = sHaveNonZeroPatternFile;
            boolean bl = new File(sLockPatternFilename).length() > 0L;
            atomicBoolean.set(bl);
            AtomicBoolean atomicBoolean2 = sHaveNonZeroPasswordFile;
            boolean bl2 = new File(sLockPasswordFilename).length() > 0L;
            atomicBoolean2.set(bl2);
            sPasswordObserver = new FileObserver(string2, 904){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void onEvent(int n, String string2) {
                    boolean bl;
                    AtomicBoolean atomicBoolean;
                    if (LockPatternUtils.LOCK_PATTERN_FILE.equals(string2)) {
                        Log.d(LockPatternUtils.TAG, "lock pattern file changed");
                        AtomicBoolean atomicBoolean2 = sHaveNonZeroPatternFile;
                        boolean bl2 = new File(sLockPatternFilename).length() > 0L;
                        atomicBoolean2.set(bl2);
                        return;
                    } else {
                        if (!LockPatternUtils.LOCK_PASSWORD_FILE.equals(string2)) return;
                        Log.d(LockPatternUtils.TAG, "lock password file changed");
                        atomicBoolean = sHaveNonZeroPasswordFile;
                        bl = new File(sLockPasswordFilename).length() > 0L;
                    }
                    atomicBoolean.set(bl);
                }
            };
            sPasswordObserver.startWatching();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int computePasswordQuality(String string2) {
        boolean bl = false;
        boolean bl2 = false;
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string2.charAt(i))) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        if (bl2 && bl) {
            return 327680;
        }
        if (bl2) {
            return 262144;
        }
        if (bl) {
            return 131072;
        }
        return 0;
    }

    private boolean getBoolean(String string2) {
        return 1 == Settings.Secure.getInt(this.mContentResolver, string2, 0);
    }

    private long getLong(String string2, long l) {
        return Settings.Secure.getLong(this.mContentResolver, string2, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getSalt() {
        long l = this.getLong(LOCK_PASSWORD_SALT_KEY, 0L);
        if (l != 0L) return Long.toHexString(l);
        try {
            l = SecureRandom.getInstance("SHA1PRNG").nextLong();
            this.setLong(LOCK_PASSWORD_SALT_KEY, l);
            Log.v(TAG, "Initialized lock password salt");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Couldn't get SecureRandom number", noSuchAlgorithmException);
        }
        return Long.toHexString(l);
    }

    private static byte[] patternToHash(List<LockPatternView.Cell> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            LockPatternView.Cell cell = list.get(i);
            byArray[i] = (byte)(3 * cell.getRow() + cell.getColumn());
        }
        try {
            byte[] byArray2 = MessageDigest.getInstance("SHA-1").digest(byArray);
            return byArray2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return byArray;
        }
    }

    public static String patternToString(List<LockPatternView.Cell> list) {
        if (list == null) {
            return "";
        }
        int n = list.size();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            LockPatternView.Cell cell = list.get(i);
            byArray[i] = (byte)(3 * cell.getRow() + cell.getColumn());
        }
        return new String(byArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setBoolean(String string2, boolean bl) {
        ContentResolver contentResolver = this.mContentResolver;
        int n = bl ? 1 : 0;
        Settings.Secure.putInt(contentResolver, string2, n);
    }

    private void setLong(String string2, long l) {
        Settings.Secure.putLong(this.mContentResolver, string2, l);
    }

    public static List<LockPatternView.Cell> stringToPattern(String string2) {
        ArrayList<LockPatternView.Cell> arrayList = Lists.newArrayList();
        byte[] byArray = string2.getBytes();
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            arrayList.add(LockPatternView.Cell.of(by / 3, by % 3));
        }
        return arrayList;
    }

    private static String toHex(byte[] byArray) {
        String string2 = "";
        for (int i = 0; i < byArray.length; ++i) {
            String string3 = string2 + "0123456789ABCDEF".charAt(0xF & byArray[i] >> 4);
            string2 = string3 + "0123456789ABCDEF".charAt(0xF & byArray[i]);
        }
        return string2;
    }

    public boolean checkPassword(String string2) {
        byte[] byArray;
        block4: {
            RandomAccessFile randomAccessFile = new RandomAccessFile(sLockPasswordFilename, "r");
            byArray = new byte[(int)randomAccessFile.length()];
            int n = randomAccessFile.read(byArray, 0, byArray.length);
            randomAccessFile.close();
            if (n > 0) break block4;
            return true;
        }
        try {
            boolean bl = Arrays.equals(byArray, this.passwordToHash(string2));
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return true;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public boolean checkPattern(List<LockPatternView.Cell> list) {
        byte[] byArray;
        block4: {
            RandomAccessFile randomAccessFile = new RandomAccessFile(sLockPatternFilename, "r");
            byArray = new byte[(int)randomAccessFile.length()];
            int n = randomAccessFile.read(byArray, 0, byArray.length);
            randomAccessFile.close();
            if (n > 0) break block4;
            return true;
        }
        try {
            boolean bl = Arrays.equals(byArray, LockPatternUtils.patternToHash(list));
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return true;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public void clearLock() {
        this.getDevicePolicyManager().setActivePasswordState(0, 0);
        this.saveLockPassword(null, 65536);
        this.setLockPatternEnabled(false);
        this.saveLockPattern(null);
        this.setLong(PASSWORD_TYPE_KEY, 65536L);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getActivePasswordQuality() {
        switch (this.getKeyguardStoredPasswordQuality()) {
            case 65536: {
                if (!this.isLockPatternEnabled()) return 0;
                return 65536;
            }
            case 131072: {
                if (!this.isLockPasswordEnabled()) return 0;
                return 131072;
            }
            case 262144: {
                if (!this.isLockPasswordEnabled()) return 0;
                return 262144;
            }
            default: {
                return 0;
            }
            case 327680: 
        }
        if (!this.isLockPasswordEnabled()) return 0;
        return 327680;
    }

    public DevicePolicyManager getDevicePolicyManager() {
        if (this.mDevicePolicyManager == null) {
            this.mDevicePolicyManager = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
            if (this.mDevicePolicyManager == null) {
                Log.e(TAG, "Can't get DevicePolicyManagerService: is it running?", new IllegalStateException("Stack trace:"));
            }
        }
        return this.mDevicePolicyManager;
    }

    public int getKeyguardStoredPasswordQuality() {
        return (int)this.getLong(PASSWORD_TYPE_KEY, 65536L);
    }

    public long getLockoutAttemptDeadline() {
        long l;
        long l2 = this.getLong(LOCKOUT_ATTEMPT_DEADLINE, 0L);
        if (l2 < (l = SystemClock.elapsedRealtime()) || l2 > 30000L + l) {
            return 0L;
        }
        return l2;
    }

    public String getNextAlarm() {
        String string2 = Settings.System.getString(this.mContentResolver, "next_alarm_formatted");
        if (string2 == null || TextUtils.isEmpty(string2)) {
            return null;
        }
        return string2;
    }

    public int getRequestedMinimumPasswordLength() {
        return this.getDevicePolicyManager().getPasswordMinimumLength(null);
    }

    public int getRequestedPasswordQuality() {
        return this.getDevicePolicyManager().getPasswordQuality(null);
    }

    public boolean isLockPasswordEnabled() {
        long l = this.getLong(PASSWORD_TYPE_KEY, 0L);
        return this.savedPasswordExists() && (l == 262144L || l == 131072L || l == 327680L);
    }

    public boolean isLockPatternEnabled() {
        return this.getBoolean("lock_pattern_autolock") && this.getLong(PASSWORD_TYPE_KEY, 65536L) == 65536L;
    }

    public boolean isPatternEverChosen() {
        return this.getBoolean(PATTERN_EVER_CHOSEN_KEY);
    }

    public boolean isPermanentlyLocked() {
        return this.getBoolean(LOCKOUT_PERMANENT_KEY);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isSecure() {
        long l = this.getKeyguardStoredPasswordQuality();
        boolean bl = l == 65536L;
        boolean bl2 = l == 131072L || l == 262144L || l == 327680L;
        return bl && this.isLockPatternEnabled() && this.savedPatternExists() || bl2 && this.savedPasswordExists();
    }

    public boolean isTactileFeedbackEnabled() {
        return this.getBoolean("lock_pattern_tactile_feedback_enabled");
    }

    public boolean isVisiblePatternEnabled() {
        return this.getBoolean("lock_pattern_visible_pattern");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] passwordToHash(String string2) {
        byte[] byArray;
        if (string2 == null) {
            return null;
        }
        String string3 = null;
        try {
            byArray = (string2 + this.getSalt()).getBytes();
            string3 = "SHA-1";
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w(TAG, "Failed to encode string because of missing algorithm: " + string3);
            return null;
        }
        byte[] byArray2 = MessageDigest.getInstance(string3).digest(byArray);
        string3 = "MD5";
        byte[] byArray3 = MessageDigest.getInstance(string3).digest(byArray);
        byte[] byArray4 = (LockPatternUtils.toHex(byArray2) + LockPatternUtils.toHex(byArray3)).getBytes();
        return byArray4;
    }

    public void reportFailedPasswordAttempt() {
        this.getDevicePolicyManager().reportFailedPasswordAttempt();
    }

    public void reportSuccessfulPasswordAttempt() {
        this.getDevicePolicyManager().reportSuccessfulPasswordAttempt();
    }

    public boolean resumeCall() {
        ITelephony iTelephony = ITelephony.Stub.asInterface(ServiceManager.checkService("phone"));
        if (iTelephony != null) {
            try {
                boolean bl = iTelephony.showCallScreen();
                if (bl) {
                    return true;
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveLockPassword(String string2, int n) {
        byte[] byArray = this.passwordToHash(string2);
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(sLockPasswordFilename, "rw");
            if (string2 == null) {
                randomAccessFile.setLength(0L);
            } else {
                randomAccessFile.write(byArray, 0, byArray.length);
            }
            randomAccessFile.close();
            DevicePolicyManager devicePolicyManager = this.getDevicePolicyManager();
            if (string2 != null) {
                int n2 = LockPatternUtils.computePasswordQuality(string2);
                this.setLong(PASSWORD_TYPE_KEY, n2);
                if (n2 != 0) {
                    devicePolicyManager.setActivePasswordState(n2, string2.length());
                    return;
                }
                devicePolicyManager.setActivePasswordState(0, 0);
                return;
            }
            devicePolicyManager.setActivePasswordState(0, 0);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e(TAG, "Unable to save lock pattern to " + sLockPasswordFilename);
            return;
        }
        catch (IOException iOException) {
            Log.e(TAG, "Unable to save lock pattern to " + sLockPasswordFilename);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveLockPattern(List<LockPatternView.Cell> list) {
        DevicePolicyManager devicePolicyManager;
        byte[] byArray = LockPatternUtils.patternToHash(list);
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(sLockPatternFilename, "rw");
            if (list == null) {
                randomAccessFile.setLength(0L);
            } else {
                randomAccessFile.write(byArray, 0, byArray.length);
            }
            randomAccessFile.close();
            devicePolicyManager = this.getDevicePolicyManager();
            if (list != null) {
                this.setBoolean(PATTERN_EVER_CHOSEN_KEY, true);
                this.setLong(PASSWORD_TYPE_KEY, 65536L);
                devicePolicyManager.setActivePasswordState(65536, list.size());
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e(TAG, "Unable to save lock pattern to " + sLockPatternFilename);
            return;
        }
        catch (IOException iOException) {
            Log.e(TAG, "Unable to save lock pattern to " + sLockPatternFilename);
            return;
        }
        {
            devicePolicyManager.setActivePasswordState(0, 0);
            return;
        }
    }

    public boolean savedPasswordExists() {
        return sHaveNonZeroPasswordFile.get();
    }

    public boolean savedPatternExists() {
        return sHaveNonZeroPatternFile.get();
    }

    public void setLockPatternEnabled(boolean bl) {
        this.setBoolean("lock_pattern_autolock", bl);
    }

    public long setLockoutAttemptDeadline() {
        long l = 30000L + SystemClock.elapsedRealtime();
        this.setLong(LOCKOUT_ATTEMPT_DEADLINE, l);
        return l;
    }

    public void setPermanentlyLocked(boolean bl) {
        this.setBoolean(LOCKOUT_PERMANENT_KEY, bl);
    }

    public void setTactileFeedbackEnabled(boolean bl) {
        this.setBoolean("lock_pattern_tactile_feedback_enabled", bl);
    }

    public void setVisiblePatternEnabled(boolean bl) {
        this.setBoolean("lock_pattern_visible_pattern", bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateEmergencyCallButtonState(Button button) {
        int n;
        if (TelephonyManager.getDefault().getCallState() == 2) {
            n = 17040006;
            button.setCompoundDrawablesWithIntrinsicBounds(17301636, 0, 0, 0);
        } else {
            n = 17040005;
            button.setCompoundDrawablesWithIntrinsicBounds(17301910, 0, 0, 0);
        }
        button.setText(n);
    }
}

