/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.Vibrator;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.android.internal.R;
import com.android.internal.widget.LockPatternUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class LockPatternView
extends View {
    private static final int ASPECT_LOCK_HEIGHT = 2;
    private static final int ASPECT_LOCK_WIDTH = 1;
    private static final int ASPECT_SQUARE = 0;
    private static final long[] DEFAULT_VIBE_PATTERN = new long[]{0L, 1L, 40L, 41L};
    private static final int MILLIS_PER_CIRCLE_ANIMATING = 700;
    private static final boolean PROFILE_DRAWING = false;
    static final int STATUS_BAR_HEIGHT = 25;
    private long mAnimatingPeriodStart;
    private int mAspect;
    private Bitmap mBitmapArrowGreenUp;
    private Bitmap mBitmapArrowRedUp;
    private Bitmap mBitmapBtnDefault;
    private Bitmap mBitmapBtnTouched;
    private Bitmap mBitmapCircleDefault;
    private Bitmap mBitmapCircleGreen;
    private Bitmap mBitmapCircleRed;
    private int mBitmapHeight;
    private int mBitmapWidth;
    private final Path mCurrentPath;
    private float mDiameterFactor;
    private boolean mDrawingProfilingStarted = false;
    private float mHitFactor;
    private float mInProgressX;
    private float mInProgressY;
    private boolean mInStealthMode;
    private boolean mInputEnabled;
    private final Rect mInvalidate;
    private OnPatternListener mOnPatternListener;
    private Paint mPaint = new Paint();
    private Paint mPathPaint = new Paint();
    private ArrayList<Cell> mPattern = new ArrayList(9);
    private DisplayMode mPatternDisplayMode;
    private boolean[][] mPatternDrawLookup;
    private boolean mPatternInProgress;
    private float mSquareHeight;
    private float mSquareWidth;
    private boolean mTactileFeedbackEnabled;
    private long[] mVibePattern;
    private Vibrator vibe;

    public LockPatternView(Context context) {
        this(context, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public LockPatternView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int[] nArray = new int[]{3, 3};
        this.mPatternDrawLookup = (boolean[][])Array.newInstance(Boolean.TYPE, nArray);
        this.mInProgressX = -1.0f;
        this.mInProgressY = -1.0f;
        this.mPatternDisplayMode = DisplayMode.Correct;
        this.mInputEnabled = true;
        this.mInStealthMode = false;
        this.mTactileFeedbackEnabled = true;
        this.mPatternInProgress = false;
        this.mDiameterFactor = 0.5f;
        this.mHitFactor = 0.6f;
        this.mCurrentPath = new Path();
        this.mInvalidate = new Rect();
        this.vibe = new Vibrator();
        String string2 = context.obtainStyledAttributes(attributeSet, R.styleable.LockPatternView).getString(0);
        this.mAspect = "square".equals(string2) ? 0 : ("lock_width".equals(string2) ? 1 : ("lock_height".equals(string2) ? 2 : 0));
        this.setClickable(true);
        this.mPathPaint.setAntiAlias(true);
        this.mPathPaint.setDither(true);
        this.mPathPaint.setColor(-1);
        this.mPathPaint.setAlpha(128);
        this.mPathPaint.setStyle(Paint.Style.STROKE);
        this.mPathPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPathPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mBitmapBtnDefault = this.getBitmapFor(17301708);
        this.mBitmapBtnTouched = this.getBitmapFor(17301709);
        this.mBitmapCircleDefault = this.getBitmapFor(17301978);
        this.mBitmapCircleGreen = this.getBitmapFor(17301979);
        this.mBitmapCircleRed = this.getBitmapFor(17301980);
        this.mBitmapArrowGreenUp = this.getBitmapFor(17301976);
        this.mBitmapArrowRedUp = this.getBitmapFor(17301977);
        this.mBitmapWidth = this.mBitmapBtnDefault.getWidth();
        this.mBitmapHeight = this.mBitmapBtnDefault.getHeight();
        this.mVibePattern = this.loadVibratePattern(0x1070011);
    }

    private void addCellToPattern(Cell cell) {
        this.mPatternDrawLookup[cell.getRow()][cell.getColumn()] = true;
        this.mPattern.add(cell);
        if (this.mOnPatternListener != null) {
            this.mOnPatternListener.onPatternCellAdded(this.mPattern);
        }
    }

    private Cell checkForNewHit(float f, float f2) {
        int n = this.getRowHit(f2);
        if (n < 0) {
            return null;
        }
        int n2 = this.getColumnHit(f);
        if (n2 < 0) {
            return null;
        }
        if (this.mPatternDrawLookup[n][n2]) {
            return null;
        }
        return Cell.of(n, n2);
    }

    private void clearPatternDrawLookup() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.mPatternDrawLookup[i][j] = false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Cell detectAndAddHit(float f, float f2) {
        Cell cell = this.checkForNewHit(f, f2);
        if (cell == null) {
            return null;
        }
        ArrayList<Cell> arrayList = this.mPattern;
        boolean bl = arrayList.isEmpty();
        Cell cell2 = null;
        if (!bl) {
            Cell cell3 = arrayList.get(arrayList.size() - 1);
            int n = cell.row - cell3.row;
            int n2 = cell.column - cell3.column;
            int n3 = cell3.row;
            int n4 = cell3.column;
            if (Math.abs(n) == 2 && Math.abs(n2) != 1) {
                int n5 = cell3.row;
                int n6 = n > 0 ? 1 : -1;
                n3 = n5 + n6;
            }
            if (Math.abs(n2) == 2 && Math.abs(n) != 1) {
                int n7 = cell3.column;
                int n8 = n2 > 0 ? 1 : -1;
                n4 = n7 + n8;
            }
            cell2 = Cell.of(n3, n4);
        }
        if (cell2 != null && !this.mPatternDrawLookup[cell2.row][cell2.column]) {
            this.addCellToPattern(cell2);
        }
        this.addCellToPattern(cell);
        if (this.mTactileFeedbackEnabled) {
            this.vibe.vibrate(this.mVibePattern, -1);
        }
        return cell;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawArrow(Canvas canvas, float f, float f2, Cell cell, Cell cell2) {
        boolean bl = this.mPatternDisplayMode != DisplayMode.Wrong;
        int n = cell2.row;
        int n2 = cell.row;
        int n3 = cell2.column;
        int n4 = cell.column;
        int n5 = ((int)this.mSquareWidth - this.mBitmapWidth) / 2;
        int n6 = ((int)this.mSquareHeight - this.mBitmapHeight) / 2;
        Bitmap bitmap = bl ? this.mBitmapArrowGreenUp : this.mBitmapArrowRedUp;
        Matrix matrix = new Matrix();
        int n7 = this.mBitmapCircleDefault.getWidth();
        int n8 = this.mBitmapCircleDefault.getHeight();
        float f3 = 90.0f + (float)Math.toDegrees((float)Math.atan2(n - n2, n3 - n4));
        matrix.setTranslate(f + (float)n5, f2 + (float)n6);
        matrix.preRotate(f3, (float)n7 / 2.0f, (float)n8 / 2.0f);
        matrix.preTranslate((float)(n7 - bitmap.getWidth()) / 2.0f, 0.0f);
        Paint paint = this.mPaint;
        canvas.drawBitmap(bitmap, matrix, paint);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawCircle(Canvas canvas, int n, int n2, boolean bl) {
        Bitmap bitmap;
        Bitmap bitmap2;
        if (!bl || this.mInStealthMode && this.mPatternDisplayMode != DisplayMode.Wrong) {
            bitmap2 = this.mBitmapCircleDefault;
            bitmap = this.mBitmapBtnDefault;
        } else if (this.mPatternInProgress) {
            bitmap2 = this.mBitmapCircleGreen;
            bitmap = this.mBitmapBtnTouched;
        } else if (this.mPatternDisplayMode == DisplayMode.Wrong) {
            bitmap2 = this.mBitmapCircleRed;
            bitmap = this.mBitmapBtnDefault;
        } else {
            if (this.mPatternDisplayMode != DisplayMode.Correct && this.mPatternDisplayMode != DisplayMode.Animate) {
                throw new IllegalStateException("unknown display mode " + (Object)((Object)this.mPatternDisplayMode));
            }
            bitmap2 = this.mBitmapCircleGreen;
            bitmap = this.mBitmapBtnDefault;
        }
        int n3 = this.mBitmapWidth;
        int n4 = this.mBitmapHeight;
        float f = this.mSquareWidth;
        float f2 = this.mSquareHeight;
        int n5 = (int)((f - (float)n3) / 2.0f);
        int n6 = (int)((f2 - (float)n4) / 2.0f);
        canvas.drawBitmap(bitmap2, n + n5, n2 + n6, this.mPaint);
        canvas.drawBitmap(bitmap, n + n5, n2 + n6, this.mPaint);
    }

    private Bitmap getBitmapFor(int n) {
        return BitmapFactory.decodeResource(this.getContext().getResources(), n);
    }

    private float getCenterXForColumn(int n) {
        return (float)this.mPaddingLeft + (float)n * this.mSquareWidth + this.mSquareWidth / 2.0f;
    }

    private float getCenterYForRow(int n) {
        return (float)this.mPaddingTop + (float)n * this.mSquareHeight + this.mSquareHeight / 2.0f;
    }

    private int getColumnHit(float f) {
        float f2 = this.mSquareWidth;
        float f3 = f2 * this.mHitFactor;
        float f4 = (float)this.mPaddingLeft + (f2 - f3) / 2.0f;
        for (int i = 0; i < 3; ++i) {
            float f5 = f4 + f2 * (float)i;
            if (!(f >= f5) || !(f <= f5 + f3)) continue;
            return i;
        }
        return -1;
    }

    private int getRowHit(float f) {
        float f2 = this.mSquareHeight;
        float f3 = f2 * this.mHitFactor;
        float f4 = (float)this.mPaddingTop + (f2 - f3) / 2.0f;
        for (int i = 0; i < 3; ++i) {
            float f5 = f4 + f2 * (float)i;
            if (!(f >= f5) || !(f <= f5 + f3)) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long[] loadVibratePattern(int n) {
        int[] nArray;
        try {
            int[] nArray2;
            nArray = nArray2 = this.getResources().getIntArray(n);
        }
        catch (Resources.NotFoundException notFoundException) {
            Log.e("LockPatternView", "Vibrate pattern missing, using default", notFoundException);
            nArray = null;
        }
        if (nArray == null) {
            return DEFAULT_VIBE_PATTERN;
        }
        long[] lArray = new long[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            lArray[n2] = nArray[n2];
            ++n2;
        }
        return lArray;
    }

    private void resetPattern() {
        this.mPattern.clear();
        this.clearPatternDrawLookup();
        this.mPatternDisplayMode = DisplayMode.Correct;
        this.invalidate();
    }

    public void clearPattern() {
        this.resetPattern();
    }

    public void disableInput() {
        this.mInputEnabled = false;
    }

    public void enableInput() {
        this.mInputEnabled = true;
    }

    public boolean isInStealthMode() {
        return this.mInStealthMode;
    }

    public boolean isTactileFeedbackEnabled() {
        return this.mTactileFeedbackEnabled;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDraw(Canvas canvas) {
        int n;
        int n2;
        ArrayList<Cell> arrayList = this.mPattern;
        int n3 = arrayList.size();
        boolean[][] blArray = this.mPatternDrawLookup;
        if (this.mPatternDisplayMode == DisplayMode.Animate) {
            int n4 = 700 * (n3 + 1);
            int n5 = (int)(SystemClock.elapsedRealtime() - this.mAnimatingPeriodStart) % n4;
            int n6 = n5 / 700;
            this.clearPatternDrawLookup();
            for (int i = 0; i < n6; ++i) {
                Cell cell = arrayList.get(i);
                blArray[cell.getRow()][cell.getColumn()] = true;
            }
            boolean bl = n6 > 0 && n6 < n3;
            if (bl) {
                float f = (float)(n5 % 700) / 700.0f;
                Cell cell = arrayList.get(n6 - 1);
                float f2 = this.getCenterXForColumn(cell.column);
                float f3 = this.getCenterYForRow(cell.row);
                Cell cell2 = arrayList.get(n6);
                float f4 = f * (this.getCenterXForColumn(cell2.column) - f2);
                float f5 = f * (this.getCenterYForRow(cell2.row) - f3);
                this.mInProgressX = f2 + f4;
                this.mInProgressY = f3 + f5;
            }
            this.invalidate();
        }
        float f = this.mSquareWidth;
        float f6 = this.mSquareHeight;
        float f7 = 0.5f * (f * this.mDiameterFactor);
        this.mPathPaint.setStrokeWidth(f7);
        Path path = this.mCurrentPath;
        path.rewind();
        boolean bl = !this.mInStealthMode || this.mPatternDisplayMode == DisplayMode.Wrong;
        boolean bl2 = true;
        while (true) {
            Cell cell;
            int n7;
            boolean bl3;
            block17: {
                block15: {
                    block16: {
                        block14: {
                            if (!bl2 || (bl2 = false)) break block14;
                            if (!bl) break block15;
                            bl3 = false;
                            n7 = 0;
                        }
                        if (n7 >= n3) break block16;
                        cell = arrayList.get(n7);
                        if (blArray[cell.row][cell.column]) break block17;
                    }
                    if ((this.mPatternInProgress || this.mPatternDisplayMode == DisplayMode.Animate) && bl3) {
                        path.lineTo(this.mInProgressX, this.mInProgressY);
                    }
                    canvas.drawPath(path, this.mPathPaint);
                }
                n2 = this.mPaddingTop;
                n = this.mPaddingLeft;
                break;
            }
            bl3 = true;
            float f8 = this.getCenterXForColumn(cell.column);
            float f9 = this.getCenterYForRow(cell.row);
            if (n7 == 0) {
                path.moveTo(f8, f9);
            } else {
                path.lineTo(f8, f9);
            }
            ++n7;
        }
        for (int i = 0; i < 3; ++i) {
            float f10 = (float)n2 + f6 * (float)i;
            for (int j = 0; j < 3; ++j) {
                this.drawCircle(canvas, (int)((float)n + f * (float)j), (int)f10, blArray[i][j]);
            }
        }
        boolean bl4 = (2 & this.mPaint.getFlags()) != 0;
        this.mPaint.setFilterBitmap(true);
        if (bl) {
            int n8;
            for (int i = 0; i < (n8 = n3 - 1); ++i) {
                Cell cell = arrayList.get(i);
                Cell cell3 = arrayList.get(i + 1);
                if (!blArray[cell3.row][cell3.column]) break;
                this.drawArrow(canvas, (float)n + f * (float)cell.column, (float)n2 + f6 * (float)cell.row, cell, cell3);
            }
        }
        this.mPaint.setFilterBitmap(bl4);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getSize(n);
        int n4 = View.MeasureSpec.getSize(n2);
        int n5 = n3;
        int n6 = n4;
        switch (this.mAspect) {
            case 0: {
                n5 = n6 = Math.min(n3, n4);
                break;
            }
            case 1: {
                n5 = n3;
                n6 = Math.min(n3, n4);
                break;
            }
            case 2: {
                n5 = Math.min(n3, n4);
                n6 = n4;
                break;
            }
        }
        this.setMeasuredDimension(n5, n6);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setPattern(DisplayMode.Correct, LockPatternUtils.stringToPattern(savedState.getSerializedPattern()));
        this.mPatternDisplayMode = DisplayMode.values()[savedState.getDisplayMode()];
        this.mInputEnabled = savedState.isInputEnabled();
        this.mInStealthMode = savedState.isInStealthMode();
        this.mTactileFeedbackEnabled = savedState.isTactileFeedbackEnabled();
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        return new SavedState(super.onSaveInstanceState(), LockPatternUtils.patternToString(this.mPattern), this.mPatternDisplayMode.ordinal(), this.mInputEnabled, this.mInStealthMode, this.mTactileFeedbackEnabled);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        this.mSquareWidth = (float)(n - this.mPaddingLeft - this.mPaddingRight) / 3.0f;
        this.mSquareHeight = (float)(n2 - this.mPaddingTop - this.mPaddingBottom) / 3.0f;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean onTouchEvent(MotionEvent var1_1) {
        if (!this.mInputEnabled || !this.isEnabled()) {
            return false;
        }
        var2_2 = var1_1.getX();
        var3_3 = var1_1.getY();
        switch (var1_1.getAction()) {
            default: {
                return false;
            }
            case 0: {
                this.resetPattern();
                var34_4 = this.detectAndAddHit(var2_2, var3_3);
                if (var34_4 != null && this.mOnPatternListener != null) {
                    this.mPatternInProgress = true;
                    this.mPatternDisplayMode = DisplayMode.Correct;
                    this.mOnPatternListener.onPatternStart();
lbl15:
                    // 3 sources

                    while (true) {
                        if (var34_4 != null) {
                            var35_5 = this.getCenterXForColumn(var34_4.column);
                            var36_6 = this.getCenterYForRow(var34_4.row);
                            var37_7 = this.mSquareWidth / 2.0f;
                            var38_8 = this.mSquareHeight / 2.0f;
                            this.invalidate((int)(var35_5 - var37_7), (int)(var36_6 - var38_8), (int)(var35_5 + var37_7), (int)(var36_6 + var38_8));
                        }
                        this.mInProgressX = var2_2;
                        this.mInProgressY = var3_3;
                        return true;
                    }
                }
                if (this.mOnPatternListener == null) ** GOTO lbl15
                this.mPatternInProgress = false;
                this.mOnPatternListener.onPatternCleared();
                ** continue;
            }
            case 1: {
                if (!this.mPattern.isEmpty() && this.mOnPatternListener != null) {
                    this.mPatternInProgress = false;
                    this.mOnPatternListener.onPatternDetected(this.mPattern);
                    this.invalidate();
                }
                return true;
            }
            case 2: {
                var4_9 = this.mPattern.size();
                var5_10 = this.detectAndAddHit(var2_2, var3_3);
                var6_11 = this.mPattern.size();
                if (var5_10 != null && this.mOnPatternListener != null && var6_11 == 1) {
                    this.mPatternInProgress = true;
                    this.mOnPatternListener.onPatternStart();
                }
                if (!(Math.abs(var2_2 - this.mInProgressX) + Math.abs(var3_3 - this.mInProgressY) > 0.01f * this.mSquareWidth)) ** GOTO lbl88
                var7_12 = this.mInProgressX;
                var8_13 = this.mInProgressY;
                this.mInProgressX = var2_2;
                this.mInProgressY = var3_3;
                if (!this.mPatternInProgress || var6_11 <= 0) ** GOTO lbl116
                var9_14 = this.mPattern;
                var10_15 = 0.5f * (this.mSquareWidth * this.mDiameterFactor);
                var11_16 = var9_14.get(var6_11 - 1);
                var12_17 = this.getCenterXForColumn(var11_16.column);
                var13_18 = this.getCenterYForRow(var11_16.row);
                var14_19 = this.mInvalidate;
                if (!(var12_17 < var2_2)) ** GOTO lbl93
                var15_20 = var12_17;
                var16_21 = var2_2;
lbl57:
                // 2 sources

                while (var13_18 < var3_3) {
                    var17_22 = var13_18;
                    var18_23 = var3_3;
lbl60:
                    // 2 sources

                    while (true) {
                        var14_19.set((int)(var15_20 - var10_15), (int)(var17_22 - var10_15), (int)(var16_21 + var10_15), (int)(var18_23 + var10_15));
                        if (!(var12_17 < var7_12)) ** GOTO lbl99
                        var19_24 = var12_17;
                        var20_25 = var7_12;
lbl65:
                        // 2 sources

                        while (var13_18 < var8_13) {
                            var21_26 = var13_18;
                            var22_27 = var8_13;
lbl68:
                            // 2 sources

                            while (true) {
                                var14_19.union((int)(var19_24 - var10_15), (int)(var21_26 - var10_15), (int)(var20_25 + var10_15), (int)(var22_27 + var10_15));
                                if (var5_10 == null) ** GOTO lbl87
                                var23_28 = this.getCenterXForColumn(var5_10.column);
                                var24_29 = this.getCenterYForRow(var5_10.row);
                                if (var6_11 < 2) ** GOTO lbl111
                                var31_30 = var9_14.get(var6_11 - 1 - (var6_11 - var4_9));
                                var32_31 = this.getCenterXForColumn(var31_30.column);
                                var33_32 = this.getCenterYForRow(var31_30.row);
                                if (!(var23_28 < var32_31)) ** GOTO lbl105
                                var26_33 = var23_28;
                                var25_34 = var32_31;
lbl80:
                                // 2 sources

                                while (var24_29 < var33_32) {
                                    var28_35 = var24_29;
                                    var27_36 = var33_32;
lbl83:
                                    // 3 sources

                                    while (true) {
                                        var29_37 = this.mSquareWidth / 2.0f;
                                        var30_38 = this.mSquareHeight / 2.0f;
                                        var14_19.set((int)(var26_33 - var29_37), (int)(var28_35 - var30_38), (int)(var25_34 + var29_37), (int)(var27_36 + var30_38));
lbl87:
                                        // 2 sources

                                        this.invalidate(var14_19);
lbl88:
                                        // 3 sources

                                        return true;
                                    }
                                }
                                ** GOTO lbl108
                                break;
                            }
                        }
                        ** GOTO lbl102
                        break;
                    }
                }
                ** GOTO lbl96
lbl93:
                // 1 sources

                var15_20 = var2_2;
                var16_21 = var12_17;
                ** GOTO lbl57
lbl96:
                // 1 sources

                var17_22 = var3_3;
                var18_23 = var13_18;
                ** continue;
lbl99:
                // 1 sources

                var19_24 = var7_12;
                var20_25 = var12_17;
                ** GOTO lbl65
lbl102:
                // 1 sources

                var21_26 = var8_13;
                var22_27 = var13_18;
                ** continue;
lbl105:
                // 1 sources

                var26_33 = var32_31;
                var25_34 = var23_28;
                ** GOTO lbl80
lbl108:
                // 1 sources

                var28_35 = var33_32;
                var27_36 = var24_29;
                ** GOTO lbl83
lbl111:
                // 1 sources

                var25_34 = var23_28;
                var26_33 = var23_28;
                var27_36 = var24_29;
                var28_35 = var24_29;
                ** continue;
lbl116:
                // 1 sources

                this.invalidate();
                ** continue;
            }
            case 3: 
        }
        this.resetPattern();
        if (this.mOnPatternListener != null) {
            this.mPatternInProgress = false;
            this.mOnPatternListener.onPatternCleared();
        }
        return true;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.mPatternDisplayMode = displayMode;
        if (displayMode == DisplayMode.Animate) {
            if (this.mPattern.size() == 0) {
                throw new IllegalStateException("you must have a pattern to animate if you want to set the display mode to animate");
            }
            this.mAnimatingPeriodStart = SystemClock.elapsedRealtime();
            Cell cell = this.mPattern.get(0);
            this.mInProgressX = this.getCenterXForColumn(cell.getColumn());
            this.mInProgressY = this.getCenterYForRow(cell.getRow());
            this.clearPatternDrawLookup();
        }
        this.invalidate();
    }

    public void setInStealthMode(boolean bl) {
        this.mInStealthMode = bl;
    }

    public void setOnPatternListener(OnPatternListener onPatternListener) {
        this.mOnPatternListener = onPatternListener;
    }

    public void setPattern(DisplayMode displayMode, List<Cell> list) {
        this.mPattern.clear();
        this.mPattern.addAll(list);
        this.clearPatternDrawLookup();
        for (Cell cell : list) {
            this.mPatternDrawLookup[cell.getRow()][cell.getColumn()] = true;
        }
        this.setDisplayMode(displayMode);
    }

    public void setTactileFeedbackEnabled(boolean bl) {
        this.mTactileFeedbackEnabled = bl;
    }

    public static class Cell {
        static Cell[][] sCells = (Cell[][])Array.newInstance(Cell.class, 3, 3);
        int column;
        int row;

        static {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    Cell.sCells[i][j] = new Cell(i, j);
                }
            }
        }

        private Cell(int n, int n2) {
            Cell.checkRange(n, n2);
            this.row = n;
            this.column = n2;
        }

        private static void checkRange(int n, int n2) {
            if (n < 0 || n > 2) {
                throw new IllegalArgumentException("row must be in range 0-2");
            }
            if (n2 < 0 || n2 > 2) {
                throw new IllegalArgumentException("column must be in range 0-2");
            }
        }

        public static Cell of(int n, int n2) {
            synchronized (Cell.class) {
                Cell.checkRange(n, n2);
                Cell cell = sCells[n][n2];
                return cell;
            }
        }

        public int getColumn() {
            return this.column;
        }

        public int getRow() {
            return this.row;
        }

        public String toString() {
            return "(row=" + this.row + ",clmn=" + this.column + ")";
        }
    }

    public static final class DisplayMode
    extends Enum<DisplayMode> {
        private static final /* synthetic */ DisplayMode[] $VALUES;
        public static final /* enum */ DisplayMode Animate;
        public static final /* enum */ DisplayMode Correct;
        public static final /* enum */ DisplayMode Wrong;

        static {
            Correct = new DisplayMode();
            Animate = new DisplayMode();
            Wrong = new DisplayMode();
            DisplayMode[] displayModeArray = new DisplayMode[]{Correct, Animate, Wrong};
            $VALUES = displayModeArray;
        }

        public static DisplayMode valueOf(String string2) {
            return Enum.valueOf(DisplayMode.class, string2);
        }

        public static DisplayMode[] values() {
            return (DisplayMode[])$VALUES.clone();
        }
    }

    public static interface OnPatternListener {
        public void onPatternCellAdded(List<Cell> var1);

        public void onPatternCleared();

        public void onPatternDetected(List<Cell> var1);

        public void onPatternStart();
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        private final int mDisplayMode;
        private final boolean mInStealthMode;
        private final boolean mInputEnabled;
        private final String mSerializedPattern;
        private final boolean mTactileFeedbackEnabled;

        private SavedState(Parcel parcel) {
            super(parcel);
            this.mSerializedPattern = parcel.readString();
            this.mDisplayMode = parcel.readInt();
            this.mInputEnabled = (Boolean)parcel.readValue(null);
            this.mInStealthMode = (Boolean)parcel.readValue(null);
            this.mTactileFeedbackEnabled = (Boolean)parcel.readValue(null);
        }

        private SavedState(Parcelable parcelable, String string2, int n, boolean bl, boolean bl2, boolean bl3) {
            super(parcelable);
            this.mSerializedPattern = string2;
            this.mDisplayMode = n;
            this.mInputEnabled = bl;
            this.mInStealthMode = bl2;
            this.mTactileFeedbackEnabled = bl3;
        }

        public int getDisplayMode() {
            return this.mDisplayMode;
        }

        public String getSerializedPattern() {
            return this.mSerializedPattern;
        }

        public boolean isInStealthMode() {
            return this.mInStealthMode;
        }

        public boolean isInputEnabled() {
            return this.mInputEnabled;
        }

        public boolean isTactileFeedbackEnabled() {
            return this.mTactileFeedbackEnabled;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeString(this.mSerializedPattern);
            parcel.writeInt(this.mDisplayMode);
            parcel.writeValue(this.mInputEnabled);
            parcel.writeValue(this.mInStealthMode);
            parcel.writeValue(this.mTactileFeedbackEnabled);
        }
    }
}

