/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.Keyboard;
import java.util.Locale;

public class PasswordEntryKeyboard
extends Keyboard {
    public static final int KEYCODE_SPACE = 32;
    private static final int SHIFT_LOCKED = 2;
    private static final int SHIFT_OFF = 0;
    private static final int SHIFT_ON = 1;
    private static final String TAG = "PasswordEntryKeyboard";
    static int sSpacebarVerticalCorrection;
    private Keyboard.Key mEnterKey;
    private int mExtensionResId;
    private Keyboard.Key mF1Key;
    private Locale mLocale;
    private Drawable mOldShiftIcon;
    private Drawable mOldShiftPreviewIcon;
    private Resources mRes;
    private Drawable mShiftIcon;
    private Keyboard.Key mShiftKey;
    private Drawable mShiftLockIcon;
    private Drawable mShiftLockPreviewIcon;
    private int mShiftState = 0;
    private Drawable mSpaceIcon;
    private Keyboard.Key mSpaceKey;

    public PasswordEntryKeyboard(Context context, int n) {
        this(context, n, 0);
    }

    public PasswordEntryKeyboard(Context context, int n, int n2) {
        super(context, n, n2);
        Resources resources;
        this.mRes = resources = context.getResources();
        this.mShiftIcon = resources.getDrawable(17302267);
        this.mShiftLockIcon = resources.getDrawable(17302268);
        this.mShiftLockPreviewIcon = resources.getDrawable(17302252);
        this.mShiftLockPreviewIcon.setBounds(0, 0, this.mShiftLockPreviewIcon.getIntrinsicWidth(), this.mShiftLockPreviewIcon.getIntrinsicHeight());
        this.mSpaceIcon = resources.getDrawable(17302269);
        sSpacebarVerticalCorrection = resources.getDimensionPixelOffset(17104907);
    }

    public PasswordEntryKeyboard(Context context, int n, CharSequence charSequence, int n2, int n3) {
        super(context, n, charSequence, n2, n3);
    }

    @Override
    protected Keyboard.Key createKeyFromXml(Resources resources, Keyboard.Row row, int n, int n2, XmlResourceParser xmlResourceParser) {
        LatinKey latinKey = new LatinKey(resources, row, n, n2, xmlResourceParser);
        int n3 = latinKey.codes[0];
        if (n3 >= 0 && n3 != 10 && (n3 < 32 || n3 > 127)) {
            latinKey.label = " ";
            latinKey.setEnabled(false);
        }
        switch (latinKey.codes[0]) {
            default: {
                return latinKey;
            }
            case 10: {
                this.mEnterKey = latinKey;
                return latinKey;
            }
            case -103: {
                this.mF1Key = latinKey;
                return latinKey;
            }
            case 32: 
        }
        this.mSpaceKey = latinKey;
        return latinKey;
    }

    void enableShiftLock() {
        int n = this.getShiftKeyIndex();
        if (n >= 0) {
            this.mShiftKey = this.getKeys().get(n);
            if (this.mShiftKey instanceof LatinKey) {
                ((LatinKey)this.mShiftKey).enableShiftLock();
            }
            this.mOldShiftIcon = this.mShiftKey.icon;
            this.mOldShiftPreviewIcon = this.mShiftKey.iconPreview;
        }
    }

    @Override
    public boolean isShifted() {
        if (this.mShiftKey != null) {
            return this.mShiftState != 0;
        }
        return super.isShifted();
    }

    void setEnterKeyResources(Resources resources, int n, int n2, int n3) {
        if (this.mEnterKey != null) {
            this.mEnterKey.popupCharacters = null;
            this.mEnterKey.popupResId = 0;
            this.mEnterKey.text = null;
            this.mEnterKey.iconPreview = resources.getDrawable(n);
            this.mEnterKey.icon = resources.getDrawable(n2);
            this.mEnterKey.label = resources.getText(n3);
            if (this.mEnterKey.iconPreview != null) {
                this.mEnterKey.iconPreview.setBounds(0, 0, this.mEnterKey.iconPreview.getIntrinsicWidth(), this.mEnterKey.iconPreview.getIntrinsicHeight());
            }
        }
    }

    void setShiftLocked(boolean bl) {
        block3: {
            block2: {
                if (this.mShiftKey == null) break block2;
                if (!bl) break block3;
                this.mShiftKey.on = true;
                this.mShiftKey.icon = this.mShiftLockIcon;
                this.mShiftState = 2;
            }
            return;
        }
        this.mShiftKey.on = false;
        this.mShiftKey.icon = this.mShiftLockIcon;
        this.mShiftState = 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean setShifted(boolean bl) {
        boolean bl2;
        if (this.mShiftKey == null) return super.setShifted(bl);
        if (!bl) {
            bl2 = this.mShiftState != 0;
            this.mShiftState = 0;
            this.mShiftKey.on = false;
            this.mShiftKey.icon = this.mOldShiftIcon;
            return bl2;
        }
        int n = this.mShiftState;
        bl2 = false;
        if (n != 0) return bl2;
        bl2 = this.mShiftState == 0;
        this.mShiftState = 1;
        this.mShiftKey.on = false;
        this.mShiftKey.icon = this.mShiftIcon;
        return bl2;
    }

    static class LatinKey
    extends Keyboard.Key {
        private boolean mEnabled = true;
        private boolean mShiftLockEnabled;

        public LatinKey(Resources resources, Keyboard.Row row, int n, int n2, XmlResourceParser xmlResourceParser) {
            super(resources, row, n, n2, xmlResourceParser);
            if (this.popupCharacters != null && this.popupCharacters.length() == 0) {
                this.popupResId = 0;
            }
        }

        void enableShiftLock() {
            this.mShiftLockEnabled = true;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean isInside(int n, int n2) {
            if (!this.mEnabled) {
                return false;
            }
            int n3 = this.codes[0];
            if (n3 != -1 && n3 != -5) {
                if (n3 != 32) return super.isInside(n, n2);
                return super.isInside(n, n2 += sSpacebarVerticalCorrection);
            }
            n2 -= this.height / 10;
            if (n3 == -1) {
                n += this.width / 6;
            }
            if (n3 != -5) return super.isInside(n, n2);
            n -= this.width / 6;
            return super.isInside(n, n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onReleased(boolean bl) {
            if (!this.mShiftLockEnabled) {
                super.onReleased(bl);
                return;
            }
            boolean bl2 = !this.pressed;
            this.pressed = bl2;
        }

        void setEnabled(boolean bl) {
            this.mEnabled = bl;
        }
    }
}

