/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.Resources;
import android.inputmethodservice.Keyboard;
import android.inputmethodservice.KeyboardView;
import android.os.Handler;
import android.os.SystemClock;
import android.os.Vibrator;
import android.provider.Settings;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import com.android.internal.widget.PasswordEntryKeyboard;

public class PasswordEntryKeyboardHelper
implements KeyboardView.OnKeyboardActionListener {
    public static final int KEYBOARD_MODE_ALPHA = 0;
    public static final int KEYBOARD_MODE_NUMERIC = 1;
    private static final int KEYBOARD_STATE_CAPSLOCK = 2;
    private static final int KEYBOARD_STATE_NORMAL = 0;
    private static final int KEYBOARD_STATE_SHIFTED = 1;
    private static final String TAG = "PasswordEntryKeyboardHelper";
    private Context mContext;
    private int mKeyboardMode = 0;
    private int mKeyboardState = 0;
    private KeyboardView mKeyboardView;
    private PasswordEntryKeyboard mNumericKeyboard;
    private PasswordEntryKeyboard mQwertyKeyboard;
    private PasswordEntryKeyboard mQwertyKeyboardShifted;
    private PasswordEntryKeyboard mSymbolsKeyboard;
    private PasswordEntryKeyboard mSymbolsKeyboardShifted;
    private View mTargetView;
    private long[] mVibratePattern;
    private Vibrator mVibrator;

    public PasswordEntryKeyboardHelper(Context context, KeyboardView keyboardView, View view) {
        this.mContext = context;
        this.mTargetView = view;
        this.mKeyboardView = keyboardView;
        this.createKeyboards();
        this.mKeyboardView.setOnKeyboardActionListener(this);
        this.mVibrator = new Vibrator();
    }

    private void createKeyboards() {
        this.mNumericKeyboard = new PasswordEntryKeyboard(this.mContext, 17498116);
        this.mQwertyKeyboard = new PasswordEntryKeyboard(this.mContext, 17498118, 16908851);
        this.mQwertyKeyboard.enableShiftLock();
        this.mQwertyKeyboardShifted = new PasswordEntryKeyboard(this.mContext, 17498119, 16908851);
        this.mQwertyKeyboardShifted.enableShiftLock();
        this.mQwertyKeyboardShifted.setShifted(true);
        this.mSymbolsKeyboard = new PasswordEntryKeyboard(this.mContext, 17498120);
        this.mSymbolsKeyboard.enableShiftLock();
        this.mSymbolsKeyboardShifted = new PasswordEntryKeyboard(this.mContext, 17498121);
        this.mSymbolsKeyboardShifted.enableShiftLock();
        this.mSymbolsKeyboardShifted.setShifted(true);
    }

    private void handleBackspace() {
        this.sendDownUpKeyEvents(67);
    }

    private void handleCharacter(int n, int[] nArray) {
        if (this.mKeyboardView.isShifted() && n != 32 && n != 10) {
            n = Character.toUpperCase(n);
        }
        this.sendKeyEventsToTarget(n);
    }

    private void handleClose() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleModeChange() {
        PasswordEntryKeyboard passwordEntryKeyboard;
        block5: {
            block6: {
                Keyboard keyboard;
                block4: {
                    keyboard = this.mKeyboardView.getKeyboard();
                    if (keyboard != this.mQwertyKeyboard && keyboard != this.mQwertyKeyboardShifted) break block4;
                    passwordEntryKeyboard = this.mSymbolsKeyboard;
                    break block5;
                }
                if (keyboard == this.mSymbolsKeyboard) break block6;
                PasswordEntryKeyboard passwordEntryKeyboard2 = this.mSymbolsKeyboardShifted;
                passwordEntryKeyboard = null;
                if (keyboard != passwordEntryKeyboard2) break block5;
            }
            passwordEntryKeyboard = this.mQwertyKeyboard;
        }
        if (passwordEntryKeyboard != null) {
            this.mKeyboardView.setKeyboard(passwordEntryKeyboard);
            this.mKeyboardState = 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleShift() {
        PasswordEntryKeyboard passwordEntryKeyboard;
        Keyboard keyboard;
        block10: {
            block9: {
                if (this.mKeyboardView == null) break block9;
                keyboard = this.mKeyboardView.getKeyboard();
                boolean bl = keyboard == this.mQwertyKeyboard || keyboard == this.mQwertyKeyboardShifted;
                if (this.mKeyboardState == 0) {
                    int n = bl ? 1 : 2;
                    this.mKeyboardState = n;
                    passwordEntryKeyboard = bl ? this.mQwertyKeyboardShifted : this.mSymbolsKeyboardShifted;
                } else if (this.mKeyboardState == 1) {
                    this.mKeyboardState = 2;
                    passwordEntryKeyboard = bl ? this.mQwertyKeyboardShifted : this.mSymbolsKeyboardShifted;
                } else {
                    int n = this.mKeyboardState;
                    passwordEntryKeyboard = null;
                    if (n == 2) {
                        this.mKeyboardState = 0;
                        passwordEntryKeyboard = bl ? this.mQwertyKeyboard : this.mSymbolsKeyboard;
                    }
                }
                if (passwordEntryKeyboard != null) break block10;
            }
            return;
        }
        if (passwordEntryKeyboard != keyboard) {
            this.mKeyboardView.setKeyboard(passwordEntryKeyboard);
        }
        boolean bl = this.mKeyboardState == 2;
        passwordEntryKeyboard.setShiftLocked(bl);
        KeyboardView keyboardView = this.mKeyboardView;
        boolean bl2 = this.mKeyboardState != 0;
        keyboardView.setShifted(bl2);
    }

    private void sendKeyEventsToTarget(int n) {
        Handler handler = this.mTargetView.getHandler();
        KeyCharacterMap keyCharacterMap = KeyCharacterMap.load(3);
        char[] cArray = new char[]{(char)n};
        KeyEvent[] keyEventArray = keyCharacterMap.getEvents(cArray);
        if (keyEventArray != null) {
            for (KeyEvent keyEvent : keyEventArray) {
                handler.sendMessage(handler.obtainMessage(1005, KeyEvent.changeFlags(keyEvent, 4 | (2 | keyEvent.getFlags()))));
            }
        }
    }

    public boolean isAlpha() {
        return this.mKeyboardMode == 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onKey(int n, int[] nArray) {
        if (n == -5) {
            this.handleBackspace();
            return;
        } else {
            if (n == -1) {
                this.handleShift();
                return;
            }
            if (n == -3) {
                this.handleClose();
                return;
            }
            if (n == -2 && this.mKeyboardView != null) {
                this.handleModeChange();
                return;
            }
            this.handleCharacter(n, nArray);
            if (this.mKeyboardState != 1) return;
            this.mKeyboardState = 2;
            this.handleShift();
            return;
        }
    }

    @Override
    public void onPress(int n) {
        if (this.mVibratePattern != null) {
            this.mVibrator.vibrate(this.mVibratePattern, -1);
        }
    }

    @Override
    public void onRelease(int n) {
    }

    @Override
    public void onText(CharSequence charSequence) {
    }

    public void sendDownUpKeyEvents(int n) {
        long l = SystemClock.uptimeMillis();
        Handler handler = this.mTargetView.getHandler();
        handler.sendMessage(handler.obtainMessage(1011, new KeyEvent(l, l, 0, n, 0, 0, 0, 0, 6)));
        handler.sendMessage(handler.obtainMessage(1011, new KeyEvent(l, l, 1, n, 0, 0, 0, 0, 6)));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setKeyboardMode(int n) {
        switch (n) {
            case 0: {
                this.mKeyboardView.setKeyboard(this.mQwertyKeyboard);
                this.mKeyboardState = 0;
                boolean bl = Settings.System.getInt(this.mContext.getContentResolver(), "show_password", 1) != 0;
                this.mKeyboardView.setPreviewEnabled(bl);
            }
            default: {
                break;
            }
            case 1: {
                this.mKeyboardView.setKeyboard(this.mNumericKeyboard);
                this.mKeyboardState = 0;
                this.mKeyboardView.setPreviewEnabled(false);
            }
        }
        this.mKeyboardMode = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setVibratePattern(int n) {
        int[] nArray;
        block5: {
            try {
                int[] nArray2;
                nArray = nArray2 = this.mContext.getResources().getIntArray(n);
            }
            catch (Resources.NotFoundException notFoundException) {
                nArray = null;
                if (n == 0) break block5;
                Log.e(TAG, "Vibrate pattern missing", notFoundException);
                nArray = null;
            }
        }
        if (nArray == null) {
            this.mVibratePattern = null;
            return;
        } else {
            this.mVibratePattern = new long[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                this.mVibratePattern[i] = nArray[i];
            }
        }
    }

    @Override
    public void swipeDown() {
    }

    @Override
    public void swipeLeft() {
    }

    @Override
    public void swipeRight() {
    }

    @Override
    public void swipeUp() {
    }
}

