/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.Log;
import android.view.InputDevice;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import java.util.ArrayList;

public class PointerLocationView
extends View {
    private static final String TAG = "Pointer";
    private int mActivePointerId;
    private boolean mCurDown;
    private int mCurNumPointers;
    private int mHeaderBottom;
    private int mMaxNumPointers;
    private final Paint mPaint;
    private final Paint mPathPaint;
    private final ArrayList<PointerState> mPointers;
    private boolean mPrintCoords = true;
    private RectF mReusableOvalRect;
    private final Paint mTargetPaint;
    private final FasterStringBuilder mText;
    private final Paint mTextBackgroundPaint;
    private final Paint mTextLevelPaint;
    private final Paint.FontMetricsInt mTextMetrics = new Paint.FontMetricsInt();
    private final Paint mTextPaint;
    private final ViewConfiguration mVC;
    private final VelocityTracker mVelocity;

    public PointerLocationView(Context context) {
        super(context);
        this.mPointers = new ArrayList();
        this.mText = new FasterStringBuilder();
        this.mReusableOvalRect = new RectF();
        this.setFocusable(true);
        this.mVC = ViewConfiguration.get(context);
        this.mTextPaint = new Paint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextSize(10.0f * this.getResources().getDisplayMetrics().density);
        this.mTextPaint.setARGB(255, 0, 0, 0);
        this.mTextBackgroundPaint = new Paint();
        this.mTextBackgroundPaint.setAntiAlias(false);
        this.mTextBackgroundPaint.setARGB(128, 255, 255, 255);
        this.mTextLevelPaint = new Paint();
        this.mTextLevelPaint.setAntiAlias(false);
        this.mTextLevelPaint.setARGB(192, 255, 0, 0);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setARGB(255, 255, 255, 255);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(2.0f);
        this.mTargetPaint = new Paint();
        this.mTargetPaint.setAntiAlias(false);
        this.mTargetPaint.setARGB(255, 0, 0, 192);
        this.mPathPaint = new Paint();
        this.mPathPaint.setAntiAlias(false);
        this.mPathPaint.setARGB(255, 0, 96, 255);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(1.0f);
        PointerState pointerState = new PointerState();
        this.mPointers.add(pointerState);
        this.mActivePointerId = 0;
        this.mVelocity = VelocityTracker.obtain();
        this.logInputDeviceCapabilities();
    }

    private void drawOval(Canvas canvas, float f, float f2, float f3, float f4, float f5, Paint paint) {
        canvas.save(1);
        canvas.rotate((float)((double)(180.0f * f5) / Math.PI), f, f2);
        this.mReusableOvalRect.left = f - f4 / 2.0f;
        this.mReusableOvalRect.right = f + f4 / 2.0f;
        this.mReusableOvalRect.top = f2 - f3 / 2.0f;
        this.mReusableOvalRect.bottom = f2 + f3 / 2.0f;
        canvas.drawOval(this.mReusableOvalRect, paint);
        canvas.restore();
    }

    private void logInputDeviceCapabilities() {
        int[] nArray = InputDevice.getDeviceIds();
        for (int i = 0; i < nArray.length; ++i) {
            InputDevice inputDevice = InputDevice.getDevice(nArray[i]);
            if (inputDevice == null) continue;
            Log.i(TAG, inputDevice.toString());
        }
    }

    private void logPointerCoords(MotionEvent.PointerCoords pointerCoords, int n) {
        Log.i(TAG, this.mText.clear().append("Pointer ").append(n + 1).append(": (").append(pointerCoords.x, 3).append(", ").append(pointerCoords.y, 3).append(") Pressure=").append(pointerCoords.pressure, 3).append(" Size=").append(pointerCoords.size, 3).append(" TouchMajor=").append(pointerCoords.touchMajor, 3).append(" TouchMinor=").append(pointerCoords.touchMinor, 3).append(" ToolMajor=").append(pointerCoords.toolMajor, 3).append(" ToolMinor=").append(pointerCoords.toolMinor, 3).append(" Orientation=").append((float)((double)(180.0f * pointerCoords.orientation) / Math.PI), 1).append("deg").toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addTouchEvent(MotionEvent motionEvent) {
        ArrayList<PointerState> arrayList = this.mPointers;
        synchronized (arrayList) {
            int n = motionEvent.getAction();
            int n2 = this.mPointers.size();
            if (n == 0 || (n & 0xFF) == 5) {
                int n3 = (0xFF00 & n) >> 8;
                if (n == 0) {
                    for (int i = 0; i < n2; ++i) {
                        PointerState pointerState = this.mPointers.get(i);
                        pointerState.clearTrace();
                        PointerState.access$102(pointerState, false);
                    }
                    this.mCurDown = true;
                    this.mMaxNumPointers = 0;
                    this.mVelocity.clear();
                }
                int n4 = motionEvent.getPointerId(n3);
                while (n2 <= n4) {
                    PointerState pointerState = new PointerState();
                    this.mPointers.add(pointerState);
                    ++n2;
                }
                if (this.mActivePointerId < 0 || !this.mPointers.get(this.mActivePointerId).mCurDown) {
                    this.mActivePointerId = n4;
                }
                PointerState.access$102(this.mPointers.get(n4), true);
                if (this.mPrintCoords) {
                    Log.i(TAG, this.mText.clear().append("Pointer ").append(n4 + 1).append(": DOWN").toString());
                }
            }
            int n5 = motionEvent.getPointerCount();
            boolean bl = n != 1 && n != 3;
            this.mCurDown = bl;
            int n6 = this.mCurDown ? n5 : 0;
            this.mCurNumPointers = n6;
            if (this.mMaxNumPointers < this.mCurNumPointers) {
                this.mMaxNumPointers = this.mCurNumPointers;
            }
            this.mVelocity.addMovement(motionEvent);
            this.mVelocity.computeCurrentVelocity(1);
            for (int i = 0; i < n5; ++i) {
                int n7 = motionEvent.getPointerId(i);
                PointerState pointerState = this.mPointers.get(n7);
                int n8 = motionEvent.getHistorySize();
                for (int j = 0; j < n8; ++j) {
                    motionEvent.getHistoricalPointerCoords(i, j, pointerState.mCoords);
                    if (this.mPrintCoords) {
                        this.logPointerCoords(pointerState.mCoords, n7);
                    }
                    pointerState.addTrace(motionEvent.getHistoricalX(i, j), motionEvent.getHistoricalY(i, j));
                }
                motionEvent.getPointerCoords(i, pointerState.mCoords);
                if (this.mPrintCoords) {
                    this.logPointerCoords(pointerState.mCoords, n7);
                }
                pointerState.addTrace(((PointerState)pointerState).mCoords.x, ((PointerState)pointerState).mCoords.y);
                PointerState.access$502(pointerState, this.mVelocity.getXVelocity(n7));
                PointerState.access$602(pointerState, this.mVelocity.getYVelocity(n7));
            }
            if (n == 1 || n == 3 || (n & 0xFF) == 6) {
                int n9 = (0xFF00 & n) >> 8;
                int n10 = motionEvent.getPointerId(n9);
                PointerState pointerState = this.mPointers.get(n10);
                PointerState.access$102(pointerState, false);
                if (this.mPrintCoords) {
                    Log.i(TAG, this.mText.clear().append("Pointer ").append(n10 + 1).append(": UP").toString());
                }
                if (n == 1 || n == 3) {
                    this.mCurDown = false;
                } else {
                    if (this.mActivePointerId == n10) {
                        int n11 = n9 == 0 ? 1 : 0;
                        this.mActivePointerId = motionEvent.getPointerId(n11);
                    }
                    pointerState.addTrace(Float.NaN, Float.NaN);
                }
            }
            this.postInvalidate();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onDraw(Canvas canvas) {
        ArrayList<PointerState> arrayList = this.mPointers;
        synchronized (arrayList) {
            int n = this.getWidth();
            int n2 = n / 7;
            int n3 = 1 + -this.mTextMetrics.ascent;
            int n4 = this.mHeaderBottom;
            int n5 = this.mPointers.size();
            if (this.mActivePointerId >= 0) {
                PointerState pointerState = this.mPointers.get(this.mActivePointerId);
                canvas.drawRect(0.0f, 0.0f, n2 - 1, n4, this.mTextBackgroundPaint);
                canvas.drawText(this.mText.clear().append("P: ").append(this.mCurNumPointers).append(" / ").append(this.mMaxNumPointers).toString(), 1.0f, n3, this.mTextPaint);
                int n6 = pointerState.mTraceCount;
                if (this.mCurDown && pointerState.mCurDown || n6 == 0) {
                    canvas.drawRect(n2, 0.0f, n2 * 2 - 1, n4, this.mTextBackgroundPaint);
                    canvas.drawText(this.mText.clear().append("X: ").append(((PointerState)pointerState).mCoords.x, 1).toString(), n2 + 1, n3, this.mTextPaint);
                    canvas.drawRect(n2 * 2, 0.0f, n2 * 3 - 1, n4, this.mTextBackgroundPaint);
                    canvas.drawText(this.mText.clear().append("Y: ").append(((PointerState)pointerState).mCoords.y, 1).toString(), 1 + n2 * 2, n3, this.mTextPaint);
                } else {
                    float f = pointerState.mTraceX[n6 - 1] - pointerState.mTraceX[0];
                    float f2 = pointerState.mTraceY[n6 - 1] - pointerState.mTraceY[0];
                    float f3 = n2;
                    float f4 = n2 * 2 - 1;
                    float f5 = n4;
                    Paint paint = Math.abs(f) < (float)this.mVC.getScaledTouchSlop() ? this.mTextBackgroundPaint : this.mTextLevelPaint;
                    canvas.drawRect(f3, 0.0f, f4, f5, paint);
                    canvas.drawText(this.mText.clear().append("dX: ").append(f, 1).toString(), n2 + 1, n3, this.mTextPaint);
                    float f6 = n2 * 2;
                    float f7 = n2 * 3 - 1;
                    float f8 = n4;
                    Paint paint2 = Math.abs(f2) < (float)this.mVC.getScaledTouchSlop() ? this.mTextBackgroundPaint : this.mTextLevelPaint;
                    canvas.drawRect(f6, 0.0f, f7, f8, paint2);
                    canvas.drawText(this.mText.clear().append("dY: ").append(f2, 1).toString(), 1 + n2 * 2, n3, this.mTextPaint);
                }
                canvas.drawRect(n2 * 3, 0.0f, n2 * 4 - 1, n4, this.mTextBackgroundPaint);
                canvas.drawText(this.mText.clear().append("Xv: ").append(pointerState.mXVelocity, 3).toString(), 1 + n2 * 3, n3, this.mTextPaint);
                canvas.drawRect(n2 * 4, 0.0f, n2 * 5 - 1, n4, this.mTextBackgroundPaint);
                canvas.drawText(this.mText.clear().append("Yv: ").append(pointerState.mYVelocity, 3).toString(), 1 + n2 * 4, n3, this.mTextPaint);
                canvas.drawRect(n2 * 5, 0.0f, n2 * 6 - 1, n4, this.mTextBackgroundPaint);
                canvas.drawRect(n2 * 5, 0.0f, (float)(n2 * 5) + ((PointerState)pointerState).mCoords.pressure * (float)n2 - 1.0f, n4, this.mTextLevelPaint);
                canvas.drawText(this.mText.clear().append("Prs: ").append(((PointerState)pointerState).mCoords.pressure, 2).toString(), 1 + n2 * 5, n3, this.mTextPaint);
                canvas.drawRect(n2 * 6, 0.0f, n, n4, this.mTextBackgroundPaint);
                canvas.drawRect(n2 * 6, 0.0f, (float)(n2 * 6) + ((PointerState)pointerState).mCoords.size * (float)n2 - 1.0f, n4, this.mTextLevelPaint);
                canvas.drawText(this.mText.clear().append("Size: ").append(((PointerState)pointerState).mCoords.size, 2).toString(), 1 + n2 * 6, n3, this.mTextPaint);
            }
            int n7 = 0;
            while (n7 < n5) {
                PointerState pointerState = this.mPointers.get(n7);
                int n8 = pointerState.mTraceCount;
                float f = 0.0f;
                float f9 = 0.0f;
                boolean bl = false;
                boolean bl2 = false;
                this.mPaint.setARGB(255, 128, 255, 255);
                int n9 = 0;
                while (true) {
                    block15: {
                        float f10;
                        float f11;
                        block16: {
                            block13: {
                                block14: {
                                    if (n9 >= n8) break block13;
                                    f11 = pointerState.mTraceX[n9];
                                    f10 = pointerState.mTraceY[n9];
                                    if (!Float.isNaN(f11)) break block14;
                                    bl = false;
                                    break block15;
                                }
                                if (!bl) break block16;
                                canvas.drawLine(f, f9, f11, f10, this.mPathPaint);
                                Paint paint = this.mPaint;
                                canvas.drawPoint(f, f9, paint);
                                bl2 = true;
                                break block16;
                            }
                            if (bl2) {
                                this.mPaint.setARGB(255, 255, 64, 128);
                                float f12 = 16.0f * pointerState.mXVelocity;
                                float f13 = 16.0f * pointerState.mYVelocity;
                                float f14 = f + f12;
                                float f15 = f9 + f13;
                                Paint paint = this.mPaint;
                                canvas.drawLine(f, f9, f14, f15, paint);
                            }
                            if (!this.mCurDown || !pointerState.mCurDown) break;
                            canvas.drawLine(0.0f, ((PointerState)pointerState).mCoords.y, this.getWidth(), ((PointerState)pointerState).mCoords.y, this.mTargetPaint);
                            canvas.drawLine(((PointerState)pointerState).mCoords.x, 0.0f, ((PointerState)pointerState).mCoords.x, this.getHeight(), this.mTargetPaint);
                            int n10 = (int)(255.0f * ((PointerState)pointerState).mCoords.pressure);
                            this.mPaint.setARGB(255, n10, 255, 255 - n10);
                            canvas.drawPoint(((PointerState)pointerState).mCoords.x, ((PointerState)pointerState).mCoords.y, this.mPaint);
                            this.mPaint.setARGB(255, n10, 255 - n10, 128);
                            this.drawOval(canvas, ((PointerState)pointerState).mCoords.x, ((PointerState)pointerState).mCoords.y, ((PointerState)pointerState).mCoords.touchMajor, ((PointerState)pointerState).mCoords.touchMinor, ((PointerState)pointerState).mCoords.orientation, this.mPaint);
                            this.mPaint.setARGB(255, n10, 128, 255 - n10);
                            this.drawOval(canvas, ((PointerState)pointerState).mCoords.x, ((PointerState)pointerState).mCoords.y, ((PointerState)pointerState).mCoords.toolMajor, ((PointerState)pointerState).mCoords.toolMinor, ((PointerState)pointerState).mCoords.orientation, this.mPaint);
                            break;
                        }
                        f = f11;
                        f9 = f10;
                        bl = true;
                    }
                    ++n9;
                }
                ++n7;
            }
            return;
        }
    }

    @Override
    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        this.mTextPaint.getFontMetricsInt(this.mTextMetrics);
        this.mHeaderBottom = 2 + (-this.mTextMetrics.ascent + this.mTextMetrics.descent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.addTouchEvent(motionEvent);
        return true;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        Log.i(TAG, "Trackball: " + motionEvent);
        return super.onTrackballEvent(motionEvent);
    }

    public void setPrintCoords(boolean bl) {
        this.mPrintCoords = bl;
    }

    private static final class FasterStringBuilder {
        private char[] mChars = new char[64];
        private int mLength;

        private int reserve(int n) {
            int n2 = this.mLength;
            int n3 = n + this.mLength;
            char[] cArray = this.mChars;
            int n4 = cArray.length;
            if (n3 > n4) {
                char[] cArray2 = new char[n4 * 2];
                System.arraycopy(cArray, 0, cArray2, 0, n2);
                this.mChars = cArray2;
            }
            return n2;
        }

        public FasterStringBuilder append(float f, int n) {
            int n2 = 1;
            for (int i = 0; i < n; ++i) {
                n2 *= 10;
            }
            float f2 = (float)(Math.rint(f * (float)n2) / (double)n2);
            this.append((int)f2);
            if (n != 0) {
                this.append(".");
                float f3 = Math.abs(f2);
                this.append((int)((float)((double)f3 - Math.floor(f3)) * (float)n2), n);
            }
            return this;
        }

        public FasterStringBuilder append(int n) {
            return this.append(n, 0);
        }

        /*
         * Enabled aggressive block sorting
         */
        public FasterStringBuilder append(int n, int n2) {
            int n3;
            boolean bl = n < 0;
            if (bl && (n = -n) < 0) {
                this.append("-2147483648");
                return this;
            }
            int n4 = this.reserve(11);
            char[] cArray = this.mChars;
            if (n == 0) {
                int cfr_ignored_0 = n4 + 1;
                cArray[n4] = 48;
                this.mLength = 1 + this.mLength;
                return this;
            }
            if (bl) {
                int n5 = n4 + 1;
                cArray[n4] = 45;
                n4 = n5;
            }
            int n6 = 10;
            int n7 = n4;
            for (n3 = 1000000000; n < n3; n3 /= 10) {
                if (--n6 >= n2) continue;
                int n8 = n7 + 1;
                cArray[n7] = 48;
                n7 = n8;
            }
            do {
                int n9 = n7;
                int n10 = n / n3;
                n -= n10 * n3;
                n7 = n9 + 1;
                cArray[n9] = (char)(n10 + 48);
            } while ((n3 /= 10) != 0);
            this.mLength = n7;
            return this;
        }

        public FasterStringBuilder append(String string2) {
            int n = string2.length();
            int n2 = this.reserve(n);
            string2.getChars(0, n, this.mChars, n2);
            this.mLength = n + this.mLength;
            return this;
        }

        public FasterStringBuilder clear() {
            this.mLength = 0;
            return this;
        }

        public String toString() {
            return new String(this.mChars, 0, this.mLength);
        }
    }

    public static class PointerState {
        private MotionEvent.PointerCoords mCoords;
        private boolean mCurDown;
        private int mTraceCount;
        private float[] mTraceX = new float[32];
        private float[] mTraceY = new float[32];
        private float mXVelocity;
        private float mYVelocity;

        public PointerState() {
            this.mCoords = new MotionEvent.PointerCoords();
        }

        static /* synthetic */ boolean access$102(PointerState pointerState, boolean bl) {
            pointerState.mCurDown = bl;
            return bl;
        }

        static /* synthetic */ float access$502(PointerState pointerState, float f) {
            pointerState.mXVelocity = f;
            return f;
        }

        static /* synthetic */ float access$602(PointerState pointerState, float f) {
            pointerState.mYVelocity = f;
            return f;
        }

        public void addTrace(float f, float f2) {
            int n = this.mTraceX.length;
            if (this.mTraceCount == n) {
                int n2 = n * 2;
                float[] fArray = new float[n2];
                System.arraycopy(this.mTraceX, 0, fArray, 0, this.mTraceCount);
                this.mTraceX = fArray;
                float[] fArray2 = new float[n2];
                System.arraycopy(this.mTraceY, 0, fArray2, 0, this.mTraceCount);
                this.mTraceY = fArray2;
            }
            this.mTraceX[this.mTraceCount] = f;
            this.mTraceY[this.mTraceCount] = f2;
            this.mTraceCount = 1 + this.mTraceCount;
        }

        public void clearTrace() {
            this.mTraceCount = 0;
        }
    }
}

