/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.os.Vibrator;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import com.android.internal.R;

public class RotarySelector
extends View {
    private static final int ARROW_SCRUNCH_DIP = 6;
    private static final boolean DBG = false;
    private static final int EDGE_PADDING_DIP = 9;
    private static final int EDGE_TRIGGER_DIP = 100;
    public static final int HORIZONTAL = 0;
    public static final int LEFT_HANDLE_GRABBED = 1;
    private static final String LOG_TAG = "RotarySelector";
    public static final int NOTHING_GRABBED = 0;
    static final int OUTER_ROTARY_RADIUS_DIP = 390;
    public static final int RIGHT_HANDLE_GRABBED = 2;
    static final int ROTARY_STROKE_WIDTH_DIP = 83;
    static final int SNAP_BACK_ANIMATION_DURATION_MILLIS = 300;
    static final int SPIN_ANIMATION_DURATION_MILLIS = 800;
    public static final int VERTICAL = 1;
    private static final long VIBRATE_LONG = 20L;
    private static final long VIBRATE_SHORT = 20L;
    private static final boolean VISUAL_DEBUG;
    private boolean mAnimating = false;
    private int mAnimatingDeltaXEnd;
    private int mAnimatingDeltaXStart;
    private long mAnimationDuration;
    private long mAnimationStartTime;
    private Bitmap mArrowLongLeft;
    private Bitmap mArrowLongRight;
    final Matrix mArrowMatrix;
    private Bitmap mArrowShortLeftAndRight;
    private Bitmap mBackground;
    private int mBackgroundHeight;
    private int mBackgroundWidth;
    final Matrix mBgMatrix;
    private float mDensity;
    private Bitmap mDimple;
    private Bitmap mDimpleDim;
    private int mDimpleSpacing;
    private int mDimpleWidth;
    private int mDimplesOfFling = 0;
    private int mEdgeTriggerThresh;
    private int mGrabbedState = 0;
    private final int mInnerRadius;
    private DecelerateInterpolator mInterpolator;
    private Bitmap mLeftHandleIcon;
    private int mLeftHandleX;
    private int mMaximumVelocity;
    private int mMinimumVelocity;
    private OnDialTriggerListener mOnDialTriggerListener;
    private int mOrientation;
    private final int mOuterRadius;
    private Paint mPaint = new Paint();
    private Bitmap mRightHandleIcon;
    private int mRightHandleX;
    private int mRotaryOffsetX = 0;
    private boolean mTriggered = false;
    private VelocityTracker mVelocityTracker;
    private Vibrator mVibrator;

    public RotarySelector(Context context) {
        this(context, null);
    }

    public RotarySelector(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mBgMatrix = new Matrix();
        this.mArrowMatrix = new Matrix();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.RotarySelector);
        this.mOrientation = typedArray.getInt(0, 0);
        typedArray.recycle();
        this.mDensity = this.getResources().getDisplayMetrics().density;
        this.mBackground = this.getBitmapFor(17301990);
        this.mDimple = this.getBitmapFor(17301991);
        this.mDimpleDim = this.getBitmapFor(17301992);
        this.mArrowLongLeft = this.getBitmapFor(17301982);
        this.mArrowLongRight = this.getBitmapFor(17301985);
        this.mArrowShortLeftAndRight = this.getBitmapFor(17301988);
        this.mInterpolator = new DecelerateInterpolator(1.0f);
        this.mEdgeTriggerThresh = (int)(100.0f * this.mDensity);
        this.mDimpleWidth = this.mDimple.getWidth();
        this.mBackgroundWidth = this.mBackground.getWidth();
        this.mBackgroundHeight = this.mBackground.getHeight();
        this.mOuterRadius = (int)(390.0f * this.mDensity);
        this.mInnerRadius = (int)(307.0f * this.mDensity);
        ViewConfiguration viewConfiguration = ViewConfiguration.get(this.mContext);
        this.mMinimumVelocity = 2 * viewConfiguration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
    }

    private void dispatchTriggerEvent(int n) {
        this.vibrate(20L);
        if (this.mOnDialTriggerListener != null) {
            this.mOnDialTriggerListener.onDialTrigger(this, n);
        }
    }

    private void drawCentered(Bitmap bitmap, Canvas canvas, int n, int n2) {
        int n3 = bitmap.getWidth();
        int n4 = bitmap.getHeight();
        canvas.drawBitmap(bitmap, n - n3 / 2, n2 - n4 / 2, this.mPaint);
    }

    private Bitmap getBitmapFor(int n) {
        return BitmapFactory.decodeResource(this.getContext().getResources(), n);
    }

    private int getYOnArc(int n, int n2, int n3, int n4) {
        int n5 = (n3 - n2) / 2;
        int n6 = n2 + n5;
        int n7 = n / 2 - n4;
        return n5 + (n6 - (int)Math.sqrt(n6 * n6 - n7 * n7));
    }

    private boolean isHoriz() {
        return this.mOrientation == 0;
    }

    private void log(String string2) {
        Log.d(LOG_TAG, string2);
    }

    private void reset() {
        this.mAnimating = false;
        this.mRotaryOffsetX = 0;
        this.mDimplesOfFling = 0;
        this.setGrabbedState(0);
        this.mTriggered = false;
    }

    private void setGrabbedState(int n) {
        if (n != this.mGrabbedState) {
            this.mGrabbedState = n;
            if (this.mOnDialTriggerListener != null) {
                this.mOnDialTriggerListener.onGrabbedStateChange(this, this.mGrabbedState);
            }
        }
    }

    private void startAnimation(int n, int n2, int n3) {
        this.mAnimating = true;
        this.mAnimationStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mAnimationDuration = n3;
        this.mAnimatingDeltaXStart = n;
        this.mAnimatingDeltaXEnd = n2;
        this.setGrabbedState(0);
        this.mDimplesOfFling = 0;
        this.invalidate();
    }

    private void startAnimationWithVelocity(int n, int n2, int n3) {
        this.mAnimating = true;
        this.mAnimationStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mAnimationDuration = 1000 * (n2 - n) / n3;
        this.mAnimatingDeltaXStart = n;
        this.mAnimatingDeltaXEnd = n2;
        this.setGrabbedState(0);
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateAnimation() {
        long l = AnimationUtils.currentAnimationTimeMillis() - this.mAnimationStartTime;
        long l2 = this.mAnimationDuration - l;
        int n = this.mAnimatingDeltaXStart - this.mAnimatingDeltaXEnd;
        boolean bl = n < 0;
        if (l2 <= 0L) {
            this.reset();
            return;
        }
        float f = this.mInterpolator.getInterpolation((float)l / (float)this.mAnimationDuration);
        this.mRotaryOffsetX = (int)((float)n * (1.0f - f)) + this.mAnimatingDeltaXEnd;
        if (this.mDimplesOfFling > 0) {
            if (!bl && this.mRotaryOffsetX < -3 * this.mDimpleSpacing) {
                this.mRotaryOffsetX += this.mDimplesOfFling * this.mDimpleSpacing;
            } else if (bl && this.mRotaryOffsetX > 3 * this.mDimpleSpacing) {
                this.mRotaryOffsetX -= this.mDimplesOfFling * this.mDimpleSpacing;
            }
        }
        this.invalidate();
    }

    private void vibrate(long l) {
        synchronized (this) {
            if (this.mVibrator == null) {
                this.mVibrator = (Vibrator)this.getContext().getSystemService("vibrator");
            }
            this.mVibrator.vibrate(l);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDraw(Canvas canvas) {
        int n;
        super.onDraw(canvas);
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (this.mAnimating) {
            this.updateAnimation();
        }
        canvas.drawBitmap(this.mBackground, this.mBgMatrix, this.mPaint);
        this.mArrowMatrix.reset();
        switch (this.mGrabbedState) {
            default: {
                throw new IllegalStateException("invalid mGrabbedState: " + this.mGrabbedState);
            }
            case 1: {
                this.mArrowMatrix.setTranslate(0.0f, 0.0f);
                if (!this.isHoriz()) {
                    this.mArrowMatrix.preRotate(-90.0f, 0.0f, 0.0f);
                    this.mArrowMatrix.postTranslate(0.0f, n3);
                }
                canvas.drawBitmap(this.mArrowLongLeft, this.mArrowMatrix, this.mPaint);
                break;
            }
            case 2: {
                this.mArrowMatrix.setTranslate(0.0f, 0.0f);
                if (!this.isHoriz()) {
                    this.mArrowMatrix.preRotate(-90.0f, 0.0f, 0.0f);
                    this.mArrowMatrix.postTranslate(0.0f, n3 + (this.mBackgroundWidth - n3));
                }
                canvas.drawBitmap(this.mArrowLongRight, this.mArrowMatrix, this.mPaint);
            }
            case 0: 
        }
        int n4 = this.mBackgroundHeight;
        int n5 = this.isHoriz() ? n3 - n4 : n2 - n4;
        int n6 = this.mLeftHandleX + this.mRotaryOffsetX;
        int n7 = this.getYOnArc(this.mBackgroundWidth, this.mInnerRadius, this.mOuterRadius, n6);
        int n8 = this.isHoriz() ? n6 : n7 + n5;
        int n9 = this.isHoriz() ? n7 + n5 : n3 - n6;
        if (this.mGrabbedState != 2) {
            this.drawCentered(this.mDimple, canvas, n8, n9);
            this.drawCentered(this.mLeftHandleIcon, canvas, n8, n9);
        } else {
            this.drawCentered(this.mDimpleDim, canvas, n8, n9);
        }
        int n10 = this.isHoriz() ? n2 / 2 + this.mRotaryOffsetX : n3 / 2 + this.mRotaryOffsetX;
        int n11 = this.getYOnArc(this.mBackgroundWidth, this.mInnerRadius, this.mOuterRadius, n10);
        if (this.isHoriz()) {
            Bitmap bitmap = this.mDimpleDim;
            int n12 = n11 + n5;
            this.drawCentered(bitmap, canvas, n10, n12);
        } else {
            this.drawCentered(this.mDimpleDim, canvas, n11 + n5, n3 - n10);
        }
        int n13 = this.mRightHandleX + this.mRotaryOffsetX;
        int n14 = this.getYOnArc(this.mBackgroundWidth, this.mInnerRadius, this.mOuterRadius, n13);
        int n15 = this.isHoriz() ? n13 : n14 + n5;
        int n16 = this.isHoriz() ? n14 + n5 : n3 - n13;
        if (this.mGrabbedState != 1) {
            this.drawCentered(this.mDimple, canvas, n15, n16);
            this.drawCentered(this.mRightHandleIcon, canvas, n15, n16);
        } else {
            this.drawCentered(this.mDimpleDim, canvas, n15, n16);
        }
        int n17 = this.mDimpleWidth / 2;
        for (int i = this.mRotaryOffsetX + this.mLeftHandleX - this.mDimpleSpacing; i > (n = -n17); i -= this.mDimpleSpacing) {
            int n18 = this.getYOnArc(this.mBackgroundWidth, this.mInnerRadius, this.mOuterRadius, i);
            if (this.isHoriz()) {
                Bitmap bitmap = this.mDimpleDim;
                int n19 = n18 + n5;
                this.drawCentered(bitmap, canvas, i, n19);
                continue;
            }
            this.drawCentered(this.mDimpleDim, canvas, n18 + n5, n3 - i);
        }
        int n20 = this.mRotaryOffsetX + this.mRightHandleX + this.mDimpleSpacing;
        int n21 = n17 + this.mRight;
        while (n20 < n21) {
            int n22 = this.getYOnArc(this.mBackgroundWidth, this.mInnerRadius, this.mOuterRadius, n20);
            if (this.isHoriz()) {
                Bitmap bitmap = this.mDimpleDim;
                int n23 = n22 + n5;
                this.drawCentered(bitmap, canvas, n20, n23);
            } else {
                this.drawCentered(this.mDimpleDim, canvas, n22 + n5, n3 - n20);
            }
            n20 += this.mDimpleSpacing;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = this.isHoriz() ? View.MeasureSpec.getSize(n) : View.MeasureSpec.getSize(n2);
        int n4 = (int)(6.0f * this.mDensity);
        int n5 = this.mArrowShortLeftAndRight.getHeight() + this.mBackgroundHeight - n4;
        if (this.isHoriz()) {
            this.setMeasuredDimension(n3, n5);
            return;
        }
        this.setMeasuredDimension(n5, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        int n5 = (int)(9.0f * this.mDensity);
        this.mLeftHandleX = n5 + this.mDimpleWidth / 2;
        int n6 = this.isHoriz() ? n : n2;
        this.mRightHandleX = n6 - n5 - this.mDimpleWidth / 2;
        this.mDimpleSpacing = n6 / 2 - this.mLeftHandleX;
        this.mBgMatrix.setTranslate(0.0f, 0.0f);
        if (!this.isHoriz()) {
            int n7 = n - this.mBackgroundHeight;
            this.mBgMatrix.preRotate(-90.0f, 0.0f, 0.0f);
            this.mBgMatrix.postTranslate(n7, n2);
            return;
        }
        this.mBgMatrix.postTranslate(0.0f, n2 - this.mBackgroundHeight);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mAnimating) {
            return true;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        int n = this.getHeight();
        int n2 = this.isHoriz() ? (int)motionEvent.getX() : n - (int)motionEvent.getY();
        int n3 = this.mDimpleWidth;
        switch (motionEvent.getAction()) {
            case 0: {
                this.mTriggered = false;
                if (this.mGrabbedState != 0) {
                    this.reset();
                    this.invalidate();
                }
                if (n2 < n3 + this.mLeftHandleX) {
                    this.mRotaryOffsetX = n2 - this.mLeftHandleX;
                    this.setGrabbedState(1);
                    this.invalidate();
                    this.vibrate(20L);
                    return true;
                }
                if (n2 <= this.mRightHandleX - n3) return true;
                this.mRotaryOffsetX = n2 - this.mRightHandleX;
                this.setGrabbedState(2);
                this.invalidate();
                this.vibrate(20L);
                return true;
            }
            case 2: {
                if (this.mGrabbedState == 1) {
                    this.mRotaryOffsetX = n2 - this.mLeftHandleX;
                    this.invalidate();
                    int n4 = this.isHoriz() ? this.getRight() : n;
                    if (n2 < n4 - this.mEdgeTriggerThresh) return true;
                    if (this.mTriggered) return true;
                    this.mTriggered = true;
                    this.dispatchTriggerEvent(1);
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                    int n5 = this.isHoriz() ? (int)velocityTracker.getXVelocity() : -((int)velocityTracker.getYVelocity());
                    int n6 = Math.max(this.mMinimumVelocity, n5);
                    this.mDimplesOfFling = Math.max(8, Math.abs(n6 / this.mDimpleSpacing));
                    this.startAnimationWithVelocity(n2 - this.mLeftHandleX, this.mDimplesOfFling * this.mDimpleSpacing, n6);
                    return true;
                }
                if (this.mGrabbedState != 2) return true;
                this.mRotaryOffsetX = n2 - this.mRightHandleX;
                this.invalidate();
                if (n2 > this.mEdgeTriggerThresh) return true;
                if (this.mTriggered) return true;
                this.mTriggered = true;
                this.dispatchTriggerEvent(2);
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                int n7 = this.isHoriz() ? (int)velocityTracker.getXVelocity() : -((int)velocityTracker.getYVelocity());
                int n8 = Math.min(-this.mMinimumVelocity, n7);
                this.mDimplesOfFling = Math.max(8, Math.abs(n8 / this.mDimpleSpacing));
                this.startAnimationWithVelocity(n2 - this.mRightHandleX, -(this.mDimplesOfFling * this.mDimpleSpacing), n8);
                return true;
            }
            case 1: {
                if (this.mGrabbedState == 1 && Math.abs(n2 - this.mLeftHandleX) > 5) {
                    this.startAnimation(n2 - this.mLeftHandleX, 0, 300);
                } else if (this.mGrabbedState == 2 && Math.abs(n2 - this.mRightHandleX) > 5) {
                    this.startAnimation(n2 - this.mRightHandleX, 0, 300);
                }
                this.mRotaryOffsetX = 0;
                this.setGrabbedState(0);
                this.invalidate();
                if (this.mVelocityTracker == null) return true;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                return true;
            }
            case 3: {
                this.reset();
                this.invalidate();
                if (this.mVelocityTracker == null) return true;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                return true;
            }
        }
        return true;
    }

    public void setLeftHandleResource(int n) {
        if (n != 0) {
            this.mLeftHandleIcon = this.getBitmapFor(n);
        }
        this.invalidate();
    }

    public void setOnDialTriggerListener(OnDialTriggerListener onDialTriggerListener) {
        this.mOnDialTriggerListener = onDialTriggerListener;
    }

    public void setRightHandleResource(int n) {
        if (n != 0) {
            this.mRightHandleIcon = this.getBitmapFor(n);
        }
        this.invalidate();
    }

    public static interface OnDialTriggerListener {
        public static final int LEFT_HANDLE = 1;
        public static final int RIGHT_HANDLE = 2;

        public void onDialTrigger(View var1, int var2);

        public void onGrabbedStateChange(View var1, int var2);
    }
}

