/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.LinearLayout;
import com.android.internal.R;

public class WeightedLinearLayout
extends LinearLayout {
    private float mMajorWeight;
    private float mMinorWeight;

    public WeightedLinearLayout(Context context) {
        super(context);
    }

    public WeightedLinearLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.WeightedLinearLayout);
        this.mMajorWeight = typedArray.getFloat(0, 0.0f);
        this.mMinorWeight = typedArray.getFloat(1, 0.0f);
        typedArray.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        int n3 = displayMetrics.widthPixels;
        boolean bl = n3 < displayMetrics.heightPixels;
        int n4 = View.MeasureSpec.getMode(n);
        super.onMeasure(n, n2);
        int n5 = this.getMeasuredWidth();
        int n6 = this.getMeasuredHeight();
        int n7 = View.MeasureSpec.makeMeasureSpec(n5, 0x40000000);
        int n8 = View.MeasureSpec.makeMeasureSpec(n6, 0x40000000);
        float f = bl ? this.mMinorWeight : this.mMajorWeight;
        boolean bl2 = false;
        if (n4 == Integer.MIN_VALUE) {
            float f2 = f - 0.0f;
            float f3 = f2 == 0.0f ? 0 : (f2 > 0.0f ? 1 : -1);
            bl2 = false;
            if (f3 > 0) {
                float f4 = (float)n5 - f * (float)n3;
                float f5 = f4 == 0.0f ? 0 : (f4 < 0.0f ? -1 : 1);
                bl2 = false;
                if (f5 < 0) {
                    n7 = View.MeasureSpec.makeMeasureSpec((int)(f * (float)n3), 0x40000000);
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            super.onMeasure(n7, n8);
        }
    }
}

