/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.sip;

import android.net.sip.SipProfile;
import android.util.Log;
import gov.nist.javax.sip.SipStackExt;
import gov.nist.javax.sip.clientauthutils.AccountManager;
import gov.nist.javax.sip.clientauthutils.AuthenticationHelper;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.PeerUnavailableException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;

class SipHelper {
    private static final boolean DEBUG = true;
    private static final String TAG = SipHelper.class.getSimpleName();
    private AddressFactory mAddressFactory;
    private HeaderFactory mHeaderFactory;
    private MessageFactory mMessageFactory;
    private SipProvider mSipProvider;
    private SipStack mSipStack;

    public SipHelper(SipStack sipStack, SipProvider sipProvider) throws PeerUnavailableException {
        this.mSipStack = sipStack;
        this.mSipProvider = sipProvider;
        SipFactory sipFactory = SipFactory.getInstance();
        this.mAddressFactory = sipFactory.createAddressFactory();
        this.mHeaderFactory = sipFactory.createHeaderFactory();
        this.mMessageFactory = sipFactory.createMessageFactory();
    }

    private CSeqHeader createCSeqHeader(String string2) throws ParseException, InvalidArgumentException {
        long l = (long)(10000.0 * Math.random());
        return this.mHeaderFactory.createCSeqHeader(l, string2);
    }

    private CallIdHeader createCallIdHeader() {
        return this.mSipProvider.getNewCallId();
    }

    private ContactHeader createContactHeader(SipProfile sipProfile) throws ParseException, SipException {
        ListeningPoint listeningPoint = this.getListeningPoint();
        SipURI sipURI = this.createSipUri(sipProfile.getUserName(), sipProfile.getProtocol(), listeningPoint);
        Address address = this.mAddressFactory.createAddress((URI)sipURI);
        address.setDisplayName(sipProfile.getDisplayName());
        return this.mHeaderFactory.createContactHeader(address);
    }

    private FromHeader createFromHeader(SipProfile sipProfile, String string2) throws ParseException {
        return this.mHeaderFactory.createFromHeader(sipProfile.getSipAddress(), string2);
    }

    private MaxForwardsHeader createMaxForwardsHeader() throws InvalidArgumentException {
        return this.mHeaderFactory.createMaxForwardsHeader(70);
    }

    private MaxForwardsHeader createMaxForwardsHeader(int n) throws InvalidArgumentException {
        return this.mHeaderFactory.createMaxForwardsHeader(n);
    }

    private Request createRequest(String string2, SipProfile sipProfile, String string3) throws ParseException, SipException {
        FromHeader fromHeader = this.createFromHeader(sipProfile, string3);
        ToHeader toHeader = this.createToHeader(sipProfile);
        SipURI sipURI = this.mAddressFactory.createSipURI(sipProfile.getUriString().replaceFirst(sipProfile.getUserName() + "@", ""));
        List<ViaHeader> list = this.createViaHeaders();
        CallIdHeader callIdHeader = this.createCallIdHeader();
        CSeqHeader cSeqHeader = this.createCSeqHeader(string2);
        MaxForwardsHeader maxForwardsHeader = this.createMaxForwardsHeader();
        Request request = this.mMessageFactory.createRequest((URI)sipURI, string2, callIdHeader, cSeqHeader, fromHeader, toHeader, list, maxForwardsHeader);
        request.addHeader(this.mHeaderFactory.createHeader("User-Agent", "SIPAUA/0.1.001"));
        return request;
    }

    private SipURI createSipUri(String string2, String string3, ListeningPoint listeningPoint) throws ParseException {
        SipURI sipURI = this.mAddressFactory.createSipURI(string2, listeningPoint.getIPAddress());
        try {
            sipURI.setPort(listeningPoint.getPort());
            sipURI.setTransportParam(string3);
            return sipURI;
        }
        catch (InvalidArgumentException invalidArgumentException) {
            throw new RuntimeException(invalidArgumentException);
        }
    }

    private ToHeader createToHeader(SipProfile sipProfile) throws ParseException {
        return this.createToHeader(sipProfile, null);
    }

    private ToHeader createToHeader(SipProfile sipProfile, String string2) throws ParseException {
        return this.mHeaderFactory.createToHeader(sipProfile.getSipAddress(), string2);
    }

    private List<ViaHeader> createViaHeaders() throws ParseException, SipException {
        ArrayList<ViaHeader> arrayList = new ArrayList<ViaHeader>(1);
        ListeningPoint listeningPoint = this.getListeningPoint();
        ViaHeader viaHeader = this.mHeaderFactory.createViaHeader(listeningPoint.getIPAddress(), listeningPoint.getPort(), listeningPoint.getTransport(), null);
        viaHeader.setRPort();
        arrayList.add(viaHeader);
        return arrayList;
    }

    private ContactHeader createWildcardContactHeader() {
        ContactHeader contactHeader = this.mHeaderFactory.createContactHeader();
        contactHeader.setWildCard();
        return contactHeader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getCallId(EventObject eventObject) {
        if (eventObject == null) {
            return null;
        }
        if (eventObject instanceof RequestEvent) {
            return SipHelper.getCallId((Message)((RequestEvent)eventObject).getRequest());
        }
        if (eventObject instanceof ResponseEvent) {
            return SipHelper.getCallId((Message)((ResponseEvent)eventObject).getResponse());
        }
        if (eventObject instanceof DialogTerminatedEvent) {
            ((DialogTerminatedEvent)eventObject).getDialog();
            return SipHelper.getCallId(((DialogTerminatedEvent)eventObject).getDialog());
        }
        if (eventObject instanceof TransactionTerminatedEvent) {
            ServerTransaction serverTransaction;
            TransactionTerminatedEvent transactionTerminatedEvent = (TransactionTerminatedEvent)eventObject;
            if (transactionTerminatedEvent.isServerTransaction()) {
                serverTransaction = transactionTerminatedEvent.getServerTransaction();
                return SipHelper.getCallId((Transaction)serverTransaction);
            }
            serverTransaction = transactionTerminatedEvent.getClientTransaction();
            return SipHelper.getCallId((Transaction)serverTransaction);
        }
        Object object = eventObject.getSource();
        if (object instanceof Transaction) {
            return SipHelper.getCallId((Transaction)object);
        }
        if (!(object instanceof Dialog)) return "";
        return SipHelper.getCallId((Dialog)object);
    }

    private static String getCallId(Dialog dialog) {
        return dialog.getCallId().getCallId();
    }

    public static String getCallId(Transaction transaction) {
        if (transaction != null) {
            return SipHelper.getCallId((Message)transaction.getRequest());
        }
        return "";
    }

    private static String getCallId(Message message) {
        return ((CallIdHeader)message.getHeader("Call-ID")).getCallId();
    }

    private ListeningPoint getListeningPoint() throws SipException {
        ListeningPoint[] listeningPointArray;
        ListeningPoint listeningPoint = this.mSipProvider.getListeningPoint("UDP");
        if (listeningPoint == null) {
            listeningPoint = this.mSipProvider.getListeningPoint("TCP");
        }
        if (listeningPoint == null && (listeningPointArray = this.mSipProvider.getListeningPoints()) != null && listeningPointArray.length > 0) {
            listeningPoint = listeningPointArray[0];
        }
        if (listeningPoint == null) {
            throw new SipException("no listening point is available");
        }
        return listeningPoint;
    }

    private ServerTransaction getServerTransaction(RequestEvent requestEvent) throws SipException {
        ServerTransaction serverTransaction = requestEvent.getServerTransaction();
        if (serverTransaction == null) {
            Request request = requestEvent.getRequest();
            return this.mSipProvider.getNewServerTransaction(request);
        }
        return serverTransaction;
    }

    public ClientTransaction handleChallenge(ResponseEvent responseEvent, AccountManager accountManager) throws SipException {
        AuthenticationHelper authenticationHelper = ((SipStackExt)this.mSipStack).getAuthenticationHelper(accountManager, this.mHeaderFactory);
        ClientTransaction clientTransaction = responseEvent.getClientTransaction();
        ClientTransaction clientTransaction2 = authenticationHelper.handleChallenge(responseEvent.getResponse(), clientTransaction, this.mSipProvider, 5);
        Log.d(TAG, "send request with challenge response: " + clientTransaction2.getRequest());
        clientTransaction2.sendRequest();
        return clientTransaction2;
    }

    public void sendBye(Dialog dialog) throws SipException {
        Request request = dialog.createRequest("BYE");
        Log.d(TAG, "send BYE: " + request);
        dialog.sendRequest(this.mSipProvider.getNewClientTransaction(request));
    }

    public void sendCancel(ClientTransaction clientTransaction) throws SipException {
        Request request = clientTransaction.createCancel();
        Log.d(TAG, "send CANCEL: " + request);
        this.mSipProvider.getNewClientTransaction(request).sendRequest();
    }

    public ClientTransaction sendInvite(SipProfile sipProfile, SipProfile sipProfile2, String string2, String string3) throws SipException {
        try {
            FromHeader fromHeader = this.createFromHeader(sipProfile, string3);
            ToHeader toHeader = this.createToHeader(sipProfile2);
            SipURI sipURI = sipProfile2.getUri();
            List<ViaHeader> list = this.createViaHeaders();
            CallIdHeader callIdHeader = this.createCallIdHeader();
            CSeqHeader cSeqHeader = this.createCSeqHeader("INVITE");
            MaxForwardsHeader maxForwardsHeader = this.createMaxForwardsHeader();
            Request request = this.mMessageFactory.createRequest((URI)sipURI, "INVITE", callIdHeader, cSeqHeader, fromHeader, toHeader, list, maxForwardsHeader);
            request.addHeader((Header)this.createContactHeader(sipProfile));
            request.setContent((Object)string2, this.mHeaderFactory.createContentTypeHeader("application", "sdp"));
            ClientTransaction clientTransaction = this.mSipProvider.getNewClientTransaction(request);
            Log.d(TAG, "send INVITE: " + request);
            clientTransaction.sendRequest();
            return clientTransaction;
        }
        catch (ParseException parseException) {
            throw new SipException("sendInvite()", (Throwable)parseException);
        }
    }

    public void sendInviteAck(ResponseEvent responseEvent, Dialog dialog) throws SipException {
        Request request = dialog.createAck(((CSeqHeader)responseEvent.getResponse().getHeader("CSeq")).getSeqNumber());
        Log.d(TAG, "send ACK: " + request);
        dialog.sendAck(request);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendInviteBusyHere(RequestEvent requestEvent, ServerTransaction serverTransaction) throws SipException {
        try {
            Request request = requestEvent.getRequest();
            Response response = this.mMessageFactory.createResponse(486, request);
            if (serverTransaction == null) {
                serverTransaction = this.getServerTransaction(requestEvent);
            }
            if (serverTransaction.getState() != TransactionState.COMPLETED) {
                Log.d(TAG, "send BUSY HERE: " + response);
                serverTransaction.sendResponse(response);
            }
            return;
        }
        catch (ParseException parseException) {
            throw new SipException("sendInviteBusyHere()", (Throwable)parseException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServerTransaction sendInviteOk(RequestEvent requestEvent, SipProfile sipProfile, String string2, ServerTransaction serverTransaction) throws SipException {
        try {
            Request request = requestEvent.getRequest();
            Response response = this.mMessageFactory.createResponse(200, request);
            response.addHeader((Header)this.createContactHeader(sipProfile));
            response.setContent((Object)string2, this.mHeaderFactory.createContentTypeHeader("application", "sdp"));
            if (serverTransaction == null) {
                serverTransaction = this.getServerTransaction(requestEvent);
            }
            if (serverTransaction.getState() != TransactionState.COMPLETED) {
                Log.d(TAG, "send OK: " + response);
                serverTransaction.sendResponse(response);
            }
            return serverTransaction;
        }
        catch (ParseException parseException) {
            throw new SipException("sendInviteOk()", (Throwable)parseException);
        }
    }

    public void sendInviteRequestTerminated(Request request, ServerTransaction serverTransaction) throws SipException {
        try {
            Response response = this.mMessageFactory.createResponse(487, request);
            Log.d(TAG, "send response: " + response);
            serverTransaction.sendResponse(response);
            return;
        }
        catch (ParseException parseException) {
            throw new SipException("sendInviteRequestTerminated()", (Throwable)parseException);
        }
    }

    public ClientTransaction sendKeepAlive(SipProfile sipProfile, String string2) throws SipException {
        try {
            Request request = this.createRequest("OPTIONS", sipProfile, string2);
            ClientTransaction clientTransaction = this.mSipProvider.getNewClientTransaction(request);
            clientTransaction.sendRequest();
            return clientTransaction;
        }
        catch (Exception exception) {
            throw new SipException("sendKeepAlive()", (Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClientTransaction sendRegister(SipProfile sipProfile, String string2, int n) throws SipException {
        try {
            Request request = this.createRequest("REGISTER", sipProfile, string2);
            if (n == 0) {
                request.addHeader((Header)this.createWildcardContactHeader());
            } else {
                request.addHeader((Header)this.createContactHeader(sipProfile));
            }
            request.addHeader((Header)this.mHeaderFactory.createExpiresHeader(n));
            ClientTransaction clientTransaction = this.mSipProvider.getNewClientTransaction(request);
            clientTransaction.sendRequest();
            return clientTransaction;
        }
        catch (ParseException parseException) {
            throw new SipException("sendRegister()", (Throwable)parseException);
        }
    }

    public ClientTransaction sendReinvite(Dialog dialog, String string2) throws SipException {
        try {
            Request request = dialog.createRequest("INVITE");
            request.setContent((Object)string2, this.mHeaderFactory.createContentTypeHeader("application", "sdp"));
            ClientTransaction clientTransaction = this.mSipProvider.getNewClientTransaction(request);
            Log.d(TAG, "send RE-INVITE: " + request);
            dialog.sendRequest(clientTransaction);
            return clientTransaction;
        }
        catch (ParseException parseException) {
            throw new SipException("sendReinvite()", (Throwable)parseException);
        }
    }

    public void sendResponse(RequestEvent requestEvent, int n) throws SipException {
        try {
            Response response = this.mMessageFactory.createResponse(n, requestEvent.getRequest());
            Log.d(TAG, "send response: " + response);
            this.getServerTransaction(requestEvent).sendResponse(response);
            return;
        }
        catch (ParseException parseException) {
            throw new SipException("sendResponse()", (Throwable)parseException);
        }
    }

    public ServerTransaction sendRinging(RequestEvent requestEvent, String string2) throws SipException {
        try {
            Request request = requestEvent.getRequest();
            ServerTransaction serverTransaction = this.getServerTransaction(requestEvent);
            Response response = this.mMessageFactory.createResponse(180, request);
            ToHeader toHeader = (ToHeader)response.getHeader("To");
            toHeader.setTag(string2);
            response.addHeader((Header)toHeader);
            Log.d(TAG, "send RINGING: " + response);
            serverTransaction.sendResponse(response);
            return serverTransaction;
        }
        catch (ParseException parseException) {
            throw new SipException("sendRinging()", (Throwable)parseException);
        }
    }
}

