/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.sip;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.sip.ISipService;
import android.net.sip.ISipSession;
import android.net.sip.ISipSessionListener;
import android.net.sip.SipManager;
import android.net.sip.SipProfile;
import android.net.sip.SipSessionAdapter;
import android.net.wifi.WifiManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.Log;
import com.android.server.sip.SipSessionGroup;
import com.android.server.sip.SipSessionListenerProxy;
import com.android.server.sip.SipWakeLock;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import javax.sip.SipException;

public final class SipService
extends ISipService.Stub {
    private static final boolean DEBUG = false;
    static final boolean DEBUGV = false;
    private static final boolean DEBUG_TIMER = false;
    private static final int EXPIRY_TIME = 3600;
    private static final int MIN_EXPIRY_TIME = 60;
    private static final int SHORT_EXPIRY_TIME = 10;
    static final String TAG = "SipService";
    private boolean mConnected;
    private ConnectivityReceiver mConnectivityReceiver;
    private Context mContext;
    private MyExecutor mExecutor;
    private String mLocalIp;
    private SipWakeLock mMyWakeLock;
    private String mNetworkType;
    private Map<String, ISipSession> mPendingSessions;
    private Map<String, SipSessionGroupExt> mSipGroups = new HashMap<String, SipSessionGroupExt>();
    private WakeupTimer mTimer;
    private boolean mWifiEnabled;
    private WifiManager.WifiLock mWifiLock;
    private boolean mWifiOnly;
    private WifiScanProcess mWifiScanProcess;
    private BroadcastReceiver mWifiStateReceiver;

    private SipService(Context context) {
        this.mPendingSessions = new HashMap<String, ISipSession>();
        this.mWifiStateReceiver = new BroadcastReceiver(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                if (!"android.net.wifi.WIFI_STATE_CHANGED".equals(intent.getAction())) {
                    return;
                }
                int n = intent.getIntExtra("wifi_state", 4);
                SipService sipService = SipService.this;
                synchronized (sipService) {
                    switch (n) {
                        case 3: {
                            SipService.access$102(SipService.this, true);
                            if (SipService.this.anyOpenedToReceiveCalls()) {
                                SipService.this.grabWifiLock();
                            }
                        }
                        default: {
                            break;
                        }
                        case 1: {
                            SipService.access$102(SipService.this, false);
                            SipService.this.releaseWifiLock();
                        }
                    }
                    return;
                }
            }
        };
        this.mContext = context;
        this.mConnectivityReceiver = new ConnectivityReceiver();
        this.mMyWakeLock = new SipWakeLock((PowerManager)context.getSystemService("power"));
        this.mTimer = new WakeupTimer(context);
        this.mWifiOnly = SipManager.isSipWifiOnly(context);
    }

    static /* synthetic */ boolean access$102(SipService sipService, boolean bl) {
        sipService.mWifiEnabled = bl;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addPendingSession(ISipSession iSipSession) {
        synchronized (this) {
            try {
                this.cleanUpPendingSessions();
                this.mPendingSessions.put(iSipSession.getCallId(), iSipSession);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "addPendingSession()", remoteException);
                return;
            }
            finally {
            }
        }
    }

    private boolean anyOpenedToReceiveCalls() {
        Iterator<SipSessionGroupExt> iterator = this.mSipGroups.values().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isOpenedToReceiveCalls()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean callingSelf(SipSessionGroupExt sipSessionGroupExt, SipSessionGroup.SipSessionImpl sipSessionImpl) {
        synchronized (this) {
            boolean bl;
            SipSessionGroupExt sipSessionGroupExt2;
            String string2 = sipSessionImpl.getCallId();
            Iterator<SipSessionGroupExt> iterator = this.mSipGroups.values().iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while ((sipSessionGroupExt2 = iterator.next()) == sipSessionGroupExt || !(bl = sipSessionGroupExt2.containsSession(string2)));
            return true;
        }
    }

    private void cleanUpPendingSessions() throws RemoteException {
        for (Map.Entry entry : this.mPendingSessions.entrySet().toArray(new Map.Entry[this.mPendingSessions.size()])) {
            if (((ISipSession)entry.getValue()).getState() == 3) continue;
            this.mPendingSessions.remove(entry.getKey());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private SipSessionGroupExt createGroup(SipProfile sipProfile) throws SipException {
        String string2 = sipProfile.getUriString();
        SipSessionGroupExt sipSessionGroupExt = this.mSipGroups.get(string2);
        if (sipSessionGroupExt == null) {
            sipSessionGroupExt = new SipSessionGroupExt(sipProfile, null, null);
            this.mSipGroups.put(string2, sipSessionGroupExt);
            this.notifyProfileAdded(sipProfile);
            return sipSessionGroupExt;
        } else {
            if (this.isCallerCreator(sipSessionGroupExt)) return sipSessionGroupExt;
            throw new SipException("only creator can access the profile");
        }
    }

    private SipSessionGroupExt createGroup(SipProfile sipProfile, PendingIntent pendingIntent, ISipSessionListener iSipSessionListener) throws SipException {
        String string2 = sipProfile.getUriString();
        SipSessionGroupExt sipSessionGroupExt = this.mSipGroups.get(string2);
        if (sipSessionGroupExt != null) {
            if (!this.isCallerCreator(sipSessionGroupExt)) {
                throw new SipException("only creator can access the profile");
            }
            sipSessionGroupExt.setIncomingCallPendingIntent(pendingIntent);
            sipSessionGroupExt.setListener(iSipSessionListener);
            return sipSessionGroupExt;
        }
        SipSessionGroupExt sipSessionGroupExt2 = new SipSessionGroupExt(sipProfile, pendingIntent, iSipSessionListener);
        this.mSipGroups.put(string2, sipSessionGroupExt2);
        this.notifyProfileAdded(sipProfile);
        return sipSessionGroupExt2;
    }

    private static Looper createLooper() {
        HandlerThread handlerThread = new HandlerThread("SipService.Executor");
        handlerThread.start();
        return handlerThread.getLooper();
    }

    private String determineLocalIp() {
        try {
            DatagramSocket datagramSocket = new DatagramSocket();
            datagramSocket.connect(InetAddress.getByName("192.168.1.1"), 80);
            String string2 = datagramSocket.getLocalAddress().getHostAddress();
            return string2;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private MyExecutor getExecutor() {
        if (this.mExecutor == null) {
            this.mExecutor = new MyExecutor();
        }
        return this.mExecutor;
    }

    private void grabWifiLock() {
        if (this.mWifiLock == null) {
            this.mWifiLock = ((WifiManager)this.mContext.getSystemService("wifi")).createWifiLock(1, TAG);
            this.mWifiLock.acquire();
            if (!this.mConnected) {
                this.startWifiScanner();
            }
        }
    }

    private boolean isCallerCreator(SipSessionGroupExt sipSessionGroupExt) {
        return sipSessionGroupExt.getLocalProfile().getCallingUid() == Binder.getCallingUid();
    }

    private boolean isCallerCreatorOrRadio(SipSessionGroupExt sipSessionGroupExt) {
        return this.isCallerRadio() || this.isCallerCreator(sipSessionGroupExt);
    }

    private boolean isCallerRadio() {
        return Binder.getCallingUid() == 1001;
    }

    private void notifyProfileAdded(SipProfile sipProfile) {
        Intent intent = new Intent("com.android.phone.SIP_ADD_PHONE");
        intent.putExtra("android:localSipUri", sipProfile.getUriString());
        this.mContext.sendBroadcast(intent);
    }

    private void notifyProfileRemoved(SipProfile sipProfile) {
        Intent intent = new Intent("com.android.phone.SIP_REMOVE_PHONE");
        intent.putExtra("android:localSipUri", sipProfile.getUriString());
        this.mContext.sendBroadcast(intent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onConnectivityChanged(String string2, boolean bl) {
        synchronized (this) {
            block15: {
                boolean bl2 = string2.equals(this.mNetworkType);
                if (bl2 || bl) {
                    boolean bl3;
                    block14: {
                        boolean bl4 = "WIFI".equalsIgnoreCase(this.mNetworkType);
                        bl3 = "WIFI".equalsIgnoreCase(string2);
                        if (bl3 && !bl || !bl4 || !bl2) {
                            // empty if block
                        }
                        if (!bl3 || bl) {
                            // empty if block
                        }
                        try {
                            boolean bl5 = this.mConnected;
                            this.mNetworkType = string2;
                            this.mConnected = bl;
                            if (bl5) {
                                this.mLocalIp = null;
                                Iterator<SipSessionGroupExt> iterator = this.mSipGroups.values().iterator();
                                while (iterator.hasNext()) {
                                    iterator.next().onConnectivityChanged(false);
                                }
                            }
                            if (!bl) break block14;
                            this.mLocalIp = this.determineLocalIp();
                            Iterator<SipSessionGroupExt> iterator = this.mSipGroups.values().iterator();
                            while (iterator.hasNext()) {
                                iterator.next().onConnectivityChanged(true);
                            }
                        }
                        catch (SipException sipException) {
                            Log.e(TAG, "onConnectivityChanged()", sipException);
                            break block15;
                        }
                        if (bl3 && this.mWifiLock != null) {
                            this.stopWifiScanner();
                        }
                        break block15;
                    }
                    this.mMyWakeLock.reset();
                    if (bl3 && this.mWifiLock != null) {
                        this.startWifiScanner();
                    }
                }
            }
            return;
        }
    }

    private void registerReceivers() {
        this.mContext.registerReceiver(this.mConnectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        this.mContext.registerReceiver(this.mWifiStateReceiver, new IntentFilter("android.net.wifi.WIFI_STATE_CHANGED"));
    }

    private void releaseWifiLock() {
        if (this.mWifiLock != null) {
            this.mWifiLock.release();
            this.mWifiLock = null;
            this.stopWifiScanner();
        }
    }

    public static void start(Context context) {
        if (SipManager.isApiSupported(context)) {
            ServiceManager.addService("sip", new SipService(context));
            context.sendBroadcast(new Intent("android.net.sip.SIP_SERVICE_UP"));
        }
    }

    private void startWifiScanner() {
        synchronized (this) {
            if (this.mWifiScanProcess == null) {
                this.mWifiScanProcess = new WifiScanProcess();
            }
            this.mWifiScanProcess.start();
            return;
        }
    }

    private void stopWifiScanner() {
        synchronized (this) {
            if (this.mWifiScanProcess != null) {
                this.mWifiScanProcess.stop();
            }
            return;
        }
    }

    private void unregisterReceivers() {
        this.mContext.unregisterReceiver(this.mConnectivityReceiver);
        this.mContext.unregisterReceiver(this.mWifiStateReceiver);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close(String string2) {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
            SipSessionGroupExt sipSessionGroupExt = this.mSipGroups.get(string2);
            if (sipSessionGroupExt != null) {
                if (!this.isCallerCreatorOrRadio(sipSessionGroupExt)) {
                    Log.w(TAG, "only creator or radio can close this profile");
                } else {
                    SipSessionGroupExt sipSessionGroupExt2 = this.mSipGroups.remove(string2);
                    this.notifyProfileRemoved(sipSessionGroupExt2.getLocalProfile());
                    sipSessionGroupExt2.close();
                    if (!this.anyOpenedToReceiveCalls()) {
                        this.releaseWifiLock();
                        this.mMyWakeLock.reset();
                    }
                    if (this.mSipGroups.isEmpty()) {
                        this.unregisterReceivers();
                    }
                }
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ISipSession createSession(SipProfile sipProfile, ISipSessionListener iSipSessionListener) {
        synchronized (this) {
            block5: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
                sipProfile.setCallingUid(Binder.getCallingUid());
                boolean bl = this.mConnected;
                if (bl) break block5;
                return null;
            }
            try {
                ISipSession iSipSession = this.createGroup(sipProfile).createSession(iSipSessionListener);
                return iSipSession;
            }
            catch (SipException sipException) {
                return null;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SipProfile[] getListOfProfiles() {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
            boolean bl = this.isCallerRadio();
            ArrayList<SipProfile> arrayList = new ArrayList<SipProfile>();
            Iterator<SipSessionGroupExt> iterator = this.mSipGroups.values().iterator();
            while (iterator.hasNext()) {
                SipSessionGroupExt sipSessionGroupExt = iterator.next();
                if (!bl && !this.isCallerCreator(sipSessionGroupExt)) continue;
                arrayList.add(sipSessionGroupExt.getLocalProfile());
            }
            return arrayList.toArray(new SipProfile[arrayList.size()]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ISipSession getPendingSession(String string2) {
        synchronized (this) {
            block6: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
                if (string2 != null) break block6;
                return null;
            }
            ISipSession iSipSession = this.mPendingSessions.get(string2);
            return iSipSession;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isOpened(String string2) {
        synchronized (this) {
            block6: {
                SipSessionGroupExt sipSessionGroupExt;
                block5: {
                    this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
                    sipSessionGroupExt = this.mSipGroups.get(string2);
                    if (sipSessionGroupExt != null) break block5;
                    return false;
                }
                if (!this.isCallerCreatorOrRadio(sipSessionGroupExt)) break block6;
                return true;
            }
            Log.w(TAG, "only creator or radio can query on the profile");
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isRegistered(String string2) {
        synchronized (this) {
            SipSessionGroupExt sipSessionGroupExt;
            block5: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
                sipSessionGroupExt = this.mSipGroups.get(string2);
                if (sipSessionGroupExt != null) break block5;
                return false;
            }
            if (this.isCallerCreatorOrRadio(sipSessionGroupExt)) {
                return sipSessionGroupExt.isRegistered();
            }
            Log.w(TAG, "only creator or radio can query on the profile");
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void open(SipProfile sipProfile) {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
            sipProfile.setCallingUid(Binder.getCallingUid());
            try {
                boolean bl = this.mSipGroups.isEmpty();
                this.createGroup(sipProfile);
                if (bl && !this.mSipGroups.isEmpty()) {
                    this.registerReceivers();
                }
                return;
            }
            catch (SipException sipException) {
                Log.e(TAG, "openToMakeCalls()", sipException);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void open3(SipProfile sipProfile, PendingIntent pendingIntent, ISipSessionListener iSipSessionListener) {
        synchronized (this) {
            block8: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
                sipProfile.setCallingUid(Binder.getCallingUid());
                if (pendingIntent == null) {
                    Log.w(TAG, "incomingCallPendingIntent cannot be null; the profile is not opened");
                } else {
                    try {
                        boolean bl = this.mSipGroups.isEmpty();
                        SipSessionGroupExt sipSessionGroupExt = this.createGroup(sipProfile, pendingIntent, iSipSessionListener);
                        if (bl && !this.mSipGroups.isEmpty()) {
                            this.registerReceivers();
                        }
                        if (!sipProfile.getAutoRegistration()) break block8;
                        sipSessionGroupExt.openToReceiveCalls();
                        if (this.mWifiEnabled) {
                            this.grabWifiLock();
                        }
                    }
                    catch (SipException sipException) {
                        Log.e(TAG, "openToReceiveCalls()", sipException);
                    }
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setRegistrationListener(String string2, ISipSessionListener iSipSessionListener) {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.USE_SIP", null);
            SipSessionGroupExt sipSessionGroupExt = this.mSipGroups.get(string2);
            if (sipSessionGroupExt != null) {
                if (this.isCallerCreator(sipSessionGroupExt)) {
                    sipSessionGroupExt.setListener(iSipSessionListener);
                } else {
                    Log.w(TAG, "only creator can set listener on the profile");
                }
            }
            return;
        }
    }

    private class AutoRegistrationProcess
    extends SipSessionAdapter
    implements Runnable {
        private int mBackoff = 1;
        private int mErrorCode;
        private String mErrorMessage;
        private long mExpiryTime;
        private KeepAliveProcess mKeepAliveProcess;
        private SipSessionListenerProxy mProxy = new SipSessionListenerProxy();
        private boolean mRegistered;
        private boolean mRunning = false;
        private SipSessionGroup.SipSessionImpl mSession;

        private AutoRegistrationProcess() {
        }

        private int backoffDuration() {
            int n = 10 * this.mBackoff;
            if (n > 3600) {
                return 3600;
            }
            this.mBackoff = 2 * this.mBackoff;
            return n;
        }

        private String getAction() {
            return this.toString();
        }

        private boolean isBehindNAT(String string2) {
            try {
                byte by;
                byte[] byArray = InetAddress.getByName(string2).getAddress();
                if (byArray[0] == 10 || (0xFF & byArray[0]) == 172 && (0xF0 & byArray[1]) == 16 || (0xFF & byArray[0]) == 192 && ((by = byArray[1]) & 0xFF) == 168) {
                    return true;
                }
            }
            catch (UnknownHostException unknownHostException) {
                Log.e(SipService.TAG, "isBehindAT()" + string2, unknownHostException);
            }
            return false;
        }

        private boolean notCurrentSession(ISipSession iSipSession) {
            if (iSipSession != this.mSession) {
                ((SipSessionGroup.SipSessionImpl)iSipSession).setListener(null);
                SipService.this.mMyWakeLock.release(iSipSession);
                return true;
            }
            return !this.mRunning;
        }

        private void restart(int n) {
            SipService.this.mTimer.cancel(this);
            SipService.this.mTimer.set(n * 1000, this);
        }

        private void restartLater() {
            this.mRegistered = false;
            this.restart(this.backoffDuration());
            if (this.mKeepAliveProcess != null) {
                this.mKeepAliveProcess.stop();
                this.mKeepAliveProcess = null;
            }
        }

        public boolean isRegistered() {
            return this.mRegistered;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onRegistering(ISipSession iSipSession) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(iSipSession)) {
                    return;
                }
                this.mRegistered = false;
                this.mProxy.onRegistering(iSipSession);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onRegistrationDone(ISipSession iSipSession, int n) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(iSipSession)) {
                    return;
                }
                this.mProxy.onRegistrationDone(iSipSession, n);
                if (n > 0) {
                    this.mSession.clearReRegisterRequired();
                    this.mExpiryTime = SystemClock.elapsedRealtime() + (long)(n * 1000);
                    if (!this.mRegistered) {
                        this.mRegistered = true;
                        int n2 = n - 60;
                        if (n2 < 60) {
                            n2 = 60;
                        }
                        this.restart(n2);
                        if (this.isBehindNAT(SipService.this.mLocalIp) || this.mSession.getLocalProfile().getSendKeepAlive()) {
                            if (this.mKeepAliveProcess == null) {
                                this.mKeepAliveProcess = new KeepAliveProcess(this.mSession);
                            }
                            this.mKeepAliveProcess.start();
                        }
                    }
                    SipService.this.mMyWakeLock.release(iSipSession);
                } else {
                    this.mRegistered = false;
                    this.mExpiryTime = -1L;
                    this.run();
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onRegistrationFailed(ISipSession iSipSession, int n, String string2) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(iSipSession)) {
                    return;
                }
                switch (n) {
                    default: {
                        this.restartLater();
                        break;
                    }
                    case -12: 
                    case -8: {
                        this.stop();
                    }
                }
                this.mErrorCode = n;
                this.mErrorMessage = string2;
                this.mProxy.onRegistrationFailed(iSipSession, n, string2);
                SipService.this.mMyWakeLock.release(iSipSession);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onRegistrationTimeout(ISipSession iSipSession) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (this.notCurrentSession(iSipSession)) {
                    return;
                }
                this.mErrorCode = -5;
                this.mProxy.onRegistrationTimeout(iSipSession);
                this.restartLater();
                SipService.this.mMyWakeLock.release(iSipSession);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (!this.mRunning) {
                    return;
                }
                this.mErrorCode = 0;
                this.mErrorMessage = null;
                if (SipService.this.mConnected) {
                    SipService.this.mMyWakeLock.acquire(this.mSession);
                    this.mSession.register(3600);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setListener(ISipSessionListener iSipSessionListener) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                block11: {
                    int n;
                    block12: {
                        block13: {
                            this.mProxy.setListener(iSipSessionListener);
                            try {
                                n = this.mSession == null ? 0 : this.mSession.getState();
                                if (n == 1 || n == 2) {
                                    this.mProxy.onRegistering(this.mSession);
                                    break block11;
                                }
                                if (this.mRegistered) {
                                    int n2 = (int)(this.mExpiryTime - SystemClock.elapsedRealtime());
                                    this.mProxy.onRegistrationDone(this.mSession, n2);
                                }
                                if (this.mErrorCode == 0) break block12;
                                if (this.mErrorCode != -5) break block13;
                                this.mProxy.onRegistrationTimeout(this.mSession);
                                break block11;
                            }
                            catch (Throwable throwable) {
                                Log.w(SipService.TAG, "setListener(): " + throwable);
                            }
                            break block11;
                        }
                        this.mProxy.onRegistrationFailed(this.mSession, this.mErrorCode, this.mErrorMessage);
                        break block11;
                    }
                    if (!SipService.this.mConnected) {
                        this.mProxy.onRegistrationFailed(this.mSession, -10, "no data connection");
                    } else if (!this.mRunning) {
                        this.mProxy.onRegistrationFailed(this.mSession, -4, "registration not running");
                    } else {
                        this.mProxy.onRegistrationFailed(this.mSession, -9, String.valueOf(n));
                    }
                }
                return;
            }
        }

        public void start(SipSessionGroup sipSessionGroup) {
            block3: {
                block2: {
                    if (this.mRunning) break block2;
                    this.mRunning = true;
                    this.mBackoff = 1;
                    this.mSession = (SipSessionGroup.SipSessionImpl)sipSessionGroup.createSession(this);
                    if (this.mSession != null) break block3;
                }
                return;
            }
            SipService.this.mMyWakeLock.acquire(this.mSession);
            this.mSession.unregister();
        }

        public void stop() {
            if (!this.mRunning) {
                return;
            }
            this.mRunning = false;
            SipService.this.mMyWakeLock.release(this.mSession);
            if (this.mSession != null) {
                this.mSession.setListener(null);
                if (SipService.this.mConnected && this.mRegistered) {
                    this.mSession.unregister();
                }
            }
            SipService.this.mTimer.cancel(this);
            if (this.mKeepAliveProcess != null) {
                this.mKeepAliveProcess.stop();
                this.mKeepAliveProcess = null;
            }
            this.mRegistered = false;
            this.setListener(this.mProxy.getListener());
        }
    }

    private class ConnectivityReceiver
    extends BroadcastReceiver {
        private MyTimerTask mTask;
        private Timer mTimer = new Timer();

        private ConnectivityReceiver() {
        }

        static /* synthetic */ MyTimerTask access$1902(ConnectivityReceiver connectivityReceiver, MyTimerTask myTimerTask) {
            connectivityReceiver.mTask = myTimerTask;
            return myTimerTask;
        }

        private NetworkInfo getActiveNetworkInfo() {
            return ((ConnectivityManager)SipService.this.mContext.getSystemService("connectivity")).getActiveNetworkInfo();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void onChanged(String string2, boolean bl) {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (bl) {
                    if (this.mTask != null) {
                        this.mTask.cancel();
                        SipService.this.mMyWakeLock.release(this.mTask);
                    }
                    this.mTask = new MyTimerTask(string2, bl);
                    this.mTimer.schedule((TimerTask)this.mTask, 2000L);
                    SipService.this.mMyWakeLock.acquire(this.mTask);
                } else {
                    if (this.mTask != null && this.mTask.mNetworkType.equals(string2)) {
                        this.mTask.cancel();
                        SipService.this.mMyWakeLock.release(this.mTask);
                    }
                    SipService.this.onConnectivityChanged(string2, false);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void onReceiveInternal(Context context, Intent intent) {
            String string2;
            block5: {
                block4: {
                    Bundle bundle;
                    if (!intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE") || (bundle = intent.getExtras()) == null) break block4;
                    NetworkInfo networkInfo = (NetworkInfo)bundle.get("networkInfo");
                    string2 = networkInfo.getTypeName();
                    NetworkInfo.State state = networkInfo.getState();
                    if (SipService.this.mWifiOnly && networkInfo.getType() != 1) break block4;
                    NetworkInfo networkInfo2 = this.getActiveNetworkInfo();
                    if (state == NetworkInfo.State.CONNECTED && networkInfo2 != null && networkInfo2.getType() != networkInfo.getType()) break block4;
                    if (state == NetworkInfo.State.CONNECTED) {
                        this.onChanged(string2, true);
                        return;
                    }
                    if (state == NetworkInfo.State.DISCONNECTED) break block5;
                }
                return;
            }
            this.onChanged(string2, false);
        }

        @Override
        public void onReceive(final Context context, final Intent intent) {
            SipService.this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    ConnectivityReceiver.this.onReceiveInternal(context, intent);
                }
            });
        }

        private class MyTimerTask
        extends TimerTask {
            private boolean mConnected;
            private String mNetworkType;

            public MyTimerTask(String string2, boolean bl) {
                this.mNetworkType = string2;
                this.mConnected = bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void realRun() {
                SipService sipService = SipService.this;
                synchronized (sipService) {
                    if (ConnectivityReceiver.this.mTask == this) {
                        ConnectivityReceiver.access$1902(ConnectivityReceiver.this, null);
                        SipService.this.onConnectivityChanged(this.mNetworkType, this.mConnected);
                        SipService.this.mMyWakeLock.release(this);
                        return;
                    }
                    StringBuilder stringBuilder = new StringBuilder().append("  unexpected task: ").append(this.mNetworkType);
                    String string2 = this.mConnected ? " CONNECTED" : "DISCONNECTED";
                    Log.w(SipService.TAG, stringBuilder.append(string2).toString());
                    SipService.this.mMyWakeLock.release(this);
                    return;
                }
            }

            @Override
            public void run() {
                SipService.this.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        MyTimerTask.this.realRun();
                    }
                });
            }
        }
    }

    private class KeepAliveProcess
    implements Runnable {
        private static final int INTERVAL = 10;
        private static final String TAG = "\\KEEPALIVE/";
        private boolean mRunning = false;
        private SipSessionGroup.SipSessionImpl mSession;

        public KeepAliveProcess(SipSessionGroup.SipSessionImpl sipSessionImpl) {
            this.mSession = sipSessionImpl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            SipService sipService = SipService.this;
            synchronized (sipService) {
                if (!this.mRunning) {
                    return;
                }
                SipSessionGroup.SipSessionImpl sipSessionImpl = this.mSession.duplicate();
                try {
                    sipSessionImpl.sendKeepAlive();
                    if (sipSessionImpl.isReRegisterRequired()) {
                        SipService.this.mMyWakeLock.acquire(this.mSession);
                        this.mSession.register(3600);
                    }
                }
                catch (Throwable throwable) {
                    Log.w(TAG, "keepalive error: " + throwable);
                }
                return;
            }
        }

        public void start() {
            if (this.mRunning) {
                return;
            }
            this.mRunning = true;
            SipService.this.mTimer.set(10000, this);
        }

        public void stop() {
            this.mRunning = false;
            this.mSession = null;
            SipService.this.mTimer.cancel(this);
        }
    }

    private static class MyEvent {
        Runnable mCallback;
        long mLastTriggerTime;
        int mMaxPeriod;
        int mPeriod;
        long mTriggerTime;

        MyEvent(int n, Runnable runnable, long l) {
            this.mMaxPeriod = n;
            this.mPeriod = n;
            this.mCallback = runnable;
            this.mLastTriggerTime = l;
        }

        private String toString(Object object) {
            String string2 = object.toString();
            int n = string2.indexOf("$");
            if (n > 0) {
                string2 = string2.substring(n + 1);
            }
            return string2;
        }

        public String toString() {
            String string2 = super.toString();
            String string3 = string2.substring(string2.indexOf("@"));
            return string3 + ":" + this.mPeriod / 1000 + ":" + this.mMaxPeriod / 1000 + ":" + this.toString(this.mCallback);
        }
    }

    private static class MyEventComparator
    implements Comparator<MyEvent> {
        private MyEventComparator() {
        }

        @Override
        public int compare(MyEvent myEvent, MyEvent myEvent2) {
            if (myEvent == myEvent2) {
                return 0;
            }
            int n = myEvent.mMaxPeriod - myEvent2.mMaxPeriod;
            if (n == 0) {
                n = -1;
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }
    }

    private class MyExecutor
    extends Handler {
        MyExecutor() {
            super(SipService.createLooper());
        }

        /*
         * Unable to fully structure code
         */
        private void executeInternal(Runnable var1_1) {
            try {
                var1_1.run();
            }
            catch (Throwable var3_3) {
                try {
                    Log.e("SipService", "run task: " + var1_1, var3_3);
                }
                catch (Throwable var2_4) {
                    SipService.access$700(SipService.this).release(var1_1);
                    throw var2_4;
                }
                var5_2 = SipService.access$700(SipService.this);
                ** continue;
            }
            var5_2 = SipService.access$700(SipService.this);
lbl4:
            // 2 sources

            while (true) {
                var5_2.release(var1_1);
                return;
            }
        }

        void execute(Runnable runnable) {
            SipService.this.mMyWakeLock.acquire(runnable);
            Message.obtain(this, 0, runnable).sendToTarget();
        }

        @Override
        public void handleMessage(Message message) {
            if (message.obj instanceof Runnable) {
                this.executeInternal((Runnable)message.obj);
                return;
            }
            Log.w(SipService.TAG, "can't handle msg: " + message);
        }
    }

    private class SipSessionGroupExt
    extends SipSessionAdapter {
        private AutoRegistrationProcess mAutoRegistration;
        private PendingIntent mIncomingCallPendingIntent;
        private boolean mOpenedToReceiveCalls;
        private SipSessionGroup mSipGroup;

        public SipSessionGroupExt(SipProfile sipProfile, PendingIntent pendingIntent, ISipSessionListener iSipSessionListener) throws SipException {
            this.mAutoRegistration = new AutoRegistrationProcess();
            String string2 = sipProfile.getPassword();
            SipProfile sipProfile2 = this.duplicate(sipProfile);
            this.mSipGroup = this.createSipSessionGroup(SipService.this.mLocalIp, sipProfile2, string2);
            this.mIncomingCallPendingIntent = pendingIntent;
            this.mAutoRegistration.setListener(iSipSessionListener);
        }

        private SipSessionGroup createSipSessionGroup(String string2, SipProfile sipProfile, String string3) throws SipException {
            try {
                SipSessionGroup sipSessionGroup = new SipSessionGroup(string2, sipProfile, string3, SipService.this.mMyWakeLock);
                return sipSessionGroup;
            }
            catch (IOException iOException) {
                Log.w(SipService.TAG, "createSipSessionGroup(): network disconnected?");
                if (string2 != null) {
                    return this.createSipSessionGroup(null, sipProfile, string3);
                }
                Log.wtf(SipService.TAG, "impossible! recursive!");
                throw new RuntimeException("createSipSessionGroup");
            }
        }

        private SipProfile duplicate(SipProfile sipProfile) {
            try {
                SipProfile sipProfile2 = new SipProfile.Builder(sipProfile).setPassword("*").build();
                return sipProfile2;
            }
            catch (Exception exception) {
                Log.wtf(SipService.TAG, "duplicate()", exception);
                throw new RuntimeException("duplicate profile", exception);
            }
        }

        private String getUri() {
            return this.mSipGroup.getLocalProfileUri();
        }

        private void resetGroup(String string2) throws SipException {
            try {
                this.mSipGroup.reset(string2);
                return;
            }
            catch (IOException iOException) {
                Log.w(SipService.TAG, "resetGroup(): network disconnected?");
                if (string2 != null) {
                    this.resetGroup(null);
                    return;
                }
                Log.wtf(SipService.TAG, "impossible!");
                throw new RuntimeException("resetGroup");
            }
        }

        public void close() {
            this.mOpenedToReceiveCalls = false;
            this.mSipGroup.close();
            this.mAutoRegistration.stop();
        }

        public boolean containsSession(String string2) {
            return this.mSipGroup.containsSession(string2);
        }

        public ISipSession createSession(ISipSessionListener iSipSessionListener) {
            return this.mSipGroup.createSession(iSipSessionListener);
        }

        public SipProfile getLocalProfile() {
            return this.mSipGroup.getLocalProfile();
        }

        public boolean isOpenedToReceiveCalls() {
            return this.mOpenedToReceiveCalls;
        }

        public boolean isRegistered() {
            return this.mAutoRegistration.isRegistered();
        }

        public void onConnectivityChanged(boolean bl) throws SipException {
            this.mSipGroup.onConnectivityChanged();
            if (bl) {
                this.resetGroup(SipService.this.mLocalIp);
                if (this.mOpenedToReceiveCalls) {
                    this.openToReceiveCalls();
                }
                return;
            }
            this.mSipGroup.close();
            this.mAutoRegistration.stop();
        }

        @Override
        public void onError(ISipSession iSipSession, int n, String string2) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onRinging(ISipSession iSipSession, SipProfile sipProfile, String string2) {
            SipSessionGroup.SipSessionImpl sipSessionImpl = (SipSessionGroup.SipSessionImpl)iSipSession;
            SipService sipService = SipService.this;
            synchronized (sipService) {
                try {
                    if (!this.isRegistered() || SipService.this.callingSelf(this, sipSessionImpl)) {
                        sipSessionImpl.endCall();
                        return;
                    }
                    SipService.this.addPendingSession(sipSessionImpl);
                    Intent intent = SipManager.createIncomingCallBroadcast((String)sipSessionImpl.getCallId(), (String)string2);
                    this.mIncomingCallPendingIntent.send(SipService.this.mContext, 101, intent);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w(SipService.TAG, "pendingIntent is canceled, drop incoming call");
                    sipSessionImpl.endCall();
                }
                return;
            }
        }

        public void openToReceiveCalls() throws SipException {
            this.mOpenedToReceiveCalls = true;
            if (SipService.this.mConnected) {
                this.mSipGroup.openToReceiveCalls(this);
                this.mAutoRegistration.start(this.mSipGroup);
            }
        }

        public void setIncomingCallPendingIntent(PendingIntent pendingIntent) {
            this.mIncomingCallPendingIntent = pendingIntent;
        }

        public void setListener(ISipSessionListener iSipSessionListener) {
            this.mAutoRegistration.setListener(iSipSessionListener);
        }
    }

    class WakeupTimer
    extends BroadcastReceiver {
        private static final String TAG = "_SIP.WkTimer_";
        private static final String TRIGGER_TIME = "TriggerTime";
        private AlarmManager mAlarmManager;
        private Context mContext;
        private TreeSet<MyEvent> mEventQueue = new TreeSet<MyEvent>(new MyEventComparator());
        private PendingIntent mPendingIntent;

        public WakeupTimer(Context context) {
            this.mContext = context;
            this.mAlarmManager = (AlarmManager)context.getSystemService("alarm");
            context.registerReceiver(this, new IntentFilter(this.getAction()));
        }

        private void cancelAlarm() {
            this.mAlarmManager.cancel(this.mPendingIntent);
            this.mPendingIntent = null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void execute(long l) {
            synchronized (this) {
                block7: {
                    boolean bl;
                    if (this.stopped() || (bl = this.mEventQueue.isEmpty())) break block7;
                    Iterator<MyEvent> iterator = this.mEventQueue.iterator();
                    while (true) {
                        MyEvent myEvent;
                        block9: {
                            block8: {
                                if (!iterator.hasNext()) break block8;
                                myEvent = iterator.next();
                                if (myEvent.mTriggerTime == l) break block9;
                            }
                            this.scheduleNext();
                            break;
                        }
                        myEvent.mLastTriggerTime = myEvent.mTriggerTime;
                        myEvent.mTriggerTime += (long)myEvent.mPeriod;
                        SipService.this.getExecutor().execute(myEvent.mCallback);
                    }
                }
                return;
            }
        }

        private String getAction() {
            return this.toString();
        }

        /*
         * Enabled aggressive block sorting
         */
        private void insertEvent(MyEvent myEvent) {
            long l = SystemClock.elapsedRealtime();
            if (this.mEventQueue.isEmpty()) {
                myEvent.mTriggerTime = l + (long)myEvent.mPeriod;
                this.mEventQueue.add(myEvent);
                return;
            }
            MyEvent myEvent2 = this.mEventQueue.first();
            int n = myEvent2.mPeriod;
            if (n <= myEvent.mMaxPeriod) {
                myEvent.mPeriod = n * (myEvent.mMaxPeriod / n);
                int n2 = n * ((myEvent.mMaxPeriod - (int)(myEvent2.mTriggerTime - l)) / n);
                myEvent.mTriggerTime = myEvent2.mTriggerTime + (long)n2;
                this.mEventQueue.add(myEvent);
                return;
            }
            long l2 = l + (long)myEvent.mPeriod;
            if (myEvent2.mTriggerTime < l2) {
                myEvent.mTriggerTime = myEvent2.mTriggerTime;
                myEvent.mLastTriggerTime -= (long)myEvent.mPeriod;
            } else {
                myEvent.mTriggerTime = l2;
            }
            this.mEventQueue.add(myEvent);
            this.recalculatePeriods();
        }

        /*
         * Enabled aggressive block sorting
         */
        private void printQueue() {
            int n = 0;
            for (MyEvent myEvent : this.mEventQueue) {
                Log.d(TAG, "     " + myEvent + ": scheduled at " + this.showTime(myEvent.mTriggerTime) + ": last at " + this.showTime(myEvent.mLastTriggerTime));
                if (++n < 5) continue;
            }
            if (this.mEventQueue.size() > n) {
                Log.d(TAG, "     .....");
                return;
            } else {
                if (n != 0) return;
                Log.d(TAG, "     <empty>");
                return;
            }
        }

        private void recalculatePeriods() {
            if (this.mEventQueue.isEmpty()) {
                return;
            }
            MyEvent myEvent = this.mEventQueue.first();
            int n = myEvent.mMaxPeriod;
            long l = myEvent.mTriggerTime;
            for (MyEvent myEvent2 : this.mEventQueue) {
                myEvent2.mPeriod = n * (myEvent2.mMaxPeriod / n);
                myEvent2.mTriggerTime = l + (long)(n * ((int)(myEvent2.mLastTriggerTime + (long)myEvent2.mMaxPeriod - l) / n));
            }
            TreeSet<MyEvent> treeSet = new TreeSet<MyEvent>(this.mEventQueue.comparator());
            treeSet.addAll(this.mEventQueue);
            this.mEventQueue.clear();
            this.mEventQueue = treeSet;
        }

        private void scheduleNext() {
            PendingIntent pendingIntent;
            if (this.stopped() || this.mEventQueue.isEmpty()) {
                return;
            }
            if (this.mPendingIntent != null) {
                throw new RuntimeException("pendingIntent is not null!");
            }
            MyEvent myEvent = this.mEventQueue.first();
            Intent intent = new Intent(this.getAction());
            intent.putExtra(TRIGGER_TIME, myEvent.mTriggerTime);
            this.mPendingIntent = pendingIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0x8000000);
            this.mAlarmManager.set(2, myEvent.mTriggerTime, pendingIntent);
        }

        private String showTime(long l) {
            int n = (int)(l % 1000L);
            int n2 = (int)(l / 1000L);
            int n3 = n2 / 60;
            int n4 = n2 % 60;
            Object[] objectArray = new Object[]{n3, n4, n};
            return String.format("%d.%d.%d", objectArray);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean stopped() {
            synchronized (this) {
                if (this.mEventQueue != null) return false;
                Log.w(TAG, "Timer stopped");
                return true;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void cancel(Runnable runnable) {
            synchronized (this) {
                boolean bl;
                if (!this.stopped() && !(bl = this.mEventQueue.isEmpty())) {
                    MyEvent myEvent = this.mEventQueue.first();
                    Iterator<MyEvent> iterator = this.mEventQueue.iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next().mCallback != runnable) continue;
                        iterator.remove();
                    }
                    if (this.mEventQueue.isEmpty()) {
                        this.cancelAlarm();
                    } else if (this.mEventQueue.first() != myEvent) {
                        this.cancelAlarm();
                        MyEvent myEvent2 = this.mEventQueue.first();
                        myEvent2.mPeriod = myEvent2.mMaxPeriod;
                        myEvent2.mTriggerTime = myEvent2.mLastTriggerTime + (long)myEvent2.mPeriod;
                        this.recalculatePeriods();
                        this.scheduleNext();
                    }
                }
                return;
            }
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String string2 = intent.getAction();
            if (this.getAction().equals(string2) && intent.getExtras().containsKey(TRIGGER_TIME)) {
                this.mPendingIntent = null;
                this.execute(intent.getLongExtra(TRIGGER_TIME, -1L));
                return;
            }
            Log.d(TAG, "unrecognized intent: " + intent);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void set(int n, Runnable runnable) {
            synchronized (this) {
                block8: {
                    boolean bl = this.stopped();
                    if (!bl) break block8;
                    return;
                }
                MyEvent myEvent = new MyEvent(n, runnable, SystemClock.elapsedRealtime());
                this.insertEvent(myEvent);
                if (this.mEventQueue.first() == myEvent) {
                    if (this.mEventQueue.size() > 1) {
                        this.cancelAlarm();
                    }
                    this.scheduleNext();
                }
                long cfr_ignored_0 = myEvent.mTriggerTime;
                return;
            }
        }

        public void stop() {
            synchronized (this) {
                this.mContext.unregisterReceiver(this);
                if (this.mPendingIntent != null) {
                    this.mAlarmManager.cancel(this.mPendingIntent);
                    this.mPendingIntent = null;
                }
                this.mEventQueue.clear();
                this.mEventQueue = null;
                return;
            }
        }
    }

    private class WifiScanProcess
    implements Runnable {
        private static final int INTERVAL = 60;
        private static final String TAG = "\\WIFI_SCAN/";
        private boolean mRunning = false;
        private WifiManager mWifiManager;

        WifiScanProcess() {
            this.mWifiManager = (WifiManager)SipService.this.mContext.getSystemService("wifi");
        }

        @Override
        public void run() {
            this.mWifiManager.startScanActive();
        }

        public void start() {
            if (this.mRunning) {
                return;
            }
            this.mRunning = true;
            SipService.this.mTimer.set(60000, this);
        }

        public void stop() {
            this.mRunning = false;
            SipService.this.mTimer.cancel(this);
        }
    }
}

