/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.sip;

import android.net.sip.ISipSession;
import android.net.sip.ISipSessionListener;
import android.net.sip.SipProfile;
import android.net.sip.SipSession;
import android.text.TextUtils;
import android.util.Log;
import com.android.server.sip.SipHelper;
import com.android.server.sip.SipSessionListenerProxy;
import com.android.server.sip.SipWakeLock;
import gov.nist.javax.sip.clientauthutils.AccountManager;
import gov.nist.javax.sip.clientauthutils.UserCredentials;
import gov.nist.javax.sip.header.ProxyAuthenticate;
import gov.nist.javax.sip.header.WWWAuthenticate;
import gov.nist.javax.sip.message.SIPMessage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramSocket;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ObjectInUseException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.Transaction;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;

class SipSessionGroup
implements SipListener {
    private static final String ANONYMOUS = "anonymous";
    private static final int CANCEL_CALL_TIMER = 3;
    private static final EventObject CONTINUE_CALL;
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_PING = false;
    private static final EventObject DEREGISTER;
    private static final EventObject END_CALL;
    private static final int EXPIRY_TIME = 3600;
    private static final EventObject HOLD_CALL;
    private static final String TAG = "SipSession";
    private static final String THREAD_POOL_SIZE = "1";
    private static final long WAKE_LOCK_HOLDING_TIME = 500L;
    private SipSessionImpl mCallReceiverSession;
    private String mLocalIp;
    private final SipProfile mLocalProfile;
    private final String mPassword;
    private Map<String, SipSessionImpl> mSessionMap = new HashMap<String, SipSessionImpl>();
    private SipHelper mSipHelper;
    private SipStack mSipStack;
    private SipWakeLock mWakeLock;

    static {
        DEREGISTER = new EventObject("Deregister");
        END_CALL = new EventObject("End call");
        HOLD_CALL = new EventObject("Hold call");
        CONTINUE_CALL = new EventObject("Continue call");
    }

    public SipSessionGroup(String string2, SipProfile sipProfile, String string3, SipWakeLock sipWakeLock) throws SipException, IOException {
        this.mLocalProfile = sipProfile;
        this.mPassword = string3;
        this.mWakeLock = sipWakeLock;
        this.reset(string2);
    }

    private void addSipSession(SipSessionImpl sipSessionImpl) {
        synchronized (this) {
            this.removeSipSession(sipSessionImpl);
            String string2 = sipSessionImpl.getCallId();
            this.mSessionMap.put(string2, sipSessionImpl);
            if (SipSessionGroup.isLoggable(sipSessionImpl)) {
                Log.d(TAG, "+++  add a session with key:  '" + string2 + "'");
                for (String string3 : this.mSessionMap.keySet()) {
                    Log.d(TAG, "  " + string3 + ": " + this.mSessionMap.get(string3));
                }
            }
            return;
        }
    }

    private static int allocateLocalPort() throws SipException {
        try {
            DatagramSocket datagramSocket = new DatagramSocket();
            int n = datagramSocket.getLocalPort();
            datagramSocket.close();
            return n;
        }
        catch (IOException iOException) {
            throw new SipException("allocateLocalPort()", (Throwable)iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SipProfile createPeerProfile(Request request) throws SipException {
        String string2;
        SipURI sipURI;
        Address address;
        block5: {
            address = ((FromHeader)request.getHeader("From")).getAddress();
            sipURI = (SipURI)address.getURI();
            string2 = sipURI.getUser();
            if (string2 != null) break block5;
            string2 = ANONYMOUS;
        }
        int n = sipURI.getPort();
        SipProfile.Builder builder = new SipProfile.Builder(string2, sipURI.getHost()).setDisplayName(address.getDisplayName());
        if (n <= 0) return builder.build();
        try {
            builder.setPort(n);
            return builder.build();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SipException("createPeerProfile()", (Throwable)illegalArgumentException);
        }
        catch (ParseException parseException) {
            throw new SipException("createPeerProfile()", (Throwable)parseException);
        }
    }

    private static boolean expectResponse(int n, String string2, EventObject eventObject) {
        Response response;
        if (eventObject instanceof ResponseEvent && (response = ((ResponseEvent)eventObject).getResponse()).getStatusCode() == n) {
            return string2.equalsIgnoreCase(SipSessionGroup.getCseqMethod((Message)response));
        }
        return false;
    }

    private static boolean expectResponse(String string2, EventObject eventObject) {
        if (eventObject instanceof ResponseEvent) {
            return string2.equalsIgnoreCase(SipSessionGroup.getCseqMethod((Message)((ResponseEvent)eventObject).getResponse()));
        }
        return false;
    }

    private String extractContent(Message message) {
        byte[] byArray = message.getRawContent();
        if (byArray != null) {
            try {
                if (message instanceof SIPMessage) {
                    return ((SIPMessage)message).getMessageContent();
                }
                String string2 = new String(byArray, "UTF-8");
                return string2;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String getCseqMethod(Message message) {
        return ((CSeqHeader)message.getHeader("CSeq")).getMethod();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SipSessionImpl getSipSession(EventObject eventObject) {
        synchronized (this) {
            String string2 = SipHelper.getCallId(eventObject);
            SipSessionImpl sipSessionImpl = this.mSessionMap.get(string2);
            if (sipSessionImpl != null && SipSessionGroup.isLoggable(sipSessionImpl)) {
                Log.d(TAG, "session key from event: " + string2);
                Log.d(TAG, "active sessions:");
                for (String string3 : this.mSessionMap.keySet()) {
                    Log.d(TAG, " ..." + string3 + ": " + this.mSessionMap.get(string3));
                }
            }
            if (sipSessionImpl == null) return this.mCallReceiverSession;
            return sipSessionImpl;
        }
    }

    private String getStackName() {
        return "stack" + System.currentTimeMillis();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isLoggable(SipSessionImpl sipSessionImpl) {
        if (sipSessionImpl == null) return true;
        switch (sipSessionImpl.mState) {
            default: {
                return true;
            }
            case 9: 
        }
        return false;
    }

    private static boolean isLoggable(SipSessionImpl sipSessionImpl, EventObject eventObject) {
        if (!SipSessionGroup.isLoggable(sipSessionImpl)) {
            return false;
        }
        if (eventObject == null) {
            return false;
        }
        if (eventObject instanceof OptionsCommand) {
            return false;
        }
        if (eventObject instanceof ResponseEvent) {
            return !"OPTIONS".equals(((ResponseEvent)eventObject).getResponse().getHeader("CSeq"));
        }
        return eventObject instanceof RequestEvent;
    }

    private static boolean isLoggable(EventObject eventObject) {
        return SipSessionGroup.isLoggable(null, eventObject);
    }

    private static boolean isRequestEvent(String string2, EventObject eventObject) {
        try {
            if (eventObject instanceof RequestEvent) {
                boolean bl = string2.equals(((RequestEvent)eventObject).getRequest().getMethod());
                return bl;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static String log(EventObject eventObject) {
        if (eventObject instanceof RequestEvent) {
            return ((RequestEvent)eventObject).getRequest().toString();
        }
        if (eventObject instanceof ResponseEvent) {
            return ((ResponseEvent)eventObject).getResponse().toString();
        }
        return eventObject.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void process(EventObject eventObject) {
        synchronized (this) {
            SipSessionImpl sipSessionImpl = this.getSipSession(eventObject);
            try {
                boolean bl = SipSessionGroup.isLoggable(sipSessionImpl, eventObject);
                boolean bl2 = sipSessionImpl != null && sipSessionImpl.process(eventObject);
                if (bl && bl2) {
                    Log.d(TAG, "new state after: " + SipSession.State.toString(sipSessionImpl.mState));
                }
            }
            catch (Throwable throwable) {
                Log.w(TAG, "event process error: " + eventObject, throwable);
                sipSessionImpl.onError(throwable);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeSipSession(SipSessionImpl sipSessionImpl) {
        synchronized (this) {
            SipSessionImpl sipSessionImpl2 = this.mCallReceiverSession;
            if (sipSessionImpl != sipSessionImpl2) {
                String string2 = sipSessionImpl.getCallId();
                SipSessionImpl sipSessionImpl3 = this.mSessionMap.remove(string2);
                if (sipSessionImpl3 != null && sipSessionImpl3 != sipSessionImpl) {
                    Log.w(TAG, "session " + sipSessionImpl + " is not associated with key '" + string2 + "'");
                    this.mSessionMap.put(string2, sipSessionImpl3);
                    for (Map.Entry<String, SipSessionImpl> entry : this.mSessionMap.entrySet()) {
                        if (entry.getValue() != sipSessionImpl3) continue;
                        string2 = entry.getKey();
                        this.mSessionMap.remove(string2);
                    }
                }
                if (sipSessionImpl3 != null && SipSessionGroup.isLoggable(sipSessionImpl3)) {
                    Log.d(TAG, "remove session " + sipSessionImpl + " @key '" + string2 + "'");
                    for (String string3 : this.mSessionMap.keySet()) {
                        Log.d(TAG, "  " + string3 + ": " + this.mSessionMap.get(string3));
                    }
                }
            }
            return;
        }
    }

    public void close() {
        synchronized (this) {
            Log.d(TAG, " close stack for " + this.mLocalProfile.getUriString());
            this.onConnectivityChanged();
            this.mSessionMap.clear();
            this.closeToNotReceiveCalls();
            if (this.mSipStack != null) {
                this.mSipStack.stop();
                this.mSipStack = null;
                this.mSipHelper = null;
            }
            return;
        }
    }

    public void closeToNotReceiveCalls() {
        synchronized (this) {
            this.mCallReceiverSession = null;
            return;
        }
    }

    boolean containsSession(String string2) {
        synchronized (this) {
            boolean bl = this.mSessionMap.containsKey(string2);
            return bl;
        }
    }

    public ISipSession createSession(ISipSessionListener iSipSessionListener) {
        if (this.isClosed()) {
            return null;
        }
        return new SipSessionImpl(iSipSessionListener);
    }

    public SipProfile getLocalProfile() {
        return this.mLocalProfile;
    }

    public String getLocalProfileUri() {
        return this.mLocalProfile.getUriString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isClosed() {
        synchronized (this) {
            SipStack sipStack = this.mSipStack;
            if (sipStack != null) return false;
            return true;
        }
    }

    void onConnectivityChanged() {
        synchronized (this) {
            SipSessionImpl[] sipSessionImplArray = this.mSessionMap.values().toArray(new SipSessionImpl[this.mSessionMap.size()]);
            int n = sipSessionImplArray.length;
            for (int i = 0; i < n; ++i) {
                sipSessionImplArray[i].onError(-10, "data connection lost");
                continue;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void openToReceiveCalls(ISipSessionListener iSipSessionListener) {
        synchronized (this) {
            if (this.mCallReceiverSession == null) {
                this.mCallReceiverSession = new SipSessionCallReceiverImpl(iSipSessionListener);
            } else {
                this.mCallReceiverSession.setListener(iSipSessionListener);
            }
            return;
        }
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        this.process((EventObject)dialogTerminatedEvent);
    }

    public void processIOException(IOExceptionEvent iOExceptionEvent) {
        this.process((EventObject)iOExceptionEvent);
    }

    public void processRequest(RequestEvent requestEvent) {
        if (SipSessionGroup.isRequestEvent("INVITE", (EventObject)requestEvent)) {
            Log.d(TAG, "<<<<< got INVITE, thread:" + Thread.currentThread());
            this.mWakeLock.acquire(500L);
        }
        this.process((EventObject)requestEvent);
    }

    public void processResponse(ResponseEvent responseEvent) {
        this.process((EventObject)responseEvent);
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        this.process((EventObject)timeoutEvent);
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        this.process((EventObject)transactionTerminatedEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void reset(String string2) throws SipException, IOException {
        synchronized (this) {
            this.mLocalIp = string2;
            if (string2 != null) {
                SipStack sipStack;
                SipProfile sipProfile = this.mLocalProfile;
                SipFactory sipFactory = SipFactory.getInstance();
                Properties properties = new Properties();
                properties.setProperty("javax.sip.STACK_NAME", this.getStackName());
                properties.setProperty("gov.nist.javax.sip.THREAD_POOL_SIZE", THREAD_POOL_SIZE);
                String string3 = sipProfile.getProxyAddress();
                if (!TextUtils.isEmpty(string3)) {
                    Log.v(TAG, "outboundProxy is " + string3);
                    properties.setProperty("javax.sip.OUTBOUND_PROXY", string3 + ":" + sipProfile.getPort() + "/" + sipProfile.getProtocol());
                }
                this.mSipStack = sipStack = sipFactory.createSipStack(properties);
                try {
                    SipProvider sipProvider = sipStack.createSipProvider(sipStack.createListeningPoint(string2, SipSessionGroup.allocateLocalPort(), sipProfile.getProtocol()));
                    sipProvider.addSipListener((SipListener)this);
                    this.mSipHelper = new SipHelper(sipStack, sipProvider);
                }
                catch (InvalidArgumentException invalidArgumentException) {
                    throw new IOException(invalidArgumentException.getMessage());
                }
                catch (TooManyListenersException tooManyListenersException) {
                    throw new SipException("SipSessionGroup constructor", (Throwable)tooManyListenersException);
                }
                Log.d(TAG, " start stack for " + sipProfile.getUriString());
                sipStack.start();
                this.mCallReceiverSession = null;
                this.mSessionMap.clear();
            }
            return;
        }
    }

    private class MakeCallCommand
    extends EventObject {
        private String mSessionDescription;
        private int mTimeout;

        public MakeCallCommand(SipProfile sipProfile, String string2) {
            this(sipProfile, string2, -1);
        }

        public MakeCallCommand(SipProfile sipProfile, String string2, int n) {
            super(sipProfile);
            this.mSessionDescription = string2;
            this.mTimeout = n;
        }

        public SipProfile getPeerProfile() {
            return (SipProfile)this.getSource();
        }

        public String getSessionDescription() {
            return this.mSessionDescription;
        }

        public int getTimeout() {
            return this.mTimeout;
        }
    }

    private class OptionsCommand
    extends EventObject {
        public OptionsCommand() {
            super(SipSessionGroup.this);
        }
    }

    private class RegisterCommand
    extends EventObject {
        private int mDuration;

        public RegisterCommand(int n) {
            super(SipSessionGroup.this);
            this.mDuration = n;
        }

        public int getDuration() {
            return this.mDuration;
        }
    }

    private class SipSessionCallReceiverImpl
    extends SipSessionImpl {
        public SipSessionCallReceiverImpl(ISipSessionListener iSipSessionListener) {
            super(iSipSessionListener);
        }

        @Override
        public boolean process(EventObject eventObject) throws SipException {
            if (SipSessionGroup.isLoggable(this, eventObject)) {
                Log.d(SipSessionGroup.TAG, " ~~~~~   " + this + ": " + SipSession.State.toString(this.mState) + ": processing " + SipSessionGroup.log(eventObject));
            }
            if (SipSessionGroup.isRequestEvent("INVITE", eventObject)) {
                RequestEvent requestEvent = (RequestEvent)eventObject;
                SipSessionImpl sipSessionImpl = new SipSessionImpl(this.mProxy);
                sipSessionImpl.mState = 3;
                sipSessionImpl.mServerTransaction = SipSessionGroup.this.mSipHelper.sendRinging(requestEvent, this.generateTag());
                sipSessionImpl.mDialog = sipSessionImpl.mServerTransaction.getDialog();
                sipSessionImpl.mInviteReceived = requestEvent;
                sipSessionImpl.mPeerProfile = SipSessionGroup.createPeerProfile(requestEvent.getRequest());
                sipSessionImpl.mPeerSessionDescription = SipSessionGroup.this.extractContent((Message)requestEvent.getRequest());
                SipSessionGroup.this.addSipSession(sipSessionImpl);
                this.mProxy.onRinging(sipSessionImpl, sipSessionImpl.mPeerProfile, sipSessionImpl.mPeerSessionDescription);
                return true;
            }
            if (SipSessionGroup.isRequestEvent("OPTIONS", eventObject)) {
                SipSessionGroup.this.mSipHelper.sendResponse((RequestEvent)eventObject, 200);
                return true;
            }
            return false;
        }
    }

    class SipSessionImpl
    extends ISipSession.Stub {
        int mAuthenticationRetryCount;
        ClientTransaction mClientTransaction;
        Dialog mDialog;
        boolean mInCall;
        RequestEvent mInviteReceived;
        SipProfile mPeerProfile;
        String mPeerSessionDescription;
        SipSessionListenerProxy mProxy = new SipSessionListenerProxy();
        int mRPort;
        boolean mReRegisterFlag = false;
        ServerTransaction mServerTransaction;
        int mState = 0;
        SessionTimer mTimer;

        public SipSessionImpl(ISipSessionListener iSipSessionListener) {
            this.setListener(iSipSessionListener);
        }

        private void cancelSessionTimer() {
            if (this.mTimer != null) {
                this.mTimer.cancel();
                this.mTimer = null;
            }
        }

        private String createErrorMessage(Response response) {
            Object[] objectArray = new Object[]{response.getReasonPhrase(), response.getStatusCode()};
            return String.format("%s (%d)", objectArray);
        }

        private boolean crossDomainAuthenticationRequired(Response response) {
            String string2 = this.getRealmFromResponse(response);
            if (string2 == null) {
                string2 = "";
            }
            return !SipSessionGroup.this.mLocalProfile.getSipDomain().trim().equals(string2.trim());
        }

        private void doCommandAsync(final EventObject eventObject) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        SipSessionImpl.this.processCommand(eventObject);
                        return;
                    }
                    catch (Throwable throwable) {
                        Log.w(SipSessionGroup.TAG, "command error: " + eventObject, throwable);
                        SipSessionImpl.this.onError(throwable);
                        return;
                    }
                }
            }, "SipSessionAsyncCmdThread").start();
        }

        private void endCallNormally() {
            this.reset();
            this.mProxy.onCallEnded(this);
        }

        private void endCallOnBusy() {
            this.reset();
            this.mProxy.onCallBusy(this);
        }

        private void endCallOnError(int n, String string2) {
            this.reset();
            this.mProxy.onError(this, n, string2);
        }

        private void establishCall() {
            this.mState = 8;
            this.mInCall = true;
            this.cancelSessionTimer();
            this.mProxy.onCallEstablished(this, this.mPeerSessionDescription);
        }

        private AccountManager getAccountManager() {
            return new AccountManager(){

                public UserCredentials getCredentials(ClientTransaction clientTransaction, String string2) {
                    return new UserCredentials(){

                        public String getPassword() {
                            return SipSessionGroup.this.mPassword;
                        }

                        public String getSipDomain() {
                            return SipSessionGroup.this.mLocalProfile.getSipDomain();
                        }

                        public String getUserName() {
                            String string2 = SipSessionGroup.this.mLocalProfile.getAuthUserName();
                            if (!TextUtils.isEmpty(string2)) {
                                return string2;
                            }
                            return SipSessionGroup.this.mLocalProfile.getUserName();
                        }
                    };
                }
            };
        }

        private int getErrorCode(int n) {
            switch (n) {
                default: {
                    if (n >= 500) break;
                    return -4;
                }
                case 403: 
                case 404: 
                case 406: 
                case 410: 
                case 480: 
                case 488: {
                    return -7;
                }
                case 414: 
                case 484: 
                case 485: {
                    return -6;
                }
                case 408: {
                    return -5;
                }
            }
            return -2;
        }

        private int getErrorCode(Throwable throwable) {
            throwable.getMessage();
            if (throwable instanceof UnknownHostException) {
                return -12;
            }
            if (throwable instanceof IOException) {
                return -1;
            }
            return -4;
        }

        private int getExpiryTime(Response response) {
            ExpiresHeader expiresHeader;
            int n = 3600;
            ExpiresHeader expiresHeader2 = (ExpiresHeader)response.getHeader("Expires");
            if (expiresHeader2 != null) {
                n = expiresHeader2.getExpires();
            }
            if ((expiresHeader = (ExpiresHeader)response.getHeader("Min-Expires")) != null) {
                n = Math.max(n, expiresHeader.getExpires());
            }
            return n;
        }

        private String getNonceFromResponse(Response response) {
            WWWAuthenticate wWWAuthenticate = (WWWAuthenticate)response.getHeader("WWW-Authenticate");
            if (wWWAuthenticate != null) {
                return wWWAuthenticate.getNonce();
            }
            ProxyAuthenticate proxyAuthenticate = (ProxyAuthenticate)response.getHeader("Proxy-Authenticate");
            if (proxyAuthenticate == null) {
                return null;
            }
            return proxyAuthenticate.getNonce();
        }

        private int getRPortFromResponse(Response response) {
            ViaHeader viaHeader = (ViaHeader)response.getHeader("Via");
            if (viaHeader == null) {
                return -1;
            }
            return viaHeader.getRPort();
        }

        private String getRealmFromResponse(Response response) {
            WWWAuthenticate wWWAuthenticate = (WWWAuthenticate)response.getHeader("WWW-Authenticate");
            if (wWWAuthenticate != null) {
                return wWWAuthenticate.getRealm();
            }
            ProxyAuthenticate proxyAuthenticate = (ProxyAuthenticate)response.getHeader("Proxy-Authenticate");
            if (proxyAuthenticate == null) {
                return null;
            }
            return proxyAuthenticate.getRealm();
        }

        private Throwable getRootCause(Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            while (throwable2 != null) {
                throwable = throwable2;
                throwable2 = throwable.getCause();
            }
            return throwable;
        }

        private Transaction getTransaction() {
            if (this.mClientTransaction != null) {
                return this.mClientTransaction;
            }
            if (this.mServerTransaction != null) {
                return this.mServerTransaction;
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean handleAuthentication(ResponseEvent responseEvent) throws SipException {
            Response response = responseEvent.getResponse();
            if (this.getNonceFromResponse(response) == null) {
                this.onError(-2, "server does not provide challenge");
                return false;
            }
            if (this.mAuthenticationRetryCount < 2) {
                this.mClientTransaction = SipSessionGroup.this.mSipHelper.handleChallenge(responseEvent, this.getAccountManager());
                this.mDialog = this.mClientTransaction.getDialog();
                this.mAuthenticationRetryCount = 1 + this.mAuthenticationRetryCount;
                if (!SipSessionGroup.isLoggable(this, (EventObject)responseEvent)) return true;
                Log.d(SipSessionGroup.TAG, "   authentication retry count=" + this.mAuthenticationRetryCount);
                return true;
            }
            if (this.crossDomainAuthenticationRequired(response)) {
                this.onError(-11, this.getRealmFromResponse(response));
                return false;
            }
            this.onError(-8, "incorrect username or password");
            return false;
        }

        private boolean inCall(EventObject eventObject) throws SipException {
            if (END_CALL == eventObject) {
                SipSessionGroup.this.mSipHelper.sendBye(this.mDialog);
                this.endCallNormally();
                return true;
            }
            if (SipSessionGroup.isRequestEvent("INVITE", eventObject)) {
                RequestEvent requestEvent;
                this.mState = 3;
                this.mInviteReceived = requestEvent = (RequestEvent)eventObject;
                this.mPeerSessionDescription = SipSessionGroup.this.extractContent((Message)requestEvent.getRequest());
                this.mServerTransaction = null;
                this.mProxy.onRinging(this, this.mPeerProfile, this.mPeerSessionDescription);
                return true;
            }
            if (SipSessionGroup.isRequestEvent("BYE", eventObject)) {
                SipSessionGroup.this.mSipHelper.sendResponse((RequestEvent)eventObject, 200);
                this.endCallNormally();
                return true;
            }
            if (eventObject instanceof MakeCallCommand) {
                this.mState = 5;
                this.mClientTransaction = SipSessionGroup.this.mSipHelper.sendReinvite(this.mDialog, ((MakeCallCommand)eventObject).getSessionDescription());
                this.startSessionTimer(((MakeCallCommand)eventObject).getTimeout());
                return true;
            }
            return false;
        }

        private boolean incomingCall(EventObject eventObject) throws SipException {
            if (eventObject instanceof MakeCallCommand) {
                this.mState = 4;
                this.mServerTransaction = SipSessionGroup.this.mSipHelper.sendInviteOk(this.mInviteReceived, SipSessionGroup.this.mLocalProfile, ((MakeCallCommand)eventObject).getSessionDescription(), this.mServerTransaction);
                this.startSessionTimer(((MakeCallCommand)eventObject).getTimeout());
                return true;
            }
            if (END_CALL == eventObject) {
                SipSessionGroup.this.mSipHelper.sendInviteBusyHere(this.mInviteReceived, this.mServerTransaction);
                this.endCallNormally();
                return true;
            }
            if (SipSessionGroup.isRequestEvent("CANCEL", eventObject)) {
                RequestEvent requestEvent = (RequestEvent)eventObject;
                SipSessionGroup.this.mSipHelper.sendResponse(requestEvent, 200);
                SipSessionGroup.this.mSipHelper.sendInviteRequestTerminated(this.mInviteReceived.getRequest(), this.mServerTransaction);
                this.endCallNormally();
                return true;
            }
            return false;
        }

        private boolean incomingCallToInCall(EventObject eventObject) throws SipException {
            if (SipSessionGroup.isRequestEvent("ACK", eventObject)) {
                this.establishCall();
                return true;
            }
            return SipSessionGroup.isRequestEvent("CANCEL", eventObject);
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean isCurrentTransaction(TransactionTerminatedEvent transactionTerminatedEvent) {
            Object object;
            Object object2 = transactionTerminatedEvent.isServerTransaction() ? this.mServerTransaction : this.mClientTransaction;
            if (object2 != (object = transactionTerminatedEvent.isServerTransaction() ? transactionTerminatedEvent.getServerTransaction() : transactionTerminatedEvent.getClientTransaction()) && this.mState != 9) {
                Log.d(SipSessionGroup.TAG, "not the current transaction; current=" + this.toString((Transaction)object2) + ", target=" + this.toString((Transaction)object));
                return false;
            }
            if (object2 != null) {
                Log.d(SipSessionGroup.TAG, "transaction terminated: " + this.toString((Transaction)object2));
                return true;
            }
            return true;
        }

        private boolean keepAliveProcess(EventObject eventObject) throws SipException {
            if (eventObject instanceof OptionsCommand) {
                this.mClientTransaction = SipSessionGroup.this.mSipHelper.sendKeepAlive(SipSessionGroup.this.mLocalProfile, this.generateTag());
                this.mDialog = this.mClientTransaction.getDialog();
                SipSessionGroup.this.addSipSession(this);
                return true;
            }
            if (eventObject instanceof ResponseEvent) {
                return this.parseOptionsResult(eventObject);
            }
            return false;
        }

        private void onError(int n, String string2) {
            this.cancelSessionTimer();
            switch (this.mState) {
                default: {
                    this.endCallOnError(n, string2);
                    return;
                }
                case 1: 
                case 2: 
            }
            this.onRegistrationFailed(n, string2);
        }

        private void onError(Throwable throwable) {
            Throwable throwable2 = this.getRootCause(throwable);
            this.onError(this.getErrorCode(throwable2), throwable2.toString());
        }

        private void onError(Response response) {
            int n = response.getStatusCode();
            if (!this.mInCall && n == 486) {
                this.endCallOnBusy();
                return;
            }
            this.onError(this.getErrorCode(n), this.createErrorMessage(response));
        }

        private void onRegistrationDone(int n) {
            this.reset();
            this.mProxy.onRegistrationDone(this, n);
        }

        private void onRegistrationFailed(int n, String string2) {
            this.reset();
            this.mProxy.onRegistrationFailed(this, n, string2);
        }

        private void onRegistrationFailed(Throwable throwable) {
            Throwable throwable2 = this.getRootCause(throwable);
            this.onRegistrationFailed(this.getErrorCode(throwable2), throwable2.toString());
        }

        private void onRegistrationFailed(Response response) {
            this.onRegistrationFailed(this.getErrorCode(response.getStatusCode()), this.createErrorMessage(response));
        }

        private boolean outgoingCall(EventObject eventObject) throws SipException {
            if (SipSessionGroup.expectResponse("INVITE", eventObject)) {
                ResponseEvent responseEvent = (ResponseEvent)eventObject;
                Response response = responseEvent.getResponse();
                int n = response.getStatusCode();
                switch (n) {
                    default: {
                        if (n < 400) break;
                        this.onError(response);
                        return true;
                    }
                    case 180: 
                    case 181: 
                    case 182: 
                    case 183: {
                        if (this.mState == 5) {
                            this.mState = 6;
                            this.cancelSessionTimer();
                            this.mProxy.onRingingBack(this);
                        }
                        return true;
                    }
                    case 200: {
                        SipSessionGroup.this.mSipHelper.sendInviteAck(responseEvent, this.mDialog);
                        this.mPeerSessionDescription = SipSessionGroup.this.extractContent((Message)response);
                        this.establishCall();
                        return true;
                    }
                    case 401: 
                    case 407: {
                        if (this.handleAuthentication(responseEvent)) {
                            SipSessionGroup.this.addSipSession(this);
                        }
                        return true;
                    }
                    case 491: {
                        return true;
                    }
                }
                return n < 300;
            }
            if (END_CALL == eventObject) {
                this.mState = 7;
                SipSessionGroup.this.mSipHelper.sendCancel(this.mClientTransaction);
                this.startSessionTimer(3);
                return true;
            }
            if (SipSessionGroup.isRequestEvent("INVITE", eventObject)) {
                RequestEvent requestEvent = (RequestEvent)eventObject;
                SipSessionGroup.this.mSipHelper.sendInviteBusyHere(requestEvent, requestEvent.getServerTransaction());
                return true;
            }
            return false;
        }

        /*
         * Unable to fully structure code
         */
        private boolean outgoingCallToReady(EventObject var1_1) throws SipException {
            block10: {
                block7: {
                    block9: {
                        block8: {
                            if (!(var1_1 instanceof ResponseEvent)) break block7;
                            var2_2 = ((ResponseEvent)var1_1).getResponse();
                            var3_3 = var2_2.getStatusCode();
                            if (!SipSessionGroup.access$1900("CANCEL", var1_1)) break block8;
                            if (var3_3 == 200) {
                                return true;
                            }
                            ** GOTO lbl-1000
                        }
                        if (!SipSessionGroup.access$1900("INVITE", var1_1)) break block9;
                        switch (var3_3) {
                            default: lbl-1000:
                            // 2 sources

                            {
                                if (var3_3 >= 400) {
                                    this.onError(var2_2);
                                    return true;
                                }
                                break block10;
                            }
                            case 200: {
                                this.outgoingCall(var1_1);
                                return true;
                            }
                            case 487: {
                                this.endCallNormally();
                                return true;
                            }
                        }
                    }
                    return false;
                }
                if (var1_1 instanceof TransactionTerminatedEvent) {
                    this.onError(new SipException("timed out"));
                }
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean parseOptionsResult(EventObject eventObject) {
            if (!SipSessionGroup.expectResponse("OPTIONS", eventObject)) {
                return false;
            }
            int n = this.getRPortFromResponse(((ResponseEvent)eventObject).getResponse());
            if (n != -1) {
                if (this.mRPort == 0) {
                    this.mRPort = n;
                }
                if (this.mRPort != n) {
                    this.mReRegisterFlag = true;
                    Object[] objectArray = new Object[]{this.mRPort, n};
                    Log.w(SipSessionGroup.TAG, String.format("rport is changed: %d <> %d", objectArray));
                    this.mRPort = n;
                }
            } else {
                Log.w(SipSessionGroup.TAG, "peer did not respond rport");
            }
            this.reset();
            return true;
        }

        private void processCommand(EventObject eventObject) throws SipException {
            if (SipSessionGroup.isLoggable(eventObject)) {
                Log.d(SipSessionGroup.TAG, "process cmd: " + eventObject);
            }
            if (!this.process(eventObject)) {
                this.onError(-9, "cannot initiate a new transaction to execute: " + eventObject);
            }
        }

        private void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
            if (this.mDialog == dialogTerminatedEvent.getDialog()) {
                this.onError(new SipException("dialog terminated"));
                return;
            }
            Log.d(SipSessionGroup.TAG, "not the current dialog; current=" + this.mDialog + ", terminated=" + dialogTerminatedEvent.getDialog());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean processExceptions(EventObject eventObject) throws SipException {
            if (SipSessionGroup.isRequestEvent("BYE", eventObject)) {
                SipSessionGroup.this.mSipHelper.sendResponse((RequestEvent)eventObject, 200);
                this.endCallNormally();
                return true;
            }
            if (SipSessionGroup.isRequestEvent("CANCEL", eventObject)) {
                SipSessionGroup.this.mSipHelper.sendResponse((RequestEvent)eventObject, 481);
                return true;
            }
            if (eventObject instanceof TransactionTerminatedEvent) {
                if (!this.isCurrentTransaction((TransactionTerminatedEvent)eventObject)) return false;
                if (eventObject instanceof TimeoutEvent) {
                    this.processTimeout((TimeoutEvent)eventObject);
                    return true;
                }
                this.processTransactionTerminated((TransactionTerminatedEvent)eventObject);
                return true;
            }
            if (SipSessionGroup.isRequestEvent("OPTIONS", eventObject)) {
                SipSessionGroup.this.mSipHelper.sendResponse((RequestEvent)eventObject, 200);
                return true;
            }
            if (!(eventObject instanceof DialogTerminatedEvent)) return false;
            this.processDialogTerminated((DialogTerminatedEvent)eventObject);
            return true;
        }

        private void processTimeout(TimeoutEvent timeoutEvent) {
            Log.d(SipSessionGroup.TAG, "processing Timeout...");
            switch (this.mState) {
                default: {
                    Log.d(SipSessionGroup.TAG, "   do nothing");
                    return;
                }
                case 1: 
                case 2: {
                    this.reset();
                    this.mProxy.onRegistrationTimeout(this);
                    return;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    this.onError(-5, timeoutEvent.toString());
                    return;
                }
                case 9: 
            }
            this.reset();
            this.mReRegisterFlag = true;
        }

        private void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
            switch (this.mState) {
                default: {
                    Log.d(SipSessionGroup.TAG, "Transaction terminated early: " + this);
                    this.onError(-3, "transaction terminated");
                    return;
                }
                case 0: 
                case 8: 
            }
            Log.d(SipSessionGroup.TAG, "Transaction terminated; do nothing");
        }

        private boolean readyForCall(EventObject eventObject) throws SipException {
            if (eventObject instanceof MakeCallCommand) {
                this.mState = 5;
                MakeCallCommand makeCallCommand = (MakeCallCommand)eventObject;
                this.mPeerProfile = makeCallCommand.getPeerProfile();
                this.mClientTransaction = SipSessionGroup.this.mSipHelper.sendInvite(SipSessionGroup.this.mLocalProfile, this.mPeerProfile, makeCallCommand.getSessionDescription(), this.generateTag());
                this.mDialog = this.mClientTransaction.getDialog();
                SipSessionGroup.this.addSipSession(this);
                this.startSessionTimer(makeCallCommand.getTimeout());
                this.mProxy.onCalling(this);
                return true;
            }
            if (eventObject instanceof RegisterCommand) {
                this.mState = 1;
                int n = ((RegisterCommand)eventObject).getDuration();
                this.mClientTransaction = SipSessionGroup.this.mSipHelper.sendRegister(SipSessionGroup.this.mLocalProfile, this.generateTag(), n);
                this.mDialog = this.mClientTransaction.getDialog();
                SipSessionGroup.this.addSipSession(this);
                this.mProxy.onRegistering(this);
                return true;
            }
            if (DEREGISTER == eventObject) {
                this.mState = 2;
                this.mClientTransaction = SipSessionGroup.this.mSipHelper.sendRegister(SipSessionGroup.this.mLocalProfile, this.generateTag(), 0);
                this.mDialog = this.mClientTransaction.getDialog();
                SipSessionGroup.this.addSipSession(this);
                this.mProxy.onRegistering(this);
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean registeringToReady(EventObject eventObject) throws SipException {
            if (SipSessionGroup.expectResponse("REGISTER", eventObject)) {
                ResponseEvent responseEvent = (ResponseEvent)eventObject;
                Response response = responseEvent.getResponse();
                int n = response.getStatusCode();
                switch (n) {
                    default: {
                        if (n < 500) break;
                        this.onRegistrationFailed(response);
                        return true;
                    }
                    case 200: {
                        int n2 = this.mState == 1 ? this.getExpiryTime(((ResponseEvent)eventObject).getResponse()) : -1;
                        this.onRegistrationDone(n2);
                        return true;
                    }
                    case 401: 
                    case 407: {
                        this.handleAuthentication(responseEvent);
                        return true;
                    }
                }
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void reset() {
            this.mInCall = false;
            SipSessionGroup.this.removeSipSession(this);
            this.mPeerProfile = null;
            this.mState = 0;
            this.mInviteReceived = null;
            this.mPeerSessionDescription = null;
            this.mRPort = 0;
            this.mAuthenticationRetryCount = 0;
            if (this.mDialog != null) {
                this.mDialog.delete();
            }
            this.mDialog = null;
            try {
                if (this.mServerTransaction != null) {
                    this.mServerTransaction.terminate();
                }
            }
            catch (ObjectInUseException objectInUseException) {}
            this.mServerTransaction = null;
            try {
                if (this.mClientTransaction != null) {
                    this.mClientTransaction.terminate();
                }
            }
            catch (ObjectInUseException objectInUseException) {}
            this.mClientTransaction = null;
            this.cancelSessionTimer();
        }

        private void startSessionTimer(int n) {
            if (n > 0) {
                this.mTimer = new SessionTimer();
                this.mTimer.start(n);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private String toString(Transaction transaction) {
            if (transaction == null) {
                return "null";
            }
            Request request = transaction.getRequest();
            Dialog dialog = transaction.getDialog();
            CSeqHeader cSeqHeader = (CSeqHeader)request.getHeader("CSeq");
            Object[] objectArray = new Object[4];
            objectArray[0] = request.getMethod();
            objectArray[1] = cSeqHeader.getSeqNumber();
            objectArray[2] = transaction.getState();
            String string2 = dialog == null ? "-" : dialog.getState();
            objectArray[3] = string2;
            return String.format("req=%s,%s,s=%s,ds=%s,", objectArray);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void answerCall(String string2, int n) {
            SipSessionGroup sipSessionGroup = SipSessionGroup.this;
            synchronized (sipSessionGroup) {
                if (this.mPeerProfile == null) {
                    return;
                }
                try {
                    this.processCommand(new MakeCallCommand(this.mPeerProfile, string2, n));
                }
                catch (SipException sipException) {
                    this.onError(sipException);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void changeCall(String string2, int n) {
            SipSessionGroup sipSessionGroup = SipSessionGroup.this;
            synchronized (sipSessionGroup) {
                if (this.mPeerProfile == null) {
                    return;
                }
                this.doCommandAsync(new MakeCallCommand(this.mPeerProfile, string2, n));
                return;
            }
        }

        public void clearReRegisterRequired() {
            this.mReRegisterFlag = false;
        }

        SipSessionImpl duplicate() {
            return new SipSessionImpl(this.mProxy.getListener());
        }

        @Override
        public void endCall() {
            this.doCommandAsync(END_CALL);
        }

        protected String generateTag() {
            return String.valueOf((long)(4.294967296E9 * Math.random()));
        }

        @Override
        public String getCallId() {
            return SipHelper.getCallId(this.getTransaction());
        }

        @Override
        public String getLocalIp() {
            return SipSessionGroup.this.mLocalIp;
        }

        @Override
        public SipProfile getLocalProfile() {
            return SipSessionGroup.this.mLocalProfile;
        }

        @Override
        public SipProfile getPeerProfile() {
            return this.mPeerProfile;
        }

        @Override
        public int getState() {
            return this.mState;
        }

        @Override
        public boolean isInCall() {
            return this.mInCall;
        }

        public boolean isReRegisterRequired() {
            return this.mReRegisterFlag;
        }

        @Override
        public void makeCall(SipProfile sipProfile, String string2, int n) {
            this.doCommandAsync(new MakeCallCommand(sipProfile, string2, n));
        }

        /*
         * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean process(EventObject eventObject) throws SipException {
            if (SipSessionGroup.isLoggable(this, eventObject)) {
                Log.d(SipSessionGroup.TAG, " ~~~~~   " + this + ": " + SipSession.State.toString(this.mState) + ": processing " + SipSessionGroup.log(eventObject));
            }
            SipSessionGroup sipSessionGroup = SipSessionGroup.this;
            synchronized (sipSessionGroup) {
                boolean bl;
                Dialog dialog;
                if (SipSessionGroup.this.isClosed()) {
                    return false;
                }
                if (eventObject instanceof RequestEvent) {
                    dialog = ((RequestEvent)eventObject).getDialog();
                } else {
                    boolean bl2 = eventObject instanceof ResponseEvent;
                    dialog = null;
                    if (bl2) {
                        dialog = ((ResponseEvent)eventObject).getDialog();
                    }
                }
                if (dialog != null) {
                    this.mDialog = dialog;
                }
                switch (this.mState) {
                    case 1: 
                    case 2: {
                        bl = this.registeringToReady(eventObject);
                        break;
                    }
                    case 9: {
                        bl = this.keepAliveProcess(eventObject);
                        break;
                    }
                    case 0: {
                        bl = this.readyForCall(eventObject);
                        break;
                    }
                    case 3: {
                        bl = this.incomingCall(eventObject);
                        break;
                    }
                    case 4: {
                        bl = this.incomingCallToInCall(eventObject);
                        break;
                    }
                    case 5: 
                    case 6: {
                        bl = this.outgoingCall(eventObject);
                        break;
                    }
                    case 7: {
                        bl = this.outgoingCallToReady(eventObject);
                        break;
                    }
                    case 8: {
                        boolean bl3;
                        bl = bl3 = this.inCall(eventObject);
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                if (bl) return true;
                if (!this.processExceptions(eventObject)) return false;
                return true;
            }
        }

        @Override
        public void register(int n) {
            this.doCommandAsync(new RegisterCommand(n));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void sendKeepAlive() {
            this.mState = 9;
            try {
                this.processCommand(new OptionsCommand());
                int n = 0;
                while (true) {
                    if (n >= 15 || 9 != this.mState) {
                        if (9 != this.mState) return;
                        this.reset();
                        Log.w(SipSessionGroup.TAG, "no response from ping");
                        return;
                    }
                    Thread.sleep(200L);
                    ++n;
                }
            }
            catch (SipException sipException) {
                Log.e(SipSessionGroup.TAG, "sendKeepAlive failed", sipException);
                return;
            }
            catch (InterruptedException interruptedException) {
                Log.e(SipSessionGroup.TAG, "sendKeepAlive interrupted", interruptedException);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void setListener(ISipSessionListener iSipSessionListener) {
            SipSessionListenerProxy sipSessionListenerProxy = this.mProxy;
            ISipSessionListener iSipSessionListener2 = iSipSessionListener instanceof SipSessionListenerProxy ? ((SipSessionListenerProxy)iSipSessionListener).getListener() : iSipSessionListener;
            sipSessionListenerProxy.setListener(iSipSessionListener2);
        }

        public String toString() {
            try {
                String string2 = super.toString();
                String string3 = string2.substring(string2.indexOf("@")) + ":" + SipSession.State.toString(this.mState);
                return string3;
            }
            catch (Throwable throwable) {
                return super.toString();
            }
        }

        @Override
        public void unregister() {
            this.doCommandAsync(DEREGISTER);
        }

        class SessionTimer {
            private boolean mRunning = true;

            SessionTimer() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void sleep(int n) {
                synchronized (this) {
                    long l = n * 1000;
                    try {
                        this.wait(l);
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        Log.e(SipSessionGroup.TAG, "session timer interrupted!");
                        return;
                    }
                    finally {
                    }
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void timeout() {
                SipSessionGroup sipSessionGroup = SipSessionGroup.this;
                synchronized (sipSessionGroup) {
                    SipSessionImpl.this.onError(-5, "Session timed out!");
                    return;
                }
            }

            void cancel() {
                synchronized (this) {
                    this.mRunning = false;
                    this.notify();
                    return;
                }
            }

            void start(final int n) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        SessionTimer.this.sleep(n);
                        if (SessionTimer.this.mRunning) {
                            SessionTimer.this.timeout();
                        }
                    }
                }, "SipSessionTimerThread").start();
            }
        }
    }
}

