/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.sip;

import android.net.sip.ISipSession;
import android.net.sip.ISipSessionListener;
import android.net.sip.SipProfile;
import android.os.DeadObjectException;
import android.util.Log;

class SipSessionListenerProxy
extends ISipSessionListener.Stub {
    private static final String TAG = "SipSession";
    private ISipSessionListener mListener;

    SipSessionListenerProxy() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handle(Throwable throwable, String string2) {
        if (throwable instanceof DeadObjectException) {
            this.mListener = null;
            return;
        } else {
            if (this.mListener == null) return;
            Log.w(TAG, string2, throwable);
            return;
        }
    }

    private void proxy(Runnable runnable) {
        new Thread(runnable, "SipSessionCallbackThread").start();
    }

    public ISipSessionListener getListener() {
        return this.mListener;
    }

    @Override
    public void onCallBusy(final ISipSession iSipSession) {
        if (this.mListener == null) {
            return;
        }
        this.proxy(new Runnable(){

            @Override
            public void run() {
                try {
                    SipSessionListenerProxy.this.mListener.onCallBusy(iSipSession);
                    return;
                }
                catch (Throwable throwable) {
                    SipSessionListenerProxy.this.handle(throwable, "onCallBusy()");
                    return;
                }
            }
        });
    }

    @Override
    public void onCallChangeFailed(final ISipSession iSipSession, final int n, final String string2) {
        if (this.mListener == null) {
            return;
        }
        this.proxy(new Runnable(){

            @Override
            public void run() {
                try {
                    SipSessionListenerProxy.this.mListener.onCallChangeFailed(iSipSession, n, string2);
                    return;
                }
                catch (Throwable throwable) {
                    SipSessionListenerProxy.this.handle(throwable, "onCallChangeFailed()");
                    return;
                }
            }
        });
    }

    @Override
    public void onCallEnded(final ISipSession iSipSession) {
        if (this.mListener == null) {
            return;
        }
        this.proxy(new Runnable(){

            @Override
            public void run() {
                try {
                    SipSessionListenerProxy.this.mListener.onCallEnded(iSipSession);
                    return;
                }
                catch (Throwable throwable) {
                    SipSessionListenerProxy.this.handle(throwable, "onCallEnded()");
                    return;
                }
            }
        });
    }

    @Override
    public void onCallEstablished(final ISipSession iSipSession, final String string2) {
        if (this.mListener == null) {
            return;
        }
        this.proxy(new Runnable(){

            @Override
            public void run() {
                try {
                    SipSessionListenerProxy.this.mListener.onCallEstablished(iSipSession, string2);
                    return;
                }
                catch (Throwable throwable) {
                    SipSessionListenerProxy.this.handle(throwable, "onCallEstablished()");
                    return;
                }
            }
        });
    }

    @Override
    public void onCalling(final ISipSession iSipSession) {
        if (this.mListener == null) {
            return;
        }
        this.proxy(new Runnable(){

            @Override
            public void run() {
                try {
                    SipSessionListenerProxy.this.mListener.onCalling(iSipSession);
                    return;
                }
                catch (Throwable throwable) {
                    SipSessionListenerProxy.this.handle(throwable, "onCalling()");
                    return;
                }
            }
        });
    }

    @Override
    public void onError(final ISipSession iSipSession, final int n, final String string2) {
        if (this.mListener == null) {
            return;
        }
        this.proxy(new Runnable(){

            @Override
            public void run() {
                try {
                    SipSessionListenerProxy.this.mListener.onError(iSipSession, n, string2);
                    return;
                }
                catch (Throwable throwable) {
                    SipSessionListenerProxy.this.handle(throwable, "onError()");
                    return;
                }
            }
        });
    }

    @Override
    public void onRegistering(final ISipSession iSipSession) {
        if (this.mListener == null) {
            return;
        }
        this.proxy(new Runnable(){

            @Override
            public void run() {
                try {
                    SipSessionListenerProxy.this.mListener.onRegistering(iSipSession);
                    return;
                }
                catch (Throwable throwable) {
                    SipSessionListenerProxy.this.handle(throwable, "onRegistering()");
                    return;
                }
            }
        });
    }

    @Override
    public void onRegistrationDone(final ISipSession iSipSession, final int n) {
        if (this.mListener == null) {
            return;
        }
        this.proxy(new Runnable(){

            @Override
            public void run() {
                try {
                    SipSessionListenerProxy.this.mListener.onRegistrationDone(iSipSession, n);
                    return;
                }
                catch (Throwable throwable) {
                    SipSessionListenerProxy.this.handle(throwable, "onRegistrationDone()");
                    return;
                }
            }
        });
    }

    @Override
    public void onRegistrationFailed(final ISipSession iSipSession, final int n, final String string2) {
        if (this.mListener == null) {
            return;
        }
        this.proxy(new Runnable(){

            @Override
            public void run() {
                try {
                    SipSessionListenerProxy.this.mListener.onRegistrationFailed(iSipSession, n, string2);
                    return;
                }
                catch (Throwable throwable) {
                    SipSessionListenerProxy.this.handle(throwable, "onRegistrationFailed()");
                    return;
                }
            }
        });
    }

    @Override
    public void onRegistrationTimeout(final ISipSession iSipSession) {
        if (this.mListener == null) {
            return;
        }
        this.proxy(new Runnable(){

            @Override
            public void run() {
                try {
                    SipSessionListenerProxy.this.mListener.onRegistrationTimeout(iSipSession);
                    return;
                }
                catch (Throwable throwable) {
                    SipSessionListenerProxy.this.handle(throwable, "onRegistrationTimeout()");
                    return;
                }
            }
        });
    }

    @Override
    public void onRinging(final ISipSession iSipSession, final SipProfile sipProfile, final String string2) {
        if (this.mListener == null) {
            return;
        }
        this.proxy(new Runnable(){

            @Override
            public void run() {
                try {
                    SipSessionListenerProxy.this.mListener.onRinging(iSipSession, sipProfile, string2);
                    return;
                }
                catch (Throwable throwable) {
                    SipSessionListenerProxy.this.handle(throwable, "onRinging()");
                    return;
                }
            }
        });
    }

    @Override
    public void onRingingBack(final ISipSession iSipSession) {
        if (this.mListener == null) {
            return;
        }
        this.proxy(new Runnable(){

            @Override
            public void run() {
                try {
                    SipSessionListenerProxy.this.mListener.onRingingBack(iSipSession);
                    return;
                }
                catch (Throwable throwable) {
                    SipSessionListenerProxy.this.handle(throwable, "onRingingBack()");
                    return;
                }
            }
        });
    }

    public void setListener(ISipSessionListener iSipSessionListener) {
        this.mListener = iSipSessionListener;
    }
}

