/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gles_jni;

import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.google.android.gles_jni.EGLContextImpl;
import com.google.android.gles_jni.EGLDisplayImpl;
import com.google.android.gles_jni.EGLSurfaceImpl;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class EGLImpl
implements EGL10 {
    private EGLContextImpl mContext = new EGLContextImpl(-1);
    private EGLDisplayImpl mDisplay = new EGLDisplayImpl(-1);
    private EGLSurfaceImpl mSurface = new EGLSurfaceImpl(-1);

    static {
        EGLImpl._nativeClassInit();
    }

    private native int _eglCreateContext(EGLDisplay var1, EGLConfig var2, EGLContext var3, int[] var4);

    private native int _eglCreatePbufferSurface(EGLDisplay var1, EGLConfig var2, int[] var3);

    private native void _eglCreatePixmapSurface(EGLSurface var1, EGLDisplay var2, EGLConfig var3, Object var4, int[] var5);

    private native int _eglCreateWindowSurface(EGLDisplay var1, EGLConfig var2, Object var3, int[] var4);

    private native int _eglGetCurrentContext();

    private native int _eglGetCurrentDisplay();

    private native int _eglGetCurrentSurface(int var1);

    private native int _eglGetDisplay(Object var1);

    private static native void _nativeClassInit();

    @Override
    public native boolean eglChooseConfig(EGLDisplay var1, int[] var2, EGLConfig[] var3, int var4, int[] var5);

    @Override
    public native boolean eglCopyBuffers(EGLDisplay var1, EGLSurface var2, Object var3);

    @Override
    public EGLContext eglCreateContext(EGLDisplay eGLDisplay, EGLConfig eGLConfig, EGLContext eGLContext, int[] nArray) {
        int n = this._eglCreateContext(eGLDisplay, eGLConfig, eGLContext, nArray);
        if (n == 0) {
            return EGL10.EGL_NO_CONTEXT;
        }
        return new EGLContextImpl(n);
    }

    @Override
    public EGLSurface eglCreatePbufferSurface(EGLDisplay eGLDisplay, EGLConfig eGLConfig, int[] nArray) {
        int n = this._eglCreatePbufferSurface(eGLDisplay, eGLConfig, nArray);
        if (n == 0) {
            return EGL10.EGL_NO_SURFACE;
        }
        return new EGLSurfaceImpl(n);
    }

    @Override
    public EGLSurface eglCreatePixmapSurface(EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object, int[] nArray) {
        EGLSurfaceImpl eGLSurfaceImpl = new EGLSurfaceImpl();
        this._eglCreatePixmapSurface(eGLSurfaceImpl, eGLDisplay, eGLConfig, object, nArray);
        if (eGLSurfaceImpl.mEGLSurface == 0) {
            return EGL10.EGL_NO_SURFACE;
        }
        return eGLSurfaceImpl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public EGLSurface eglCreateWindowSurface(EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object, int[] nArray) {
        int n;
        Surface surface;
        if (object instanceof SurfaceView) {
            surface = ((SurfaceView)object).getHolder().getSurface();
        } else {
            if (!(object instanceof SurfaceHolder)) {
                throw new UnsupportedOperationException("eglCreateWindowSurface() can only be called with an instance of SurfaceView or SurfaceHolder at the moment, this will be fixed later.");
            }
            surface = ((SurfaceHolder)object).getSurface();
        }
        if ((n = this._eglCreateWindowSurface(eGLDisplay, eGLConfig, surface, nArray)) == 0) {
            return EGL10.EGL_NO_SURFACE;
        }
        return new EGLSurfaceImpl(n);
    }

    @Override
    public native boolean eglDestroyContext(EGLDisplay var1, EGLContext var2);

    @Override
    public native boolean eglDestroySurface(EGLDisplay var1, EGLSurface var2);

    @Override
    public native boolean eglGetConfigAttrib(EGLDisplay var1, EGLConfig var2, int var3, int[] var4);

    @Override
    public native boolean eglGetConfigs(EGLDisplay var1, EGLConfig[] var2, int var3, int[] var4);

    @Override
    public EGLContext eglGetCurrentContext() {
        synchronized (this) {
            EGLContext eGLContext;
            int n = this._eglGetCurrentContext();
            if (n == 0) {
                eGLContext = EGL10.EGL_NO_CONTEXT;
                return eGLContext;
            }
            if (this.mContext.mEGLContext != n) {
                this.mContext = new EGLContextImpl(n);
            }
            eGLContext = this.mContext;
        }
    }

    @Override
    public EGLDisplay eglGetCurrentDisplay() {
        synchronized (this) {
            EGLDisplay eGLDisplay;
            int n = this._eglGetCurrentDisplay();
            if (n == 0) {
                eGLDisplay = EGL10.EGL_NO_DISPLAY;
                return eGLDisplay;
            }
            if (this.mDisplay.mEGLDisplay != n) {
                this.mDisplay = new EGLDisplayImpl(n);
            }
            eGLDisplay = this.mDisplay;
        }
    }

    @Override
    public EGLSurface eglGetCurrentSurface(int n) {
        synchronized (this) {
            EGLSurface eGLSurface;
            int n2 = this._eglGetCurrentSurface(n);
            if (n2 == 0) {
                eGLSurface = EGL10.EGL_NO_SURFACE;
                return eGLSurface;
            }
            if (this.mSurface.mEGLSurface != n2) {
                this.mSurface = new EGLSurfaceImpl(n2);
            }
            eGLSurface = this.mSurface;
        }
    }

    @Override
    public EGLDisplay eglGetDisplay(Object object) {
        synchronized (this) {
            EGLDisplay eGLDisplay;
            int n = this._eglGetDisplay(object);
            if (n == 0) {
                eGLDisplay = EGL10.EGL_NO_DISPLAY;
                return eGLDisplay;
            }
            if (this.mDisplay.mEGLDisplay != n) {
                this.mDisplay = new EGLDisplayImpl(n);
            }
            eGLDisplay = this.mDisplay;
        }
    }

    @Override
    public native int eglGetError();

    @Override
    public native boolean eglInitialize(EGLDisplay var1, int[] var2);

    @Override
    public native boolean eglMakeCurrent(EGLDisplay var1, EGLSurface var2, EGLSurface var3, EGLContext var4);

    @Override
    public native boolean eglQueryContext(EGLDisplay var1, EGLContext var2, int var3, int[] var4);

    @Override
    public native String eglQueryString(EGLDisplay var1, int var2);

    @Override
    public native boolean eglQuerySurface(EGLDisplay var1, EGLSurface var2, int var3, int[] var4);

    @Override
    public native boolean eglSwapBuffers(EGLDisplay var1, EGLSurface var2);

    @Override
    public native boolean eglTerminate(EGLDisplay var1);

    @Override
    public native boolean eglWaitGL();

    @Override
    public native boolean eglWaitNative(int var1, Object var2);
}

