/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.pdu;

public class Base64 {
    static final int BASELENGTH = 255;
    static final int FOURBYTE = 4;
    static final byte PAD = 61;
    private static byte[] base64Alphabet = new byte[255];

    static {
        for (int i = 0; i < 255; ++i) {
            Base64.base64Alphabet[i] = -1;
        }
        for (int i = 90; i >= 65; --i) {
            Base64.base64Alphabet[i] = (byte)(i - 65);
        }
        for (int i = 122; i >= 97; --i) {
            Base64.base64Alphabet[i] = (byte)(26 + (i - 97));
        }
        for (int i = 57; i >= 48; --i) {
            Base64.base64Alphabet[i] = (byte)(52 + (i - 48));
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static byte[] decodeBase64(byte[] byArray) {
        byte[] byArray2 = Base64.discardNonBase64(byArray);
        if (byArray2.length == 0) {
            return new byte[0];
        }
        int n = byArray2.length / 4;
        int n2 = 0;
        int n3 = byArray2.length;
        while (byArray2[n3 - 1] == 61) {
            if (--n3 != 0) continue;
            return new byte[0];
        }
        byte[] byArray3 = new byte[n3 - n];
        int n4 = 0;
        while (n4 < n) {
            int n5 = n4 * 4;
            byte by = byArray2[n5 + 2];
            byte by2 = byArray2[n5 + 3];
            byte by3 = base64Alphabet[byArray2[n5]];
            byte by4 = base64Alphabet[byArray2[n5 + 1]];
            if (by != 61 && by2 != 61) {
                byte by5 = base64Alphabet[by];
                byte by6 = base64Alphabet[by2];
                byArray3[n2] = (byte)(by3 << 2 | by4 >> 4);
                byArray3[n2 + 1] = (byte)((by4 & 0xF) << 4 | 0xF & by5 >> 2);
                byArray3[n2 + 2] = (byte)(by6 | by5 << 6);
            } else if (by == 61) {
                byArray3[n2] = (byte)(by3 << 2 | by4 >> 4);
            } else if (by2 == 61) {
                byte by7 = base64Alphabet[by];
                byArray3[n2] = (byte)(by3 << 2 | by4 >> 4);
                byArray3[n2 + 1] = (byte)((by4 & 0xF) << 4 | 0xF & by7 >> 2);
            }
            n2 += 3;
            ++n4;
        }
        return byArray3;
    }

    static byte[] discardNonBase64(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (!Base64.isBase64(byArray[i])) continue;
            int n2 = n + 1;
            byArray2[n] = byArray[i];
            n = n2;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }

    private static boolean isBase64(byte by) {
        if (by == 61) {
            return true;
        }
        return base64Alphabet[by] != -1;
    }
}

