/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.pdu;

import android.util.Log;
import com.google.android.mms.pdu.CharacterSets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class EncodedStringValue
implements Cloneable {
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final String TAG = "EncodedStringValue";
    private int mCharacterSet;
    private byte[] mData;

    public EncodedStringValue(int n, byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("EncodedStringValue: Text-string is null.");
        }
        this.mCharacterSet = n;
        this.mData = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.mData, 0, byArray.length);
    }

    public EncodedStringValue(String string2) {
        try {
            this.mData = string2.getBytes("utf-8");
            this.mCharacterSet = 106;
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e(TAG, "Default encoding must be supported.", unsupportedEncodingException);
            return;
        }
    }

    public EncodedStringValue(byte[] byArray) {
        this(106, byArray);
    }

    public static String concat(EncodedStringValue[] encodedStringValueArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = encodedStringValueArray.length - 1;
        for (int i = 0; i <= n; ++i) {
            stringBuilder.append(encodedStringValueArray[i].getString());
            if (i >= n) continue;
            stringBuilder.append(";");
        }
        return stringBuilder.toString();
    }

    public static EncodedStringValue copy(EncodedStringValue encodedStringValue) {
        if (encodedStringValue == null) {
            return null;
        }
        return new EncodedStringValue(encodedStringValue.mCharacterSet, encodedStringValue.mData);
    }

    public static EncodedStringValue[] encodeStrings(String[] stringArray) {
        int n = stringArray.length;
        if (n > 0) {
            EncodedStringValue[] encodedStringValueArray = new EncodedStringValue[n];
            for (int i = 0; i < n; ++i) {
                encodedStringValueArray[i] = new EncodedStringValue(stringArray[i]);
            }
            return encodedStringValueArray;
        }
        return null;
    }

    public static EncodedStringValue[] extract(String string2) {
        String[] stringArray = string2.split(";");
        ArrayList<EncodedStringValue> arrayList = new ArrayList<EncodedStringValue>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= 0) continue;
            arrayList.add(new EncodedStringValue(stringArray[i]));
        }
        int n = arrayList.size();
        if (n > 0) {
            return arrayList.toArray(new EncodedStringValue[n]);
        }
        return null;
    }

    public void appendTextString(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Text-string is null.");
        }
        if (this.mData == null) {
            this.mData = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.mData, 0, byArray.length);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(this.mData);
            byteArrayOutputStream.write(byArray);
            this.mData = byteArrayOutputStream.toByteArray();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new NullPointerException("appendTextString: failed when write a new Text-string");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        int n = this.mData.length;
        byte[] byArray = new byte[n];
        System.arraycopy(this.mData, 0, byArray, 0, n);
        try {
            EncodedStringValue encodedStringValue = new EncodedStringValue(this.mCharacterSet, byArray);
            return encodedStringValue;
        }
        catch (Exception exception) {
            Log.e(TAG, "failed to clone an EncodedStringValue: " + this);
            exception.printStackTrace();
            throw new CloneNotSupportedException(exception.getMessage());
        }
    }

    public int getCharacterSet() {
        return this.mCharacterSet;
    }

    public String getString() {
        if (this.mCharacterSet == 0) {
            return new String(this.mData);
        }
        try {
            String string2 = CharacterSets.getMimeName(this.mCharacterSet);
            String string3 = new String(this.mData, string2);
            return string3;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                String string4 = new String(this.mData, "iso-8859-1");
                return string4;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                return new String(this.mData);
            }
        }
    }

    public byte[] getTextString() {
        byte[] byArray = new byte[this.mData.length];
        System.arraycopy(this.mData, 0, byArray, 0, this.mData.length);
        return byArray;
    }

    public void setCharacterSet(int n) {
        this.mCharacterSet = n;
    }

    public void setTextString(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("EncodedStringValue: Text-string is null.");
        }
        this.mData = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.mData, 0, byArray.length);
    }

    public EncodedStringValue[] split(String string2) {
        String[] stringArray = this.getString().split(string2);
        EncodedStringValue[] encodedStringValueArray = new EncodedStringValue[stringArray.length];
        for (int i = 0; i < encodedStringValueArray.length; ++i) {
            try {
                encodedStringValueArray[i] = new EncodedStringValue(this.mCharacterSet, stringArray[i].getBytes());
                continue;
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
        }
        return encodedStringValueArray;
    }
}

