/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.pdu;

import com.google.android.mms.pdu.PduPart;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class PduBody {
    private Map<String, PduPart> mPartMapByContentId = null;
    private Map<String, PduPart> mPartMapByContentLocation = null;
    private Map<String, PduPart> mPartMapByFileName = null;
    private Map<String, PduPart> mPartMapByName = null;
    private Vector<PduPart> mParts = new Vector();

    public PduBody() {
        this.mPartMapByContentId = new HashMap<String, PduPart>();
        this.mPartMapByContentLocation = new HashMap<String, PduPart>();
        this.mPartMapByName = new HashMap<String, PduPart>();
        this.mPartMapByFileName = new HashMap<String, PduPart>();
    }

    private void putPartToMaps(PduPart pduPart) {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4 = pduPart.getContentId();
        if (byArray4 != null) {
            this.mPartMapByContentId.put(new String(byArray4), pduPart);
        }
        if ((byArray3 = pduPart.getContentLocation()) != null) {
            String string2 = new String(byArray3);
            this.mPartMapByContentLocation.put(string2, pduPart);
        }
        if ((byArray2 = pduPart.getName()) != null) {
            String string3 = new String(byArray2);
            this.mPartMapByName.put(string3, pduPart);
        }
        if ((byArray = pduPart.getFilename()) != null) {
            String string4 = new String(byArray);
            this.mPartMapByFileName.put(string4, pduPart);
        }
    }

    public void addPart(int n, PduPart pduPart) {
        if (pduPart == null) {
            throw new NullPointerException();
        }
        this.putPartToMaps(pduPart);
        this.mParts.add(n, pduPart);
    }

    public boolean addPart(PduPart pduPart) {
        if (pduPart == null) {
            throw new NullPointerException();
        }
        this.putPartToMaps(pduPart);
        return this.mParts.add(pduPart);
    }

    public PduPart getPart(int n) {
        return this.mParts.get(n);
    }

    public PduPart getPartByContentId(String string2) {
        return this.mPartMapByContentId.get(string2);
    }

    public PduPart getPartByContentLocation(String string2) {
        return this.mPartMapByContentLocation.get(string2);
    }

    public PduPart getPartByFileName(String string2) {
        return this.mPartMapByFileName.get(string2);
    }

    public PduPart getPartByName(String string2) {
        return this.mPartMapByName.get(string2);
    }

    public int getPartIndex(PduPart pduPart) {
        return this.mParts.indexOf(pduPart);
    }

    public int getPartsNum() {
        return this.mParts.size();
    }

    public void removeAll() {
        this.mParts.clear();
    }

    public PduPart removePart(int n) {
        return this.mParts.remove(n);
    }
}

