/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.pdu;

import android.content.ContentResolver;
import android.content.Context;
import android.text.TextUtils;
import com.google.android.mms.pdu.EncodedStringValue;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.PduBody;
import com.google.android.mms.pdu.PduContentTypes;
import com.google.android.mms.pdu.PduHeaders;
import com.google.android.mms.pdu.PduPart;
import com.google.android.mms.pdu.SendReq;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;

public class PduComposer {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final int END_STRING_FLAG = 0;
    private static final int LENGTH_QUOTE = 31;
    private static final int LONG_INTEGER_LENGTH_MAX = 8;
    private static final int PDU_COMPOSER_BLOCK_SIZE = 1024;
    private static final int PDU_COMPOSE_CONTENT_ERROR = 1;
    private static final int PDU_COMPOSE_FIELD_NOT_SET = 2;
    private static final int PDU_COMPOSE_FIELD_NOT_SUPPORTED = 3;
    private static final int PDU_COMPOSE_SUCCESS = 0;
    private static final int PDU_EMAIL_ADDRESS_TYPE = 2;
    private static final int PDU_IPV4_ADDRESS_TYPE = 3;
    private static final int PDU_IPV6_ADDRESS_TYPE = 4;
    private static final int PDU_PHONE_NUMBER_ADDRESS_TYPE = 1;
    private static final int PDU_UNKNOWN_ADDRESS_TYPE = 5;
    private static final int QUOTED_STRING_FLAG = 34;
    static final String REGEXP_EMAIL_ADDRESS_TYPE = "[a-zA-Z| ]*\\<{0,1}[a-zA-Z| ]+@{1}[a-zA-Z| ]+\\.{1}[a-zA-Z| ]+\\>{0,1}";
    static final String REGEXP_IPV4_ADDRESS_TYPE = "[0-9]{1,3}\\.{1}[0-9]{1,3}\\.{1}[0-9]{1,3}\\.{1}[0-9]{1,3}";
    static final String REGEXP_IPV6_ADDRESS_TYPE = "[a-fA-F]{4}\\:{1}[a-fA-F0-9]{4}\\:{1}[a-fA-F0-9]{4}\\:{1}[a-fA-F0-9]{4}\\:{1}[a-fA-F0-9]{4}\\:{1}[a-fA-F0-9]{4}\\:{1}[a-fA-F0-9]{4}\\:{1}[a-fA-F0-9]{4}";
    static final String REGEXP_PHONE_NUMBER_ADDRESS_TYPE = "\\+?[0-9|\\.|\\-]+";
    private static final int SHORT_INTEGER_MAX = 127;
    static final String STRING_IPV4_ADDRESS_TYPE = "/TYPE=IPV4";
    static final String STRING_IPV6_ADDRESS_TYPE = "/TYPE=IPV6";
    static final String STRING_PHONE_NUMBER_ADDRESS_TYPE = "/TYPE=PLMN";
    private static final int TEXT_MAX = 127;
    private static HashMap<String, Integer> mContentTypeMap;
    protected ByteArrayOutputStream mMessage = null;
    private GenericPdu mPdu = null;
    private PduHeaders mPduHeader = null;
    protected int mPosition = 0;
    private final ContentResolver mResolver;
    private BufferStack mStack = null;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !PduComposer.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
        mContentTypeMap = null;
        mContentTypeMap = new HashMap();
        int n = 0;
        while (n < PduContentTypes.contentTypes.length) {
            mContentTypeMap.put(PduContentTypes.contentTypes[n], n);
            ++n;
        }
        return;
    }

    public PduComposer(Context context, GenericPdu genericPdu) {
        this.mPdu = genericPdu;
        this.mResolver = context.getContentResolver();
        this.mPduHeader = genericPdu.getPduHeaders();
        this.mStack = new BufferStack();
        this.mMessage = new ByteArrayOutputStream();
        this.mPosition = 0;
    }

    private EncodedStringValue appendAddressType(EncodedStringValue encodedStringValue) {
        EncodedStringValue encodedStringValue2;
        block9: {
            int n;
            block8: {
                try {
                    n = PduComposer.checkAddressType(encodedStringValue.getString());
                    encodedStringValue2 = EncodedStringValue.copy(encodedStringValue);
                    if (1 != n) break block8;
                }
                catch (NullPointerException nullPointerException) {
                    return null;
                }
                encodedStringValue2.appendTextString(STRING_PHONE_NUMBER_ADDRESS_TYPE.getBytes());
                break block9;
            }
            if (3 == n) {
                encodedStringValue2.appendTextString(STRING_IPV4_ADDRESS_TYPE.getBytes());
            } else if (4 == n) {
                encodedStringValue2.appendTextString(STRING_IPV6_ADDRESS_TYPE.getBytes());
            }
        }
        return encodedStringValue2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int appendHeader(int n) {
        switch (n) {
            default: {
                return 3;
            }
            case 141: {
                this.appendOctet(n);
                int n2 = this.mPduHeader.getOctet(n);
                if (n2 == 0) {
                    this.appendShortInteger(18);
                    return 0;
                }
                this.appendShortInteger(n2);
                return 0;
            }
            case 139: 
            case 152: {
                byte[] byArray = this.mPduHeader.getTextString(n);
                if (byArray == null) {
                    return 2;
                }
                this.appendOctet(n);
                this.appendTextString(byArray);
                return 0;
            }
            case 129: 
            case 130: 
            case 151: {
                int n3;
                EncodedStringValue[] encodedStringValueArray = this.mPduHeader.getEncodedStringValues(n);
                if (encodedStringValueArray == null) {
                    return 2;
                }
                int n4 = 0;
                while (n4 < (n3 = encodedStringValueArray.length)) {
                    EncodedStringValue encodedStringValue = this.appendAddressType(encodedStringValueArray[n4]);
                    if (encodedStringValue == null) {
                        return 1;
                    }
                    this.appendOctet(n);
                    this.appendEncodedString(encodedStringValue);
                    ++n4;
                }
                return 0;
            }
            case 137: {
                this.appendOctet(n);
                EncodedStringValue encodedStringValue = this.mPduHeader.getEncodedStringValue(n);
                if (encodedStringValue == null || TextUtils.isEmpty(encodedStringValue.getString()) || new String(encodedStringValue.getTextString()).equals("insert-address-token")) {
                    this.append(1);
                    this.append(129);
                    return 0;
                }
                this.mStack.newbuf();
                PositionMarker positionMarker = this.mStack.mark();
                this.append(128);
                EncodedStringValue encodedStringValue2 = this.appendAddressType(encodedStringValue);
                if (encodedStringValue2 == null) {
                    return 1;
                }
                this.appendEncodedString(encodedStringValue2);
                int n5 = positionMarker.getLength();
                this.mStack.pop();
                this.appendValueLength(n5);
                this.mStack.copy();
                return 0;
            }
            case 134: 
            case 143: 
            case 144: 
            case 145: 
            case 149: 
            case 155: {
                int n6 = this.mPduHeader.getOctet(n);
                if (n6 == 0) {
                    return 2;
                }
                this.appendOctet(n);
                this.appendOctet(n6);
                return 0;
            }
            case 133: {
                long l = this.mPduHeader.getLongInteger(n);
                if (-1L == l) {
                    return 2;
                }
                this.appendOctet(n);
                this.appendDateValue(l);
                return 0;
            }
            case 150: {
                EncodedStringValue encodedStringValue = this.mPduHeader.getEncodedStringValue(n);
                if (encodedStringValue == null) {
                    return 2;
                }
                this.appendOctet(n);
                this.appendEncodedString(encodedStringValue);
                return 0;
            }
            case 138: {
                byte[] byArray = this.mPduHeader.getTextString(n);
                if (byArray == null) {
                    return 2;
                }
                this.appendOctet(n);
                if (Arrays.equals(byArray, "advertisement".getBytes())) {
                    this.appendOctet(129);
                    return 0;
                }
                if (Arrays.equals(byArray, "auto".getBytes())) {
                    this.appendOctet(131);
                    return 0;
                }
                if (Arrays.equals(byArray, "personal".getBytes())) {
                    this.appendOctet(128);
                    return 0;
                }
                if (Arrays.equals(byArray, "informational".getBytes())) {
                    this.appendOctet(130);
                    return 0;
                }
                this.appendTextString(byArray);
                return 0;
            }
            case 136: 
        }
        long l = this.mPduHeader.getLongInteger(n);
        if (-1L == l) {
            return 2;
        }
        this.appendOctet(n);
        this.mStack.newbuf();
        PositionMarker positionMarker = this.mStack.mark();
        this.append(129);
        this.appendLongInteger(l);
        int n7 = positionMarker.getLength();
        this.mStack.pop();
        this.appendValueLength(n7);
        this.mStack.copy();
        return 0;
    }

    protected static int checkAddressType(String string2) {
        if (string2 == null) {
            return 5;
        }
        if (string2.matches(REGEXP_IPV4_ADDRESS_TYPE)) {
            return 3;
        }
        if (string2.matches(REGEXP_PHONE_NUMBER_ADDRESS_TYPE)) {
            return 1;
        }
        if (string2.matches(REGEXP_EMAIL_ADDRESS_TYPE)) {
            return 2;
        }
        if (string2.matches(REGEXP_IPV6_ADDRESS_TYPE)) {
            return 4;
        }
        return 5;
    }

    private int makeAckInd() {
        if (this.mMessage == null) {
            this.mMessage = new ByteArrayOutputStream();
            this.mPosition = 0;
        }
        this.appendOctet(140);
        this.appendOctet(133);
        if (this.appendHeader(152) != 0) {
            return 1;
        }
        if (this.appendHeader(141) != 0) {
            return 1;
        }
        this.appendHeader(145);
        return 0;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int makeMessageBody() {
        this.mStack.newbuf();
        PositionMarker positionMarker = this.mStack.mark();
        String string2 = new String(this.mPduHeader.getTextString(132));
        Integer n = mContentTypeMap.get(string2);
        if (n == null) {
            return 1;
        }
        this.appendShortInteger(n);
        PduBody pduBody = ((SendReq)this.mPdu).getBody();
        if (pduBody == null || pduBody.getPartsNum() == 0) {
            this.appendUintvarInteger(0L);
            this.mStack.pop();
            this.mStack.copy();
            return 0;
        }
        try {
            PduPart pduPart = pduBody.getPart(0);
            byte[] byArray = pduPart.getContentId();
            if (byArray != null) {
                this.appendOctet(138);
                if (60 == byArray[0] && 62 == byArray[byArray.length - 1]) {
                    this.appendTextString(byArray);
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("<");
                    String string3 = new String(byArray);
                    this.appendTextString(stringBuilder.append(string3).append(">").toString());
                }
            }
            this.appendOctet(137);
            this.appendTextString(pduPart.getContentType());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
        int n2 = positionMarker.getLength();
        this.mStack.pop();
        this.appendValueLength(n2);
        this.mStack.copy();
        int n3 = pduBody.getPartsNum();
        this.appendUintvarInteger(n3);
        int n4 = 0;
        while (true) {
            int n5;
            int n6;
            block27: {
                int n7;
                byte[] byArray;
                byte[] byArray2;
                if (n4 >= n3) {
                    return 0;
                }
                PduPart pduPart = pduBody.getPart(n4);
                this.mStack.newbuf();
                PositionMarker positionMarker2 = this.mStack.mark();
                this.mStack.newbuf();
                PositionMarker positionMarker3 = this.mStack.mark();
                byte[] byArray3 = pduPart.getContentType();
                if (byArray3 == null) {
                    return 1;
                }
                HashMap<String, Integer> hashMap = mContentTypeMap;
                String string4 = new String(byArray3);
                Integer n8 = hashMap.get(string4);
                if (n8 == null) {
                    this.appendTextString(byArray3);
                } else {
                    this.appendShortInteger(n8);
                }
                if ((byArray2 = pduPart.getName()) == null && (byArray2 = pduPart.getFilename()) == null && (byArray2 = pduPart.getContentLocation()) == null) {
                    return 1;
                }
                this.appendOctet(133);
                this.appendTextString(byArray2);
                int n9 = pduPart.getCharset();
                if (n9 != 0) {
                    this.appendOctet(129);
                    this.appendShortInteger(n9);
                }
                int n10 = positionMarker3.getLength();
                this.mStack.pop();
                this.appendValueLength(n10);
                this.mStack.copy();
                byte[] byArray4 = pduPart.getContentId();
                if (byArray4 != null) {
                    this.appendOctet(192);
                    if (60 == byArray4[0] && 62 == byArray4[byArray4.length - 1]) {
                        this.appendQuotedString(byArray4);
                    } else {
                        StringBuilder stringBuilder = new StringBuilder().append("<");
                        String string5 = new String(byArray4);
                        this.appendQuotedString(stringBuilder.append(string5).append(">").toString());
                    }
                }
                if ((byArray = pduPart.getContentLocation()) != null) {
                    this.appendOctet(142);
                    this.appendTextString(byArray);
                }
                n6 = positionMarker2.getLength();
                n5 = 0;
                byte[] byArray5 = pduPart.getData();
                if (byArray5 != null) {
                    this.arraycopy(byArray5, 0, byArray5.length);
                    n5 = byArray5.length;
                } else {
                    int n11;
                    byte[] byArray6 = new byte[1024];
                    InputStream inputStream = this.mResolver.openInputStream(pduPart.getDataUri());
                    while ((n11 = inputStream.read(byArray6)) != -1) {
                        this.mMessage.write(byArray6, 0, n11);
                        this.mPosition = n11 + this.mPosition;
                        n5 += n11;
                    }
                }
                if (n5 != (n7 = positionMarker2.getLength() - n6)) {
                    throw new RuntimeException("BUG: Length sanity check failed");
                }
                break block27;
                catch (FileNotFoundException fileNotFoundException) {
                    return 1;
                }
                catch (IOException iOException) {
                    return 1;
                }
                catch (RuntimeException runtimeException) {
                    return 1;
                }
            }
            this.mStack.pop();
            this.appendUintvarInteger(n6);
            this.appendUintvarInteger(n5);
            this.mStack.copy();
            ++n4;
        }
    }

    private int makeNotifyResp() {
        if (this.mMessage == null) {
            this.mMessage = new ByteArrayOutputStream();
            this.mPosition = 0;
        }
        this.appendOctet(140);
        this.appendOctet(131);
        if (this.appendHeader(152) != 0) {
            return 1;
        }
        if (this.appendHeader(141) != 0) {
            return 1;
        }
        if (this.appendHeader(149) != 0) {
            return 1;
        }
        return 0;
    }

    private int makeReadRecInd() {
        if (this.mMessage == null) {
            this.mMessage = new ByteArrayOutputStream();
            this.mPosition = 0;
        }
        this.appendOctet(140);
        this.appendOctet(135);
        if (this.appendHeader(141) != 0) {
            return 1;
        }
        if (this.appendHeader(139) != 0) {
            return 1;
        }
        if (this.appendHeader(151) != 0) {
            return 1;
        }
        if (this.appendHeader(137) != 0) {
            return 1;
        }
        this.appendHeader(133);
        if (this.appendHeader(155) != 0) {
            return 1;
        }
        return 0;
    }

    private int makeSendReqPdu() {
        if (this.mMessage == null) {
            this.mMessage = new ByteArrayOutputStream();
            this.mPosition = 0;
        }
        this.appendOctet(140);
        this.appendOctet(128);
        this.appendOctet(152);
        byte[] byArray = this.mPduHeader.getTextString(152);
        if (byArray == null) {
            throw new IllegalArgumentException("Transaction-ID is null.");
        }
        this.appendTextString(byArray);
        if (this.appendHeader(141) != 0) {
            return 1;
        }
        this.appendHeader(133);
        if (this.appendHeader(137) != 0) {
            return 1;
        }
        int n = this.appendHeader(151);
        boolean bl = false;
        if (n != 1) {
            bl = true;
        }
        if (this.appendHeader(130) != 1) {
            bl = true;
        }
        if (this.appendHeader(129) != 1) {
            bl = true;
        }
        if (!bl) {
            return 1;
        }
        this.appendHeader(150);
        this.appendHeader(138);
        this.appendHeader(136);
        this.appendHeader(143);
        this.appendHeader(134);
        this.appendHeader(144);
        this.appendOctet(132);
        this.makeMessageBody();
        return 0;
    }

    protected void append(int n) {
        this.mMessage.write(n);
        this.mPosition = 1 + this.mPosition;
    }

    protected void appendDateValue(long l) {
        this.appendLongInteger(l);
    }

    protected void appendEncodedString(EncodedStringValue encodedStringValue) {
        if (!$assertionsDisabled && encodedStringValue == null) {
            throw new AssertionError();
        }
        int n = encodedStringValue.getCharacterSet();
        byte[] byArray = encodedStringValue.getTextString();
        if (byArray == null) {
            return;
        }
        this.mStack.newbuf();
        PositionMarker positionMarker = this.mStack.mark();
        this.appendShortInteger(n);
        this.appendTextString(byArray);
        int n2 = positionMarker.getLength();
        this.mStack.pop();
        this.appendValueLength(n2);
        this.mStack.copy();
    }

    protected void appendLongInteger(long l) {
        int n;
        long l2 = l;
        for (n = 0; l2 != 0L && n < 8; l2 >>>= 8, ++n) {
        }
        this.appendShortLength(n);
        int n2 = 8 * (n - 1);
        for (int i = 0; i < n; ++i) {
            this.append((int)(0xFFL & l >>> n2));
            n2 -= 8;
        }
    }

    protected void appendOctet(int n) {
        this.append(n);
    }

    protected void appendQuotedString(String string2) {
        this.appendQuotedString(string2.getBytes());
    }

    protected void appendQuotedString(byte[] byArray) {
        this.append(34);
        this.arraycopy(byArray, 0, byArray.length);
        this.append(0);
    }

    protected void appendShortInteger(int n) {
        this.append(0xFF & (n | 0x80));
    }

    protected void appendShortLength(int n) {
        this.append(n);
    }

    protected void appendTextString(String string2) {
        this.appendTextString(string2.getBytes());
    }

    protected void appendTextString(byte[] byArray) {
        if ((0xFF & byArray[0]) > 127) {
            this.append(127);
        }
        this.arraycopy(byArray, 0, byArray.length);
        this.append(0);
    }

    protected void appendUintvarInteger(long l) {
        long l2 = 127L;
        int n = 0;
        while (true) {
            if (n >= 5 || l < l2) {
                while (n > 0) {
                    this.append((int)(0xFFL & (0x80L | 0x7FL & l >>> n * 7)));
                    --n;
                }
                break;
            }
            l2 = 0x7FL | l2 << 7;
            ++n;
        }
        this.append((int)(l & 0x7FL));
    }

    protected void appendValueLength(long l) {
        if (l < 31L) {
            this.appendShortLength((int)l);
            return;
        }
        this.append(31);
        this.appendUintvarInteger(l);
    }

    protected void arraycopy(byte[] byArray, int n, int n2) {
        this.mMessage.write(byArray, n, n2);
        this.mPosition = n2 + this.mPosition;
    }

    public byte[] make() {
        switch (this.mPdu.getMessageType()) {
            default: {
                return null;
            }
            case 128: {
                if (this.makeSendReqPdu() == 0) break;
                return null;
            }
            case 131: {
                if (this.makeNotifyResp() == 0) break;
                return null;
            }
            case 133: {
                if (this.makeAckInd() == 0) break;
                return null;
            }
            case 135: {
                if (this.makeReadRecInd() == 0) break;
                return null;
            }
        }
        return this.mMessage.toByteArray();
    }

    private class BufferStack {
        private LengthRecordNode stack = null;
        int stackSize = 0;
        private LengthRecordNode toCopy = null;

        private BufferStack() {
        }

        void copy() {
            PduComposer.this.arraycopy(this.toCopy.currentMessage.toByteArray(), 0, this.toCopy.currentPosition);
            this.toCopy = null;
        }

        PositionMarker mark() {
            PositionMarker positionMarker = new PositionMarker();
            PositionMarker.access$402(positionMarker, PduComposer.this.mPosition);
            PositionMarker.access$502(positionMarker, this.stackSize);
            return positionMarker;
        }

        void newbuf() {
            if (this.toCopy != null) {
                throw new RuntimeException("BUG: Invalid newbuf() before copy()");
            }
            LengthRecordNode lengthRecordNode = new LengthRecordNode();
            lengthRecordNode.currentMessage = PduComposer.this.mMessage;
            lengthRecordNode.currentPosition = PduComposer.this.mPosition;
            lengthRecordNode.next = this.stack;
            this.stack = lengthRecordNode;
            this.stackSize = 1 + this.stackSize;
            PduComposer.this.mMessage = new ByteArrayOutputStream();
            PduComposer.this.mPosition = 0;
        }

        void pop() {
            ByteArrayOutputStream byteArrayOutputStream = PduComposer.this.mMessage;
            int n = PduComposer.this.mPosition;
            PduComposer.this.mMessage = this.stack.currentMessage;
            PduComposer.this.mPosition = this.stack.currentPosition;
            this.toCopy = this.stack;
            this.stack = this.stack.next;
            --this.stackSize;
            this.toCopy.currentMessage = byteArrayOutputStream;
            this.toCopy.currentPosition = n;
        }
    }

    private static class LengthRecordNode {
        ByteArrayOutputStream currentMessage = null;
        public int currentPosition = 0;
        public LengthRecordNode next = null;

        private LengthRecordNode() {
        }
    }

    private class PositionMarker {
        private int c_pos;
        private int currentStackSize;

        private PositionMarker() {
        }

        static /* synthetic */ int access$402(PositionMarker positionMarker, int n) {
            positionMarker.c_pos = n;
            return n;
        }

        static /* synthetic */ int access$502(PositionMarker positionMarker, int n) {
            positionMarker.currentStackSize = n;
            return n;
        }

        int getLength() {
            if (this.currentStackSize != ((PduComposer)PduComposer.this).mStack.stackSize) {
                throw new RuntimeException("BUG: Invalid call to getLength()");
            }
            return PduComposer.this.mPosition - this.c_pos;
        }
    }
}

