/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.pdu;

import android.util.Log;
import com.google.android.mms.InvalidHeaderValueException;
import com.google.android.mms.pdu.AcknowledgeInd;
import com.google.android.mms.pdu.Base64;
import com.google.android.mms.pdu.CharacterSets;
import com.google.android.mms.pdu.DeliveryInd;
import com.google.android.mms.pdu.EncodedStringValue;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.NotificationInd;
import com.google.android.mms.pdu.NotifyRespInd;
import com.google.android.mms.pdu.PduBody;
import com.google.android.mms.pdu.PduContentTypes;
import com.google.android.mms.pdu.PduHeaders;
import com.google.android.mms.pdu.PduPart;
import com.google.android.mms.pdu.QuotedPrintable;
import com.google.android.mms.pdu.ReadOrigInd;
import com.google.android.mms.pdu.ReadRecInd;
import com.google.android.mms.pdu.RetrieveConf;
import com.google.android.mms.pdu.SendConf;
import com.google.android.mms.pdu.SendReq;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;

public class PduParser {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final boolean DEBUG = false;
    private static final int END_STRING_FLAG = 0;
    private static final int LENGTH_QUOTE = 31;
    private static final boolean LOCAL_LOGV = false;
    private static final String LOG_TAG = "PduParser";
    private static final int LONG_INTEGER_LENGTH_MAX = 8;
    private static final int QUOTE = 127;
    private static final int QUOTED_STRING_FLAG = 34;
    private static final int SHORT_INTEGER_MAX = 127;
    private static final int SHORT_LENGTH_MAX = 30;
    private static final int TEXT_MAX = 127;
    private static final int TEXT_MIN = 32;
    private static final int THE_FIRST_PART = 0;
    private static final int THE_LAST_PART = 1;
    private static final int TYPE_QUOTED_STRING = 1;
    private static final int TYPE_TEXT_STRING = 0;
    private static final int TYPE_TOKEN_STRING = 2;
    private static byte[] mStartParam;
    private static byte[] mTypeParam;
    private PduBody mBody = null;
    private PduHeaders mHeaders = null;
    private ByteArrayInputStream mPduDataStream = null;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !PduParser.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
        mTypeParam = null;
        mStartParam = null;
    }

    public PduParser(byte[] byArray) {
        this.mPduDataStream = new ByteArrayInputStream(byArray);
    }

    protected static boolean checkMandatoryHeader(PduHeaders pduHeaders) {
        if (pduHeaders == null) {
            return false;
        }
        int n = pduHeaders.getOctet(140);
        if (pduHeaders.getOctet(141) == 0) {
            return false;
        }
        switch (n) {
            default: {
                return false;
            }
            case 128: {
                if (pduHeaders.getTextString(132) == null) {
                    return false;
                }
                if (pduHeaders.getEncodedStringValue(137) == null) {
                    return false;
                }
                if (pduHeaders.getTextString(152) != null) break;
                return false;
            }
            case 129: {
                if (pduHeaders.getOctet(146) == 0) {
                    return false;
                }
                if (pduHeaders.getTextString(152) != null) break;
                return false;
            }
            case 130: {
                if (pduHeaders.getTextString(131) == null) {
                    return false;
                }
                if (-1L == pduHeaders.getLongInteger(136)) {
                    return false;
                }
                if (pduHeaders.getTextString(138) == null) {
                    return false;
                }
                if (-1L == pduHeaders.getLongInteger(142)) {
                    return false;
                }
                if (pduHeaders.getTextString(152) != null) break;
                return false;
            }
            case 131: {
                if (pduHeaders.getOctet(149) == 0) {
                    return false;
                }
                if (pduHeaders.getTextString(152) != null) break;
                return false;
            }
            case 132: {
                if (pduHeaders.getTextString(132) == null) {
                    return false;
                }
                if (-1L != pduHeaders.getLongInteger(133)) break;
                return false;
            }
            case 134: {
                if (-1L == pduHeaders.getLongInteger(133)) {
                    return false;
                }
                if (pduHeaders.getTextString(139) == null) {
                    return false;
                }
                if (pduHeaders.getOctet(149) == 0) {
                    return false;
                }
                if (pduHeaders.getEncodedStringValues(151) != null) break;
                return false;
            }
            case 133: {
                if (pduHeaders.getTextString(152) != null) break;
                return false;
            }
            case 136: {
                if (-1L == pduHeaders.getLongInteger(133)) {
                    return false;
                }
                if (pduHeaders.getEncodedStringValue(137) == null) {
                    return false;
                }
                if (pduHeaders.getTextString(139) == null) {
                    return false;
                }
                if (pduHeaders.getOctet(155) == 0) {
                    return false;
                }
                if (pduHeaders.getEncodedStringValues(151) != null) break;
                return false;
            }
            case 135: {
                if (pduHeaders.getEncodedStringValue(137) == null) {
                    return false;
                }
                if (pduHeaders.getTextString(139) == null) {
                    return false;
                }
                if (pduHeaders.getOctet(155) == 0) {
                    return false;
                }
                if (pduHeaders.getEncodedStringValues(151) != null) break;
                return false;
            }
        }
        return true;
    }

    private static int checkPartPosition(PduPart pduPart) {
        byte[] byArray;
        byte[] byArray2;
        if (!$assertionsDisabled && pduPart == null) {
            throw new AssertionError();
        }
        if (mTypeParam == null && mStartParam == null) {
            return 1;
        }
        if (mStartParam != null && (byArray2 = pduPart.getContentId()) != null && Arrays.equals(mStartParam, byArray2)) {
            return 0;
        }
        if (mTypeParam != null && (byArray = pduPart.getContentType()) != null && Arrays.equals(mTypeParam, byArray)) {
            return 0;
        }
        return 1;
    }

    protected static int extractByteValue(ByteArrayInputStream byteArrayInputStream) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        int n = byteArrayInputStream.read();
        if (!$assertionsDisabled && -1 == n) {
            throw new AssertionError();
        }
        return n & 0xFF;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static byte[] getWapString(ByteArrayInputStream byteArrayInputStream, int n) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = byteArrayInputStream.read();
        if (!$assertionsDisabled && -1 == n2) {
            throw new AssertionError();
        }
        while (-1 != n2 && n2 != 0) {
            if (n == 2) {
                if (PduParser.isTokenCharacter(n2)) {
                    byteArrayOutputStream.write(n2);
                }
            } else if (PduParser.isText(n2)) {
                byteArrayOutputStream.write(n2);
            }
            n2 = byteArrayInputStream.read();
            if (!$assertionsDisabled && -1 == n2) {
                throw new AssertionError();
            }
        }
        if (byteArrayOutputStream.size() > 0) {
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    protected static boolean isText(int n) {
        if (n >= 32 && n <= 126 || n >= 128 && n <= 255) {
            return true;
        }
        switch (n) {
            default: {
                return false;
            }
            case 9: 
            case 10: 
            case 13: 
        }
        return true;
    }

    protected static boolean isTokenCharacter(int n) {
        if (n < 33 || n > 126) {
            return false;
        }
        switch (n) {
            default: {
                return true;
            }
            case 34: 
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 91: 
            case 92: 
            case 93: 
            case 123: 
            case 125: 
        }
        return false;
    }

    private static void log(String string2) {
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static byte[] parseContentType(ByteArrayInputStream byteArrayInputStream, HashMap<Integer, Object> hashMap) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        byteArrayInputStream.mark(1);
        int n = byteArrayInputStream.read();
        if (!$assertionsDisabled && -1 == n) {
            throw new AssertionError();
        }
        byteArrayInputStream.reset();
        int n2 = n & 0xFF;
        if (n2 < 32) {
            int n3;
            byte[] byArray;
            int n4 = PduParser.parseValueLength(byteArrayInputStream);
            int n5 = byteArrayInputStream.available();
            byteArrayInputStream.mark(1);
            int n6 = byteArrayInputStream.read();
            if (!$assertionsDisabled && -1 == n6) {
                throw new AssertionError();
            }
            byteArrayInputStream.reset();
            int n7 = n6 & 0xFF;
            if (n7 >= 32 && n7 <= 127) {
                byArray = PduParser.parseWapString(byteArrayInputStream, 0);
            } else {
                if (n7 <= 127) {
                    Log.e(LOG_TAG, "Corrupt content-type");
                    return PduContentTypes.contentTypes[0].getBytes();
                }
                int n8 = PduParser.parseShortInteger(byteArrayInputStream);
                if (n8 < PduContentTypes.contentTypes.length) {
                    byArray = PduContentTypes.contentTypes[n8].getBytes();
                } else {
                    byteArrayInputStream.reset();
                    byArray = PduParser.parseWapString(byteArrayInputStream, 0);
                }
            }
            if ((n3 = n4 - (n5 - byteArrayInputStream.available())) > 0) {
                PduParser.parseContentTypeParams(byteArrayInputStream, hashMap, n3);
            }
            if (n3 >= 0) return byArray;
            Log.e(LOG_TAG, "Corrupt MMS message");
            return PduContentTypes.contentTypes[0].getBytes();
        }
        if (n2 > 127) return PduContentTypes.contentTypes[PduParser.parseShortInteger(byteArrayInputStream)].getBytes();
        return PduParser.parseWapString(byteArrayInputStream, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void parseContentTypeParams(ByteArrayInputStream byteArrayInputStream, HashMap<Integer, Object> hashMap, Integer n) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        int n2 = byteArrayInputStream.available();
        int n3 = n;
        int n4 = 0;
        while (n3 > 0) {
            int n5;
            block22: {
                int n6 = byteArrayInputStream.read();
                if (!$assertionsDisabled && -1 == n6) {
                    throw new AssertionError();
                }
                --n3;
                switch (n6) {
                    default: {
                        if (-1 != PduParser.skipWapValue(byteArrayInputStream, n3)) break;
                        Log.e(LOG_TAG, "Corrupt Content-Type");
                        n5 = n4;
                        break block22;
                    }
                    case 131: 
                    case 137: {
                        byteArrayInputStream.mark(1);
                        int n7 = PduParser.extractByteValue(byteArrayInputStream);
                        byteArrayInputStream.reset();
                        if (n7 > 127) {
                            int n8 = PduParser.parseShortInteger(byteArrayInputStream);
                            if (n8 < PduContentTypes.contentTypes.length) {
                                byte[] byArray = PduContentTypes.contentTypes[n8].getBytes();
                                hashMap.put(131, byArray);
                            }
                        } else {
                            byte[] byArray = PduParser.parseWapString(byteArrayInputStream, 0);
                            if (byArray != null && hashMap != null) {
                                hashMap.put(131, byArray);
                            }
                        }
                        n5 = byteArrayInputStream.available();
                        n3 = n - (n2 - n5);
                        break block22;
                    }
                    case 138: 
                    case 153: {
                        byte[] byArray = PduParser.parseWapString(byteArrayInputStream, 0);
                        if (byArray != null && hashMap != null) {
                            hashMap.put(153, byArray);
                        }
                        n5 = byteArrayInputStream.available();
                        n3 = n - (n2 - n5);
                        break block22;
                    }
                    case 129: {
                        byteArrayInputStream.mark(1);
                        int n9 = PduParser.extractByteValue(byteArrayInputStream);
                        byteArrayInputStream.reset();
                        if (n9 > 32 && n9 < 127 || n9 == 0) {
                            byte[] byArray = PduParser.parseWapString(byteArrayInputStream, 0);
                            try {
                                int n10 = CharacterSets.getMibEnumValue(new String(byArray));
                                hashMap.put(129, n10);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                Log.e(LOG_TAG, Arrays.toString(byArray), unsupportedEncodingException);
                                hashMap.put(129, 0);
                            }
                        } else {
                            int n11 = (int)PduParser.parseIntegerValue(byteArrayInputStream);
                            if (hashMap != null) {
                                hashMap.put(129, n11);
                            }
                        }
                        n5 = byteArrayInputStream.available();
                        n3 = n - (n2 - n5);
                        break block22;
                    }
                    case 133: 
                    case 151: {
                        byte[] byArray = PduParser.parseWapString(byteArrayInputStream, 0);
                        if (byArray != null && hashMap != null) {
                            hashMap.put(151, byArray);
                        }
                        n5 = byteArrayInputStream.available();
                        n3 = n - (n2 - n5);
                        break block22;
                    }
                }
                n5 = n4;
                n3 = 0;
            }
            n4 = n5;
        }
        if (n3 != 0) {
            Log.e(LOG_TAG, "Corrupt Content-Type");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static EncodedStringValue parseEncodedStringValue(ByteArrayInputStream byteArrayInputStream) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        byteArrayInputStream.mark(1);
        int n = byteArrayInputStream.read();
        if (!$assertionsDisabled && -1 == n) {
            throw new AssertionError();
        }
        int n2 = n & 0xFF;
        byteArrayInputStream.reset();
        int n3 = 0;
        if (n2 < 32) {
            PduParser.parseValueLength(byteArrayInputStream);
            n3 = PduParser.parseShortInteger(byteArrayInputStream);
        }
        byte[] byArray = PduParser.parseWapString(byteArrayInputStream, 0);
        EncodedStringValue encodedStringValue = new EncodedStringValue(byArray);
        if (n3 == 0) return encodedStringValue;
        try {
            return new EncodedStringValue(n3, byArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static long parseIntegerValue(ByteArrayInputStream byteArrayInputStream) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        byteArrayInputStream.mark(1);
        int n = byteArrayInputStream.read();
        if (!$assertionsDisabled && -1 == n) {
            throw new AssertionError();
        }
        byteArrayInputStream.reset();
        if (n > 127) {
            return PduParser.parseShortInteger(byteArrayInputStream);
        }
        return PduParser.parseLongInteger(byteArrayInputStream);
    }

    protected static long parseLongInteger(ByteArrayInputStream byteArrayInputStream) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        int n = byteArrayInputStream.read();
        if (!$assertionsDisabled && -1 == n) {
            throw new AssertionError();
        }
        int n2 = n & 0xFF;
        if (n2 > 8) {
            throw new RuntimeException("Octet count greater than 8 and I can't represent that!");
        }
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            int n3 = byteArrayInputStream.read();
            if (!$assertionsDisabled && -1 == n3) {
                throw new AssertionError();
            }
            l = (l << 8) + (long)(n3 & 0xFF);
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static boolean parsePartHeaders(ByteArrayInputStream byteArrayInputStream, PduPart pduPart, int n) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && pduPart == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        int n2 = byteArrayInputStream.available();
        int n3 = 0;
        int n4 = n;
        while (n4 > 0) {
            int n5;
            int n6;
            block27: {
                int n7;
                int n8;
                block26: {
                    n8 = byteArrayInputStream.read();
                    if (!$assertionsDisabled && -1 == n8) {
                        throw new AssertionError();
                    }
                    n7 = n4 - 1;
                    if (n8 <= 127) break block26;
                    switch (n8) {
                        default: {
                            if (-1 != PduParser.skipWapValue(byteArrayInputStream, n7)) break;
                            Log.e(LOG_TAG, "Corrupt Part headers");
                            return false;
                        }
                        case 142: {
                            byte[] byArray = PduParser.parseWapString(byteArrayInputStream, 0);
                            if (byArray != null) {
                                pduPart.setContentLocation(byArray);
                            }
                            n6 = byteArrayInputStream.available();
                            n5 = n - (n2 - n6);
                            break block27;
                        }
                        case 192: {
                            byte[] byArray = PduParser.parseWapString(byteArrayInputStream, 1);
                            if (byArray != null) {
                                pduPart.setContentId(byArray);
                            }
                            n6 = byteArrayInputStream.available();
                            n5 = n - (n2 - n6);
                            break block27;
                        }
                        case 174: 
                        case 197: {
                            int n9 = PduParser.parseValueLength(byteArrayInputStream);
                            byteArrayInputStream.mark(1);
                            int n10 = byteArrayInputStream.available();
                            int n11 = byteArrayInputStream.read();
                            if (n11 == 128) {
                                pduPart.setContentDisposition(PduPart.DISPOSITION_FROM_DATA);
                            } else if (n11 == 129) {
                                pduPart.setContentDisposition(PduPart.DISPOSITION_ATTACHMENT);
                            } else if (n11 == 130) {
                                pduPart.setContentDisposition(PduPart.DISPOSITION_INLINE);
                            } else {
                                byteArrayInputStream.reset();
                                pduPart.setContentDisposition(PduParser.parseWapString(byteArrayInputStream, 0));
                            }
                            if (n10 - byteArrayInputStream.available() < n9) {
                                int n12;
                                if (byteArrayInputStream.read() == 152) {
                                    pduPart.setFilename(PduParser.parseWapString(byteArrayInputStream, 0));
                                }
                                if (n10 - (n12 = byteArrayInputStream.available()) < n9) {
                                    int n13 = n9 - (n10 - n12);
                                    byteArrayInputStream.read(new byte[n13], 0, n13);
                                }
                            }
                            n6 = byteArrayInputStream.available();
                            n5 = n - (n2 - n6);
                            break block27;
                        }
                    }
                    n6 = n3;
                    n5 = 0;
                    break block27;
                }
                if (n8 >= 32 && n8 <= 127) {
                    byte[] byArray = PduParser.parseWapString(byteArrayInputStream, 0);
                    byte[] byArray2 = PduParser.parseWapString(byteArrayInputStream, 0);
                    if ("Content-Transfer-Encoding".equalsIgnoreCase(new String(byArray))) {
                        pduPart.setContentTransferEncoding(byArray2);
                    }
                    n6 = byteArrayInputStream.available();
                    n5 = n - (n2 - n6);
                } else {
                    if (-1 == PduParser.skipWapValue(byteArrayInputStream, n7)) {
                        Log.e(LOG_TAG, "Corrupt Part headers");
                        return false;
                    }
                    n6 = n3;
                    n5 = 0;
                }
            }
            n3 = n6;
            n4 = n5;
        }
        if (n4 != 0) {
            Log.e(LOG_TAG, "Corrupt Part headers");
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected static PduBody parseParts(ByteArrayInputStream var0) {
        block15: {
            if (var0 == null) {
                return null;
            }
            var1_1 = PduParser.parseUnsignedInt(var0);
            var2_2 = new PduBody();
            block0: for (var3_3 = 0; var3_3 < var1_1; ++var3_3) {
                block19: {
                    block17: {
                        block16: {
                            block18: {
                                var4_4 = PduParser.parseUnsignedInt(var0);
                                var5_5 = PduParser.parseUnsignedInt(var0);
                                var6_6 = new PduPart();
                                var7_7 = var0.available();
                                if (var7_7 <= 0) {
                                    return null;
                                }
                                var8_8 = new HashMap<Integer, Object>();
                                var9_9 = PduParser.parseContentType(var0, var8_8);
                                if (var9_9 != null) {
                                    var6_6.setContentType(var9_9);
lbl16:
                                    // 2 sources

                                    while (true) {
                                        var10_10 = (byte[])var8_8.get(151);
                                        if (var10_10 != null) {
                                            var6_6.setName(var10_10);
                                        }
                                        if ((var11_11 = (Integer)var8_8.get(129)) != null) {
                                            var6_6.setCharset(var11_11);
                                        }
                                        if ((var12_12 = var4_4 - (var7_7 - var0.available())) > 0 ? PduParser.parsePartHeaders(var0, var6_6, var12_12) == false : var12_12 < 0) {
                                            return null;
                                        }
                                        break;
                                    }
                                } else {
                                    var6_6.setContentType(PduContentTypes.contentTypes[0].getBytes());
                                    ** continue;
                                }
                                if (var6_6.getContentLocation() == null && var6_6.getName() == null && var6_6.getFilename() == null && var6_6.getContentId() == null) {
                                    var6_6.setContentLocation(Long.toOctalString(System.currentTimeMillis()).getBytes());
                                }
                                if (var5_5 <= 0) break block17;
                                var15_14 = new byte[var5_5];
                                var16_15 = new String(var6_6.getContentType());
                                var0.read(var15_14, 0, var5_5);
                                if (!var16_15.equalsIgnoreCase("application/vnd.wap.multipart.alternative")) break block18;
                                var13_13 = PduParser.parseParts(new ByteArrayInputStream(var15_14)).getPart(0);
lbl36:
                                // 2 sources

                                while (PduParser.checkPartPosition(var13_13) == 0) {
                                    var2_2.addPart(0, var13_13);
lbl38:
                                    // 2 sources

                                    continue block0;
                                }
                                break block19;
                            }
                            var18_16 = var6_6.getContentTransferEncoding();
                            if (var18_16 == null) break block15;
                            var19_17 = new String(var18_16);
                            if (var19_17.equalsIgnoreCase("base64")) {
                                var20_18 = Base64.decodeBase64(var15_14);
lbl47:
                                // 3 sources

                                while (true) {
                                    if (var20_18 == null) {
                                        PduParser.log("Decode part data error!");
                                        return null;
                                    }
                                    break block16;
                                    break;
                                }
                            }
                            if (!var19_17.equalsIgnoreCase("quoted-printable")) break block15;
                            var20_18 = QuotedPrintable.decodeQuotedPrintable(var15_14);
                            ** GOTO lbl47
                        }
                        var6_6.setData(var20_18);
                    }
                    var13_13 = var6_6;
                    ** GOTO lbl36
                }
                var2_2.addPart(var13_13);
                ** continue;
            }
            return var2_2;
        }
        var20_18 = var15_14;
        ** while (true)
    }

    protected static int parseShortInteger(ByteArrayInputStream byteArrayInputStream) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        int n = byteArrayInputStream.read();
        if (!$assertionsDisabled && -1 == n) {
            throw new AssertionError();
        }
        return n & 0x7F;
    }

    protected static int parseUnsignedInt(ByteArrayInputStream byteArrayInputStream) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        int n = byteArrayInputStream.read();
        int n2 = 0;
        if (n == -1) {
            return n;
        }
        while ((n & 0x80) != 0) {
            n2 = n2 << 7 | n & 0x7F;
            n = byteArrayInputStream.read();
            if (n != -1) continue;
            return n;
        }
        return n2 << 7 | n & 0x7F;
    }

    protected static int parseValueLength(ByteArrayInputStream byteArrayInputStream) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        int n = byteArrayInputStream.read();
        if (!$assertionsDisabled && -1 == n) {
            throw new AssertionError();
        }
        int n2 = n & 0xFF;
        if (n2 <= 30) {
            return n2;
        }
        if (n2 == 31) {
            return PduParser.parseUnsignedInt(byteArrayInputStream);
        }
        throw new RuntimeException("Value length > LENGTH_QUOTE!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static byte[] parseWapString(ByteArrayInputStream byteArrayInputStream, int n) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        byteArrayInputStream.mark(1);
        int n2 = byteArrayInputStream.read();
        if (!$assertionsDisabled && -1 == n2) {
            throw new AssertionError();
        }
        if (1 == n && 34 == n2) {
            byteArrayInputStream.mark(1);
            return PduParser.getWapString(byteArrayInputStream, n);
        }
        if (n == 0 && 127 == n2) {
            byteArrayInputStream.mark(1);
            return PduParser.getWapString(byteArrayInputStream, n);
        }
        byteArrayInputStream.reset();
        return PduParser.getWapString(byteArrayInputStream, n);
    }

    protected static int skipWapValue(ByteArrayInputStream byteArrayInputStream, int n) {
        if (!$assertionsDisabled && byteArrayInputStream == null) {
            throw new AssertionError();
        }
        int n2 = byteArrayInputStream.read(new byte[n], 0, n);
        if (n2 < n) {
            return -1;
        }
        return n2;
    }

    public GenericPdu parse() {
        if (this.mPduDataStream == null) {
            return null;
        }
        this.mHeaders = this.parseHeaders(this.mPduDataStream);
        if (this.mHeaders == null) {
            return null;
        }
        int n = this.mHeaders.getOctet(140);
        if (!PduParser.checkMandatoryHeader(this.mHeaders)) {
            PduParser.log("check mandatory headers failed!");
            return null;
        }
        if (128 == n || 132 == n) {
            this.mBody = PduParser.parseParts(this.mPduDataStream);
            if (this.mBody == null) {
                return null;
            }
        }
        switch (n) {
            default: {
                PduParser.log("Parser doesn't support this message type in this version!");
                return null;
            }
            case 128: {
                return new SendReq(this.mHeaders, this.mBody);
            }
            case 129: {
                return new SendConf(this.mHeaders);
            }
            case 130: {
                return new NotificationInd(this.mHeaders);
            }
            case 131: {
                return new NotifyRespInd(this.mHeaders);
            }
            case 132: {
                RetrieveConf retrieveConf = new RetrieveConf(this.mHeaders, this.mBody);
                byte[] byArray = retrieveConf.getContentType();
                if (byArray == null) {
                    return null;
                }
                String string2 = new String(byArray);
                if (string2.equals("application/vnd.wap.multipart.mixed") || string2.equals("application/vnd.wap.multipart.related") || string2.equals("application/vnd.wap.multipart.alternative")) {
                    return retrieveConf;
                }
                return null;
            }
            case 134: {
                return new DeliveryInd(this.mHeaders);
            }
            case 133: {
                return new AcknowledgeInd(this.mHeaders);
            }
            case 136: {
                return new ReadOrigInd(this.mHeaders);
            }
            case 135: 
        }
        return new ReadRecInd(this.mHeaders);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PduHeaders parseHeaders(ByteArrayInputStream var1_1) {
        if (var1_1 == null) {
            return null;
        }
        var2_2 = true;
        var3_3 = new PduHeaders();
        block79: while (var2_2 && var1_1.available() > 0) {
            var1_1.mark(1);
            var4_7 = PduParser.extractByteValue(var1_1);
            if (var4_7 >= 32 && var4_7 <= 127) {
                var1_1.reset();
                PduParser.parseWapString(var1_1, 0);
                continue;
            }
            switch (var4_7) {
                default: {
                    PduParser.log("Unknown header");
                    continue block79;
                }
                case 140: {
                    var76_14 = PduParser.extractByteValue(var1_1);
                    switch (var76_14) {
                        default: {
                            try {
                                var3_3.setOctet(var76_14, var4_7);
                                continue block79;
                            }
                            catch (InvalidHeaderValueException var78_36) {
                                PduParser.log("Set invalid Octet value: " + var76_14 + " into the header filed: " + var4_7);
                                return null;
                            }
                        }
                        case 137: 
                        case 138: 
                        case 139: 
                        case 140: 
                        case 141: 
                        case 142: 
                        case 143: 
                        case 144: 
                        case 145: 
                        case 146: 
                        case 147: 
                        case 148: 
                        case 149: 
                        case 150: 
                        case 151: 
                    }
                    return null;
                    catch (RuntimeException var77_37) {
                        PduParser.log(var4_7 + "is not Octet header field!");
                        return null;
                    }
                }
                case 134: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 148: 
                case 149: 
                case 153: 
                case 155: 
                case 156: 
                case 162: 
                case 163: 
                case 165: 
                case 167: 
                case 169: 
                case 171: 
                case 177: 
                case 180: 
                case 186: 
                case 187: 
                case 188: 
                case 191: {
                    var73_13 = PduParser.extractByteValue(var1_1);
                    try {
                        var3_3.setOctet(var73_13, var4_7);
                        continue block79;
                    }
                    catch (InvalidHeaderValueException var75_38) {
                        PduParser.log("Set invalid Octet value: " + var73_13 + " into the header filed: " + var4_7);
                        return null;
                    }
                    catch (RuntimeException var74_39) {
                        PduParser.log(var4_7 + "is not Octet header field!");
                        return null;
                    }
                }
                case 133: 
                case 142: 
                case 159: {
                    try {
                        var3_3.setLongInteger(PduParser.parseLongInteger(var1_1), var4_7);
                        continue block79;
                    }
                    catch (RuntimeException var72_40) {
                        PduParser.log(var4_7 + "is not Long-Integer header field!");
                        return null;
                    }
                }
                case 173: 
                case 175: 
                case 179: {
                    try {
                        var3_3.setLongInteger(PduParser.parseIntegerValue(var1_1), var4_7);
                        continue block79;
                    }
                    catch (RuntimeException var71_41) {
                        PduParser.log(var4_7 + "is not Long-Integer header field!");
                        return null;
                    }
                }
                case 131: 
                case 139: 
                case 152: 
                case 158: 
                case 183: 
                case 184: 
                case 185: 
                case 189: 
                case 190: {
                    var68_8 = PduParser.parseWapString(var1_1, 0);
                    if (var68_8 == null) continue block79;
                    try {
                        var3_3.setTextString(var68_8, var4_7);
                        continue block79;
                    }
                    catch (NullPointerException var70_10) {
                        PduParser.log("null pointer error!");
                        continue block79;
                    }
                    catch (RuntimeException var69_42) {
                        PduParser.log(var4_7 + "is not Text-String header field!");
                        return null;
                    }
                }
                case 147: 
                case 150: 
                case 154: 
                case 166: 
                case 181: 
                case 182: {
                    var65_5 = PduParser.parseEncodedStringValue(var1_1);
                    if (var65_5 == null) continue block79;
                    try {
                        var3_3.setEncodedStringValue(var65_5, var4_7);
                        continue block79;
                    }
                    catch (NullPointerException var67_6) {
                        PduParser.log("null pointer error!");
                        continue block79;
                    }
                    catch (RuntimeException var66_43) {
                        PduParser.log(var4_7 + "is not Encoded-String-Value header field!");
                        return null;
                    }
                }
                case 129: 
                case 130: 
                case 151: {
                    var58_32 = PduParser.parseEncodedStringValue(var1_1);
                    if (var58_32 == null) continue block79;
                    var59_33 = var58_32.getTextString();
                    if (var59_33 != null) {
                        var60_34 = new String(var59_33);
                        var61_35 = var60_34.indexOf("/");
                        if (var61_35 > 0) {
                            var60_34 = var60_34.substring(0, var61_35);
                        }
                        var58_32.setTextString(var60_34.getBytes());
                    }
                    try {
                        var3_3.appendEncodedStringValue(var58_32, var4_7);
                        continue block79;
                    }
                    catch (NullPointerException var64_4) {
                        PduParser.log("null pointer error!");
                        continue block79;
                    }
                    catch (NullPointerException var62_44) {
                        PduParser.log("null pointer error!");
                        return null;
                    }
                    catch (RuntimeException var63_45) {
                        PduParser.log(var4_7 + "is not Encoded-String-Value header field!");
                        return null;
                    }
                }
                case 135: 
                case 136: 
                case 157: {
                    PduParser.parseValueLength(var1_1);
                    var51_29 = PduParser.extractByteValue(var1_1);
                    try {
                        var55_31 = var53_30 = PduParser.parseLongInteger(var1_1);
                        if (129 != var51_29) ** GOTO lbl115
                        var55_31 += System.currentTimeMillis() / 1000L;
                    }
                    catch (RuntimeException var52_47) {
                        PduParser.log(var4_7 + "is not Long-Integer header field!");
                        return null;
                    }
lbl115:
                    // 2 sources

                    try {
                        var3_3.setLongInteger(var55_31, var4_7);
                        continue block79;
                    }
                    catch (RuntimeException var57_46) {
                        PduParser.log(var4_7 + "is not Long-Integer header field!");
                        return null;
                    }
                }
                case 137: {
                    PduParser.parseValueLength(var1_1);
                    if (128 == PduParser.extractByteValue(var1_1)) {
                        var42_23 = PduParser.parseEncodedStringValue(var1_1);
                        if (var42_23 != null && (var45_25 = var42_23.getTextString()) != null) {
                            var46_26 = new String(var45_25);
                            var47_27 = var46_26.indexOf("/");
                            if (var47_27 > 0) {
                                var46_26 = var46_26.substring(0, var47_27);
                            }
                            try {
                                var49_28 = var46_26.getBytes();
                                var42_23.setTextString(var49_28);
                            }
                            catch (NullPointerException var48_48) {
                                PduParser.log("null pointer error!");
                                return null;
                            }
                        }
                    } else {
                        var41_22 = "insert-address-token".getBytes();
                        var42_23 = new EncodedStringValue(var41_22);
                    }
                    try {
                        var3_3.setEncodedStringValue(var42_23, 137);
                        continue block79;
                    }
                    catch (NullPointerException var44_24) {
                        PduParser.log("null pointer error!");
                        continue block79;
                    }
                    catch (NullPointerException var40_49) {
                        PduParser.log(var4_7 + "is not Encoded-String-Value header field!");
                        return null;
                    }
                    catch (RuntimeException var43_50) {
                        PduParser.log(var4_7 + "is not Encoded-String-Value header field!");
                        return null;
                    }
                }
                case 138: {
                    var1_1.mark(1);
                    var33_18 = PduParser.extractByteValue(var1_1);
                    if (var33_18 < 128) ** GOTO lbl179
                    if (128 == var33_18) {
                        var3_3.setTextString("personal".getBytes(), 138);
                        continue block79;
                    }
                    if (129 == var33_18) {
                        var3_3.setTextString("advertisement".getBytes(), 138);
                        continue block79;
                    }
                    if (130 != var33_18) ** GOTO lbl176
                    try {
                        var3_3.setTextString("informational".getBytes(), 138);
                        continue block79;
                    }
                    catch (NullPointerException var38_21) {
                        PduParser.log("null pointer error!");
                        continue block79;
                    }
                    catch (RuntimeException var37_51) {
                        PduParser.log(var4_7 + "is not Text-String header field!");
                        return null;
                    }
lbl176:
                    // 1 sources

                    if (131 != var33_18) continue block79;
                    var3_3.setTextString("auto".getBytes(), 138);
                    continue block79;
lbl179:
                    // 1 sources

                    var1_1.reset();
                    var34_19 = PduParser.parseWapString(var1_1, 0);
                    if (var34_19 == null) continue block79;
                    try {
                        var3_3.setTextString(var34_19, 138);
                        continue block79;
                    }
                    catch (NullPointerException var36_20) {
                        PduParser.log("null pointer error!");
                        continue block79;
                    }
                    catch (RuntimeException var35_52) {
                        PduParser.log(var4_7 + "is not Text-String header field!");
                        return null;
                    }
                }
                case 141: {
                    var30_17 = PduParser.parseShortInteger(var1_1);
                    try {
                        var3_3.setOctet(var30_17, 141);
                        continue block79;
                    }
                    catch (InvalidHeaderValueException var32_53) {
                        PduParser.log("Set invalid Octet value: " + var30_17 + " into the header filed: " + var4_7);
                        return null;
                    }
                    catch (RuntimeException var31_54) {
                        PduParser.log(var4_7 + "is not Octet header field!");
                        return null;
                    }
                }
                case 160: {
                    PduParser.parseValueLength(var1_1);
                    try {
                        PduParser.parseIntegerValue(var1_1);
                    }
                    catch (RuntimeException var24_55) {
                        PduParser.log(var4_7 + " is not Integer-Value");
                        return null;
                    }
                    var27_15 = PduParser.parseEncodedStringValue(var1_1);
                    if (var27_15 == null) continue block79;
                    try {
                        var3_3.setEncodedStringValue(var27_15, 160);
                        continue block79;
                    }
                    catch (NullPointerException var29_16) {
                        PduParser.log("null pointer error!");
                        continue block79;
                    }
                    catch (RuntimeException var28_56) {
                        PduParser.log(var4_7 + "is not Encoded-String-Value header field!");
                        return null;
                    }
                }
                case 161: {
                    PduParser.parseValueLength(var1_1);
                    try {
                        PduParser.parseIntegerValue(var1_1);
                    }
                    catch (RuntimeException var19_58) {
                        PduParser.log(var4_7 + " is not Integer-Value");
                        return null;
                    }
                    try {
                        var3_3.setLongInteger(PduParser.parseLongInteger(var1_1), 161);
                        continue block79;
                    }
                    catch (RuntimeException var22_57) {
                        PduParser.log(var4_7 + "is not Long-Integer header field!");
                        return null;
                    }
                }
                case 164: {
                    PduParser.parseValueLength(var1_1);
                    PduParser.extractByteValue(var1_1);
                    PduParser.parseEncodedStringValue(var1_1);
                    continue block79;
                }
                case 170: 
                case 172: {
                    PduParser.parseValueLength(var1_1);
                    PduParser.extractByteValue(var1_1);
                    try {
                        PduParser.parseIntegerValue(var1_1);
                        continue block79;
                    }
                    catch (RuntimeException var12_59) {
                        PduParser.log(var4_7 + " is not Integer-Value");
                        return null;
                    }
                }
                case 178: {
                    PduParser.parseContentType(var1_1, null);
                    continue block79;
                }
                case 132: 
            }
            var5_9 = new HashMap<Integer, Object>();
            var6_11 = PduParser.parseContentType(var1_1, var5_9);
            if (var6_11 != null) {
                try {
                    var3_3.setTextString(var6_11, 132);
                }
                catch (NullPointerException var8_12) {
                    PduParser.log("null pointer error!");
                }
            }
lbl270:
            // 4 sources

            PduParser.mStartParam = (byte[])var5_9.get(153);
            PduParser.mTypeParam = (byte[])var5_9.get(131);
            var2_2 = false;
            continue;
            catch (RuntimeException var7_60) {
                PduParser.log(var4_7 + "is not Text-String header field!");
                return null;
            }
        }
        ** GOTO lbl270
        return var3_3;
    }
}

