/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.pdu;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.net.Uri;
import android.provider.Telephony;
import android.util.Log;
import com.google.android.mms.InvalidHeaderValueException;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.AcknowledgeInd;
import com.google.android.mms.pdu.DeliveryInd;
import com.google.android.mms.pdu.EncodedStringValue;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.MultimediaMessagePdu;
import com.google.android.mms.pdu.NotificationInd;
import com.google.android.mms.pdu.NotifyRespInd;
import com.google.android.mms.pdu.PduBody;
import com.google.android.mms.pdu.PduHeaders;
import com.google.android.mms.pdu.PduPart;
import com.google.android.mms.pdu.ReadOrigInd;
import com.google.android.mms.pdu.ReadRecInd;
import com.google.android.mms.pdu.RetrieveConf;
import com.google.android.mms.pdu.SendReq;
import com.google.android.mms.util.PduCache;
import com.google.android.mms.util.PduCacheEntry;
import com.google.android.mms.util.SqliteWrapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class PduPersister {
    private static final int[] ADDRESS_FIELDS = new int[]{129, 130, 137, 151};
    private static final HashMap<Integer, Integer> CHARSET_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, String> CHARSET_COLUMN_NAME_MAP;
    private static final boolean DEBUG = false;
    private static final long DUMMY_THREAD_ID = Long.MAX_VALUE;
    private static final HashMap<Integer, Integer> ENCODED_STRING_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, String> ENCODED_STRING_COLUMN_NAME_MAP;
    private static final boolean LOCAL_LOGV = false;
    private static final HashMap<Integer, Integer> LONG_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, String> LONG_COLUMN_NAME_MAP;
    private static final HashMap<Uri, Integer> MESSAGE_BOX_MAP;
    private static final HashMap<Integer, Integer> OCTET_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, String> OCTET_COLUMN_NAME_MAP;
    private static final int PART_COLUMN_CHARSET = 1;
    private static final int PART_COLUMN_CONTENT_DISPOSITION = 2;
    private static final int PART_COLUMN_CONTENT_ID = 3;
    private static final int PART_COLUMN_CONTENT_LOCATION = 4;
    private static final int PART_COLUMN_CONTENT_TYPE = 5;
    private static final int PART_COLUMN_FILENAME = 6;
    private static final int PART_COLUMN_ID = 0;
    private static final int PART_COLUMN_NAME = 7;
    private static final int PART_COLUMN_TEXT = 8;
    private static final String[] PART_PROJECTION;
    private static final PduCache PDU_CACHE_INSTANCE;
    private static final int PDU_COLUMN_CONTENT_CLASS = 11;
    private static final int PDU_COLUMN_CONTENT_LOCATION = 5;
    private static final int PDU_COLUMN_CONTENT_TYPE = 6;
    private static final int PDU_COLUMN_DATE = 21;
    private static final int PDU_COLUMN_DELIVERY_REPORT = 12;
    private static final int PDU_COLUMN_DELIVERY_TIME = 22;
    private static final int PDU_COLUMN_EXPIRY = 23;
    private static final int PDU_COLUMN_ID = 0;
    private static final int PDU_COLUMN_MESSAGE_BOX = 1;
    private static final int PDU_COLUMN_MESSAGE_CLASS = 7;
    private static final int PDU_COLUMN_MESSAGE_ID = 8;
    private static final int PDU_COLUMN_MESSAGE_SIZE = 24;
    private static final int PDU_COLUMN_MESSAGE_TYPE = 13;
    private static final int PDU_COLUMN_MMS_VERSION = 14;
    private static final int PDU_COLUMN_PRIORITY = 15;
    private static final int PDU_COLUMN_READ_REPORT = 16;
    private static final int PDU_COLUMN_READ_STATUS = 17;
    private static final int PDU_COLUMN_REPORT_ALLOWED = 18;
    private static final int PDU_COLUMN_RESPONSE_TEXT = 9;
    private static final int PDU_COLUMN_RETRIEVE_STATUS = 19;
    private static final int PDU_COLUMN_RETRIEVE_TEXT = 3;
    private static final int PDU_COLUMN_RETRIEVE_TEXT_CHARSET = 26;
    private static final int PDU_COLUMN_STATUS = 20;
    private static final int PDU_COLUMN_SUBJECT = 4;
    private static final int PDU_COLUMN_SUBJECT_CHARSET = 25;
    private static final int PDU_COLUMN_THREAD_ID = 2;
    private static final int PDU_COLUMN_TRANSACTION_ID = 10;
    private static final String[] PDU_PROJECTION;
    public static final int PROC_STATUS_COMPLETED = 3;
    public static final int PROC_STATUS_PERMANENTLY_FAILURE = 2;
    public static final int PROC_STATUS_TRANSIENT_FAILURE = 1;
    private static final String TAG = "PduPersister";
    public static final String TEMPORARY_DRM_OBJECT_URI = "content://mms/9223372036854775807/part";
    private static final HashMap<Integer, Integer> TEXT_STRING_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, String> TEXT_STRING_COLUMN_NAME_MAP;
    private static PduPersister sPersister;
    private final ContentResolver mContentResolver;
    private final Context mContext;

    static {
        PDU_PROJECTION = new String[]{"_id", "msg_box", "thread_id", "retr_txt", "sub", "ct_l", "ct_t", "m_cls", "m_id", "resp_txt", "tr_id", "ct_cls", "d_rpt", "m_type", "v", "pri", "rr", "read_status", "rpt_a", "retr_st", "st", "date", "d_tm", "exp", "m_size", "sub_cs", "retr_txt_cs"};
        PART_PROJECTION = new String[]{"_id", "chset", "cd", "cid", "cl", "ct", "fn", "name", "text"};
        MESSAGE_BOX_MAP = new HashMap();
        MESSAGE_BOX_MAP.put(Telephony.Mms.Inbox.CONTENT_URI, 1);
        MESSAGE_BOX_MAP.put(Telephony.Mms.Sent.CONTENT_URI, 2);
        MESSAGE_BOX_MAP.put(Telephony.Mms.Draft.CONTENT_URI, 3);
        MESSAGE_BOX_MAP.put(Telephony.Mms.Outbox.CONTENT_URI, 4);
        CHARSET_COLUMN_INDEX_MAP = new HashMap();
        CHARSET_COLUMN_INDEX_MAP.put(150, 25);
        CHARSET_COLUMN_INDEX_MAP.put(154, 26);
        CHARSET_COLUMN_NAME_MAP = new HashMap();
        CHARSET_COLUMN_NAME_MAP.put(150, "sub_cs");
        CHARSET_COLUMN_NAME_MAP.put(154, "retr_txt_cs");
        ENCODED_STRING_COLUMN_INDEX_MAP = new HashMap();
        ENCODED_STRING_COLUMN_INDEX_MAP.put(154, 3);
        ENCODED_STRING_COLUMN_INDEX_MAP.put(150, 4);
        ENCODED_STRING_COLUMN_NAME_MAP = new HashMap();
        ENCODED_STRING_COLUMN_NAME_MAP.put(154, "retr_txt");
        ENCODED_STRING_COLUMN_NAME_MAP.put(150, "sub");
        TEXT_STRING_COLUMN_INDEX_MAP = new HashMap();
        TEXT_STRING_COLUMN_INDEX_MAP.put(131, 5);
        TEXT_STRING_COLUMN_INDEX_MAP.put(132, 6);
        TEXT_STRING_COLUMN_INDEX_MAP.put(138, 7);
        TEXT_STRING_COLUMN_INDEX_MAP.put(139, 8);
        TEXT_STRING_COLUMN_INDEX_MAP.put(147, 9);
        TEXT_STRING_COLUMN_INDEX_MAP.put(152, 10);
        TEXT_STRING_COLUMN_NAME_MAP = new HashMap();
        TEXT_STRING_COLUMN_NAME_MAP.put(131, "ct_l");
        TEXT_STRING_COLUMN_NAME_MAP.put(132, "ct_t");
        TEXT_STRING_COLUMN_NAME_MAP.put(138, "m_cls");
        TEXT_STRING_COLUMN_NAME_MAP.put(139, "m_id");
        TEXT_STRING_COLUMN_NAME_MAP.put(147, "resp_txt");
        TEXT_STRING_COLUMN_NAME_MAP.put(152, "tr_id");
        OCTET_COLUMN_INDEX_MAP = new HashMap();
        OCTET_COLUMN_INDEX_MAP.put(186, 11);
        OCTET_COLUMN_INDEX_MAP.put(134, 12);
        OCTET_COLUMN_INDEX_MAP.put(140, 13);
        OCTET_COLUMN_INDEX_MAP.put(141, 14);
        OCTET_COLUMN_INDEX_MAP.put(143, 15);
        OCTET_COLUMN_INDEX_MAP.put(144, 16);
        OCTET_COLUMN_INDEX_MAP.put(155, 17);
        OCTET_COLUMN_INDEX_MAP.put(145, 18);
        OCTET_COLUMN_INDEX_MAP.put(153, 19);
        OCTET_COLUMN_INDEX_MAP.put(149, 20);
        OCTET_COLUMN_NAME_MAP = new HashMap();
        OCTET_COLUMN_NAME_MAP.put(186, "ct_cls");
        OCTET_COLUMN_NAME_MAP.put(134, "d_rpt");
        OCTET_COLUMN_NAME_MAP.put(140, "m_type");
        OCTET_COLUMN_NAME_MAP.put(141, "v");
        OCTET_COLUMN_NAME_MAP.put(143, "pri");
        OCTET_COLUMN_NAME_MAP.put(144, "rr");
        OCTET_COLUMN_NAME_MAP.put(155, "read_status");
        OCTET_COLUMN_NAME_MAP.put(145, "rpt_a");
        OCTET_COLUMN_NAME_MAP.put(153, "retr_st");
        OCTET_COLUMN_NAME_MAP.put(149, "st");
        LONG_COLUMN_INDEX_MAP = new HashMap();
        LONG_COLUMN_INDEX_MAP.put(133, 21);
        LONG_COLUMN_INDEX_MAP.put(135, 22);
        LONG_COLUMN_INDEX_MAP.put(136, 23);
        LONG_COLUMN_INDEX_MAP.put(142, 24);
        LONG_COLUMN_NAME_MAP = new HashMap();
        LONG_COLUMN_NAME_MAP.put(133, "date");
        LONG_COLUMN_NAME_MAP.put(135, "d_tm");
        LONG_COLUMN_NAME_MAP.put(136, "exp");
        LONG_COLUMN_NAME_MAP.put(142, "m_size");
        PDU_CACHE_INSTANCE = PduCache.getInstance();
    }

    private PduPersister(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
    }

    private byte[] getByteArrayFromPartColumn(Cursor cursor, int n) {
        if (!cursor.isNull(n)) {
            return PduPersister.getBytes(cursor.getString(n));
        }
        return null;
    }

    public static byte[] getBytes(String string2) {
        try {
            byte[] byArray = string2.getBytes("iso-8859-1");
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e(TAG, "ISO_8859_1 must be supported!", unsupportedEncodingException);
            return new byte[0];
        }
    }

    private Integer getIntegerFromPartColumn(Cursor cursor, int n) {
        if (!cursor.isNull(n)) {
            return cursor.getInt(n);
        }
        return null;
    }

    public static PduPersister getPduPersister(Context context) {
        if (sPersister == null || !context.equals(PduPersister.sPersister.mContext)) {
            sPersister = new PduPersister(context);
        }
        return sPersister;
    }

    /*
     * Exception decompiling
     */
    private void loadAddress(long var1_1, PduHeaders var3_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 198->256)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private PduPart[] loadParts(long var1_1) throws MmsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 16[TRYBLOCK] [27, 26 : 542->550)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void persistAddress(long l, int n, EncodedStringValue[] encodedStringValueArray) {
        ContentValues contentValues = new ContentValues(3);
        for (EncodedStringValue encodedStringValue : encodedStringValueArray) {
            contentValues.clear();
            contentValues.put("address", PduPersister.toIsoString(encodedStringValue.getTextString()));
            contentValues.put("charset", encodedStringValue.getCharacterSet());
            contentValues.put("type", n);
            Uri uri = Uri.parse("content://mms/" + l + "/addr");
            SqliteWrapper.insert(this.mContext, this.mContentResolver, uri, contentValues);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void persistData(PduPart var1_1, Uri var2_2, String var3_3) throws MmsException {
        block29: {
            var4_4 = null;
            var5_5 = null;
            try {
                try {
                    var15_6 = var1_1.getData();
                    if ("text/plain".equals(var3_3) || "application/smil".equals(var3_3) || "text/html".equals(var3_3)) {
                        var16_7 = new ContentValues();
                        var16_7.put("text", new EncodedStringValue(var15_6).getString());
                        var17_8 = this.mContentResolver.update(var2_2, var16_7, null, null);
                        var5_5 = null;
                        var4_4 = null;
                        if (var17_8 != 1) {
                            throw new MmsException("unable to update " + var2_2.toString());
                        }
                        break block29;
                    }
                }
                catch (FileNotFoundException var13_9) {
                    Log.e("PduPersister", "Failed to open Input/Output stream.", var13_9);
                    throw new MmsException(var13_9);
                }
            }
            catch (Throwable var8_10) {
                block30: {
                    if (var4_4 != null) {
                        ** try [egrp 2[TRYBLOCK] [10 : 157->162)] { 
lbl23:
                        // 1 sources

                        break block30;
                    } else lbl-1000:
                    // 3 sources

                    {
                        while (true) {
                            if (var5_5 == null) throw var8_10;
                            var5_5.close();
                            throw var8_10;
                            break;
                        }
                    }
lbl29:
                    // 1 sources

                    catch (IOException var11_19) {
                        Log.e("PduPersister", "IOException while closing: " + var4_4, var11_19);
                        ** GOTO lbl-1000
                    }
                    catch (IOException var6_16) {
                        Log.e("PduPersister", "Failed to read/write data.", var6_16);
                        throw new MmsException(var6_16);
                    }
                }
                var4_4.close();
                ** continue;
                catch (IOException var9_20) {
                    Log.e("PduPersister", "IOException while closing: " + var5_5, var9_20);
                    throw var8_10;
                }
            }
            {
                var4_4 = this.mContentResolver.openOutputStream(var2_2);
                var5_5 = null;
                if (var15_6 != null) ** GOTO lbl-1000
                var22_11 = var1_1.getDataUri();
                if (var22_11 != null && var22_11 != var2_2) ** GOTO lbl-1000
            }
            {
                Log.w("PduPersister", "Can't find data for this part.");
                if (var4_4 == null) return;
            }
            try {
                var4_4.close();
                return;
            }
            catch (IOException var26_12) {
                Log.e("PduPersister", "IOException while closing: " + var4_4, var26_12);
                return;
            }
lbl-1000:
            // 1 sources

            {
                var5_5 = this.mContentResolver.openInputStream(var22_11);
                var28_14 = new byte[256];
                while ((var29_15 = var5_5.read(var28_14)) != -1) {
                    var4_4.write(var28_14, 0, var29_15);
                }
                break block29;
            }
lbl-1000:
            // 1 sources

            {
                var4_4.write(var15_6);
            }
        }
        if (var4_4 != null) {
            var4_4.close();
        }
lbl70:
        // 4 sources

        while (true) {
            if (var5_5 == null) return;
            try {
                var5_5.close();
                return;
            }
            catch (IOException var18_17) {
                Log.e("PduPersister", "IOException while closing: " + var5_5, var18_17);
                return;
            }
            break;
        }
        catch (IOException var20_18) {
            Log.e("PduPersister", "IOException while closing: " + var4_4, var20_18);
            ** continue;
        }
    }

    private void setEncodedStringValueToHeaders(Cursor cursor, int n, PduHeaders pduHeaders, int n2) {
        String string2 = cursor.getString(n);
        if (string2 != null && string2.length() > 0) {
            pduHeaders.setEncodedStringValue(new EncodedStringValue(cursor.getInt(CHARSET_COLUMN_INDEX_MAP.get(n2)), PduPersister.getBytes(string2)), n2);
        }
    }

    private void setLongToHeaders(Cursor cursor, int n, PduHeaders pduHeaders, int n2) {
        if (!cursor.isNull(n)) {
            pduHeaders.setLongInteger(cursor.getLong(n), n2);
        }
    }

    private void setOctetToHeaders(Cursor cursor, int n, PduHeaders pduHeaders, int n2) throws InvalidHeaderValueException {
        if (!cursor.isNull(n)) {
            pduHeaders.setOctet(cursor.getInt(n), n2);
        }
    }

    private void setTextStringToHeaders(Cursor cursor, int n, PduHeaders pduHeaders, int n2) {
        String string2 = cursor.getString(n);
        if (string2 != null) {
            pduHeaders.setTextString(PduPersister.getBytes(string2), n2);
        }
    }

    public static String toIsoString(byte[] byArray) {
        try {
            String string2 = new String(byArray, "iso-8859-1");
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e(TAG, "ISO_8859_1 must be supported!", unsupportedEncodingException);
            return "";
        }
    }

    private void updateAddress(long l, int n, EncodedStringValue[] encodedStringValueArray) {
        SqliteWrapper.delete(this.mContext, this.mContentResolver, Uri.parse("content://mms/" + l + "/addr"), "type=" + n, null);
        this.persistAddress(l, n, encodedStringValueArray);
    }

    private void updatePart(Uri uri, PduPart pduPart) throws MmsException {
        ContentValues contentValues = new ContentValues(7);
        int n = pduPart.getCharset();
        if (n != 0) {
            contentValues.put("chset", n);
        }
        if (pduPart.getContentType() != null) {
            String string2 = PduPersister.toIsoString(pduPart.getContentType());
            contentValues.put("ct", string2);
            if (pduPart.getFilename() != null) {
                contentValues.put("fn", new String(pduPart.getFilename()));
            }
            if (pduPart.getName() != null) {
                contentValues.put("name", new String(pduPart.getName()));
            }
            if (pduPart.getContentDisposition() != null) {
                contentValues.put("cd", PduPersister.toIsoString(pduPart.getContentDisposition()));
            }
            if (pduPart.getContentId() != null) {
                contentValues.put("cid", PduPersister.toIsoString(pduPart.getContentId()));
            }
            if (pduPart.getContentLocation() != null) {
                contentValues.put("cl", PduPersister.toIsoString(pduPart.getContentLocation()));
            }
            SqliteWrapper.update(this.mContext, this.mContentResolver, uri, contentValues, null, null);
            if (pduPart.getData() != null || uri != pduPart.getDataUri()) {
                this.persistData(pduPart, uri, string2);
            }
            return;
        }
        throw new MmsException("MIME type of the part must be set.");
    }

    public Cursor getPendingMessages(long l) {
        Uri.Builder builder = Telephony.MmsSms.PendingMessages.CONTENT_URI.buildUpon();
        builder.appendQueryParameter("protocol", "mms");
        String[] stringArray = new String[]{String.valueOf(10), String.valueOf(l)};
        return SqliteWrapper.query(this.mContext, this.mContentResolver, builder.build(), null, "err_type < ? AND due_time <= ?", stringArray, "due_time");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GenericPdu load(Uri var1_1) throws MmsException {
        var2_2 = (PduCacheEntry)PduPersister.PDU_CACHE_INSTANCE.get(var1_1);
        if (var2_2 != null) {
            return var2_2.getPdu();
        }
        var3_3 = SqliteWrapper.query(this.mContext, this.mContentResolver, var1_1, PduPersister.PDU_PROJECTION, null, null, null);
        var4_4 = new PduHeaders();
        var5_5 = ContentUris.parseId(var1_1);
        if (var3_3 == null) ** GOTO lbl10
        try {
            block28: {
                if (var3_3.getCount() == 1 && var3_3.moveToFirst()) break block28;
lbl10:
                // 2 sources

                throw new MmsException("Bad uri: " + var1_1);
            }
            var8_7 = var3_3.getInt(1);
            var9_8 = var3_3.getLong(2);
            for (Map.Entry<Integer, Integer> var27_10 : PduPersister.ENCODED_STRING_COLUMN_INDEX_MAP.entrySet()) {
                this.setEncodedStringValueToHeaders(var3_3, var27_10.getValue(), var4_4, var27_10.getKey());
            }
            for (Map.Entry<Integer, Integer> var26_12 : PduPersister.TEXT_STRING_COLUMN_INDEX_MAP.entrySet()) {
                this.setTextStringToHeaders(var3_3, var26_12.getValue(), var4_4, var26_12.getKey());
            }
            for (Map.Entry<Integer, Integer> var25_14 : PduPersister.OCTET_COLUMN_INDEX_MAP.entrySet()) {
                this.setOctetToHeaders(var3_3, var25_14.getValue(), var4_4, var25_14.getKey());
            }
            for (Map.Entry<Integer, Integer> var24_16 : PduPersister.LONG_COLUMN_INDEX_MAP.entrySet()) {
                this.setLongToHeaders(var3_3, var24_16.getValue(), var4_4, var24_16.getKey());
            }
        }
        finally {
            if (var3_3 != null) {
                var3_3.close();
            }
        }
        if (var5_5 == -1L) {
            throw new MmsException("Error! ID of the message: -1.");
        }
        this.loadAddress(var5_5, var4_4);
        var15_17 = var4_4.getOctet(140);
        var16_18 = new PduBody();
        if ((var15_17 == 132 || var15_17 == 128) && (var17_19 = this.loadParts(var5_5)) != null) {
            var21_20 = var17_19.length;
            for (var22_21 = 0; var22_21 < var21_20; ++var22_21) {
                var16_18.addPart(var17_19[var22_21]);
            }
        }
        switch (var15_17) {
            default: {
                throw new MmsException("Unrecognized PDU type: " + Integer.toHexString(var15_17));
            }
            case 130: {
                var18_22 /* !! */  = new NotificationInd(var4_4);
                ** GOTO lbl69
            }
            case 134: {
                var18_22 /* !! */  = new DeliveryInd(var4_4);
                ** GOTO lbl69
            }
            case 136: {
                var18_22 /* !! */  = new ReadOrigInd(var4_4);
                ** GOTO lbl69
            }
            case 132: {
                var18_22 /* !! */  = new RetrieveConf(var4_4, var16_18);
                ** GOTO lbl69
            }
            case 128: {
                var18_22 /* !! */  = new SendReq(var4_4, var16_18);
                ** GOTO lbl69
            }
            case 133: {
                var18_22 /* !! */  = new AcknowledgeInd(var4_4);
                ** GOTO lbl69
            }
            case 131: {
                var18_22 /* !! */  = new NotifyRespInd(var4_4);
                ** GOTO lbl69
            }
            case 135: {
                var18_22 /* !! */  = new ReadRecInd(var4_4);
lbl69:
                // 8 sources

                var19_23 = new PduCacheEntry(var18_22 /* !! */ , var8_7, var9_8);
                PduPersister.PDU_CACHE_INSTANCE.put(var1_1, var19_23);
                return var18_22 /* !! */ ;
            }
            case 129: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
        }
        throw new MmsException("Unsupported PDU type: " + Integer.toHexString(var15_17));
    }

    public Uri move(Uri uri, Uri uri2) throws MmsException {
        long l = ContentUris.parseId(uri);
        if (l == -1L) {
            throw new MmsException("Error! ID of the message: -1.");
        }
        Integer n = MESSAGE_BOX_MAP.get(uri2);
        if (n == null) {
            throw new MmsException("Bad destination, must be one of content://mms/inbox, content://mms/sent, content://mms/drafts, content://mms/outbox, content://mms/temp.");
        }
        ContentValues contentValues = new ContentValues(1);
        contentValues.put("msg_box", n);
        SqliteWrapper.update(this.mContext, this.mContentResolver, uri, contentValues, null, null);
        return ContentUris.withAppendedId(uri2, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Uri persist(GenericPdu genericPdu, Uri uri) throws MmsException {
        Uri uri2;
        PduBody pduBody;
        if (uri == null) {
            throw new MmsException("Uri may not be null.");
        }
        if (MESSAGE_BOX_MAP.get(uri) == null) {
            throw new MmsException("Bad destination, must be one of content://mms/inbox, content://mms/sent, content://mms/drafts, content://mms/outbox, content://mms/temp.");
        }
        PDU_CACHE_INSTANCE.purge(uri);
        PduHeaders pduHeaders = genericPdu.getPduHeaders();
        ContentValues contentValues = new ContentValues();
        for (Map.Entry<Integer, String> entry : ENCODED_STRING_COLUMN_NAME_MAP.entrySet()) {
            int n = entry.getKey();
            EncodedStringValue encodedStringValue = pduHeaders.getEncodedStringValue(n);
            if (encodedStringValue == null) continue;
            String string2 = CHARSET_COLUMN_NAME_MAP.get(n);
            contentValues.put(entry.getValue(), PduPersister.toIsoString(encodedStringValue.getTextString()));
            contentValues.put(string2, encodedStringValue.getCharacterSet());
        }
        for (Map.Entry<Integer, String> entry : TEXT_STRING_COLUMN_NAME_MAP.entrySet()) {
            byte[] byArray = pduHeaders.getTextString(entry.getKey());
            if (byArray == null) continue;
            contentValues.put(entry.getValue(), PduPersister.toIsoString(byArray));
        }
        for (Map.Entry<Integer, String> entry : OCTET_COLUMN_NAME_MAP.entrySet()) {
            int n = pduHeaders.getOctet(entry.getKey());
            if (n == 0) continue;
            contentValues.put(entry.getValue(), n);
        }
        for (Map.Entry<Integer, String> entry : LONG_COLUMN_NAME_MAP.entrySet()) {
            long l = pduHeaders.getLongInteger(entry.getKey());
            if (l == -1L) continue;
            contentValues.put(entry.getValue(), l);
        }
        HashMap<Integer, EncodedStringValue[]> hashMap = new HashMap<Integer, EncodedStringValue[]>(ADDRESS_FIELDS.length);
        for (int n : ADDRESS_FIELDS) {
            EncodedStringValue[] encodedStringValueArray;
            if (n == 137) {
                EncodedStringValue encodedStringValue = pduHeaders.getEncodedStringValue(n);
                encodedStringValueArray = null;
                if (encodedStringValue != null) {
                    encodedStringValueArray = new EncodedStringValue[]{encodedStringValue};
                }
            } else {
                encodedStringValueArray = pduHeaders.getEncodedStringValues(n);
            }
            hashMap.put(n, encodedStringValueArray);
        }
        HashSet<String> hashSet = new HashSet<String>();
        long l = Long.MAX_VALUE;
        int n = genericPdu.getMessageType();
        if (n == 130 || n == 132 || n == 128) {
            EncodedStringValue[] encodedStringValueArray = null;
            switch (n) {
                case 130: 
                case 132: {
                    encodedStringValueArray = (EncodedStringValue[])hashMap.get(137);
                    break;
                }
                case 128: {
                    encodedStringValueArray = (EncodedStringValue[])hashMap.get(151);
                }
            }
            if (encodedStringValueArray != null) {
                for (EncodedStringValue encodedStringValue : encodedStringValueArray) {
                    if (encodedStringValue == null) continue;
                    hashSet.add(encodedStringValue.getString());
                }
            }
            l = Telephony.Threads.getOrCreateThreadId(this.mContext, hashSet);
        }
        contentValues.put("thread_id", l);
        long l2 = System.currentTimeMillis();
        if (genericPdu instanceof MultimediaMessagePdu && (pduBody = ((MultimediaMessagePdu)genericPdu).getBody()) != null) {
            int n2 = pduBody.getPartsNum();
            for (int i = 0; i < n2; ++i) {
                this.persistPart(pduBody.getPart(i), l2);
            }
        }
        if ((uri2 = SqliteWrapper.insert(this.mContext, this.mContentResolver, uri, contentValues)) == null) {
            throw new MmsException("persist() failed: return null.");
        }
        long l3 = ContentUris.parseId(uri2);
        ContentValues contentValues2 = new ContentValues(1);
        contentValues2.put("mid", l3);
        SqliteWrapper.update(this.mContext, this.mContentResolver, Uri.parse("content://mms/" + l2 + "/part"), contentValues2, null, null);
        Uri uri3 = Uri.parse(uri + "/" + l3);
        int[] nArray = ADDRESS_FIELDS;
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray[n4];
            EncodedStringValue[] encodedStringValueArray = (EncodedStringValue[])hashMap.get(n5);
            if (encodedStringValueArray != null) {
                this.persistAddress(l3, n5, encodedStringValueArray);
            }
            ++n4;
        }
        return uri3;
    }

    public Uri persistPart(PduPart pduPart, long l) throws MmsException {
        Uri uri;
        String string2;
        Uri uri2 = Uri.parse("content://mms/" + l + "/part");
        ContentValues contentValues = new ContentValues(8);
        int n = pduPart.getCharset();
        if (n != 0) {
            contentValues.put("chset", n);
        }
        if (pduPart.getContentType() != null) {
            string2 = PduPersister.toIsoString(pduPart.getContentType());
            contentValues.put("ct", string2);
            if ("application/smil".equals(string2)) {
                contentValues.put("seq", -1);
            }
            if (pduPart.getFilename() != null) {
                contentValues.put("fn", new String(pduPart.getFilename()));
            }
            if (pduPart.getName() != null) {
                contentValues.put("name", new String(pduPart.getName()));
            }
            if (pduPart.getContentDisposition() != null) {
                contentValues.put("cd", PduPersister.toIsoString(pduPart.getContentDisposition()));
            }
            if (pduPart.getContentId() != null) {
                contentValues.put("cid", PduPersister.toIsoString(pduPart.getContentId()));
            }
            if (pduPart.getContentLocation() != null) {
                contentValues.put("cl", PduPersister.toIsoString(pduPart.getContentLocation()));
            }
            if ((uri = SqliteWrapper.insert(this.mContext, this.mContentResolver, uri2, contentValues)) == null) {
                throw new MmsException("Failed to persist part, return null.");
            }
        } else {
            throw new MmsException("MIME type of the part must be set.");
        }
        this.persistData(pduPart, uri, string2);
        pduPart.setDataUri(uri);
        return uri;
    }

    public void release() {
        Uri uri = Uri.parse(TEMPORARY_DRM_OBJECT_URI);
        SqliteWrapper.delete(this.mContext, this.mContentResolver, uri, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateHeaders(Uri uri, SendReq sendReq) {
        long l;
        EncodedStringValue encodedStringValue;
        byte[] byArray;
        int n;
        int n2;
        byte[] byArray2;
        long l2;
        int n3;
        long l3;
        PDU_CACHE_INSTANCE.purge(uri);
        ContentValues contentValues = new ContentValues(10);
        byte[] byArray3 = sendReq.getContentType();
        if (byArray3 != null) {
            contentValues.put("ct_t", PduPersister.toIsoString(byArray3));
        }
        if ((l3 = sendReq.getDate()) != -1L) {
            contentValues.put("date", l3);
        }
        if ((n3 = sendReq.getDeliveryReport()) != 0) {
            contentValues.put("d_rpt", n3);
        }
        if ((l2 = sendReq.getExpiry()) != -1L) {
            contentValues.put("exp", l2);
        }
        if ((byArray2 = sendReq.getMessageClass()) != null) {
            contentValues.put("m_cls", PduPersister.toIsoString(byArray2));
        }
        if ((n2 = sendReq.getPriority()) != 0) {
            contentValues.put("pri", n2);
        }
        if ((n = sendReq.getReadReport()) != 0) {
            contentValues.put("rr", n);
        }
        if ((byArray = sendReq.getTransactionId()) != null) {
            contentValues.put("tr_id", PduPersister.toIsoString(byArray));
        }
        if ((encodedStringValue = sendReq.getSubject()) != null) {
            contentValues.put("sub", PduPersister.toIsoString(encodedStringValue.getTextString()));
            contentValues.put("sub_cs", encodedStringValue.getCharacterSet());
        } else {
            contentValues.put("sub", "");
        }
        if ((l = sendReq.getMessageSize()) > 0L) {
            contentValues.put("m_size", l);
        }
        PduHeaders pduHeaders = sendReq.getPduHeaders();
        HashSet<String> hashSet = new HashSet<String>();
        int[] nArray = ADDRESS_FIELDS;
        int n4 = nArray.length;
        int n5 = 0;
        while (true) {
            EncodedStringValue[] encodedStringValueArray;
            if (n5 >= n4) {
                contentValues.put("thread_id", Telephony.Threads.getOrCreateThreadId(this.mContext, hashSet));
                SqliteWrapper.update(this.mContext, this.mContentResolver, uri, contentValues, null, null);
                return;
            }
            int n6 = nArray[n5];
            if (n6 == 137) {
                EncodedStringValue encodedStringValue2 = pduHeaders.getEncodedStringValue(n6);
                encodedStringValueArray = null;
                if (encodedStringValue2 != null) {
                    encodedStringValueArray = new EncodedStringValue[]{encodedStringValue2};
                }
            } else {
                encodedStringValueArray = pduHeaders.getEncodedStringValues(n6);
            }
            if (encodedStringValueArray != null) {
                this.updateAddress(ContentUris.parseId(uri), n6, encodedStringValueArray);
                if (n6 == 151) {
                    for (EncodedStringValue encodedStringValue3 : encodedStringValueArray) {
                        if (encodedStringValue3 == null) continue;
                        hashSet.add(encodedStringValue3.getString());
                    }
                }
            }
            ++n5;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateParts(Uri uri, PduBody pduBody) throws MmsException {
        PduCacheEntry pduCacheEntry = (PduCacheEntry)PDU_CACHE_INSTANCE.get(uri);
        if (pduCacheEntry != null) {
            ((MultimediaMessagePdu)pduCacheEntry.getPdu()).setBody(pduBody);
        }
        ArrayList<PduPart> arrayList = new ArrayList<PduPart>();
        HashMap<Uri, PduPart> hashMap = new HashMap<Uri, PduPart>();
        int n = pduBody.getPartsNum();
        StringBuilder stringBuilder = new StringBuilder().append('(');
        for (int i = 0; i < n; ++i) {
            PduPart pduPart = pduBody.getPart(i);
            Uri uri2 = pduPart.getDataUri();
            if (uri2 == null || !uri2.getAuthority().startsWith("mms")) {
                arrayList.add(pduPart);
                continue;
            }
            hashMap.put(uri2, pduPart);
            if (stringBuilder.length() > 1) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append("_id");
            stringBuilder.append("!=");
            DatabaseUtils.appendEscapedSQLString(stringBuilder, uri2.getLastPathSegment());
        }
        stringBuilder.append(')');
        long l = ContentUris.parseId(uri);
        Context context = this.mContext;
        ContentResolver contentResolver = this.mContentResolver;
        Uri uri3 = Uri.parse(Telephony.Mms.CONTENT_URI + "/" + l + "/part");
        String string2 = stringBuilder.length() > 2 ? stringBuilder.toString() : null;
        SqliteWrapper.delete(context, contentResolver, uri3, string2, null);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.persistPart((PduPart)iterator.next(), l);
        }
        Iterator iterator2 = hashMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            this.updatePart((Uri)entry.getKey(), (PduPart)entry.getValue());
        }
        return;
    }
}

