/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.util;

import java.util.HashMap;

public abstract class AbstractCache<K, V> {
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final int MAX_CACHED_ITEMS = 500;
    private static final String TAG = "AbstractCache";
    private final HashMap<K, CacheEntry<V>> mCacheMap = new HashMap();

    protected AbstractCache() {
    }

    public V get(K k) {
        CacheEntry<V> cacheEntry;
        if (k != null && (cacheEntry = this.mCacheMap.get(k)) != null) {
            cacheEntry.hit = 1 + cacheEntry.hit;
            return cacheEntry.value;
        }
        return null;
    }

    public V purge(K k) {
        CacheEntry<V> cacheEntry = this.mCacheMap.remove(k);
        if (cacheEntry != null) {
            return cacheEntry.value;
        }
        return null;
    }

    public void purgeAll() {
        this.mCacheMap.clear();
    }

    public boolean put(K k, V v) {
        if (this.mCacheMap.size() >= 500) {
            return false;
        }
        if (k != null) {
            CacheEntry cacheEntry = new CacheEntry();
            cacheEntry.value = v;
            this.mCacheMap.put(k, cacheEntry);
            return true;
        }
        return false;
    }

    public int size() {
        return this.mCacheMap.size();
    }

    private static class CacheEntry<V> {
        int hit;
        V value;

        private CacheEntry() {
        }
    }
}

