/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.util;

import android.content.ContentUris;
import android.content.UriMatcher;
import android.net.Uri;
import android.provider.Telephony;
import com.google.android.mms.util.AbstractCache;
import com.google.android.mms.util.PduCacheEntry;
import java.util.HashMap;
import java.util.HashSet;

public final class PduCache
extends AbstractCache<Uri, PduCacheEntry> {
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final HashMap<Integer, Integer> MATCH_TO_MSGBOX_ID_MAP;
    private static final int MMS_ALL = 0;
    private static final int MMS_ALL_ID = 1;
    private static final int MMS_CONVERSATION = 10;
    private static final int MMS_CONVERSATION_ID = 11;
    private static final int MMS_DRAFTS = 6;
    private static final int MMS_DRAFTS_ID = 7;
    private static final int MMS_INBOX = 2;
    private static final int MMS_INBOX_ID = 3;
    private static final int MMS_OUTBOX = 8;
    private static final int MMS_OUTBOX_ID = 9;
    private static final int MMS_SENT = 4;
    private static final int MMS_SENT_ID = 5;
    private static final String TAG = "PduCache";
    private static final UriMatcher URI_MATCHER;
    private static PduCache sInstance;
    private final HashMap<Integer, HashSet<Uri>> mMessageBoxes = new HashMap();
    private final HashMap<Long, HashSet<Uri>> mThreads = new HashMap();

    static {
        URI_MATCHER = new UriMatcher(-1);
        URI_MATCHER.addURI("mms", null, 0);
        URI_MATCHER.addURI("mms", "#", 1);
        URI_MATCHER.addURI("mms", "inbox", 2);
        URI_MATCHER.addURI("mms", "inbox/#", 3);
        URI_MATCHER.addURI("mms", "sent", 4);
        URI_MATCHER.addURI("mms", "sent/#", 5);
        URI_MATCHER.addURI("mms", "drafts", 6);
        URI_MATCHER.addURI("mms", "drafts/#", 7);
        URI_MATCHER.addURI("mms", "outbox", 8);
        URI_MATCHER.addURI("mms", "outbox/#", 9);
        URI_MATCHER.addURI("mms-sms", "conversations", 10);
        URI_MATCHER.addURI("mms-sms", "conversations/#", 11);
        MATCH_TO_MSGBOX_ID_MAP = new HashMap();
        MATCH_TO_MSGBOX_ID_MAP.put(2, 1);
        MATCH_TO_MSGBOX_ID_MAP.put(4, 2);
        MATCH_TO_MSGBOX_ID_MAP.put(6, 3);
        MATCH_TO_MSGBOX_ID_MAP.put(8, 4);
    }

    private PduCache() {
    }

    public static final PduCache getInstance() {
        synchronized (PduCache.class) {
            if (sInstance == null) {
                sInstance = new PduCache();
            }
            PduCache pduCache = sInstance;
            return pduCache;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Uri normalizeKey(Uri uri) {
        switch (URI_MATCHER.match(uri)) {
            default: {
                return null;
            }
            case 1: {
                return uri;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
        }
        String string2 = uri.getLastPathSegment();
        return Uri.withAppendedPath(Telephony.Mms.CONTENT_URI, string2);
    }

    private void purgeByMessageBox(Integer n) {
        HashSet<Uri> hashSet;
        if (n != null && (hashSet = this.mMessageBoxes.remove(n)) != null) {
            for (Uri uri : hashSet) {
                PduCacheEntry pduCacheEntry = (PduCacheEntry)super.purge(uri);
                if (pduCacheEntry == null) continue;
                this.removeFromThreads(uri, pduCacheEntry);
            }
        }
    }

    private void purgeByThreadId(long l) {
        HashSet<Uri> hashSet = this.mThreads.remove(l);
        if (hashSet != null) {
            for (Uri uri : hashSet) {
                PduCacheEntry pduCacheEntry = (PduCacheEntry)super.purge(uri);
                if (pduCacheEntry == null) continue;
                this.removeFromMessageBoxes(uri, pduCacheEntry);
            }
        }
    }

    private PduCacheEntry purgeSingleEntry(Uri uri) {
        PduCacheEntry pduCacheEntry = (PduCacheEntry)super.purge(uri);
        if (pduCacheEntry != null) {
            this.removeFromThreads(uri, pduCacheEntry);
            this.removeFromMessageBoxes(uri, pduCacheEntry);
            return pduCacheEntry;
        }
        return null;
    }

    private void removeFromMessageBoxes(Uri uri, PduCacheEntry pduCacheEntry) {
        HashSet<Uri> hashSet = this.mThreads.get(pduCacheEntry.getMessageBox());
        if (hashSet != null) {
            hashSet.remove(uri);
        }
    }

    private void removeFromThreads(Uri uri, PduCacheEntry pduCacheEntry) {
        HashSet<Uri> hashSet = this.mThreads.get(pduCacheEntry.getThreadId());
        if (hashSet != null) {
            hashSet.remove(uri);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PduCacheEntry purge(Uri uri) {
        synchronized (this) {
            int n = URI_MATCHER.match(uri);
            switch (n) {
                default: {
                    return null;
                }
                case 1: {
                    return this.purgeSingleEntry(uri);
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    String string2 = uri.getLastPathSegment();
                    return this.purgeSingleEntry(Uri.withAppendedPath(Telephony.Mms.CONTENT_URI, string2));
                }
                case 0: 
                case 10: {
                    this.purgeAll();
                    return null;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    this.purgeByMessageBox(MATCH_TO_MSGBOX_ID_MAP.get(n));
                    return null;
                }
                case 11: {
                    this.purgeByThreadId(ContentUris.parseId(uri));
                    return null;
                }
            }
        }
    }

    @Override
    public void purgeAll() {
        synchronized (this) {
            super.purgeAll();
            this.mMessageBoxes.clear();
            this.mThreads.clear();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean put(Uri uri, PduCacheEntry pduCacheEntry) {
        synchronized (this) {
            Uri uri2;
            boolean bl;
            long l;
            HashSet<Uri> hashSet;
            int n = pduCacheEntry.getMessageBox();
            HashSet<Uri> hashSet2 = this.mMessageBoxes.get(n);
            if (hashSet2 == null) {
                hashSet2 = new HashSet();
                this.mMessageBoxes.put(n, hashSet2);
            }
            if ((hashSet = this.mThreads.get(l = pduCacheEntry.getThreadId())) == null) {
                hashSet = new HashSet();
                this.mThreads.put(l, hashSet);
            }
            if (bl = super.put(uri2 = this.normalizeKey(uri), pduCacheEntry)) {
                hashSet2.add(uri2);
                hashSet.add(uri2);
            }
            return bl;
        }
    }
}

