/**
 * Copyright (C) 2009, 2010 SC 4ViewSoft SRL
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *      http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package view.chart;

import java.util.ArrayList;
import java.util.List;

import org.achartengine.ChartFactory;
import org.achartengine.chart.PointStyle;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.renderer.XYSeriesRenderer;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.Paint.Align;
import android.os.Bundle;

/**
 * Average temperature demo chart.
 * 
 */

public class TemperatureChart extends AbstractDemoChart {
  /**
   * Returns the chart name.
   * 
   * @return the chart name
   */
  public String getName() {
    return "粮情监测系统";
  }

  /**
   * Returns the chart description.
   * 
   * @return the chart description
   */
  public String getDesc() {
    return "The average temperature in 4 Greek islands (line chart)";
  }

  /**
   * Executes the chart demo.
   * 
   * @param context the context
   * @return the built intent
   */                                                                                                         
  public Intent execute(Context context) {
    String[] titles = new String[] { "粮仓外部温度", "粮食温度", "粮仓内部温度" };
    List<double[]> x = new ArrayList<double[]>();
      x.add(new double[] { 2, 4, 6, 8, 10, 12, 14, 16, 18, 20,22,24 });
      x.add(new double[] {2, 4, 6, 8, 10, 12, 14, 16, 18, 20 ,22,24});
      x.add(new double[] { 2, 4, 6, 8, 10, 12, 14, 16, 18, 20 ,22,24});
    List<double[]> values = new ArrayList<double[]>();
    values.add(new double[] { 9, 8.4, 8.8, 9.8, 12.4, 14.4, 20.4, 16.1, 13.6, 10.3, 7.2,
        11.9 });
    values.add(new double[] { 13, 14, 12, 15, 20, 24, 26, 26, 23, 18, 14, 15 });
    values.add(new double[] { 10, 9, 10, 10, 16, 21, 24, 21, 19, 18, 12, 12 });
    int[] colors = new int[] { Color.WHITE,  Color.CYAN, Color.YELLOW };
    PointStyle[] styles = new PointStyle[] {  PointStyle.DIAMOND,
        PointStyle.SQUARE ,PointStyle.CIRCLE};
    XYMultipleSeriesRenderer renderer = buildRenderer(colors, styles);
    int length = renderer.getSeriesRendererCount();
    for (int i = 0; i < length; i++) {
      ((XYSeriesRenderer) renderer.getSeriesRendererAt(i)).setFillPoints(true);
    }
    setChartSettings(renderer, "温度曲线", "时刻", "温度", 0.5, 24.5, -5, 45,
        Color.LTGRAY, Color.LTGRAY);
    renderer.setXLabels(12);
    renderer.setYLabels(10);
    renderer.setShowGrid(true);
    renderer.setXLabelsAlign(Align.RIGHT);
    renderer.setYLabelsAlign(Align.RIGHT);
    renderer.setZoomButtonsVisible(true);         //放大缩小
    renderer.setPanLimits(new double[] { -10, 20, -10, 40 });
    renderer.setZoomLimits(new double[] { -10, 20, -10, 40 });

   Intent intent = ChartFactory.getLineChartIntent(context, buildDataset(titles, x, values),
       renderer, "Average temperature");
    return intent;
  }

}
