package view.graphic;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

import android.opengl.GLSurfaceView;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.view.MotionEvent;
import android.widget.Toast;

import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;

import view.graphic.GrainCloudActivity;
class CloudSurfaceView extends GLSurfaceView 
{
	int[] textureIds=new int[3];
	private final float TOUCH_SCALE_FACTOR = 180.0f/320;//角度缩放比例
    private SceneRenderer mRenderer;//场景渲染器    
    
    private float mPreviousY;//上次的触控位置Y坐标
    private float mPreviousX;//上次的触控位置X坐标
	//关于摄像机的变量
	float cx=0;//摄像机x位置
	float cy=0;//摄像机y位置
	float cz=60;//摄像机z位置
	int k;
	float Zx=8.0f;float Zy=2.5f;float Zz=4.0f;//温度云图的三轴尺寸
	float tx=0;//目标点x位置
	float ty=0;//目标点y位置
	float tz=0;//目标点z位置
	public float currSightDis=100;//摄像机和目标的距离
	float angdegElevation=30;//仰角
	public float angdegAzimuth=180;//方位角	
	float left;
    float right;
	float top;
	float bottom;
	float near;
	float far;
	static float Tucengch;
	//可触控物体列表
	ArrayList<TouchableObject> lovnList=new ArrayList<TouchableObject>();
	//被选中物体的索引值，即id，没有被选中时索引值为-1
	int checkedIndex=-1;
	public CloudSurfaceView(Context context) {
        super(context);
        this.setEGLContextClientVersion(2); //设置使用OPENGL ES2.0
        mRenderer = new SceneRenderer();	//创建场景渲染器
        setRenderer(mRenderer);				//设置渲染器		        
        setRenderMode(GLSurfaceView.RENDERMODE_CONTINUOUSLY);//设置渲染模式为主动渲染   
    
    }
	
	//触摸事件回调方法
    @Override 
    public boolean onTouchEvent(MotionEvent e) 
    {
        float y = e.getY();
        float x = e.getX();
        switch (e.getAction()) {
        case MotionEvent.ACTION_DOWN:
			//计算仿射变换后AB两点的位置
			float[] AB=IntersectantUtil.calculateABPosition
			(
				x, //触控点X坐标
				y, //触控点Y坐标
				GrainCloudActivity.ScreenWidth, //屏幕宽度
				GrainCloudActivity.ScreenHeight, //屏幕长度
				left, //视角left、top值
				top,
				near, //视角near、far值
				far
			);
			//射线AB
			Vector3f start = new Vector3f(AB[0], AB[1], AB[2]);//起点
			Vector3f end = new Vector3f(AB[3], AB[4], AB[5]);//终点
			Vector3f dir = end.minus(start);//长度和方向
			/*
			 * 计算AB线段与每个物体包围盒的最佳交点(与A点最近的交点)，
			 * 并记录有最佳交点的物体在列表中的索引值
			 */
			//记录列表中时间最小的索引值
    		checkedIndex = -1;//标记为没有选中任何物体
    		int tmpIndex=-1;//记录与A点最近物体索引的临时值
    		float minTime=1;//记录列表中所有物体与AB相交的最短时间
    		for(int i=0;i<lovnList.size();i++){//遍历列表中的物体
    			AABB3 box = lovnList.get(i).getCurrBox(); //获得物体AABB包围盒   
				float t = box.rayIntersect(start, dir, null);//计算相交时间
    			if (t <= minTime) {
					minTime = t;//记录最小值
					tmpIndex = i;//记录最小值索引
				}
    		}
    		checkedIndex=tmpIndex;//将索引保存在checkedIndex中    		
    		changeObj(checkedIndex);//改变被选中物体	
       	break;
        case MotionEvent.ACTION_MOVE:
            float dy = y - mPreviousY;//计算触控笔Y位移
            float dx = x - mPreviousX;//计算触控笔X位移
            //不超过阈值不移动摄像机
            if(Math.abs(dx)<7f && Math.abs(dy)<7f){
            	break;
            }            
            angdegAzimuth += dx * TOUCH_SCALE_FACTOR;//设置沿x轴旋转角度
            angdegElevation += dy * TOUCH_SCALE_FACTOR;//设置沿z轴旋转角度
            //将仰角限制在5～90度范围内
            angdegElevation = Math.max(angdegElevation, 5);
            angdegElevation = Math.min(angdegElevation, 90);
            //设置摄像机的位置
            setCameraPostion();
        break;
        }
        mPreviousY = y;//记录触控笔位置
        mPreviousX = x;//记录触控笔位置
        return true;
    }
    //设置摄像机位置的方法
	public void setCameraPostion() {
		//计算摄像机的位置
		double angradElevation = Math.toRadians(angdegElevation);//仰角（弧度）
		double angradAzimuth = Math.toRadians(angdegAzimuth);//方位角
		cx = (float) (tx - currSightDis * Math.cos(angradElevation)	* Math.sin(angradAzimuth));
		cy = (float) (ty + currSightDis * Math.sin(angradElevation));
		cz = (float) (tz - currSightDis * Math.cos(angradElevation) * Math.cos(angradAzimuth));
	}
	//改变列表中下标为index的物体
	public void changeObj(int index){
		if(index != -1){//如果有物体被选中
    		for(int i=0;i<lovnList.size();i++){
    			if(i==index){//改变选中的物体
    				lovnList.get(i).changeOnTouch(true,i);
    		//	Toast.makeText(mRenderer.this, "hello", Toast.LENGTH_SHORT);
    		
    			}
    			else{//恢复其他物体
    				lovnList.get(i).changeOnTouch(false,i);
    			}
    		}
        }
    	else{//如果没有物体被选中
    		for(int i=0;i<lovnList.size();i++){//恢复其他物体			
    			lovnList.get(i).changeOnTouch(false,i);
    		}
    	}
	}
	private class SceneRenderer implements GLSurfaceView.Renderer 
    {
    	//从指定的obj文件中加载对象
		LoadedObjectVertexNormalFace pm;
		 
		LoadedObjectVertexNormalFace cft;
		LoadedObjectVertexNormalAverage xzcft[] ;
		LoadedObjectVertexNormalAverage zcft0 ;
		LoadedObjectVertexNormalAverage zcft1 ;
		LoadedObjectVertexNormalAverage zcft2 ;
		LoadedObjectVertexNormalAverage zcft3 ;
		LoadedObjectVertexNormalAverage zcft4 ;
		LoadedObjectVertexNormalAverage zcft5 ;
		LoadedObjectVertexNormalAverage zcft6 ;
		LoadedObjectVertexNormalAverage zcft7;
		LoadedObjectVertexNormalAverage zcft8 ;
		LoadedObjectVertexNormalAverage zcft9 ;
		LoadedObjectVertexNormalAverage zcft10 ;
		LoadedObjectVertexNormalAverage zcft11 ;
		LoadedObjectVertexNormalAverage zcft12 ;
		LoadedObjectVertexNormalAverage zcft13 ;
		LoadedObjectVertexNormalAverage zcft14 ;
		LoadedObjectVertexNormalAverage zcft15 ;
        public void onDrawFrame(GL10 gl) 
        { 
        	//清除深度缓冲与颜色缓冲
            GLES20.glClear( GLES20.GL_DEPTH_BUFFER_BIT | GLES20.GL_COLOR_BUFFER_BIT);
			//设置camera位置
			MatrixState.setCamera(cx, cy, cz, tx, ty, tz, 0, 1, 0);
            //初始化光源位置
            MatrixState.setLightLocation(100, 100, 100);                    
            //绘制物体            
            //pm.drawSelf();//平面
        	/*if(Index==1){ MatrixState.pushMatrix();
        		MatrixState.translate(0, 0f, -60f);
        		   MatrixState.translate(-10f, 0f, 0f);
        	         
        	     tp.drawSelf(gl,textureIds[0]);
        	     MatrixState.popMatrix(); 
        	}
        	else
        	{*/
           if(Tucengch==1){
            MatrixState.pushMatrix(); 
            MatrixState.translate(0, 15f,0);
            MatrixState.scale(Zx, Zy/4, Zz);
            zcft0.drawSelf();
            MatrixState.popMatrix();   
            //绘制球体
            MatrixState.pushMatrix();
            MatrixState.translate(0f, 7.5f, 0);
            MatrixState.scale(Zx, Zy/4, Zz);
            zcft1.drawSelf();
            MatrixState.popMatrix();  
            //绘制圆环
            MatrixState.pushMatrix();
            MatrixState.translate(0, 0f, 0f);
            MatrixState.scale(Zx, Zy/4, Zz);
            //MatrixState.rotate(45, 0, 1, 0);
            zcft2.drawSelf();
            MatrixState.popMatrix();  
            //绘制茶壶
            MatrixState.pushMatrix();
            MatrixState.translate(0, -7.5f, 0f);
            MatrixState.scale(Zx, Zy/4, Zz);
           // MatrixState.rotate(30, 0, 1, 0);
            zcft3.drawSelf();
            MatrixState.popMatrix(); }
            else if(Tucengch==2){
               MatrixState.pushMatrix(); 
               MatrixState.translate(0, 0f,22.5f);
               MatrixState.scale(Zx, Zy, Zz/8);
               zcft0.drawSelf();
               MatrixState.popMatrix();   
               //绘制球体
               MatrixState.pushMatrix();
               MatrixState.translate(0f, 0f, 15f);
               MatrixState.scale(Zx, Zy, Zz/8);
               zcft1.drawSelf();
               MatrixState.popMatrix();  
               //绘制圆环
               MatrixState.pushMatrix();
               MatrixState.translate(0, 0f, 7.5f);
               MatrixState.scale(Zx, Zy, Zz/8);
               //MatrixState.rotate(45, 0, 1, 0);
               zcft2.drawSelf();
               MatrixState.popMatrix();  
               //绘制茶壶
               MatrixState.pushMatrix();
               MatrixState.translate(0, 0f, 0f);
               MatrixState.scale(Zx, Zy, Zz/8);
               zcft3.drawSelf();
               MatrixState.popMatrix(); 
               MatrixState.pushMatrix(); 
               MatrixState.translate(0, 0f,-7.5f);
               MatrixState.scale(Zx, Zy, Zz/8);
               zcft4.drawSelf();
               MatrixState.popMatrix();   
               //绘制球体
               MatrixState.pushMatrix();
               MatrixState.translate(0f, 0f, -15f);
               MatrixState.scale(Zx, Zy, Zz/8);
               zcft5.drawSelf();
               MatrixState.popMatrix();  
               //绘制圆环
               MatrixState.pushMatrix();
               MatrixState.translate(0, 0f, -22.5f);
               MatrixState.scale(Zx, Zy, Zz/8);
               //MatrixState.rotate(45, 0, 1, 0);
               zcft6.drawSelf();
               MatrixState.popMatrix();  
               //绘制茶壶
               MatrixState.pushMatrix();
               MatrixState.translate(0, 0f, -30f);
               MatrixState.scale(Zx, Zy, Zz/8);
               zcft7.drawSelf();
               MatrixState.popMatrix();  }
            else if(Tucengch==3){
                MatrixState.pushMatrix(); 
                MatrixState.translate(52.5f, 0f,0f);
                MatrixState.scale(Zx/16, Zy, Zz);
                zcft0.drawSelf();
                MatrixState.popMatrix();   
                //绘制球体
                MatrixState.pushMatrix();
                MatrixState.translate(45f, 0f, 0f);
                MatrixState.scale(Zx/16, Zy, Zz);
                zcft1.drawSelf();
                MatrixState.popMatrix();  
                //绘制圆环
                MatrixState.pushMatrix();
                MatrixState.translate(37.5f, 0f, 0f);
                MatrixState.scale(Zx/16, Zy, Zz);
                //MatrixState.rotate(45, 0, 1, 0);
                zcft2.drawSelf();
                MatrixState.popMatrix();  
                //绘制茶壶
                MatrixState.pushMatrix();
                MatrixState.translate(30f, 0f, 0f);
                MatrixState.scale(Zx/16, Zy, Zz);
                zcft3.drawSelf();
                MatrixState.popMatrix(); 
                MatrixState.pushMatrix(); 
                MatrixState.translate(22.5f, 0f,0f);
                MatrixState.scale(Zx/16, Zy, Zz);
                zcft4.drawSelf();
                MatrixState.popMatrix();   
                //绘制球体
                MatrixState.pushMatrix();
                MatrixState.translate(15f, 0f, 0f);
                MatrixState.scale(Zx/16, Zy, Zz);
                zcft5.drawSelf();
                MatrixState.popMatrix();  
                //绘制圆环
                MatrixState.pushMatrix();
                MatrixState.translate(7.5f, 0f, 0f);
                MatrixState.scale(Zx/16, Zy, Zz);
                //MatrixState.rotate(45, 0, 1, 0);
                zcft6.drawSelf();
                MatrixState.popMatrix();  
                //绘制茶壶
                MatrixState.pushMatrix();
                MatrixState.translate(0, 0f, 0f);
                MatrixState.scale(Zx/16, Zy, Zz);
                zcft7.drawSelf();
                MatrixState.popMatrix(); 
                
                MatrixState.pushMatrix(); 
                MatrixState.translate(-7.5f, 0f,0f);
                MatrixState.scale(Zx/16, Zy, Zz);
                zcft8.drawSelf();
                MatrixState.popMatrix();   
                //绘制球体
                MatrixState.pushMatrix();
                MatrixState.translate(-15f, 0f, 0f);
                MatrixState.scale(Zx/16, Zy, Zz);
                zcft9.drawSelf();
                MatrixState.popMatrix();  
                //绘制圆环
                MatrixState.pushMatrix();
                MatrixState.translate(-22.5f, 0f, 0f);
                MatrixState.scale(Zx/16, Zy, Zz);
                //MatrixState.rotate(45, 0, 1, 0);
                zcft10.drawSelf();
                MatrixState.popMatrix();  
                //绘制茶壶
                MatrixState.pushMatrix();
                MatrixState.translate(-30f, 0f, 0f);
                MatrixState.scale(Zx/16, Zy, Zz);
                zcft11.drawSelf();
                MatrixState.popMatrix(); 
                MatrixState.pushMatrix(); 
                MatrixState.translate(-37.5f, 0f,0f);
                MatrixState.scale(Zx/16, Zy, Zz);
                zcft12.drawSelf();
                MatrixState.popMatrix();   
                //绘制球体
                MatrixState.pushMatrix();
                MatrixState.translate(-45f, 0f, 0f);
                MatrixState.scale(Zx/16, Zy, Zz);
                zcft13.drawSelf();
                MatrixState.popMatrix();  
                //绘制圆环
                MatrixState.pushMatrix();
                MatrixState.translate(-52.5f, 0f, 0f);
                MatrixState.scale(Zx/16, Zy, Zz);
                //MatrixState.rotate(45, 0, 1, 0);
                zcft14.drawSelf();
                MatrixState.popMatrix();  
                //绘制茶壶
                MatrixState.pushMatrix();
                MatrixState.translate(-60f, 0f, 0f);
                MatrixState.scale(Zx/16, Zy, Zz);
                zcft15.drawSelf();
                MatrixState.popMatrix();
                
                }
           else if(Tucengch==0){
        	   MatrixState.pushMatrix(); 
               MatrixState.translate(0, -10f,0);
               MatrixState.scale(Zx, Zy, Zz);
               cft.drawSelf();
               MatrixState.popMatrix();
           }
           
        	
          
         
        } 

        public void onSurfaceChanged(GL10 gl, int width, int height) {
            //设置视窗大小及位置 
        	GLES20.glViewport(0, 0, width, height); 
        	//计算GLSurfaceView的宽高比
            float ratio = (float) width / height;
            //调用此方法计算产生透视投影矩阵
            left=right=ratio;
            top=bottom=1;
            near=2;
            far=500;
            MatrixState.setProjectFrustum(-left, right, -bottom, top, near, far);
            //计算摄像机的位置
            setCameraPostion();
        }

        public void onSurfaceCreated(GL10 gl, EGLConfig config) {
            //设置屏幕背景色RGBA
            GLES20.glClearColor(0f,0f,0f,1.0f);    
            //打开深度检测
            GLES20.glEnable(GLES20.GL_DEPTH_TEST);  
            //关闭背面剪裁
            GLES20.glDisable(GLES20.GL_CULL_FACE);
            //初始化变换矩阵
            MatrixState.setInitStack();
            //加载要绘制的物体
           
           /* for(k=0;k<=5;k++) {   
            xzcft[k]=LoadUtil.loadFromFileVertexOnlyAverage("cft.obj", MySurfaceView.this.getResources(),MySurfaceView.this);
            }*/
            zcft0=LoadUtil.loadFromFileVertexOnlyAverage("cft.obj", CloudSurfaceView.this.getResources(),CloudSurfaceView.this);
            zcft1=LoadUtil.loadFromFileVertexOnlyAverage("cft.obj", CloudSurfaceView.this.getResources(),CloudSurfaceView.this);
            zcft2=LoadUtil.loadFromFileVertexOnlyAverage("cft.obj", CloudSurfaceView.this.getResources(),CloudSurfaceView.this);
            zcft3=LoadUtil.loadFromFileVertexOnlyAverage("cft.obj", CloudSurfaceView.this.getResources(),CloudSurfaceView.this);
            zcft4=LoadUtil.loadFromFileVertexOnlyAverage("cft.obj", CloudSurfaceView.this.getResources(),CloudSurfaceView.this);
            zcft5=LoadUtil.loadFromFileVertexOnlyAverage("cft.obj", CloudSurfaceView.this.getResources(),CloudSurfaceView.this);
            zcft6=LoadUtil.loadFromFileVertexOnlyAverage("cft.obj", CloudSurfaceView.this.getResources(),CloudSurfaceView.this);
            zcft7=LoadUtil.loadFromFileVertexOnlyAverage("cft.obj", CloudSurfaceView.this.getResources(),CloudSurfaceView.this);
            zcft8=LoadUtil.loadFromFileVertexOnlyAverage("cft.obj", CloudSurfaceView.this.getResources(),CloudSurfaceView.this);
            zcft9=LoadUtil.loadFromFileVertexOnlyAverage("cft.obj", CloudSurfaceView.this.getResources(),CloudSurfaceView.this);
            zcft10=LoadUtil.loadFromFileVertexOnlyAverage("cft.obj", CloudSurfaceView.this.getResources(),CloudSurfaceView.this);
            zcft11=LoadUtil.loadFromFileVertexOnlyAverage("cft.obj", CloudSurfaceView.this.getResources(),CloudSurfaceView.this);
            zcft12=LoadUtil.loadFromFileVertexOnlyAverage("cft.obj", CloudSurfaceView.this.getResources(),CloudSurfaceView.this);
            zcft13=LoadUtil.loadFromFileVertexOnlyAverage("cft.obj", CloudSurfaceView.this.getResources(),CloudSurfaceView.this);
            zcft14=LoadUtil.loadFromFileVertexOnlyAverage("cft.obj", CloudSurfaceView.this.getResources(),CloudSurfaceView.this);
            zcft15=LoadUtil.loadFromFileVertexOnlyAverage("cft.obj", CloudSurfaceView.this.getResources(),CloudSurfaceView.this);
            cft=LoadUtil.loadFromFileVertexOnlyFace("cft.obj", CloudSurfaceView.this.getResources(),CloudSurfaceView.this);
    		/*for(k=0;k<=5;k++){
    		lovnList.add(xzcft[k]);
    		}*/
    		lovnList.add(zcft0); lovnList.add(zcft1);lovnList.add(zcft2);lovnList.add(zcft3);
    		lovnList.add(zcft4); lovnList.add(zcft5);lovnList.add(zcft6);lovnList.add(zcft7);
    		lovnList.add(zcft8); lovnList.add(zcft9);lovnList.add(zcft10);lovnList.add(zcft11);
    		lovnList.add(zcft12); lovnList.add(zcft13);lovnList.add(zcft14);lovnList.add(zcft15);
        }
    }
	public int initTexture(GL10 gl,int drawableId){
	   int[] textures=new int[1];
	   gl.glGenTextures(1,textures,0);
	   int currTextureId=textures[0];
	   gl.glBindTexture(GL10.GL_TEXTURE_2D, currTextureId);
	   gl.glTexParameterf(GL10.GL_TEXTURE_2D,GL10.GL_TEXTURE_MIN_FILTER, GL10.GL_NEAREST);
	   gl.glTexParameterf(GL10.GL_TEXTURE_2D,GL10.GL_TEXTURE_MAG_FILTER, GL10.GL_LINEAR);
	   gl.glTexParameterf(GL10.GL_TEXTURE_2D, GL10.GL_TEXTURE_WRAP_S, GL10.GL_CLAMP_TO_EDGE);
	   gl.glTexParameterf(GL10.GL_TEXTURE_2D, GL10.GL_TEXTURE_WRAP_T, GL10.GL_CLAMP_TO_EDGE);
	   InputStream is=this.getResources().openRawResource(drawableId);
	   Bitmap bitmapTmp;
	   try{
		   bitmapTmp=BitmapFactory.decodeStream(is);
	   }
	   finally { try{is.close();}
	   catch(IOException e) {e.printStackTrace();}
	   }
	   GLUtils.texImage2D(GL10.GL_TEXTURE_2D, 0, bitmapTmp, 0);
	   bitmapTmp.recycle();
	   return currTextureId;
	}
}

