package view.graphic;





import view.main.R;
import android.app.Activity;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.LinearLayout;
 
public class GrainCloudActivity extends Activity {
	private CloudSurfaceView mGLSurfaceView;
	private ImageSurfaceView IglSurfaceView;
	static float ScreenWidth;//屏幕宽度
	static float ScreenHeight;//屏幕高度
	public static boolean f=true;
	
    @Override
    protected void onCreate(Bundle savedInstanceState) 
    {
        super.onCreate(savedInstanceState);         
        //设置为全屏
        requestWindowFeature(Window.FEATURE_NO_TITLE); 
		getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN ,  
		              WindowManager.LayoutParams.FLAG_FULLSCREEN);
		//设置为横屏模式
		setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
		DisplayMetrics dm=new DisplayMetrics();
        getWindowManager().getDefaultDisplay().getMetrics(dm);
        setContentView(R.layout.stereogram);
		//初始化GLSurfaceView
        mGLSurfaceView = new CloudSurfaceView(this);
         ScreenWidth=dm.widthPixels;			//dm.widthPixels    获取屏幕横向分辨率
        ScreenHeight=dm.heightPixels;		//dm.heightPixels	获取屏幕竖向分辨率	                             
        mGLSurfaceView.requestFocus();//获取焦点
        mGLSurfaceView.setFocusableInTouchMode(true);//设置为可触控  
        // setContentView(mGLSurfaceView);	
        LinearLayout ll=(LinearLayout)findViewById(R.id.stereoliner); 
        ll.addView(mGLSurfaceView); 
        
         IglSurfaceView = new ImageSurfaceView(this);
 		IglSurfaceView.requestFocus();//获取焦点
 		IglSurfaceView.setFocusableInTouchMode(true);//设置为可触控  
        //将自定义的GLSurfaceView添加到外层LinearLayout中
        LinearLayout l2=(LinearLayout)findViewById(R.id.imageliner); 
        l2.addView(IglSurfaceView); 
     // mGLSurfaceView = new MySurfaceView(this);
       
         IglSurfaceView.screenHeight=dm.widthPixels;
         IglSurfaceView.screenWidth=dm.heightPixels;
         IglSurfaceView.ratio=IglSurfaceView.screenWidth/IglSurfaceView.screenHeight;  
    
         Button floorButton = (Button) findViewById(R.id.vis);
         Button rowButton = (Button) findViewById(R.id.invis);
         Button lieButton = (Button) findViewById(R.id.gone);
         Button yuntuButton=(Button)findViewById(R.id.backs);
         floorButton.setOnClickListener(mfloorListener);
         rowButton.setOnClickListener(mrowListener);
         lieButton.setOnClickListener(mlieListener);
         yuntuButton.setOnClickListener(mtuListener);
}
   

    @Override
    protected void onResume() {
        super.onResume();
        mGLSurfaceView.onResume();
        IglSurfaceView.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
        mGLSurfaceView.onPause();
        IglSurfaceView.onPause();
    }  
    OnClickListener mfloorListener = new OnClickListener() {
        public void onClick(View v) {
      
       mGLSurfaceView.Tucengch=1;
        }
    };

    OnClickListener mrowListener = new OnClickListener() {
        public void onClick(View v) {
        	mGLSurfaceView.Tucengch=2;
        }
    };

    OnClickListener mlieListener = new OnClickListener() {
        public void onClick(View v) {
        	mGLSurfaceView.Tucengch=3;
        }
    };
    OnClickListener mtuListener = new OnClickListener() {
        public void onClick(View v) {
        	mGLSurfaceView.Tucengch=0;
        }
    };
}