
package view.graphic;
import static view.graphic.Constant.NEAR;
import static view.graphic.Constant.PHOTO_COUNT;

import java.io.IOException;
import java.io.InputStream;

import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

import view.main.R;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLSurfaceView;
import android.opengl.GLUtils;
import android.view.KeyEvent;
import android.view.MotionEvent;

public class ImageSurfaceView extends GLSurfaceView 
{
	public float screenWidth;//屏幕宽带
	public float screenHeight;//屏幕高度
	public float ratio;//屏幕宽高比
	private final float TOUCH_SCALE_FACTOR = 180.0f/320;//角度缩放比例
	private final float TOUCH_SCALE = 0.05f;
	private SceneRenderer mRenderer;//场景渲染器
	
    float mPreviousX;//上次按下位置x坐标
    float mPreviousY;//上次按下位置y坐标
    long previousTime;//上次按下的时间
    boolean isCheck=false;//是否点击查看图片
    boolean isMove=false;
    
    int[] cloudtextureIds=new int[PHOTO_COUNT];//云图纹理id数组
    int[] gridtextureIds=new int[PHOTO_COUNT];//温度数据纹理id数组
    float yAngle=0;//总场景旋转角度
    static int currIndex=0;//当前选中的索引
    float yAngleV=0;//总场景角度变化速度
	
	public ImageSurfaceView(Context context) { 
        super(context);
        mRenderer = new SceneRenderer();	//创建场景渲染器
        setRenderer(mRenderer);				//设置渲染器		
        setRenderMode(GLSurfaceView.RENDERMODE_CONTINUOUSLY);//设置渲染模式为主动渲染   
        
     }
	@Override
    public boolean onKeyDown(int keyCode, KeyEvent e)
    { 
    	if(keyCode==4)
    	{
    		
    	 // currIndex=0;
    		//}
    	//	else
    	// {//若在主场景中则退出程序
    			System.exit(0);
    	//	}
    	}
    	return true;
    }
	
	 private   float  x1;
	  private   float  y1;
	  private   float  x2;
	  private   float  y2;
	  float  r1  =  0F;
      float  r2  =  0F; 
	 float r=0.5f;
	  private   int  max  =   0 ;
	  public float mAngleY;
      public float mAngleX;
float mx;float my;

		@Override
	  public   boolean  onTouchEvent(MotionEvent event) {
	      int  action  =  event.getActionMasked();
	      int  p  =  event.getPointerCount(); // 接触点数 
	      x1  =  event.getX();
	      y1  =  event.getY();
	      int  N  =  event.getHistorySize();
	      if (N  >  max){
	         max  =  N;
	     }
	    // 只处理两点触摸 
	      if (p  ==   2   &&  action  ==  MotionEvent.ACTION_POINTER_1_DOWN){
	         x1  =  event.getX( 0 );
	         y1  =  event.getY( 0 );
	         x2  =  event.getX( 1 );
	         y2  =  event.getY( 1 );
	         
	     }
	      // 只处理两点触摸 
	      if (p  ==   2   &&  action  ==  MotionEvent.ACTION_MOVE){
	        r1  =  ( float ) Math.sqrt((x1  -  x2)  *  (x1  -  x2)  +  (y1  -  y2)
	                  *  (y1  -  y2))  /   2 ;
	          float  tx1  =  event.getX( 0 );
	          float  ty1  =  event.getY( 0 );
	          float  tx2  =  event.getX( 1 );
	          float  ty2  =  event.getY( 1 );
	         r2  =  ( float ) Math.sqrt((tx1  -  tx2)  *  (tx1  -  tx2)  +  (ty1  -  ty2)
	                  *  (ty1  -  ty2))  /   2 ;
	          
	        r  =  r  +  (r2  -  r1)/5000;
	     } 
	      if (p  ==   1 && action  ==  MotionEvent.ACTION_MOVE){
	          
	          float dx = x1 - mPreviousX;
	          float dy = y1 - mPreviousY;
	          mAngleX += dx * TOUCH_SCALE_FACTOR;
	          mx += dx * TOUCH_SCALE;
	          mAngleY += dy * TOUCH_SCALE_FACTOR;
	          my += dy * TOUCH_SCALE;
	      }
	      if(p==1&&action==MotionEvent.ACTION_DOWN){
	    	  
	      }
	      mPreviousX = x1;
	      mPreviousY = y1;
	      return   true ;

	 }

	public class SceneRenderer implements GLSurfaceView.Renderer 
    {   
    	Board tp=new Board(); //用于显示照片的纹理矩形   	
    	
    	public SceneRenderer(){}
        public void onDrawFrame(GL10 gl) 
        { 
        	//清除颜色缓存于深度缓存
        	gl.glClear(GL10.GL_COLOR_BUFFER_BIT | GL10.GL_DEPTH_BUFFER_BIT);
        	//设置当前矩阵为模式矩阵
            gl.glMatrixMode(GL10.GL_MODELVIEW);
            //设置当前矩阵为单位矩阵
            gl.glLoadIdentity();    
         	
           
         	 if(currIndex==1)
            {  	
          gl.glTranslatef(0, 0f, -60f); 
        	gl.glTranslatef(mx, -my, 0);
         	 gl.glScalef(r, r, 0);
         	gl.glTranslatef(0, 8f, 0f);
            	tp.drawSelf(gl,gridtextureIds[0]);
          gl.glTranslatef(0, -18f, 0f);   
        	tp.drawSelf(gl,cloudtextureIds[0]);
        //   	gl.glPopMatrix();  
            }
           else if(currIndex==2)
           {
        	   gl.glTranslatef(0, 0f, -60f); 
        		gl.glTranslatef(mx, -my, 0);
        		 gl.glScalef(r, r, 0);
        		gl.glTranslatef(0f, 8f, 0);
               	tp.drawSelf(gl,gridtextureIds[1]);
               gl.glTranslatef(0, -18f, 0f);   
            tp.drawSelf(gl,cloudtextureIds[1]);
           }
           else if(currIndex==3)
           {
        	   gl.glTranslatef(0, 0f, -60f); 
           	gl.glTranslatef(mx, -my, 0);
            	 gl.glScalef(r, r, 0);
            	gl.glTranslatef(0f, 8f, 0);
               	tp.drawSelf(gl,gridtextureIds[2]);
                gl.glTranslatef(0, -18f, 0f);   
            	tp.drawSelf(gl,cloudtextureIds[2]);
           }
           else if(currIndex==4){
        	   gl.glTranslatef(0, 0f, -60f); 
        	   gl.glScalef(r, r, 0);
              gl.glTranslatef(mx, -my, 0);
              gl.glTranslatef(0f, 8f, 0);
              	tp.drawSelf(gl,gridtextureIds[3]);
              	 gl.glTranslatef(0, -18f, 0f);   
             	tp.drawSelf(gl,cloudtextureIds[3]);
           }
           else{ gl.glTranslatef(0, 0f, -60f); 
          // gl.glScalef(r, r, 0);
         //	tp.drawSelf(gl,textureIds[7]);
           }
        }
    	
    
        public void onSurfaceChanged(GL10 gl, int width, int height) {
            //设置视窗大小及位置 
        	gl.glViewport(0, 0, width, height);
        	//设置当前矩阵为投影矩阵
            gl.glMatrixMode(GL10.GL_PROJECTION);
            //设置当前矩阵为单位矩阵
            gl.glLoadIdentity();
            //调用此方法计算产生透视投影矩阵 
            gl.glFrustumf(-ratio, ratio, -1, 1, NEAR, 100);
            //设置为关闭背面剪裁
        	gl.glDisable(GL10.GL_CULL_FACE);
        }

    	
        public void onSurfaceCreated(GL10 gl, EGLConfig config) 
        {        	        	
            //关闭抗抖动 
        	gl.glDisable(GL10.GL_DITHER);
        	//设置特定Hint项目的模式，这里为设置为使用快速模式
            gl.glHint(GL10.GL_PERSPECTIVE_CORRECTION_HINT,GL10.GL_FASTEST);
            //设置屏幕背景色黑色RGBA
            gl.glClearColor(0,0,0,0);            
            //启用深度测试
            gl.glEnable(GL10.GL_DEPTH_TEST);
            //加载n幅纹理图
            cloudtextureIds[0]=initTexture(gl,R.drawable.cloudlayer_0);//图片1
            cloudtextureIds[1]=initTexture(gl,R.drawable.cloudlayer_1);//图片2
            cloudtextureIds[2]=initTexture(gl,R.drawable.cloudlayer_2);//图片3
            cloudtextureIds[3]=initTexture(gl,R.drawable.cloudlayer_3);//图片4
            cloudtextureIds[4]=initTexture(gl,R.drawable.cloudlayer_0);//图片5
            cloudtextureIds[5]=initTexture(gl,R.drawable.cloudlayer_1);//图片6
            cloudtextureIds[6]=initTexture(gl,R.drawable.cloudlayer_2);//图片7
            cloudtextureIds[7]=initTexture(gl,R.drawable.cloudlayer_3);//图片8
            gridtextureIds[0]=initTexture(gl,R.drawable.gridlayer_0);//图片1
            gridtextureIds[1]=initTexture(gl,R.drawable.gridlayer_1);//图片2
            gridtextureIds[2]=initTexture(gl,R.drawable.gridlayer_2);//图片3
            gridtextureIds[3]=initTexture(gl,R.drawable.gridlayer_3);//图片4
        }
    }
	
	//初始化纹理
	public int initTexture(GL10 gl,int drawableId)//textureId
	{
		//生成纹理ID
		int[] textures = new int[1];
		gl.glGenTextures(1, textures, 0);    
		int currTextureId=textures[0];    
		gl.glBindTexture(GL10.GL_TEXTURE_2D, currTextureId);
		gl.glTexParameterf(GL10.GL_TEXTURE_2D, GL10.GL_TEXTURE_MIN_FILTER,GL10.GL_NEAREST);
        gl.glTexParameterf(GL10.GL_TEXTURE_2D,GL10.GL_TEXTURE_MAG_FILTER,GL10.GL_LINEAR);
        gl.glTexParameterf(GL10.GL_TEXTURE_2D, GL10.GL_TEXTURE_WRAP_S,GL10.GL_CLAMP_TO_EDGE);
        gl.glTexParameterf(GL10.GL_TEXTURE_2D, GL10.GL_TEXTURE_WRAP_T,GL10.GL_CLAMP_TO_EDGE);        
        
        InputStream is = this.getResources().openRawResource(drawableId);
        Bitmap bitmapTmp; 
        try 
        {
        	bitmapTmp = BitmapFactory.decodeStream(is);
        } 
        finally 
        {
            try 
            {
                is.close();
            } 
            catch(IOException e) 
            {
                e.printStackTrace();
            }
        }
        GLUtils.texImage2D(GL10.GL_TEXTURE_2D, 0, bitmapTmp, 0);
        bitmapTmp.recycle(); 
        
        return currTextureId;
	}
}
