package view.main;


import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.format.DateFormat;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;


import android.widget.TextView;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;

/**
 * Created by YH_CHUN on 2016/4/7.
 */
public class AlarmActivity extends Activity implements View.OnClickListener{
    private EditText et_alarm_message;
    private ImageView iv_alarm_image_left;
    private ImageView iv_alarm_image_right;
    private  byte[] left;
    private byte[] right;

    private static int flag = 0;//1位点击了左边拍照图片，2为点击了右边的拍照图片
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_alarm);
        initView();
    }
    private void initView(){
        iv_alarm_image_left =(ImageView)findViewById(R.id.iv_alarm_image_left);
        iv_alarm_image_right =(ImageView)findViewById(R.id.iv_alarm_image_right);
        et_alarm_message = (EditText)findViewById(R.id.et_alarm_message);
        findViewById(R.id.tv_alarm_commit).setOnClickListener(this);
        iv_alarm_image_left.setOnClickListener(this);
        iv_alarm_image_right.setOnClickListener(this);
    }


    public void onClick(View v) {
        int id = v.getId();
        switch (id){
            case R.id.iv_alarm_image_left:
                flag = 1;
                takePhoto();
                break;
            case R.id.iv_alarm_image_right:
                flag = 2;
                takePhoto();
                break;
            case R.id.tv_alarm_commit:
                ofCommit();
                break;
        }

    }

    private void ofCommit(){
        ofFinish(new Bundle(), 100);
    }
    private void takePhoto(){
        Intent camera = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        startActivityForResult(camera, 100);

    }
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        if(requestCode == 100 && resultCode == Activity.RESULT_OK && null != data){
            String sdState= Environment.getExternalStorageState();
            if(!sdState.equals(Environment.MEDIA_MOUNTED)){
                Log.e("AlarmActivity", "sd card unmount");
                return;
            }
            new DateFormat();
            String name= DateFormat.format("yyyyMMdd_hhmmss", Calendar.getInstance(Locale.CHINA))+".jpg";
            Bundle bundle = data.getExtras();
            //获取相机返回的数据，并转换为图片格式
            Bitmap bitmap = (Bitmap)bundle.get("data");
            FileOutputStream fout = null;
            File file = new File(Constants.Path);
            file.mkdirs();
            String filename=file.getPath()+name;
            try {
                fout = new FileOutputStream(filename);
                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, fout);
            } catch (FileNotFoundException e) {
                e.printStackTrace();
            }finally{
                try {
                    fout.flush();
                    fout.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            //显示图片
            if(flag ==1)
            {
                iv_alarm_image_left.setImageBitmap(bitmap);
                left=Bitmap2Bytes(bitmap);
            }
            else if(flag ==2){
                iv_alarm_image_right.setImageBitmap(bitmap);
                right=Bitmap2Bytes(bitmap);

            }
        }


    };
    private byte[] Bitmap2Bytes(Bitmap bm){
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.PNG, 100, baos);
        return baos.toByteArray();
    }
    //返回上一个界面，
    public void onBack(View view){

        ofFinish(new Bundle(),1);

    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK){
            Bundle bundle = new Bundle();
            ofFinish(new Bundle(),1);
            return true;
        }
        return false;
    }

    private void ofFinish(Bundle bundle,int res){
        Intent intent = new Intent();
        intent.putExtras(bundle);
        setResult(res, intent);
        finish();
    }

}
