package view.main;

import java.io.IOException;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.AlertDialog.Builder;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.content.pm.ActivityInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PixelFormat;
import android.hardware.Camera;
import android.hardware.Camera.PictureCallback;
import android.hardware.Camera.ShutterCallback;
import android.os.Bundle;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.ViewGroup.LayoutParams;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

public class CameraActivity extends Activity implements SurfaceHolder.Callback, OnClickListener
{

	private static final int select = 0;
	private static final int select1 = 1;
	SurfaceView mySurfaceView;								//SurfaceView的引用
	SurfaceHolder mySurfaceHolder;						//SurfaceHolder的引用
	LinearLayout linear1;
	Button bStart;											//打开按钮
	
	Button bTpg;											//拍照按钮
	Camera myCamera;										//Camera的引用
	boolean isView = false;									//是否正在浏览中
	Bitmap bm;												//拍摄的照片 
	TextView txtView1;
	ProgressDialog pd;
    @Override
    public void onCreate(Bundle savedInstanceState) 
    {
        super.onCreate(savedInstanceState);
        //设置为横屏
        this.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
        //设置全屏显示
        requestWindowFeature(Window.FEATURE_NO_TITLE); 
        getWindow().setFlags
        (
        		WindowManager.LayoutParams.FLAG_FULLSCREEN ,  
                WindowManager.LayoutParams.FLAG_FULLSCREEN
        );
        //设置显示主界面
        setContentView(R.layout.camera);
        //得到拍照预览SurfaceView的引用
       mySurfaceView = (SurfaceView) findViewById(R.id.mySurfaceView);	
        //初始化开始按钮引用
        linear1=(LinearLayout)findViewById(R.id.cameralinearlayout);
        bStart = (Button) findViewById(R.id.Button01);					
        //初始化拍照按钮引用
        bTpg = (Button) findViewById(R.id.Button02);						
        //为三个按钮添加监听器
       							
        bStart.setOnClickListener(this);							
        bTpg.setOnClickListener(this);	
        //获得SurfaceHolder
        mySurfaceHolder = mySurfaceView.getHolder();	
        //添加回调接口的实现
        mySurfaceHolder.addCallback(this);								
        mySurfaceHolder.setType(SurfaceHolder.SURFACE_TYPE_PUSH_BUFFERS); 
        LayoutParams layoutParams = new LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT,ViewGroup.LayoutParams.WRAP_CONTENT);
         txtView1 = new TextView(this);
        txtView1.setText("lable");
   
         }
     
    @Override
    protected void onPause() {
        super.onPause();
        isView = false;
        if(myCamera != null)
		{//若相机不为空则释放相机		
			myCamera.stopPreview();	//停止预览
			myCamera.release();		//释放照相机对象					
			myCamera = null;		//清空照相机引用					
		}
    } 
    
    @Override
	protected Dialog onCreateDialog(int id) {        //创建对话框的方法
		// TODO Auto-generated method stub
	Dialog dialog=null;
	switch(id){
	    case select:
		Builder b=new AlertDialog.Builder(this);
		b.setIcon(R.drawable.ic_launcher);
		b.setTitle("粮仓确认");
		b.setMessage("粮仓为3号仓");
	    b.setPositiveButton("确认", 
	    		new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int which) {
				setContentView(R.layout.realdetail);
				//Intent intent=new Intent(CameraActivity.this,RealActivity.class);
				ImageView myImageView = (ImageView) findViewById(R.id.CameraImageView);
	    		myImageView.setImageBitmap(bm);
			}
		});
	    b.setNegativeButton("取消", 
	    		new DialogInterface.OnClickListener() {
			public void onClick(DialogInterface dialog, int which) {
				isView = false;	
				
			}
		});
	   dialog=b.create();
	   break;
	  /*  case select1:
	   pd=new ProgressDialog(this);
	    pd.setMax(100);
	    pd.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
	    break;*/
	}
    	return dialog;
	}

	//初始化相机的方法
    public void initCamera()
    {
    	if(myCamera==null&&!isView)
    	{//若在非预览状态且未打开照相机则打开照相机
    		myCamera = Camera.open();							
    	}
        if(myCamera != null && !isView)
        {//若照相机成功打开且处在非预览状态则进入预览状态
    		try 
    		{
                Camera.Parameters myParameters = myCamera.getParameters();
                //设置照片格式
                myParameters.setPictureFormat(PixelFormat.JPEG);
                //设置预览大小
                //myParameters.setPreviewSize(200, 200);		
                //将参数设置入Camera
                myCamera.setParameters(myParameters);
                //设置照相机的预览者
        		myCamera.setPreviewDisplay(mySurfaceHolder);
        		//开始预览
        		myCamera.startPreview();
        		//将状态标志位设成true表示正在预览
            	isView = true;	
        	} 
    		catch (IOException e)
    		{								
        		e.printStackTrace();								
        	}    										
        }
    }
    
    ShutterCallback myShutterCallback = new ShutterCallback()
    {//快门回调接口
    	
    	public void onShutter(){}								//空实现
    };
    PictureCallback myRawCallback = new PictureCallback()
    {//拍照回调接口
    
    	public void onPictureTaken(byte[] data, Camera camera) {}	//空实现
    };
   PictureCallback myjpegCallback = new PictureCallback()
    {//拍照回调接口
    
    	public void onPictureTaken(byte[] data, Camera camera) 
    	{
    		bm = BitmapFactory.decodeByteArray(data, 0, data.length);
    		/*ImageView myImageView = (ImageView) findViewById(R.id.CameraImageView);
    		myImageView.setImageBitmap(bm);	//将图片显示到下方的ImageView中
    		isView = false;
    		myCamera.stopPreview();//停止预览模式
    		myCamera.release();	//释放
    		myCamera = null;  
    		isView = false;*/
    	}
    };	



    //重写SurfaceHolder.Callback接口中的方法
	
	public void surfaceChanged(SurfaceHolder arg0, int arg1, int arg2, int arg3) {
		
		
	}

	//重写SurfaceHolder.Callback接口中的方法
	
	public void surfaceCreated(SurfaceHolder arg0) {
		
		
	}

	//重写SurfaceHolder.Callback接口中的方法
	
	public void surfaceDestroyed(SurfaceHolder arg0) {
		
		
	}

	public void onClick(View v) {
		// TODO Auto-generated method stub
		if(v == bStart)
		{//按下的为开始按钮								
    		
			initCamera();									//初始化相机
			
		}
		else if(v == bTpg)
		{//按下拍照按钮
			if(isView&&myCamera!=null)
			{
				myCamera.takePicture(myShutterCallback, myRawCallback, myjpegCallback);
				//linear1.addView(txtView1);
			//	isView = false;
				
				showDialog(select);
	    		
			}
			else
			{
				Toast.makeText
				 (
						 this, 
						 "请先识别粮仓信息", 
						 Toast.LENGTH_SHORT
				 ).show();
			}
		}
	}


}