 package view.main;

import java.util.Calendar;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.TextView;
import android.widget.TimePicker;

public class DataQueryActivity extends Activity {
	private Button dataquerybutton;
	private int mYear;
	private int mMonth;
	private int mDay;
	private int mHour;
	private int mMinute;
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
    	Calendar c=Calendar.getInstance();
    	mYear=c.get(Calendar.YEAR);//得到年份
    	mMonth=c.get(Calendar.MONTH);//得到月份
    	mDay=c.get(Calendar.DAY_OF_MONTH);//得到天数  	
        super.onCreate(savedInstanceState);
        setContentView(R.layout.dataquery);
		dataquerybutton = (Button)findViewById(R.id.dataquerybutton);
        showTime(); 
        DatePicker dp=(DatePicker)findViewById(R.id.DatePicker01);
        dp.init(
        		mYear, 
        		mMonth, 
        		mDay, 
        		new DatePicker.OnDateChangedListener()
        		{ 			
				
					public void onDateChanged(DatePicker view, int year, int monthOfYear,
							int dayOfMonth) {
						mYear=year;
						mMonth=monthOfYear;
						mDay=dayOfMonth;
						showTime();//设置文本框中的内容
					}
        		}
        );
		dataquerybutton.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				Intent intent=new Intent(DataQueryActivity.this,BaseInfoActivity.class);
				startActivity(intent);
			}
		});
    }
     private void showTime()//设置文本框
    {
    	TextView tv=(TextView)findViewById(R.id.TextView01);//拿到文本框中的引用
    	tv.setText(
    			new StringBuilder().append("查询日期：").append(mYear).append("/")//将内容添加到文本框中，添加年数
    			.append(formatTime(mMonth+1)).append("/")//添加月数
    			.append(formatTime(mDay)).append(" ")//添加天数
    			
    	);
    } 
    private String formatTime(int i)
    {
    	String s=""+i;
    	if(s.length()==1)
    	{
    		s="0"+s;
    	}
    	return s;
    }
}