package xml.download;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

import android.util.Log;

public class HttpDownloader {
	public boolean downFile(String urlStr, String path,String filename) throws IOException {
		InputStream in = connectNet(urlStr);
		fileManager(path,filename);
		OutputStream out = new BufferedOutputStream(new FileOutputStream(path+filename));
		int i;
		while ((i = in.read()) != -1) {
			out.write(i);
		}
		in.close();
		out.close();
		Log.i("tag", filename+"下载完毕！");
		return true;
	}
	public boolean downFile(String urlStr, String path) throws IOException {
		URL url = new URL(urlStr);
		String filename = (new File(url.getFile())).getName();
		return downFile(urlStr,path,filename);
	}

	private InputStream connectNet(String _urlStr) throws IOException {
		URL url = new URL(_urlStr);
		HttpURLConnection urlConn = (HttpURLConnection) url.openConnection();
		return urlConn.getInputStream();
	}

	private void fileManager(String path,String _filename) throws IOException {
		File afile = new File(path);
		File bfile = new File(path + _filename);
		if (!afile.exists()) {
			afile.mkdirs();
		}
		if (!bfile.exists())
			bfile.createNewFile();
	}
}