package xml.main;

import java.io.IOException;

import xml.classes.BarnImageInfo;
import xml.classes.BaseInfo;
import xml.classes.IndexStr;
import xml.classes.MyParser;
import xml.classes.StaticPaths;
import xml.download.HttpDownloader;
import xml.parse.MainHandler;
import xml.reader.BaseInfoReader;
import xml.reader.ImageReader;


import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.util.Log;
import android.widget.Toast;

public class DownloadService extends Service {

	@Override
	public IBinder onBind(Intent arg0) {
		// TODO Auto-generated method stub
		Log.i("tag", "onBind");
		return null;
	}

	@Override
	public void onCreate() {
		// TODO Auto-generated method stub
		Log.i("tag", "onCreate");
	}

	@Override
	public void onDestroy() {
		// TODO Auto-generated method stub
		Log.i("tag", "onDestroy");
		super.onDestroy();
	}

	@Override
	public void onStart(Intent intent, int startId) {
		// TODO Auto-generated method stub
		Log.i("tag", "onStart,my service start");
		Toast.makeText(this, "My Service Start", Toast.LENGTH_LONG).show();
		
		HttpDownloader dl = new HttpDownloader();
		// 解析主文件，更新服务器文件地址
		MainHandler handler = new MainHandler();
		
		
		
		
		
		try {
			dl.downFile(StaticPaths.SrootPath+"XML/main.xml", StaticPaths.rootXMLPath);
			MyParser.parse(handler, StaticPaths.mainPath);
		} catch (Exception e) {
			Log.i("tag", "解析主文件出错，请更新文件或稍后再试");
			Toast.makeText(this , "解析主文件出错，请更新文件或稍后再试", Toast.LENGTH_SHORT).show();
		}
		//下载文件
		Log.i("tag", "开始下载");
		downXMLFile(dl);
		downGridImage(dl);
		downCloudImage(dl);
		downBaseInfo(dl);
		Log.i("tag", "下载完毕！");
	}
	private void downXMLFile(HttpDownloader dl){
		try {
			System.out.println(StaticPaths.SbarnInfo);
			System.out.println(StaticPaths.rootXMLPath);
			System.out.println(StaticPaths.barnInfoName);
			dl.downFile(StaticPaths.SbarnInfo, StaticPaths.rootXMLPath,StaticPaths.barnInfoName);
			dl.downFile(StaticPaths.SbaseInfo_head, StaticPaths.rootXMLPath,StaticPaths.baseInfo_HeadName);
			dl.downFile(StaticPaths.ScloudImage, StaticPaths.rootXMLPath,StaticPaths.cloudImageName);
			dl.downFile(StaticPaths.SgridImage, StaticPaths.rootXMLPath,StaticPaths.gridImageName);
			dl.downFile(StaticPaths.SgarinAvgTem, StaticPaths.rootXMLPath,StaticPaths.garinAvgTemName);
			dl.downFile(StaticPaths.SinnerTem, StaticPaths.rootXMLPath,StaticPaths.innerTemName);
			dl.downFile(StaticPaths.SouterTem, StaticPaths.rootXMLPath,StaticPaths.outerTemName);
			dl.downFile(StaticPaths.SinnerHum, StaticPaths.rootXMLPath,StaticPaths.innerHumName);
			dl.downFile(StaticPaths.SouterHum, StaticPaths.rootXMLPath,StaticPaths.outerHumName);
		} catch (IOException e) {
			Log.i("tag", "XML下载出错！");
			e.printStackTrace();
		}
	}
	private void downGridImage(HttpDownloader dl){
		ImageReader ir = new ImageReader();
		try {
			for (BarnImageInfo bii : ir.getGridlist()) {
				for (IndexStr is : bii.getRow()) {
					dl.downFile(StaticPaths.SrootPath + is.getStr(),
							StaticPaths.gridImageFilePath);
				}
				for (IndexStr is : bii.getLayer()) {
					dl.downFile(StaticPaths.SrootPath + is.getStr(),
							StaticPaths.gridImageFilePath);
				}
				for (IndexStr is : bii.getCol()) {
					dl.downFile(StaticPaths.SrootPath + is.getStr(),
							StaticPaths.gridImageFilePath);
				}
			}
			
		} catch (IOException e) {
			Log.i("tag", "Image下载出错！");
			e.printStackTrace();
		}
	}
	private void downCloudImage(HttpDownloader dl){
		ImageReader ir = new ImageReader();
		try {
			
			for (BarnImageInfo bii : ir.getCloudlist()) {
				for (IndexStr is : bii.getRow()) {
					dl.downFile(StaticPaths.SrootPath + is.getStr(),
							StaticPaths.cloudImageFilePath);
				}
				for (IndexStr is : bii.getLayer()) {
					dl.downFile(StaticPaths.SrootPath + is.getStr(),
							StaticPaths.cloudImageFilePath);
				}
				for (IndexStr is : bii.getCol()) {
					dl.downFile(StaticPaths.SrootPath + is.getStr(),
							StaticPaths.cloudImageFilePath);
				}
			}
		} catch (IOException e) {
			Log.i("tag", "Image下载出错！");
			e.printStackTrace();
		}
	}
	private void downBaseInfo(HttpDownloader dl){
		BaseInfoReader bir = new BaseInfoReader();
		try {
			for (BaseInfo gi : bir.getbList()) {
				dl.downFile(StaticPaths.SrootPath + gi.getHead(),
						StaticPaths.headImageFilePath);
				dl.downFile(StaticPaths.SrootPath + gi.getInfoCard(),
						StaticPaths.baseInfoImageFilePath);
			}
		} catch (IOException e) {
			Log.i("tag", "BaseInfo下载出错！");
			e.printStackTrace();
		}
	}
}
