/*粮仓信息解析工具类*/
package xml.parse;

import java.util.ArrayList;


import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import xml.classes.BarnInfo;

import android.util.Log;

public class BarnInfoHandler extends DefaultHandler {
	private ArrayList<BarnInfo> list = new ArrayList<BarnInfo>();
	private String tagName;
	
	private String id;// 仓号
	private String capacity;// 仓容
	private String type;// 仓型
	private String grainsort;// 储量种类
	private String graindegree;// 储量等级
	private String ingraintime;// 入库时间
	private String normaltempmax;// 正常温度最大值
	private String normaltempmin;// 正常温度最小值
	private String normalhumimax;// 正常湿度最大值
	private String normalhumimin;// 正常湿度最小值
	private String windtype;// 通风方式
	private String storeman;//保管员姓名

	@Override
	public void startDocument() throws SAXException {
		// TODO Auto-generated method stub
		Log.i("tag","parse begin");
	}

	@Override
	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		// TODO Auto-generated method stub
		tagName=localName;
	}


	@Override
	public void characters(char[] ch, int start, int length)
			throws SAXException {
		// TODO Auto-generated method stub
		if(tagName.equals("id"))
			id=new String(ch,start,length);
		else if(tagName.equals("capacity"))
			capacity=new String(ch,start,length);
		else if(tagName.equals("type"))
			type=new String(ch,start,length);
		else if(tagName.equals("grainsort"))
			grainsort=new String(ch,start,length);
		else if(tagName.equals("graindegree"))
			graindegree=new String(ch,start,length);
		else if(tagName.equals("ingraintime"))
			ingraintime=new String(ch,start,length);
		else if(tagName.equals("normaltempmax"))
			normaltempmax=new String(ch,start,length);
		else if(tagName.equals("normaltempmin"))
			normaltempmin=new String(ch,start,length);
		else if(tagName.equals("normalhumimax"))
			normalhumimax=new String(ch,start,length);
		else if(tagName.equals("normalhumimin"))
			normalhumimin=new String(ch,start,length);
		else if(tagName.equals("windtype"))
			windtype=new String(ch,start,length);
		else if(tagName.equals("storeman"))
			storeman=new String(ch,start,length);
	}

	@Override
	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		// TODO Auto-generated method stub
		tagName="";
		if (localName.equals("warehouse")){
			BarnInfo barnInfo = new BarnInfo();
			barnInfo.setId(id);
			barnInfo.setCapacity(capacity);
			barnInfo.setType(type);
			barnInfo.setGrainsort(grainsort);
			barnInfo.setGraindegree(graindegree);
			barnInfo.setIngraintime(ingraintime);
			barnInfo.setNormaltempmax(normaltempmax);
			barnInfo.setNormaltempmin(normaltempmin);
			barnInfo.setNormalhumimax(normalhumimax);
			barnInfo.setNormalhumimin(normalhumimin);
			barnInfo.setWindtype(windtype);
			barnInfo.setStoreman(storeman);
			list.add(barnInfo);
		}
	}

	@Override
	public void endDocument() throws SAXException {
		// TODO Auto-generated method stub
		Log.i("tag","parse end");
	}
	public ArrayList<BarnInfo> getBarnInfoList(){
		return list;
	}
}
