package xml.parse;

import java.util.ArrayList;


import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import xml.classes.BaseInfo;

import android.util.Log;

public class BaseInfoHandler extends DefaultHandler {
	private String tagName;
	
	private String id;
	private String head;
	private String infocard;
	
	private ArrayList<BaseInfo> list = new ArrayList<BaseInfo>();

	@Override
	public void startDocument() throws SAXException {
		Log.i("tag", "parse begin");
	}

	@Override
	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		// TODO Auto-generated method stub
		tagName = localName;
		if (localName.equals("warehouse")) {
			id = attributes.getValue(0);
		}
	}

	@Override
	public void characters(char[] ch, int start, int length)
			throws SAXException {
		// TODO Auto-generated method stub
		if (tagName.equals("head"))
			head = new String(ch, start, length);
		if (tagName.equals("infocard"))
			infocard = new String(ch, start, length);
	}

	@Override
	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		tagName = "";
		if (localName.equals("warehouse")) {
			BaseInfo bi = new BaseInfo();
			bi.setId(id);
			bi.setHead(head);
			bi.setInfoCard(infocard);
			list.add(bi);
		}
	}

	@Override
	public void endDocument() throws SAXException {
		// TODO Auto-generated method stub
		Log.i("tag", "parse end");
	}

	public ArrayList<BaseInfo> getList() {
		return list;
	}
}
