/*粮仓信息解析工具类*/
package xml.parse;

import java.util.ArrayList;


import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import xml.classes.Part;
import xml.classes.Point;

import android.util.Log;

public class GrainInfoHandler extends DefaultHandler {
	String tagName;
	
	int type=-1;//解析器的type 根据要解析的文件是温度还是湿度确定，最后要作为解析结果Part的一个属性
	
	String id;
	String time;
	float value;
	
	ArrayList<Part> list = new ArrayList<Part>();//解析最终结果
	ArrayList<Point> plist = new ArrayList<Point>();//解析出来的Point构成的list

	@Override
	public void startDocument() throws SAXException {
		Log.i("tag","parse begin");
	}

	@Override
	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		// TODO Auto-generated method stub
		tagName=localName;
		if(localName.equals("warehouse")){
			id=attributes.getValue(0);//记录粮仓的id
		}
	}

	@Override
	public void characters(char[] ch, int start, int length)
			throws SAXException {
		// TODO Auto-generated method stub
		if(tagName.equals("value"))
			value = Float.parseFloat(new String(ch,start,length));
		else if(tagName.equals("time"))
			time = new String(ch,start,length);
	}

	@Override
	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		tagName="";
		if(localName.equals("point")){
			Point point=new Point(value, time);
			plist.add(point);//将一个解析出来的point加入临时队列
		}
		if(localName.equals("warehouse")){
			Part part = new Part();
			@SuppressWarnings("unchecked")
			//将一个Point列表从临时list中复制出来
			ArrayList<Point> templist=(ArrayList<Point>) plist.clone();
			part.list=templist;
			part.id=id;
			part.type=type;
			list.add(part);
			plist.clear();//清空临时list
		}
	}

	@Override
	public void endDocument() throws SAXException {
		// TODO Auto-generated method stub
		Log.i("tag","parse end");
	}
	//设置type值，以作为不同的解析器解析相同结构的不同的文件
	public void setType(int _type){
		this.type=_type;
	}
	public ArrayList<Part> getList(){
		return list;
	}
}
