package xml.parse;

import java.util.ArrayList;


import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import xml.classes.BarnImageInfo;
import xml.classes.IndexStr;

import android.util.Log;

public class ImageInfoHandler extends DefaultHandler {

	private String tagName;
	private String id;
	private int index;
	private String path;
	private BarnImageInfo barn = new BarnImageInfo();
	private ArrayList<IndexStr> inslist = new ArrayList<IndexStr>();
	private ArrayList<BarnImageInfo> barlist = new ArrayList<BarnImageInfo>();

	@Override
	public void startDocument() throws SAXException {
		Log.i("tag", "parse begin");
	}

	@Override
	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		// TODO Auto-generated method stub
		tagName = localName;
		if (localName.equals("warehouse")) {
			id = attributes.getValue(0);
		}
		if (localName.equals("part")) {
			index = Integer.parseInt(attributes.getValue(0));
		}
	}

	@Override
	public void characters(char[] ch, int start, int length)
			throws SAXException {
		// TODO Auto-generated method stub
		if (tagName.equals("part"))
			path = new String(ch, start, length);
	}

	@SuppressWarnings("unchecked")
	@Override
	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		tagName = "";
		if (localName.equals("part")) {
			IndexStr in = new IndexStr(index, path);
			inslist.add(in);
		}
		if (localName.equals("layer")) {
			barn.setId(id);
			barn.setLayer((ArrayList<IndexStr>) inslist.clone());
			inslist.clear();
		}
		if (localName.equals("row")) {
			barn.setRow((ArrayList<IndexStr>) inslist.clone());
			inslist.clear();
		}
		if (localName.equals("col")) {
			barn.setCol((ArrayList<IndexStr>) inslist.clone());
			inslist.clear();
		}
		if (localName.equals("warehouse")) {
			BarnImageInfo ba = barn.clone();
			barlist.add(ba);
		}
	}

	@Override
	public void endDocument() throws SAXException {
		// TODO Auto-generated method stub
		Log.i("tag", "parse end");
	}

	public ArrayList<BarnImageInfo> getList() {
		return barlist;
	}
}
