package xml.reader;

import java.util.ArrayList;
import java.util.List;

import xml.classes.BarnInfo;
import xml.classes.MyParser;
import xml.classes.StaticPaths;
import xml.parse.BarnInfoHandler;

import android.util.Log;

public class BarnReader {
	// 粮仓信息对象队列
	private ArrayList<BarnInfo> bList = new ArrayList<BarnInfo>();

	public BarnReader() {
		parseBarnInfo();
	}

	// 解析粮仓信息并返回粮仓信息队列
	public void parseBarnInfo() {
		BarnInfoHandler handler = new BarnInfoHandler();
		try {
			MyParser.parse(handler, StaticPaths.barnInfoPath);
			bList=handler.getBarnInfoList();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	// 粮仓信息展示函数
	public void dis() {
		Log.i("tag", "display start");
		for (BarnInfo bInfo : bList) {
			Log.i("tag", "仓号  ---" + bInfo.getId());
			Log.i("tag", "仓容  ---" + bInfo.getCapacity());
			Log.i("tag", "仓型  ---" + bInfo.getType());
			Log.i("tag", "储量种类  ---" + bInfo.getGrainsort());
			Log.i("tag", "储量等级  ---" + bInfo.getGraindegree());
			Log.i("tag", "入库时间  ---" + bInfo.getIngraintime());
			Log.i("tag", "正常温度最大值  ---" + bInfo.getNormaltempmax());
			Log.i("tag", "正常温度最小值 ---" + bInfo.getNormaltempmin());
			Log.i("tag", "正常湿度最大值 ---" + bInfo.getNormalhumimax());
			Log.i("tag", "正常湿度最小值  ---" + bInfo.getNormalhumimin());
			Log.i("tag", "通风方式  ---" + bInfo.getWindtype());
			Log.i("tag", "保管员 ---" + bInfo.getStoreman());
		}
		Log.i("tag", "display end");
	}

	public List<BarnInfo> getbList() {
		return bList;
	}
}
