package xml.reader;

import java.util.ArrayList;
import java.util.List;

import xml.classes.GrainInfo;
import xml.classes.MyParser;
import xml.classes.Part;
import xml.classes.Point;
import xml.classes.StaticPaths;
import xml.parse.GrainInfoHandler;

import android.util.Log;

public class GrainReader{
	// 粮食信息队列
	private List<GrainInfo> list = new ArrayList<GrainInfo>();
	private List<Part> pplist = new ArrayList<Part>();

	//构造函数，内部调用解析函数
	public GrainReader() {
		try {
			parseGrainInfo();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	// 解析粮食三温两湿并返回按粮仓排列的信息队列
	private void parseGrainInfo() throws Exception {
		int i = 0;//标记
		unite();// 解析信息并加入总的Part列表中
		//将总的part中的part逐个归到相应的GrainInfo中
		for (Part part : pplist) {
			if (!list.isEmpty()) {
				for (GrainInfo ginfo : list) {
					if (ginfo.id.equals(part.id)){
						_add(ginfo, part);
					}else{
						i++;
						continue;
					}
				}
			} else {
				GrainInfo ginfo = new GrainInfo();
				ginfo.setId(part.id);
				_add(ginfo, part);
				list.add(ginfo);
			}
			if (i == list.size()){
				GrainInfo ginfo = new GrainInfo();
				ginfo.setId(part.id);
				_add(ginfo, part);
				list.add(ginfo);
			}
			i=0;//初始化标记
		}
	}
	//辅助函数，把解析出来的Part加入到指定GrainInfo中
	private void _add(GrainInfo gInfo, Part part) {
		switch (part.type) {
		case 1:
			gInfo.setGrainAvgTem(part.list);
			break;
		case 2:
			gInfo.setInnerTem(part.list);
			break;
		case 3:
			gInfo.setOuterTem(part.list);
			break;
		case 4:
			gInfo.setInnerHum(part.list);
			break;
		case 5:
			gInfo.setOuterHum(part.list);
			break;
		}
	}

	// 把解析出来的信息列表加入总的Past列表中
	private void unite() throws Exception {
		GrainInfoHandler handler = new GrainInfoHandler();
		_unite(handler, StaticPaths.garinAvgTemPath,1);
		_unite(handler, StaticPaths.innerTemPath,2);
		_unite(handler, StaticPaths.outerTemPath,3);
		_unite(handler, StaticPaths.innerHumPath,4);
		_unite(handler, StaticPaths.outerHumPath,5);
	}
	//辅助函数，使用指定handler解析指定路径path的xml文件，并加入到总的Part构成的list中
	private void _unite(GrainInfoHandler handler,String path,int type) throws Exception{
		handler.setType(type);//设置解析器type
		MyParser.parse(handler, path);//解析
		for (Part part : handler.getList()) {
			pplist.add(part);//加入总队列
		}
	}
	//提供解析结果
	public List<GrainInfo> getList() {
		return list;
	}
	// 粮食信息展示函数
	public void dis() {
		Log.i("tag", "display start");
		Log.i("tag", list.size() + "个粮仓的信息");
		for (GrainInfo grainInfo : list) {
			Log.i("tag", "粮仓 " + grainInfo.id + "的信息：");
			disPartList(grainInfo.grainAvgTem, 1);
			disPartList(grainInfo.innerTem, 2);
			disPartList(grainInfo.outerTem, 3);
			disPartList(grainInfo.innerHum, 4);
			disPartList(grainInfo.outerHum, 5);
		}
		Log.i("tag", "display end");
	}
	//辅助信息展示函数
	private void disPartList(List<Point> grainAvgTem, int type) {
		for (Point point : grainAvgTem) {
			switch (type) {
			case 1:
				Log.i("tag", "时间" + point.time + "粮均温" + point.value + "");
				break;
			case 2:
				Log.i("tag", "时间" + point.time + "仓内温" + point.value + "");
				break;
			case 3:
				Log.i("tag", "时间" + point.time + "仓外温" + point.value + "");
				break;
			case 4:
				Log.i("tag", "时间" + point.time + "仓内湿" + point.value + "");
				break;
			case 5:
				Log.i("tag", "时间" + point.time + "仓外湿" + point.value + "");
				break;
			}
		}
	}
}
