package xml.reader;

import java.util.ArrayList;
import xml.classes.BarnImageInfo;
import xml.classes.IndexStr;
import xml.classes.MyParser;
import xml.classes.StaticPaths;
import xml.parse.ImageInfoHandler;

import android.util.Log;

public class ImageReader {
	private ArrayList<BarnImageInfo> cloudlist = new ArrayList<BarnImageInfo>();
	private ArrayList<BarnImageInfo> gridlist = new ArrayList<BarnImageInfo>();

	public ImageReader() {
		parse();
	}

	private void parse() {
		ImageInfoHandler cloudhandler = new ImageInfoHandler();
		ImageInfoHandler gridhandler = new ImageInfoHandler();
		try {
			MyParser.parse(cloudhandler, StaticPaths.cloudImagePath);
			MyParser.parse(gridhandler, StaticPaths.gridImagePath);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		cloudlist = cloudhandler.getList();
		gridlist = gridhandler.getList();
	}
	
	public void dis() throws Exception{
		Log.i("tag", "******锟斤拷图*******");
		for (BarnImageInfo bii : cloudlist) {
			Log.i("tag", bii.getId());
			for (IndexStr is : bii.getLayer()) {
				Log.i("tag", "锟斤拷" + is.getIndex() + "锟姐：" + is.getStr());
			}
			for (IndexStr is : bii.getRow()) {
				Log.i("tag", "锟斤拷" + is.getIndex() + "锟叫ｏ拷" + is.getStr());
			}
			for (IndexStr is : bii.getCol()) {
				Log.i("tag", "锟斤拷" + is.getIndex() + "锟叫ｏ拷" + is.getStr());
			}
		}
		Log.i("tag", "******锟斤拷锟酵�******");
		for (BarnImageInfo bii : gridlist) {
			Log.i("tag", bii.getId());
			for (IndexStr is : bii.getLayer()) {
				Log.i("tag", "锟斤拷" + is.getIndex() + "锟姐：" + is.getStr());
			}
			for (IndexStr is : bii.getRow()) {
				Log.i("tag", "锟斤拷" + is.getIndex() + "锟叫ｏ拷" + is.getStr());
			}
			for (IndexStr is : bii.getCol()) {
				Log.i("tag", "锟斤拷" + is.getIndex() + "锟叫ｏ拷" + is.getStr());
			}
		}
	}

	public ArrayList<BarnImageInfo> getCloudlist() {
		return cloudlist;
	}
	public ArrayList<BarnImageInfo> getGridlist() {
		return gridlist;
	}
}
