package com.syj.wutui;

import java.util.ArrayList;

import com.example.webdatashow.R;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.RelativeLayout.LayoutParams;

public class H_AutoCompleteTextView extends EditText {

	Context context = null;
	MyTextWatcher myTextWatcher = null;
	public H_AutoCompleteTextView(Context context, AttributeSet attrs) {
		super(context, attrs);
		this.context = context;
		setPopw();
		this.addTextChangedListener(watcher);
	}


	public void setFatherRelativeLayouyt(RelativeLayout layout) {
		this.relativeLayout = layout;
		isRLayout = true;
	}

	public void setFatherLinearLayout(LinearLayout layout) {
		this.linearLayout = layout;
		isRLayout = false;
	}

	
	public void setMemoryData(ArrayList<String> list) {
		this.memoryData = list;
	}
	
	public void addMyTextWatcher(MyTextWatcher myTextWatcher) {
		this.myTextWatcher = myTextWatcher;
	}

	public void removeMyTextWatcher() {
		this.myTextWatcher = null;
	}
	
	public void removeTheShowView() {
		if (popView.isShown()) {
			if (isRLayout) {
				relativeLayout.removeView(popView);
			} else {
				linearLayout.removeView(popView);
			}
		}
	}

	public boolean isListShowing() {
		return popView.isShown();
	}
	TextWatcher watcher = new TextWatcher() {

		@Override
		public void onTextChanged(CharSequence s, int start, int before, int count) {
			mList.clear();
			mList.addAll(getSimilarString(String.valueOf(s), memoryData));
			if (mList.size() > 0) {
				mAdapter.notifyDataSetInvalidated();
				if (!popView.isShown()) {
					int[] top = new int[2];
					H_AutoCompleteTextView.this.getLocationInWindow(top);
					
					layoutParams.topMargin = top[1] - 15;
					layoutParams.leftMargin = top[0];
					if (isRLayout) {
						relativeLayout.addView(popView, layoutParams);
					} else {
						linearLayout.addView(popView, layoutParams);
					}
					popView.setFocusable(true);
				}
			} else {
				if (isRLayout) {
					relativeLayout.removeView(popView);
				} else {
					linearLayout.removeView(popView);
				}
			}
			if (myTextWatcher != null) {
				myTextWatcher.onTextChanged(s, start, before, count);
			}
		}

		@Override
		public void beforeTextChanged(CharSequence s, int start, int count, int after) {
			if (myTextWatcher != null) {
				myTextWatcher.beforeTextChanged(s, start, count, after);
			}
		}

		@Override
		public void afterTextChanged(Editable s) {
			if (s.length() == 0) {
				removeTheShowView();
			}
			if (myTextWatcher != null) {
				myTextWatcher.afterTextChanged(s);
			}
		}
	};

	ArrayList<String> memoryData = null;
	LayoutParams layoutParams = new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
	private View popView = null;
	private ListView mlistView = null;
	private ArrayList<String> mList = null;
	
	private ArrayAdapter<String> mAdapter = null;
	RelativeLayout relativeLayout = null;
	LinearLayout linearLayout = null;
	private boolean isRLayout = false;

	private void setPopw() {
		if (this.popView == null) {
			popView = View.inflate(context, R.layout.h_view_search_list, null);
		}
		if (mlistView == null) {
			mlistView = (ListView) popView.findViewById(R.id.list_category);
			mlistView.setItemsCanFocus(true);
			mlistView.setOnItemClickListener(new OnItemClickListener() {

				@Override
				public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
					H_AutoCompleteTextView.this.setText(mList.get(position));
				
					// Toast.makeText(context, mList.get(position),
					// Toast.LENGTH_LONG).show();
					if (isRLayout) {
						relativeLayout.removeView(popView);
					} else {
						linearLayout.removeView(popView);
					}
				}
			});
		}
		mList = new ArrayList<String>();
		if (mAdapter == null) {
			mAdapter = new ArrayAdapter<String>(context, R.layout.h_activity_search_item, R.id.tv_context, mList);
		}
		mlistView.setAdapter(mAdapter);
	}

	
	private ArrayList<String> getSimilarString(String edt, ArrayList<String> datas) {
		ArrayList<String> similars = new ArrayList<String>();
		if (datas != null) {
			for (String s : datas) {
				if (s.startsWith(edt)) {
					similars.add(s);
				}
			}
		}
		return similars;
	}

	public interface MyTextWatcher {
	
		public void onTextChanged(CharSequence s, int start, int before, int count);
		public void beforeTextChanged(CharSequence s, int start, int count, int after);
		public void afterTextChanged(Editable s);
	}
}
