package com.syj.wutui;

import java.util.ArrayList;
import java.util.List;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;


public class H_DBManager {

	private H_DBHelper helper;
	private SQLiteDatabase db;
	public SQLiteDatabase getDb() {
		return db;
	}

	public H_DBManager(Context context) {
		helper = new H_DBHelper(context);
		db = helper.getWritableDatabase();
	}


	public synchronized void addSearchResult(H_SearchHistoryVo result) {
		db.beginTransaction();
		try {
			db.execSQL("REPLACE INTO history(content,searchtime)VALUES(?,?)", new Object[]{result.content,
					result.searchtime});
			db.setTransactionSuccessful();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			db.endTransaction(); 
		}
	}

	
	public List<H_SearchHistoryVo> querySearchHistory() {
		List<H_SearchHistoryVo> list = new ArrayList<H_SearchHistoryVo>();
		Cursor cursor = db.rawQuery("select * from history", null);
		while (cursor.moveToNext()) {
			H_SearchHistoryVo item = new H_SearchHistoryVo();
			item.content = cursor.getString(cursor.getColumnIndex("content"));
			item.searchtime = cursor.getString(cursor.getColumnIndex("searchtime"));
			list.add(item);
		}
		cursor.close();
		return list;
	}

	
	public synchronized void deleteSearchHistory() {
		db.beginTransaction();
		db.execSQL("DELETE FROM  history");
		System.out.println("DELETE");
		db.setTransactionSuccessful();
		db.endTransaction();
	}
}
