package com.example.sarthome;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.StrictMode;
import android.text.method.ScrollingMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

public class LoginActivity extends Activity implements OnClickListener {
    /** Called when the activity is first created. */
	
	private Button startButton,curtainOnOffButton,curtainAddButtonClient,curtainSubButtonClient,autoButtonClient;	
	private Button fanOnOffButton,fanAddButtonClient,fanSubButtonClient,lampOnOffButton,lampAddButtonClient,lampSubButtonClient;	
	private TextView recvDamp,recvTamp,recPm25,airLevel;	
	private Context mContext;
	private boolean isConnecting = false;
	private int mport;
    private String ip;
	private Thread mThreadClient = null;
	private Thread mThreadServer = null;
	private Socket mSocketServer = null;
	private Socket mSocketClient = null;
	static BufferedReader mBufferedReaderServer	= null;
	static PrintWriter mPrintWriterServer = null;
	static BufferedReader mBufferedReaderClient	= null;
	static PrintWriter mPrintWriterClient = null;
	private  String recvMessageClient = "";
	private  String mistakeMessage = "";
	private String[] fanOnOff=new String[] { "*", "**"};//鳤Ϊ2
	private String[] lampOnOff=new String[] { "!", "!!"};//鳤Ϊ2
	private String[] curtainOnOff=new String[] { "@", "@@"};//鳤Ϊ2
	private String[] autoArray=new String[] { "$", "$$"};//鳤Ϊ2
	private String[] fanAdd=new String[] { "*0", "*1", "*2", "*3", "*4", "*5", "*6", "*7", "*8", "*9", "*10"};//ȼ鳤Ϊ11
	private String[] fanSub=new String[] { "*0", "*1", "*2", "*3", "*4", "*5", "*6", "*7", "*8", "*9", "*10"};//ȼ鳤Ϊ11
	private String[] lampSub=new String[] { "!0", "!1", "!2", "!3", "!4", "!5", "!6", "!7", "!8", "!9", "!10"};//Ƽ鳤Ϊ11
	private String[] lampAdd=new String[] { "!0", "!1", "!2", "!3", "!4", "!5", "!6", "!7", "!8", "!9", "!10"};//Ƽ鳤Ϊ11
	private String[] curtainSub=new String[] { "@0", "@1", "@2", "@3", "@4", "@5", "@6", "@7", "@8", "@9", "@10"};//鳤Ϊ11
	private String[] curtainAdd=new String[] { "@0", "@1", "@2", "@3", "@4", "@5", "@6", "@7", "@8", "@9", "@10"};//鳤Ϊ11
	private EditText dialog_ip;
	private EditText dialog_port;
	private int mFlag=-1,mFlagOnOff=-1;
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);   
        setContentView(R.layout.activity_login);
        mContext = this;
        
        StrictMode.setThreadPolicy(new StrictMode.ThreadPolicy.Builder()        
        .detectDiskReads()        
        .detectDiskWrites()        
        .detectNetwork()   // or .detectAll() for all detectable problems       
        .penaltyLog()        
        .build());        
        StrictMode.setVmPolicy(new StrictMode.VmPolicy.Builder()        
        .detectLeakedSqlLiteObjects()     
        .penaltyLog()        
        .penaltyDeath()        
        .build()); 
        InitView();//ʼ
        startButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View arg0) {
				// TODO Auto-generated method stub
				Connection();//ӷ
			}
		});
    }
    public void InitView(){
    	
    	startButton= (Button)findViewById(R.id.StartConnect);
        fanOnOffButton= (Button)findViewById(R.id.fan_on_off);
        fanAddButtonClient=(Button)findViewById(R.id.fanadd);
        fanSubButtonClient=(Button)findViewById(R.id.fansub);
        lampOnOffButton=(Button)findViewById(R.id.lamp_on_off);
        lampAddButtonClient=(Button)findViewById(R.id.lampadd);
        lampSubButtonClient=(Button)findViewById(R.id.lampsub);
        curtainOnOffButton=(Button)findViewById(R.id.curtain_on_off);
        curtainAddButtonClient=(Button)findViewById(R.id.curtainadd);
        curtainSubButtonClient=(Button)findViewById(R.id.curtainsub);
        autoButtonClient=(Button)findViewById(R.id.auto);
                             
        fanOnOffButton.setOnClickListener(this);       
        fanAddButtonClient.setOnClickListener(this);       
        fanSubButtonClient.setOnClickListener(this);
        lampOnOffButton.setOnClickListener(this);
        lampAddButtonClient.setOnClickListener(this);
        lampSubButtonClient.setOnClickListener(this);
        curtainOnOffButton.setOnClickListener(this);
        curtainAddButtonClient.setOnClickListener(this);
        curtainSubButtonClient.setOnClickListener(this);
        autoButtonClient.setOnClickListener(this);
        
        airLevel=(TextView)findViewById(R.id.airlevel);  
        recvDamp= (TextView)findViewById(R.id.Recdamp);       
        recvDamp.setMovementMethod(ScrollingMovementMethod.getInstance()); 
        recvTamp= (TextView)findViewById(R.id.Rectemp); 
        recvTamp.setMovementMethod(ScrollingMovementMethod.getInstance()); 
        recPm25= (TextView)findViewById(R.id.Recpm25); 
        recPm25.setMovementMethod(ScrollingMovementMethod.getInstance());   
    	
    }
    /*
     * ӷ
     */
    public void Connection(){
    	try
    	{
			if (isConnecting) 
			{				
				isConnecting = false;
				try {
					if(mSocketClient!=null)
					{
						mSocketClient.close();
						mSocketClient = null;
						
						mPrintWriterClient.close();
						mPrintWriterClient = null;
					}
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				mThreadClient.interrupt();
				startButton.setText("");
			}
			else
			{				
				isConnecting = true;					
				DialogIpPort();	
			}
    	}catch(Exception e)
    	{
    		Toast.makeText(mContext, "쳣" + e.getMessage(), Toast.LENGTH_SHORT).show();
    	}
    }
    //¼
    public void onClick(View v)
    {
    	if(isConnecting&&mSocketClient!=null){
    		try{
    			switch(v.getId()){
    			case R.id.fan_on_off:
    				mFlagOnOff();
    				mPrintWriterClient.print(fanOnOff[mFlagOnOff]);//͸
  				  	mPrintWriterClient.flush(); //棬ͷ
  				  	break;
    			case R.id.fanadd:
    				mFlagAdd();
    				mPrintWriterClient.print(fanAdd[mFlag]);//͸
					mPrintWriterClient.flush();
					break;
    			case R.id.fansub:
    				mFlagSub();
    				mPrintWriterClient.print(fanSub[mFlag]);//͸
					mPrintWriterClient.flush();
					break;
    			case R.id.lamp_on_off:
    				mFlagOnOff();
    				mPrintWriterClient.print(lampOnOff[mFlagOnOff]);//͸
    				mPrintWriterClient.flush();
    				break;
    			case R.id.lampadd:
    				mFlagAdd();
    				mPrintWriterClient.print(lampAdd[mFlag]);
    				mPrintWriterClient.flush();
    				break;
    			case R.id.lampsub:
    				mFlagSub();
    				mPrintWriterClient.print(lampSub[mFlag]);
    				mPrintWriterClient.flush();
    				break;
    			case R.id.curtain_on_off:
    				mFlagOnOff();
    				mPrintWriterClient.print(curtainOnOff[mFlagOnOff]);
    				mPrintWriterClient.flush();
    				break;
    			case R.id.curtainadd:
    				mFlagAdd();
    				mPrintWriterClient.print(curtainAdd[mFlag]);
    				mPrintWriterClient.flush();
    				break;
    			case R.id.curtainsub:
    				mFlagSub();
    				mPrintWriterClient.print(curtainSub[mFlag]);
    				mPrintWriterClient.flush();
    				break;
    			case R.id.auto:
    				mFlagOnOff();
    				mPrintWriterClient.print(autoArray[mFlagOnOff]);//͸
    				mPrintWriterClient.flush();
    				
    			default:
    				break;
    			}
    		}catch(Exception e){
    			Toast.makeText(mContext, "쳣" + e.getMessage(), Toast.LENGTH_SHORT).show();
    			
    			}
    		
    	}else{
    		Toast.makeText(mContext, "ûӦķ", Toast.LENGTH_SHORT).show();	
    	}
    }
    /*
     * ־
     */
    protected void mFlagSub(){
    	if(mFlag>=0){
			mFlag=-1+mFlag;
		}
		if(mFlag==10){
			mFlag=-2+mFlag;
		}
		if(mFlag<0){
			mFlag=0;
		}
    }
    /*
     * ӱ־
     */
    protected void mFlagAdd(){
    	if(mFlag<10){
			mFlag=1+mFlag;
		}	
    }
    /*
     * ر־
     */
    protected void mFlagOnOff(){
    	if(mFlagOnOff<1){
			mFlagOnOff=1+mFlagOnOff;
		}
		else
		{
			mFlagOnOff=0;
		}
    }
    /*
     * ˿ںIPַԻ
     */
    public void DialogIpPort(){
    	LayoutInflater inflater=getLayoutInflater();
    	View login_dialog = inflater.inflate(R.layout.dialog,(ViewGroup)findViewById(R.id.dialog));
    	dialog_ip=(EditText)login_dialog.findViewById(R.id.dialog_ip);
    	dialog_port=(EditText)login_dialog.findViewById(R.id.dialog_port);
    	new AlertDialog.Builder(this).setTitle("ȷIPַͶ˿ں").setView(login_dialog).
    	setPositiveButton("",new DialogInterface.OnClickListener() {
			
			@Override
			public void onClick(DialogInterface arg0, int arg1) {
				// TODO Auto-generated method stub
				try{
					
					ip=dialog_ip.getText().toString();
					mport=Integer.parseInt(dialog_port.getText().toString());
					mThreadClient = new Thread(mRunnable);
					mThreadClient.start();
					startButton.setText("Ͽ");	
				}catch(Exception e){
					Toast.makeText(mContext, "쳣" + e.getMessage(), Toast.LENGTH_SHORT).show();					
				}
				
			}
		}).setNegativeButton("ȡ",new DialogInterface.OnClickListener() {
			
			@Override
			public void onClick(DialogInterface arg0, int arg1) {
				// TODO Auto-generated method stub
				startButton.setText("");	
			}
		}).show();
    	
    }
	//߳:Ϣ
	private Runnable	mRunnable	= new Runnable() 
	{
		public void run()
		{
			try 
			{				
				//ӷ
				mSocketClient = new Socket(ip, mport);	//portnum
				//ȡ롢
				mBufferedReaderClient = new BufferedReader(new InputStreamReader(mSocketClient.getInputStream()));
				
				mPrintWriterClient = new PrintWriter(mSocketClient.getOutputStream(), true);
				
				mistakeMessage = "Ѿserver!";//Ϣ
				Message msg = new Message();
                msg.what = 0;
				mHandler.sendMessage(msg);		
				//break;
			}
			catch (Exception e) 
			{
				mistakeMessage = "IP쳣:" + e.toString() + e.getMessage() + "\n";//Ϣ
				Message msg = new Message();
                msg.what = 1;
				mHandler.sendMessage(msg);
				return;
			}			
			setRecvMessage();
		}
	};
	
	/*
	 * Ϣ
	 */
    public void setRecvMessage(){
        char[] buffer = new char[256];
        int count = 0;
        while (isConnecting)
        {
            try
            {
                if((count = mBufferedReaderClient.read(buffer))>0)
                {
                    recvMessageClient = getInfoBuff(buffer, count);//ܵݴ
                    Message msg = new Message();
                    msg.what = 1;
                    mHandler.sendMessage(msg);
                }
            }
            catch (Exception e)
            {
                mistakeMessage = "쳣:" + e.getMessage()+"\n";//Ϣ
                Message msg = new Message();
                msg.what = 0;
                mHandler.sendMessage(msg);
            }
        }

    }
	Handler mHandler = new Handler()
	{										
		  public void handleMessage(Message msg)										
		  {		
			  String[] string={"","",""};
			  super.handleMessage(msg);			
			  if(msg.what == 0)
			  {
				  Toast.makeText(LoginActivity.this,mistakeMessage,Toast.LENGTH_SHORT).show();//ˢϢ
			  }
			  else if(msg.what == 1)
			  {
				try
				{
					String[] result = recvMessageClient.split("\\*");
					recvTamp.setText(result[0]);
					recvDamp.setText(result[1]);	// ˢ  
					recPm25.setText(result[2]);
					if((0<=Integer.parseInt(result[2]))&&(35>=Integer.parseInt(result[2]))){
						airLevel.setTextColor(android.graphics.Color.GREEN);//textɫ
						airLevel.setText(string[0]);
					}else if((36<=Integer.parseInt(result[2]))&&(75>=Integer.parseInt(result[2]))){
						airLevel.setTextColor(0xff99cc33);
						airLevel.setText(string[1]);
					}else{
						airLevel.setTextColor(0xff663300);
						airLevel.setText(string[2]);
					}
				}catch(Exception e)
				{
					Toast.makeText(LoginActivity.this,"޷ȡݣǷӣ",Toast.LENGTH_SHORT).show();//ˢϢ
				}
			  }
		  }	  
	 };
	 
	//ServerSocket
     private ServerSocket serverSocket = null;
     private boolean serverRuning = false;
     
		private String getInfoBuff(char[] buff, int count)
		{
			char[] temp = new char[count];
			for(int i=0; i<count; i++)
			{
				temp[i] = buff[i];
			}
			return new String(temp);
		}

		public void onDestroy() {
			super.onDestroy();
			if (isConnecting) 
			{				
				isConnecting = false;
				try {
					if(mSocketClient!=null)
					{
						mSocketClient.close();
						mSocketClient = null;
						
						mPrintWriterClient.close();
						mPrintWriterClient = null;
					}
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				mThreadClient.interrupt();
			}
			if (serverRuning) 
			{
				serverRuning = false;				
				try {
					if(serverSocket!=null)
					{
						serverSocket.close();
						serverSocket = null;
					}
					if(mSocketServer!=null)
					{
						mSocketServer.close();
						mSocketServer = null;
					}
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				mThreadServer.interrupt();
			}
		}
}