package com.xml.handler;

import java.util.ArrayList;
import java.util.List;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import com.xml.category.River;

public class ContentHandlerXml extends DefaultHandler {
	private List<River> rivers=null;
	private River river;
	private String tagName;//当前解析的元素标签

	public List<River> getRivers(){	
		return rivers;
	}
	//接收文档开始的通知
	@Override
	public void startDocument() throws SAXException {
		super.startDocument();
		rivers=new ArrayList<River>();	
	}
	/* 接收元素开始的通知
	 * 
	 * 参数意义如下：
	 *    namespaceURI：元素的命名空间
	 *    localName ：元素的本地名称（不带前缀）
	 *    qName ：元素的限定名（带前缀）
	 *    atts ：元素的属性集合
	 */
	@Override
	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		
		if(localName.equals("river")){
			river=new River();
			river.setName(attributes.getValue("name"));
			river.setLength(Integer.parseInt(attributes.getValue("length")));
		}
		this.tagName=localName;
	}

	//接收字符数据的通知
	@Override
	public void characters(char[] ch, int start, int length)
			throws SAXException {
		if(tagName!=null){
			String data=new String(ch,start,length);
			if(tagName.equals("introduction")){	
				
			    river.setIntroduction(data);
				//System.err.println(data);
			}else if(tagName.equals("imageurl")){
				river.setImageurl(data);
				//System.err.println(data);
			}
		}
	}

	/* 接收文档的结尾的通知。参数意义如下：
	 *    uri ：元素的命名空间
	 *    localName ：元素的本地名称（不带前缀）
	 *    name ：元素的限定名（带前缀）
	 */

	@Override
	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		
		if(localName.equals("river")){
			rivers.add(river);
			river=null;
		}
		this.tagName=null;
	}
}