/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.app;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.view.View;
import com.android.pc.ioc.app.InstrumentationBean;
import com.android.pc.ioc.core.kernel.KernelObject;
import com.android.pc.ioc.core.kernel.KernelReflect;
import com.android.pc.ioc.db.sqlite.DbUtils;
import com.android.pc.ioc.util.ContextUtils;
import com.android.pc.ioc.util.InjectViewUtils;
import com.android.pc.util.Handler_Properties;
import com.android.pc.util.Logger;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class Ioc {
    private Application application;
    private static Ioc ioc;
    private Logger logger = null;
    private int mode_w = 480;
    private int mode_h = 800;
    private InstrumentationBean instrumentation;
    private HashMap<String, DbUtils> dbMap = new HashMap();
    private String dbName = "db";
    private List<Activity> activitys = new ArrayList<Activity>();
    Thread initThread = new Thread(){

        @Override
        public void run() {
            ContextUtils.getFactoryProvider();
        }
    };

    public Application getApplication() {
        return this.application;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static Ioc getIoc() {
        if (ioc == null) {
            ioc = new Ioc();
        }
        return ioc;
    }

    public void init(Application app) {
        long time = System.currentTimeMillis();
        this.application = app;
        this.logger = Logger.getLogger("debug");
        Properties properties = Handler_Properties.loadConfigAssets("mvc.properties");
        if (properties != null && properties.containsKey("standard_w")) {
            this.mode_w = Integer.valueOf(properties.get("standard_w").toString());
        }
        if (properties != null && properties.containsKey("standard_h")) {
            this.mode_h = Integer.valueOf(properties.get("standard_h").toString());
        }
        boolean iscompatible = false;
        if (properties != null && properties.containsKey("iscompatible")) {
            iscompatible = Boolean.valueOf(properties.get("iscompatible").toString());
        }
        this.initThread.start();
        InjectViewUtils.setApplication(this.application);
        Object mainThread = KernelObject.declaredGet(this.application.getBaseContext(), "mMainThread");
        Field instrumentationField = KernelReflect.declaredField(mainThread.getClass(), "mInstrumentation");
        this.instrumentation = new InstrumentationBean();
        if (iscompatible) {
            KernelObject.copy(KernelReflect.get(mainThread, instrumentationField), (Object)this.instrumentation);
        }
        KernelReflect.set(mainThread, instrumentationField, (Object)this.instrumentation);
        this.logger.d("appliaction \u52a0\u8f7d\u65f6\u95f4\u4e3a:" + (System.currentTimeMillis() - time));
    }

    public int getMode_w() {
        return this.mode_w;
    }

    public void setMode_w(int mode_w) {
        this.mode_w = mode_w;
    }

    public int getMode_h() {
        return this.mode_h;
    }

    public void setMode_h(int mode_h) {
        this.mode_h = mode_h;
    }

    public void keypress(View view, final int key) {
        view.setFocusable(true);
        view.requestFocus();
        new Thread(new Runnable(){

            @Override
            public void run() {
                Ioc.this.instrumentation.sendKeyDownUpSync(key);
            }
        }).start();
    }

    public DbUtils getDb() {
        return this.getDb(null, this.dbName);
    }

    public DbUtils getDb(String dbDirs, String dbName) {
        DbUtils db;
        String key;
        String string = key = dbDirs == null ? dbName : String.valueOf(dbDirs) + dbName;
        if (this.dbMap.containsKey(key)) {
            return this.dbMap.get(key);
        }
        if (dbDirs == null) {
            db = DbUtils.create((Context)this.application, dbName);
            this.dbMap.put(dbName, db);
        } else {
            File file = new File(dbDirs);
            if (!file.exists()) {
                file.mkdirs();
            }
            db = DbUtils.create((Context)this.application, dbDirs, dbName);
            this.dbMap.put(String.valueOf(dbDirs) + dbName, db);
        }
        db.configDebug(true);
        db.configAllowTransaction(true);
        return db;
    }

    public List<Activity> getActivity() {
        return this.activitys;
    }
}

