/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.core.kernel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class KernelList {
    public static final List EMPTY_LIST = new ArrayList();
    public static final Comparator<Orderable> COMPARATOR = new Comparator<Orderable>(){

        @Override
        public int compare(Orderable lhs, Orderable rhs) {
            return lhs.getOrder() - rhs.getOrder();
        }
    };
    public static final Comparator<Orderable> COMPARATOR_DESC = new Comparator<Orderable>(){

        @Override
        public int compare(Orderable lhs, Orderable rhs) {
            return rhs.getOrder() - lhs.getOrder();
        }
    };
    public static final Comparator COMMON_COMPARATOR = new Comparator(){

        public int compare(Object lhs, Object rhs) {
            return KernelList.getOrder(lhs) - KernelList.getOrder(rhs);
        }
    };

    public static <T> T get(List<T> list, int index) {
        return KernelList.get(list, null, index);
    }

    public static <T> T get(List<T> list, T defaultValue, int index) {
        if (index >= 0 && index < list.size()) {
            return list.get(index);
        }
        return defaultValue;
    }

    public static <T extends Orderable> void addOrder(List<T> list, T element) {
        int order = element.getOrder();
        int size = list.size();
        int i = 0;
        while (i < size) {
            if (order < ((Orderable)list.get(i)).getOrder()) {
                list.add(i, element);
                return;
            }
            ++i;
        }
        list.add(element);
    }

    public static <T extends Orderable> void addOrderOnly(List<T> list, T element) {
        int order = element.getOrder();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Orderable orderable = (Orderable)list.get(i);
            if (orderable == element) {
                return;
            }
            if (order < orderable.getOrder()) {
                list.add(i, element);
                return;
            }
            ++i;
        }
        list.add(element);
    }

    public static <T extends Orderable> void sortOrderable(List<T> list) {
        Collections.sort(list, COMPARATOR);
    }

    public static <T extends Orderable> void sortOrderableDesc(List<T> list) {
        Collections.sort(list, COMPARATOR_DESC);
    }

    public static int getOrder(Object element) {
        return element instanceof Orderable ? ((Orderable)element).getOrder() : 0;
    }

    public static void addOrderObject(List list, Object element) {
        int order = KernelList.getOrder(element);
        int size = list.size();
        int i = 0;
        while (i < size) {
            if (order < KernelList.getOrder(list.get(i))) {
                list.add(i, element);
                return;
            }
            ++i;
        }
        list.add(element);
    }

    public static void sortCommonObjects(List list) {
        Collections.sort(list, COMMON_COMPARATOR);
    }

    public static interface Orderable {
        public int getOrder();
    }
}

