/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.core.kernel;

import com.android.pc.ioc.core.kernel.KernelArray;
import com.android.pc.ioc.core.kernel.KernelClass;
import com.android.pc.ioc.core.kernel.KernelCollection;
import com.android.pc.ioc.core.kernel.KernelLang;
import com.android.pc.ioc.core.kernel.KernelMap;
import com.android.pc.ioc.core.kernel.KernelReflect;
import com.android.pc.ioc.core.kernel.KernelString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class KernelObject {
    public static <T> T getValue(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static void set(Object obj, String name, Object value) {
        KernelObject.declaredSet(obj, name, 0, false, value);
    }

    public static void declaredSet(Object obj, String name, Object value) {
        KernelObject.declaredSet(obj, name, 0, true, value);
    }

    public static boolean declaredSet(Object obj, String name, int ancest, boolean declared, Object value) {
        Field field;
        if (obj instanceof Class) {
            field = KernelReflect.declaredField((Class)obj, name, ancest, declared);
            field = KernelReflect.memberStatic(field);
        } else {
            field = KernelReflect.declaredField(obj.getClass(), name, ancest, declared);
        }
        return KernelReflect.set(obj, field, value);
    }

    public static Object get(Object obj, String name) {
        return KernelObject.declaredGet(obj, name, 0, false);
    }

    public static Object declaredGet(Object obj, String name) {
        return KernelObject.declaredGet(obj, name, 0, true);
    }

    public static Object declaredGet(Object obj, String name, int ancest, boolean declared) {
        Field field;
        if (obj instanceof Class) {
            field = KernelReflect.declaredField((Class)obj, name, ancest, declared);
            field = KernelReflect.memberStatic(field);
        } else {
            field = KernelReflect.declaredField(obj.getClass(), name, ancest, declared);
        }
        return KernelReflect.get(obj, field);
    }

    public static Object send(Object obj, String name, Object ... args) {
        return KernelObject.send(obj, name, 0, true, true, KernelClass.parameterTypes(args), args);
    }

    public static Object send(Object obj, String name, Class[] parameterTypes, Object ... args) {
        return KernelObject.send(obj, name, 0, false, false, parameterTypes, args);
    }

    public static Object send(Object obj, String name, int ancest, boolean assignable, boolean cacheable, Class[] parameterTypes, Object ... args) {
        return KernelObject.declaredSend(obj, name, ancest, false, assignable, cacheable, parameterTypes, args);
    }

    public static Object declaredSend(Object obj, String name, Object ... args) {
        return KernelObject.declaredSend(obj, name, 0, true, true, true, KernelClass.parameterTypes(args), args);
    }

    public static Object declaredSend(Object obj, String name, Class[] parameterTypes, Object ... args) {
        return KernelObject.declaredSend(obj, name, 0, true, false, false, parameterTypes, args);
    }

    public static Object declaredSend(Object obj, String name, int ancest, boolean declared, boolean assignable, boolean cacheable, Class[] parameterTypes, Object ... args) {
        Method method;
        if (obj instanceof Class) {
            method = KernelReflect.assignableMethod((Class)obj, name, ancest, declared, assignable, cacheable, parameterTypes);
            method = KernelReflect.memberStatic(method);
        } else {
            method = KernelReflect.assignableMethod(obj.getClass(), name, ancest, declared, assignable, cacheable, parameterTypes);
        }
        return KernelReflect.invoke(obj, method, args);
    }

    public static boolean setter(Object obj, Field field, Object value) {
        return KernelObject.setter(obj, field.getName(), field.getType(), value);
    }

    public static boolean setter(Object obj, String field, Object value) {
        return KernelObject.setter(obj, field, value.getClass(), value);
    }

    public static boolean setter(Object obj, String field, Class fieldType, Object value) {
        Method method = KernelClass.setter(obj.getClass(), field, fieldType);
        return method != null && KernelReflect.invoke(obj, false, method, value) == null;
    }

    public static boolean publicSetter(Object obj, Field field, Object value) {
        if (KernelObject.setter(obj, field, value)) {
            return true;
        }
        return Modifier.isPublic(field.getModifiers()) && KernelReflect.set(obj, field, value);
    }

    public static boolean publicSetter(Object obj, String field, Object value) {
        Method method = KernelClass.setter(obj.getClass(), field, value.getClass());
        if (method == null) {
            return KernelObject.setter(obj, field, value);
        }
        KernelReflect.invoke(obj, method, value);
        return true;
    }

    public static boolean declaredSetter(Object obj, Field field, Object value) {
        if (KernelObject.setter(obj, field, value)) {
            return true;
        }
        return KernelReflect.set(obj, field, value);
    }

    public static Object getter(Object obj, Field field) {
        return KernelObject.getter(obj, field.getName(), field.getType());
    }

    public static Object getter(Object obj, String field) {
        return KernelObject.getter(obj, field, Object.class);
    }

    public static Object getter(Object obj, String field, Class fieldType) {
        Method method = KernelClass.getter(obj.getClass(), field, fieldType);
        if (method != null) {
            return KernelReflect.invoke(obj, method, new Object[0]);
        }
        return null;
    }

    public static Object publicGetter(Object obj, Field field) {
        Method method = KernelClass.getter(obj.getClass(), field);
        if (method == null) {
            if (Modifier.isPublic(field.getModifiers())) {
                return KernelReflect.get(obj, field);
            }
        } else {
            return KernelReflect.invoke(obj, method, new Object[0]);
        }
        return null;
    }

    public static Object publicGetter(Object obj, String field) {
        Method method = KernelClass.getter(obj.getClass(), field);
        if (method == null) {
            return KernelObject.get(obj, field);
        }
        return KernelReflect.invoke(obj, method, new Object[0]);
    }

    public static Object declaredGetter(Object obj, Field field) {
        Method method = KernelClass.getter(obj.getClass(), field);
        if (method == null) {
            return KernelReflect.get(obj, field);
        }
        return KernelReflect.invoke(obj, method, new Object[0]);
    }

    public static Object declaredGetter(Object obj, String field) {
        Method method = KernelClass.getter(obj.getClass(), field);
        if (method == null) {
            return KernelObject.declaredGet(obj, field);
        }
        return KernelReflect.invoke(obj, method, new Object[0]);
    }

    public static Object expressGetter(Object obj, String target) {
        String[] fields;
        if (KernelString.isEmpty(target)) {
            return obj;
        }
        String[] stringArray = fields = target.split("\\.");
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            if (obj == null) {
                return null;
            }
            if (field.startsWith(":")) {
                Method method = KernelReflect.method(obj.getClass(), field.substring(1), new Class[0]);
                if (method != null) {
                    obj = KernelReflect.invoke(obj, method, new Object[0]);
                }
            } else {
                obj = KernelObject.declaredGetter(obj, field);
            }
            ++n2;
        }
        return obj;
    }

    public static <T> T cast(Object obj, Class<T> toClass) {
        if (obj != null && toClass.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        return null;
    }

    public static <T> T clone(T obj) {
        try {
            if (obj.getClass().isArray()) {
                return KernelArray.clone(obj);
            }
            Object clone = obj.getClass().newInstance();
            KernelObject.clone(obj, clone);
            return (T)clone;
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public static <T> void clone(final T obj, final T clone) {
        if (obj.getClass().isArray()) {
            KernelArray.copy(obj, clone);
        } else if (obj instanceof Collection) {
            KernelCollection.copy((Collection)obj, (Collection)clone);
        } else if (obj instanceof Map) {
            KernelMap.copy((Map)obj, (Map)clone);
        } else {
            KernelReflect.doWithDeclaredFields(obj.getClass(), new KernelLang.CallbackBreak<Field>(){

                @Override
                public void doWith(Field template) throws KernelLang.BreakException {
                    template.setAccessible(true);
                    try {
                        template.set(clone, template.get(obj));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public static void copy(final Object obj, final Object copy) {
        final Class<?> cls = copy.getClass();
        if (obj.getClass().isArray()) {
            KernelArray.copy(obj, copy);
        } else if (obj instanceof Collection) {
            if (copy instanceof Collection) {
                KernelCollection.copy((Collection)obj, (Collection)copy);
            }
        } else if (obj instanceof Map) {
            if (copy instanceof Map) {
                KernelMap.copy((Map)obj, (Map)copy);
            }
        } else {
            KernelReflect.doWithDeclaredFields(obj.getClass(), new KernelLang.CallbackBreak<Field>(){

                @Override
                public void doWith(Field template) throws KernelLang.BreakException {
                    Field field = KernelReflect.declaredField(cls, template.getName());
                    if (field != null && field.getType().isAssignableFrom(template.getType())) {
                        template.setAccessible(true);
                        try {
                            field.set(copy, template.get(obj));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    public static byte[] serialize(Object obj) {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
            objectOut.writeObject(obj);
            return byteOut.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Object unserialize(byte[] buf) {
        try {
            ByteArrayInputStream byteInput = new ByteArrayInputStream(buf);
            ObjectInputStream objectInput = new ObjectInputStream(byteInput);
            Object obj = objectInput.readObject();
            return obj;
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static <T> T serializeClone(T obj) {
        byte[] buf = KernelObject.serialize(obj);
        if (buf == null) {
            return null;
        }
        return (T)KernelObject.unserialize(buf);
    }

    public static int hashCode(Object obj) {
        return obj == null ? 1 : obj.hashCode();
    }

    public static boolean equals(Object obj, Object equal) {
        return obj == equal || obj != null && obj.equals(equal);
    }

    public static Map<String, Object> getMap(final Object obj) {
        final HashMap<String, Object> map = new HashMap<String, Object>();
        KernelReflect.doWithDeclaredFields(obj.getClass(), new KernelLang.CallbackBreak<Field>(){

            @Override
            public void doWith(Field template) throws KernelLang.BreakException {
                Object value = KernelObject.publicGetter(obj, template);
                if (value != null) {
                    map.put(template.getName(), value);
                }
            }
        });
        return map;
    }

    public static void setMap(Object obj, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            KernelObject.publicSetter(obj, entry.getKey(), entry.getValue());
        }
    }
}

