/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.db.sqlite;

import android.database.Cursor;
import com.android.pc.ioc.app.Ioc;
import com.android.pc.ioc.db.sqlite.DbUtils;
import com.android.pc.ioc.db.sqlite.DoubleKeyValueMap;
import com.android.pc.ioc.db.sqlite.FinderLazyLoader;
import com.android.pc.ioc.db.sqlite.ForeignLazyLoader;
import com.android.pc.ioc.db.table.Column;
import com.android.pc.ioc.db.table.DbModel;
import com.android.pc.ioc.db.table.Finder;
import com.android.pc.ioc.db.table.Foreign;
import com.android.pc.ioc.db.table.Table;

public class CursorUtils {
    public static <T> T getEntity(DbUtils db, Cursor cursor, Class<T> entityType, long findCacheSequence) {
        if (db == null || cursor == null) {
            return null;
        }
        EntityTempCache.setSeq(findCacheSequence);
        try {
            Table table = Table.get(entityType);
            int idIndex = cursor.getColumnIndex(table.getId().getColumnName());
            String idStr = cursor.getString(idIndex);
            T entity = EntityTempCache.get(entityType, idStr);
            if (entity != null) {
                return entity;
            }
            entity = entityType.newInstance();
            EntityTempCache.put(entity, idStr);
            int columnCount = cursor.getColumnCount();
            int i = 0;
            while (i < columnCount) {
                String columnName = cursor.getColumnName(i);
                Column column = table.columnMap.get(columnName);
                if (column != null) {
                    if (column instanceof Foreign) {
                        Foreign foreign = (Foreign)column;
                        if (foreign.getFieldValue(entity) == null) {
                            foreign.db = db;
                            foreign.setValue2Entity(entity, cursor.getString(i));
                        }
                    } else {
                        column.setValue2Entity(entity, cursor.getString(i));
                    }
                } else if (columnName.equals(table.getId().getColumnName())) {
                    table.getId().setValue2Entity(entity, cursor.getString(i));
                }
                ++i;
            }
            for (Column column : table.columnMap.values()) {
                Finder finder;
                if (!(column instanceof Finder) || (finder = (Finder)column).getFieldValue(entity) != null) continue;
                finder.db = db;
                finder.setValue2Entity(entity, null);
            }
            return entity;
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e);
            return null;
        }
    }

    public static DbModel getDbModel(Cursor cursor) {
        DbModel result = null;
        if (cursor != null) {
            result = new DbModel();
            int columnCount = cursor.getColumnCount();
            int i = 0;
            while (i < columnCount) {
                result.add(cursor.getColumnName(i), cursor.getString(i));
                ++i;
            }
        }
        return result;
    }

    private static class EntityTempCache {
        private static final DoubleKeyValueMap<Class, String, Object> cache = new DoubleKeyValueMap();
        private static long seq = 0L;

        private EntityTempCache() {
        }

        public static void put(Object entity, String idStr) {
            cache.put(entity.getClass(), idStr, entity);
        }

        public static <T> T get(Class<T> entityType, String idStr) {
            return (T)cache.get(entityType, idStr);
        }

        public static void setSeq(long seq) {
            if (EntityTempCache.seq != seq) {
                cache.clear();
                EntityTempCache.seq = seq;
            }
        }
    }

    public static class FindCacheSequence {
        private static long seq = 0L;
        private static final String FOREIGN_LAZY_LOADER_CLASS_NAME = ForeignLazyLoader.class.getName();
        private static final String FINDER_LAZY_LOADER_CLASS_NAME = FinderLazyLoader.class.getName();

        public static long getSeq() {
            String findMethodCaller = Thread.currentThread().getStackTrace()[4].getClassName();
            if (!findMethodCaller.equals(FOREIGN_LAZY_LOADER_CLASS_NAME) && !findMethodCaller.equals(FINDER_LAZY_LOADER_CLASS_NAME)) {
                ++seq;
            }
            return seq;
        }
    }
}

